/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.upgrade;

import java.io.InputStream;
import java.nio.file.Path;
import org.opensearch.cli.Terminal;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.settings.KeyStoreWrapper;
import org.opensearch.common.settings.KeystoreWrapperUtil;
import org.opensearch.core.common.settings.SecureString;
import org.opensearch.upgrade.TaskInput;
import org.opensearch.upgrade.UpgradeTask;

class ImportKeystoreTask
implements UpgradeTask {
    private static final String OPENSEARCH_KEYSTORE_FILENAME = "opensearch.keystore";
    private static final String ES_KEYSTORE_FILENAME = "elasticsearch.keystore";

    ImportKeystoreTask() {
    }

    @Override
    public void accept(Tuple<TaskInput, Terminal> input) {
        TaskInput taskInput = (TaskInput)input.v1();
        Terminal terminal = (Terminal)input.v2();
        try (SecureString keyStorePassword = new SecureString(new char[0]);){
            terminal.println("Importing keystore settings ...");
            KeyStoreWrapper esKeystore = KeyStoreWrapper.load((Path)taskInput.getEsConfig(), (String)ES_KEYSTORE_FILENAME);
            if (esKeystore == null) {
                terminal.println("No elasticsearch keystore settings to import.");
                return;
            }
            KeyStoreWrapper openSearchKeystore = KeyStoreWrapper.load((Path)taskInput.getOpenSearchConfig().resolve(OPENSEARCH_KEYSTORE_FILENAME));
            if (openSearchKeystore == null) {
                openSearchKeystore = KeyStoreWrapper.create();
            }
            if (esKeystore.hasPassword()) {
                char[] passwordArray = terminal.readSecret("Enter password for the elasticsearch keystore : ");
                keyStorePassword = new SecureString(passwordArray);
            }
            esKeystore.decrypt(keyStorePassword.getChars());
            for (String setting : esKeystore.getSettingNames()) {
                if (setting.equals("keystore.seed") || openSearchKeystore.getSettingNames().contains(setting)) continue;
                InputStream settingIS = esKeystore.getFile(setting);
                byte[] bytes = new byte[settingIS.available()];
                settingIS.read(bytes);
                KeystoreWrapperUtil.saveSetting(openSearchKeystore, setting, bytes);
            }
            openSearchKeystore.save(taskInput.getOpenSearchConfig(), keyStorePassword.getChars());
            terminal.println("Success!" + System.lineSeparator());
        }
    }
}

