/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.rest.action.servers;

import de.virtimo.bpc.opensearch.plugin.BpcConnection;
import de.virtimo.bpc.opensearch.plugin.Manager;
import de.virtimo.bpc.opensearch.plugin.MasterServerInfo;
import de.virtimo.bpc.opensearch.plugin.dto.ConnectedServerDTO;
import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.rest.action.BaseBpcPluginRestHandler;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.logging.Loggers;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;

public class RestGetConnectedMasterServerAction
extends BaseBpcPluginRestHandler {
    private static final Logger LOG = Loggers.getLogger(RestGetConnectedMasterServerAction.class, (String[])new String[]{"os-bpc-plugin"});

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_bpc/servers/master"));
    }

    public String getName() {
        return "get_master_server_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient nodeClient, Manager manager) throws IOException {
        LOG.debug("prepareRequest request=" + request + ", nodeClient=" + nodeClient + ", manager=" + manager);
        return channel -> {
            MasterServerInfo masterServerInfo = manager.getMasterServerInfo();
            if (masterServerInfo == null) {
                this.sendNotFound((RestChannel)channel, "No master server found");
            } else {
                BpcConnection connection = manager.getConnections().getConnectionByServerUUID(masterServerInfo.getServerUUID());
                if (connection == null) {
                    this.sendNotFound((RestChannel)channel, "Failed to get the master server connection with the UUID: " + masterServerInfo.getServerUUID());
                } else {
                    ConnectedServerDTO connectedMasterServer = new ConnectedServerDTO(connection.getConnectedNode(), connection.getWebsocketId(), connection.getServerStateInfo(), connection.getServerLoadedModules());
                    this.sendDTO((RestChannel)channel, (OpenSearchPluginDTO)connectedMasterServer);
                }
            }
        };
    }
}

