/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.logging;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateObserver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.logging.NodeAndClusterIdConverter;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;

public class NodeAndClusterIdStateListener
implements ClusterStateObserver.Listener {
    private static final Logger logger = LogManager.getLogger(NodeAndClusterIdStateListener.class);

    private NodeAndClusterIdStateListener() {
    }

    public static void getAndSetNodeIdAndClusterId(ClusterService clusterService, ThreadContext threadContext) {
        ClusterState clusterState = clusterService.state();
        ClusterStateObserver observer = new ClusterStateObserver(clusterState, clusterService, null, logger, threadContext);
        observer.waitForNextChange((ClusterStateObserver.Listener)new NodeAndClusterIdStateListener(), NodeAndClusterIdStateListener::isNodeAndClusterIdPresent);
    }

    private static boolean isNodeAndClusterIdPresent(ClusterState clusterState) {
        return NodeAndClusterIdStateListener.getNodeId(clusterState) != null && NodeAndClusterIdStateListener.getClusterUUID(clusterState) != null;
    }

    private static String getClusterUUID(ClusterState state) {
        return state.getMetadata().clusterUUID();
    }

    private static String getNodeId(ClusterState state) {
        return state.getNodes().getLocalNodeId();
    }

    @Override
    public void onNewClusterState(ClusterState state) {
        String nodeId = NodeAndClusterIdStateListener.getNodeId(state);
        String clusterUUID = NodeAndClusterIdStateListener.getClusterUUID(state);
        logger.debug("Received cluster state update. Setting nodeId=[{}] and clusterUuid=[{}]", (Object)nodeId, (Object)clusterUUID);
        NodeAndClusterIdConverter.setNodeIdAndClusterId(nodeId, clusterUUID);
    }

    @Override
    public void onClusterServiceClose() {
    }

    @Override
    public void onTimeout(TimeValue timeout) {
    }
}

