/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.MinimizationOperations;
import org.apache.lucene.util.automaton.Operations;
import org.opensearch.common.Nullable;
import org.opensearch.common.regex.Regex;
import org.opensearch.core.index.Index;
import org.opensearch.indices.SystemIndexDescriptor;
import org.opensearch.indices.SystemIndexRegistry;

public class SystemIndices {
    private static final Logger logger = LogManager.getLogger(SystemIndices.class);
    private final CharacterRunAutomaton runAutomaton;

    public SystemIndices(Map<String, Collection<SystemIndexDescriptor>> pluginAndModulesDescriptors) {
        SystemIndexRegistry.register(pluginAndModulesDescriptors);
        this.runAutomaton = SystemIndices.buildCharacterRunAutomaton(SystemIndexRegistry.getAllDescriptors());
    }

    public boolean isSystemIndex(Index index) {
        return this.isSystemIndex(index.getName());
    }

    public boolean isSystemIndex(String indexName) {
        return this.runAutomaton.run(indexName);
    }

    @Nullable
    public SystemIndexDescriptor findMatchingDescriptor(String name) {
        List matchingDescriptors = SystemIndexRegistry.getAllDescriptors().stream().filter(descriptor -> descriptor.matchesIndexPattern(name)).collect(Collectors.toList());
        if (matchingDescriptors.isEmpty()) {
            return null;
        }
        if (matchingDescriptors.size() == 1) {
            return (SystemIndexDescriptor)matchingDescriptors.get(0);
        }
        StringBuilder errorMessage = new StringBuilder().append("index name [").append(name).append("] is claimed as a system index by multiple system index patterns: [").append(matchingDescriptors.stream().map(descriptor -> "pattern: [" + descriptor.getIndexPattern() + "], description: [" + descriptor.getDescription() + "]").collect(Collectors.joining("; ")));
        assert (false) : errorMessage.toString();
        throw new IllegalStateException(errorMessage.toString());
    }

    public boolean validateSystemIndex(String index) {
        SystemIndexDescriptor matchingDescriptor;
        if (index.charAt(0) == '.' && (matchingDescriptor = this.findMatchingDescriptor(index)) != null) {
            logger.trace("index [{}] is a system index because it matches index pattern [{}] with description [{}]", (Object)index, (Object)matchingDescriptor.getIndexPattern(), (Object)matchingDescriptor.getDescription());
            return true;
        }
        return false;
    }

    private static CharacterRunAutomaton buildCharacterRunAutomaton(Collection<SystemIndexDescriptor> descriptors) {
        Optional<Automaton> automaton = descriptors.stream().map(descriptor -> Regex.simpleMatchToAutomaton(descriptor.getIndexPattern())).reduce(Operations::union);
        return new CharacterRunAutomaton(MinimizationOperations.minimize((Automaton)automaton.orElse(Automata.makeEmpty()), (int)Integer.MAX_VALUE));
    }
}

