/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.monitor;

import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.util.StringUtil;
import java.util.Map;
import java.util.logging.Logger;
import org.opensearch.client.RestHighLevelClient;

public class OpenSearch {
    private static final Logger LOG = Logger.getLogger(OpenSearch.class.getName());
    private final OpenSearchService openSearchService;

    public OpenSearch(OpenSearchService openSearchService) {
        LOG.info("OpenSearch openSearchService=...");
        this.openSearchService = openSearchService;
    }

    public RestHighLevelClient getClient() {
        LOG.info("getClient");
        return this.openSearchService.getClient();
    }

    public OpenSearchService getOpenSearchService() {
        LOG.info("getOpenSearchService");
        return this.openSearchService;
    }

    public Map getIndexMapping(String index) {
        LOG.info("getIndexMapping index=" + index);
        if (!StringUtil.isNullOrEmpty((String)index)) {
            try {
                Map columnMap;
                Object mappingPropertiesObject;
                if (this.openSearchService.existsIndex(index) && (mappingPropertiesObject = (columnMap = this.openSearchService.getMapping(index)).get("properties")) instanceof Map) {
                    Map m = (Map)mappingPropertiesObject;
                    m.remove("_percolator_query");
                    return m;
                }
            }
            catch (Exception ex) {
                LOG.warning("Failed to get the mapping of the index: " + index);
            }
        }
        return null;
    }
}

