/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Arrays;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.SQLUtil;
import oracle.jdbc.driver.VarnumBinder;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

class DoubleBinder
extends VarnumBinder {
    double paramVal;
    char[] digits = new char[20];

    DoubleBinder(double x) {
        this.paramVal = x;
    }

    @Override
    long bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues, long localCheckSum, ByteArray bindData, long[] bindDataOffsets, int[] bindDataLengths, int bindDataIndex, boolean bindUseDBA, int formOfUse) throws SQLException {
        byte[] b = null;
        int offset = 0;
        double val = this.paramVal;
        long pos = 0L;
        if (bindUseDBA) {
            bindDataOffsets[bindDataIndex] = pos = bindData.getPosition();
            stmt.lastBoundDataOffsets[bindPosition] = pos;
            b = stmt.connection.methodTempLittleByteBuffer;
            offset = 0;
        } else {
            b = bindBytes;
            offset = byteoffset + 1;
        }
        int len = this.getDatumBytes(stmt, val, b, offset);
        if (bindUseDBA) {
            bindData.put(b, 0, len);
            bindIndicators[indoffset] = 0;
            bindDataLengths[bindDataIndex] = len;
            stmt.lastBoundDataLengths[bindPosition] = len;
        } else {
            b[byteoffset] = (byte)len;
            bindIndicators[indoffset] = 0;
        }
        bindIndicators[lenoffset] = (short)(len + 1);
        return localCheckSum;
    }

    private int getDatumBytes(OraclePreparedStatement stmt, double val, byte[] b, int offset) throws SQLException {
        int len = 0;
        if (val == 0.0) {
            b[offset] = -128;
            len = 1;
        } else if (val == Double.POSITIVE_INFINITY) {
            b[offset] = -1;
            b[offset + 1] = 101;
            len = 2;
        } else if (val == Double.NEGATIVE_INFINITY) {
            b[offset] = 0;
            len = 1;
        } else {
            byte[] tmpBytes = NUMBER.toBytes(val);
            len = tmpBytes.length;
            System.arraycopy(tmpBytes, 0, b, offset, len);
        }
        return len;
    }

    @Override
    Datum getDatum(OraclePreparedStatement stmt, int bindPosition, int formOfUse, int internalType) throws SQLException {
        byte[] b = stmt.connection.methodTempLittleByteBuffer;
        int len = this.getDatumBytes(stmt, this.paramVal, b, 0);
        return SQLUtil.makeDatum((OracleConnection)stmt.connection, Arrays.copyOf(b, len), internalType, null, 0);
    }
}

