/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api;

import de.virtimo.bpc.api.BackupJobInfo;
import de.virtimo.bpc.api.BackupSetting;
import de.virtimo.bpc.api.backup.BackupActivatedInfo;
import de.virtimo.bpc.api.backup.BackupJob;
import de.virtimo.bpc.api.backup.BackupRestoredInfo;
import de.virtimo.bpc.api.backup.BackupSnapshotInfo;
import de.virtimo.bpc.api.backup.SnapshotName;
import de.virtimo.bpc.api.backup.exception.BackupConflictException;
import de.virtimo.bpc.api.backup.exception.BackupException;
import de.virtimo.bpc.api.backup.exception.BackupNotFoundException;
import de.virtimo.bpc.api.backup.exception.BackupRepositoryNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.response.GlobalConfig;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.StreamingOutput;

public interface BackupManager {
    public List<BackupJobInfo> getBackupJobs();

    public int getNumberOfScheduledBackupJobs();

    public Set<String> getIdentifiersOfScheduledBackupJobs();

    public Set<String> getIdentifiersOfBackupJobs();

    public void scheduleBackupJobWithSettings(String var1, BackupSetting var2);

    public void stopBackupJob(String var1);

    public void stopBackupJobsWithPrefix(String var1);

    public void deleteBackupJob(String var1);

    public List<BackupSnapshotInfo> getAllBackups() throws ServiceNotFoundException, BackupRepositoryNotFoundException, OpenSearchRelatedException;

    public BackupSnapshotInfo getBackupInfo(String var1) throws BackupRepositoryNotFoundException, BackupNotFoundException, ServiceNotFoundException, OpenSearchRelatedException;

    public BackupSnapshotInfo createBackupUsingBackupJob(String var1) throws BackupException, ServiceNotFoundException, ModuleNotFoundException, OpenSearchRelatedException;

    public BackupSnapshotInfo createBackup(SnapshotName var1, Set<String> var2) throws BackupException, ServiceNotFoundException, ModuleNotFoundException, OpenSearchRelatedException;

    public BackupSnapshotInfo createBackupForBackupJob(BackupJob var1) throws BackupException, ServiceNotFoundException, ModuleNotFoundException, OpenSearchRelatedException;

    public BackupSnapshotInfo deleteBackup(String var1) throws BackupRepositoryNotFoundException, BackupNotFoundException, ServiceNotFoundException, OpenSearchRelatedException;

    public BackupActivatedInfo activateBackup(String var1) throws BackupNotFoundException, BackupConflictException, BackupException, ServiceNotFoundException, OpenSearchRelatedException;

    public BackupRestoredInfo restoreBackup(String var1, String var2) throws BackupNotFoundException, BackupConflictException, BackupException, ServiceNotFoundException, OpenSearchRelatedException;

    public StreamingOutput downloadSnapshotContent(String var1) throws BackupNotFoundException, BackupConflictException, BackupException, ServiceNotFoundException, OpenSearchRelatedException;

    public GlobalConfig exportBpcConfiguration(String var1) throws BackupException, BackupConflictException, ServiceNotFoundException, OpenSearchRelatedException;
}

