/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public interface BpcService {
    public static final Logger LOG = Logger.getLogger(BpcService.class.getName());

    public BundleContext getBundleContext();

    public void shutdownService();

    public static void unregister(BundleContext bundleContext, ServiceRegistration<?> serviceRegistration, Class serviceClazz) {
        if (serviceRegistration != null) {
            LOG.info(bundleContext.getBundle().getSymbolicName() + ": Unregistering the '" + serviceClazz.getSimpleName() + "' service ...");
            long startTS = System.currentTimeMillis();
            try {
                ServiceReference serviceReference = serviceRegistration.getReference();
                Object service = bundleContext.getService(serviceReference);
                if (service instanceof BpcService) {
                    ((BpcService)service).shutdownService();
                }
                bundleContext.ungetService(serviceReference);
                serviceRegistration.unregister();
                LOG.info(bundleContext.getBundle().getSymbolicName() + ": Unregistered the '" + serviceClazz.getSimpleName() + "' service in " + (System.currentTimeMillis() - startTS) + "ms");
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, bundleContext.getBundle().getSymbolicName() + ": Failed to unregister the '" + serviceClazz.getSimpleName() + "' service.", ex);
            }
        }
    }
}

