/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api.opensearch.querybuilder;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.virtimo.bpc.util.ObjectMapperPool;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class BpcDataSort {
    private String property;
    private String direction;

    public static List<BpcDataSort> fromJsonArray(String sortJson) throws IOException {
        ObjectMapper objectMapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try {
            List list = (List)objectMapper.readValue(sortJson, (TypeReference)new TypeReference<List<BpcDataSort>>(){});
            return list;
        }
        finally {
            if (objectMapper != null) {
                ObjectMapperPool.getInstance().restore((Object)objectMapper);
            }
        }
    }

    public static List<BpcDataSort> fromCompactFormat(String sortInstructions) {
        ArrayList<BpcDataSort> result = new ArrayList<BpcDataSort>();
        if (!StringUtil.isNullOrEmpty(sortInstructions)) {
            List<String> sortInstructionsList = StringUtil.explode(sortInstructions, ",");
            for (String sortInstruction : sortInstructionsList) {
                String fieldSortOrder;
                String fieldName;
                int separatorIdx = sortInstruction.lastIndexOf("|");
                if (separatorIdx == -1) {
                    fieldName = sortInstruction;
                    fieldSortOrder = "ASC";
                } else {
                    fieldName = sortInstruction.substring(0, separatorIdx);
                    fieldSortOrder = sortInstruction.substring(separatorIdx + 1);
                }
                String sortOrder = fieldSortOrder.equalsIgnoreCase("DESC") ? "DESC" : "ASC";
                result.add(new BpcDataSort(fieldName, sortOrder));
            }
        }
        return result;
    }

    private BpcDataSort() {
    }

    public BpcDataSort(String property, String direction) {
        this.property = property;
        this.direction = direction;
    }

    public String getProperty() {
        return this.property;
    }

    public String getDirection() {
        return this.direction;
    }

    public String toString() {
        return this.property + " : " + this.direction;
    }
}

