/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.backendconnections;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.exception.ModuleInstanceNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.backendconnections.BackendConnectionsModule;
import de.virtimo.bpc.core.auth.IdentityProviderConfiguration;
import de.virtimo.bpc.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleContext;

public class BackendConnections {
    public static IdentityProviderConfiguration getIdentityProviderConfiguration(BundleContext bundleContext, String identityProviderBackendConnectionId) throws ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        try (BpcServicesTracker<ModuleManager> moduleManagerTracker = new BpcServicesTracker<ModuleManager>(bundleContext, ModuleManager.class);){
            IdentityProviderConfiguration identityProviderConfiguration = BackendConnections.getIdentityProviderConfiguration(moduleManagerTracker.getService(), identityProviderBackendConnectionId);
            return identityProviderConfiguration;
        }
    }

    public static IdentityProviderConfiguration getIdentityProviderConfiguration(ModuleManager moduleManager, String identityProviderBackendConnectionId) throws ModuleNotFoundException, ModuleInstanceNotFoundException {
        ModuleConfiguration idpConfig = BackendConnections.getModuleConfigurationOfIdentityProvider(moduleManager, identityProviderBackendConnectionId);
        return idpConfig == null ? null : new IdentityProviderConfiguration(idpConfig);
    }

    public static ModuleConfiguration getModuleConfigurationOfIdentityProvider(ModuleManager moduleManager, String identityProviderBackendConnectionId) throws ModuleNotFoundException, ModuleInstanceNotFoundException {
        if (StringUtil.isNullOrEmpty(identityProviderBackendConnectionId)) {
            return null;
        }
        BackendConnectionsModule backendConnectionsModule = (BackendConnectionsModule)moduleManager.getModuleById("backendconnection");
        ModuleInstance backendConnectionModule = backendConnectionsModule.getModuleInstanceByIdOrName(identityProviderBackendConnectionId);
        return backendConnectionModule.getConfiguration();
    }

    public static List<IdentityProviderConfiguration> getIdentityProviderConfigurationsOfType(BundleContext bundleContext, String idpType) throws ServiceNotFoundException, ModuleNotFoundException {
        ArrayList<IdentityProviderConfiguration> result = new ArrayList<IdentityProviderConfiguration>();
        for (IdentityProviderConfiguration idpConfiguration : BackendConnections.getAllIdentityProviderConfigurations(bundleContext)) {
            String idpName = idpConfiguration.getIdentityProviderName();
            if (!idpType.equalsIgnoreCase(idpName)) continue;
            result.add(idpConfiguration);
        }
        return result;
    }

    public static List<IdentityProviderConfiguration> getAllIdentityProviderConfigurations(BundleContext bundleContext) throws ServiceNotFoundException, ModuleNotFoundException {
        ArrayList<IdentityProviderConfiguration> result = new ArrayList<IdentityProviderConfiguration>();
        for (ModuleConfiguration idpModuleConfiguration : BackendConnections.getAllModuleConfigurations(bundleContext, "identity_provider")) {
            result.add(new IdentityProviderConfiguration(idpModuleConfiguration));
        }
        return result;
    }

    public static List<ModuleConfiguration> getAllModuleConfigurations(BundleContext bundleContext, String instanceType) throws ServiceNotFoundException, ModuleNotFoundException {
        try (BpcServicesTracker<ModuleManager> moduleManagerTracker = new BpcServicesTracker<ModuleManager>(bundleContext, ModuleManager.class);){
            List<ModuleConfiguration> list = BackendConnections.getAllModuleConfigurations(moduleManagerTracker.getService(), instanceType);
            return list;
        }
    }

    public static List<ModuleConfiguration> getAllModuleConfigurations(ModuleManager moduleManager, String instanceType) throws ModuleNotFoundException {
        ArrayList<ModuleConfiguration> result = new ArrayList<ModuleConfiguration>();
        BackendConnectionsModule backendConnectionsModule = (BackendConnectionsModule)moduleManager.getModuleById("backendconnection");
        for (ModuleInstance moduleInstance : backendConnectionsModule.getModuleInstancesByInstanceType(instanceType)) {
            result.add(moduleInstance.getConfiguration());
        }
        return result;
    }
}

