/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core;

import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.Settings;
import de.virtimo.bpc.core.resource.response.MaskPasswords;
import de.virtimo.bpc.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SettingsImpl
implements Settings {
    private final List<Setting> settings;

    public SettingsImpl() {
        this.settings = new ArrayList<Setting>();
    }

    public SettingsImpl(Collection<? extends Setting> settingsCollection) {
        this.settings = settingsCollection == null ? new ArrayList<Setting>() : new ArrayList<Setting>(settingsCollection);
    }

    public SettingsImpl(Settings settings) {
        this.settings = settings == null ? new ArrayList<Setting>() : new ArrayList<Setting>(settings.asList());
    }

    @Override
    public boolean isEmpty() {
        return this.settings.isEmpty();
    }

    @Override
    public int size() {
        return this.settings.size();
    }

    @Override
    public Settings add(Setting setting) {
        if (setting != null) {
            this.settings.add(setting);
        }
        return this;
    }

    @Override
    public Set<String> getNames() {
        HashSet<String> result = new HashSet<String>();
        for (Setting setting : this.settings) {
            String name = setting.getName();
            if (StringUtil.isNullOrEmpty(name)) continue;
            result.add(name);
        }
        return result;
    }

    @Override
    public Set<String> getIDs() {
        HashSet<String> result = new HashSet<String>();
        for (Setting setting : this.settings) {
            String id = setting.getId();
            if (StringUtil.isNullOrEmpty(id)) continue;
            result.add(id);
        }
        return result;
    }

    @Override
    public Set<String> getModuleIDs() {
        HashSet<String> result = new HashSet<String>();
        for (Setting setting : this.settings) {
            String moduleId = setting.getModuleId();
            if (StringUtil.isNullOrEmpty(moduleId)) continue;
            result.add(moduleId);
        }
        return result;
    }

    @Override
    public Set<String> getInstanceIDs() {
        HashSet<String> result = new HashSet<String>();
        for (Setting setting : this.settings) {
            String instanceId = setting.getInstanceId();
            if (StringUtil.isNullOrEmpty(instanceId)) continue;
            result.add(instanceId);
        }
        return result;
    }

    @Override
    public Set<String> getInstanceTypes() {
        HashSet<String> result = new HashSet<String>();
        for (Setting setting : this.settings) {
            String instanceType = setting.getInstanceType();
            if (StringUtil.isNullOrEmpty(instanceType)) continue;
            result.add(instanceType);
        }
        if (result.isEmpty()) {
            result.add("none");
        }
        return result;
    }

    @Override
    public Settings getSettingsOfModuleId(String moduleId) {
        SettingsImpl settingsOfModule = new SettingsImpl();
        if (!StringUtil.isNullOrEmpty(moduleId)) {
            for (Setting setting : this.settings) {
                if (!moduleId.equals(setting.getModuleId())) continue;
                settingsOfModule.add(setting);
            }
        }
        return settingsOfModule;
    }

    @Override
    public Settings getSettingsOfInstanceId(String instanceId) {
        SettingsImpl settingsOfInstance = new SettingsImpl();
        if (!StringUtil.isNullOrEmpty(instanceId)) {
            for (Setting setting : this.settings) {
                if (!instanceId.equals(setting.getInstanceId())) continue;
                settingsOfInstance.add(setting);
            }
        }
        return settingsOfInstance;
    }

    @Override
    public Settings getSettingsByNames(Set<String> names) {
        SettingsImpl settingsByNames = new SettingsImpl();
        if (names != null && !names.isEmpty()) {
            for (Setting setting : this.settings) {
                if (!names.contains(setting.getName())) continue;
                settingsByNames.add(setting);
            }
        }
        return settingsByNames;
    }

    @Override
    public List<Setting> maskPasswords() {
        return new MaskPasswords().maskPasswords(this.settings);
    }

    @Override
    public void unmaskPasswords(Settings existingSettings) {
        new MaskPasswords().unmaskPasswords(existingSettings.asList(), this.settings);
    }

    @Override
    public void clearMaskedPasswords() {
        new MaskPasswords().clearMaskedPasswords(this.settings);
    }

    @Override
    public List<Setting> asList() {
        return new ArrayList<Setting>(this.settings);
    }

    @Override
    public Map<String, Setting> asMap() {
        HashMap<String, Setting> result = new HashMap<String, Setting>();
        for (Setting setting : this.settings) {
            result.put(setting.getName(), setting);
        }
        return result;
    }

    @Override
    @NotNull
    public Iterator<Setting> iterator() {
        return this.settings.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SettingsImpl settings1 = (SettingsImpl)o;
        return Objects.equals(this.settings, settings1.settings);
    }

    public int hashCode() {
        return Objects.hashCode(this.settings);
    }

    public String toString() {
        return "SettingsImpl{settings=" + this.settings + "}";
    }
}

