/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auditlog.resource;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.auditlog.AuditLogLevel;
import de.virtimo.bpc.api.auditlog.AuditLogService;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.LogServiceException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.auditlog.AuditLogException;
import de.virtimo.bpc.core.auditlog.resource.AuditLogData;
import de.virtimo.bpc.core.deeplink.Deeplink;
import de.virtimo.bpc.core.deeplink.monitor.MonitorInstanceInvestigator;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.flow.IguasuHelper;
import de.virtimo.bpc.jaxrs.ApiResponse;
import de.virtimo.bpc.jaxrs.ApiResponses;
import de.virtimo.bpc.jaxrs.BpcEndpoint;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.logservice.ExternalReferenceData;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.StringUtil;
import de.virtimo.bpc.util.UriQueryUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.osgi.framework.BundleContext;

@Path(value="auditlog")
public class AuditLogEndpoint {
    private static final Logger LOG = Logger.getLogger(AuditLogEndpoint.class.getName());
    private final BundleContext bundleContext;
    private BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private BpcServicesTracker<AuditLogService> auditLogServiceTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;
    private BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;

    public AuditLogEndpoint(BundleContext bundleContext) {
        LOG.info("AuditLogEndpoint bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOG.info("onStartup");
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);
        this.auditLogServiceTracker = new BpcServicesTracker<AuditLogService>(this.bundleContext, AuditLogService.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(this.bundleContext, CoreBundleConfiguration.class);
    }

    public void onShutdown() {
        LOG.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    private CoreModule getCoreModule() throws ServiceNotFoundException, ModuleNotFoundException {
        return (CoreModule)this.moduleManagerTracker.getService().getModuleById("_core");
    }

    private void doGlobalMaintenanceModeEnabledCheck() throws ServiceNotFoundException, AuditLogException {
        if (this.coreBundleConfigurationTracker.getService().isMaintenanceModeEnabled()) {
            throw new AuditLogException((ErrorCode)CoreErrorCode.AUDITLOG_MAINTENANCE, "The core is currently in maintenance.");
        }
    }

    @POST
    @Path(value="/log")
    @BpcRoleOrRightRequired(role="AUDIT_LOG_USER", right="AUDIT_LOG_CREATE_ENTRY")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="The transferred data is not valid"), @ApiResponse(responseCode="401", description="Authentication could not be performed")})
    public Response log(@Context HttpHeaders hh, String json) {
        LOG.info("log");
        try {
            AuditLogData auditLogData;
            if (StringUtil.isNullOrEmpty(json)) {
                throw new LogServiceException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "No audit log data given");
            }
            this.doGlobalMaintenanceModeEnabledCheck();
            try {
                auditLogData = JsonUtil.getInstance().convertJsonStringToPojo(json, AuditLogData.class);
            }
            catch (IOException ex) {
                throw new LogServiceException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "Could not convert the given data to a AuditLogData object. Invalid JSON structure?", ex);
            }
            ExternalReferenceData externalReferenceData = IguasuHelper.extractIguasuSpecificHeaderValues(hh);
            AuditLogService auditLogService = this.auditLogServiceTracker.getService();
            auditLogService.log(AuditLogLevel.parse(auditLogData.getLevel()), auditLogData.getOriginator(), auditLogData.getAction(), auditLogData.getDescription(), auditLogData.getOldValues(), auditLogData.getNewValues(), this.createExternalReference(auditLogData, externalReferenceData));
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to create the audit log entry", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    private Map<String, Object> createExternalReference(AuditLogData auditLogData, ExternalReferenceData externalReferenceData) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (auditLogData != null && auditLogData.getExternalReference() != null) {
            result.putAll(auditLogData.getExternalReference());
        }
        if (externalReferenceData != null && !externalReferenceData.isEmpty()) {
            result.putAll(externalReferenceData.asMap());
        }
        return result.isEmpty() ? null : result;
    }

    @GET
    @Path(value="/open/monitor")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcEndpoint
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Authentication could not be performed"), @ApiResponse(responseCode="404", description="Module instance was not found"), @ApiResponse(responseCode="500", description="BPC deeplink could not be created"), @ApiResponse(responseCode="503", description="BPC or instance are currently in maintenance mode")})
    public Response openMonitorPage(@Context HttpServletRequest req) {
        LOG.info("openMonitorPage");
        try {
            this.doGlobalMaintenanceModeEnabledCheck();
            ModuleManager moduleManager = this.moduleManagerTracker.getService();
            CoreModule coreModule = this.getCoreModule();
            Set<String> monitorInstanceIDs = new MonitorInstanceInvestigator(moduleManager).getIDsOfMonitorInstancesUsingThisOpenSearchIndex("bpc-auditlog");
            Map<String, String> queryParams = UriQueryUtil.getQueryParams(req.getQueryString());
            String redirectUrl = new Deeplink(coreModule.getBpcFrontendUrl()).createMonitorRedirectUrl(monitorInstanceIDs, queryParams);
            return Response.ok().status(Response.Status.FOUND).header("Location", (Object)redirectUrl).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Creating the BPC deeplink and redirecting the user failed.", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

