/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.core.apikey.APIKeySession;
import de.virtimo.bpc.core.auth.CsrfTokenService;
import de.virtimo.bpc.util.UriQueryUtil;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.BundleContext;

public class CsrfTokenServiceImpl
implements CsrfTokenService,
BpcService {
    private static final Logger LOG = Logger.getLogger(CsrfTokenServiceImpl.class.getName());
    private final BundleContext bundleContext;

    public CsrfTokenServiceImpl(BundleContext bundleContext) {
        LOG.info("IpPinningServiceImpl bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOG.info("shutdownService");
    }

    @Override
    public boolean isValidRequest(HttpServletRequest httpServletRequest, UserSession userSession) {
        if (userSession instanceof APIKeySession) {
            LOG.finest("API key session - skip CSRF check");
            return true;
        }
        if ("GET".equalsIgnoreCase(httpServletRequest.getMethod())) {
            LOG.finest("GET Request - skip CSRF check");
            return true;
        }
        Map<String, List<String>> principals = userSession.getPrincipals();
        if (principals != null && principals.containsKey("X-Csrf-Token")) {
            List<String> csrfTokenListSession = principals.get("X-Csrf-Token");
            String csrfTokenRequest = httpServletRequest.getHeader("X-Csrf-Token");
            if (csrfTokenRequest == null) {
                String query = httpServletRequest.getQueryString();
                csrfTokenRequest = UriQueryUtil.getQueryParams(query).get("X-Csrf-Token");
            }
            if (csrfTokenRequest != null && csrfTokenListSession.contains(csrfTokenRequest)) {
                LOG.finest("CSRF Token found and matching usersession");
            } else {
                return false;
            }
        }
        return true;
    }
}

