/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingValidator;
import de.virtimo.bpc.api.ValidationException;
import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.api.db.exception.DataSourceNotFoundException;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.FrontendWarningException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.core.auth.oidc.KeycloakAdminClient;
import de.virtimo.bpc.core.auth.oidc.KeycloakAdminClientBuilder;
import de.virtimo.bpc.core.auth.oidc.KeycloakIdentityProvider;
import de.virtimo.bpc.core.auth.oidc.OidcIdentityProvider;
import de.virtimo.bpc.util.BpcTrustStore;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.SetUtil;
import de.virtimo.bpc.util.StringUtil;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import org.osgi.framework.BundleContext;

public class IdentityProviderSettingsValidator
implements SettingValidator {
    private static final Logger LOG = Logger.getLogger(IdentityProviderSettingsValidator.class.getName());
    private final BundleContext bundleContext;
    private final BpcServicesTracker<DatabaseManager> databaseManagerTracker;

    public IdentityProviderSettingsValidator(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.databaseManagerTracker = new BpcServicesTracker<DatabaseManager>(bundleContext, DatabaseManager.class);
    }

    @Override
    public void destroy() {
        LOG.info("destroy");
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public boolean canValidate(String moduleId, String moduleInstanceId, String instanceType) {
        return "backendconnection".equalsIgnoreCase(moduleId) && "identity_provider".equalsIgnoreCase(instanceType);
    }

    @Override
    public boolean canValidate(Setting setting) {
        if ("identity_provider".equalsIgnoreCase(setting.getInstanceType())) {
            List<String> settingsToValidate = Arrays.asList("identityProvider", "identityProvider_mappings", "identityProvider_configuration", "identityProvider_sessionExpirationMinutes");
            return settingsToValidate.contains(setting.getName());
        }
        return false;
    }

    @Override
    public List<FrontendWarningException> validate(Setting setting) throws ValidationException {
        Object idpMappingsObject;
        LOG.info("validate setting:" + setting);
        if (setting.getName().equalsIgnoreCase("identityProvider")) {
            String identityProvider = (String)setting.getValue();
            if (StringUtil.isNullOrEmpty(identityProvider)) {
                throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "CORE_ERROR_IDENTITY_PROVIDER_VALIDATION_MISSING_IDENTITY_PROVIDER", MapUtil.mapOf("field", "identityProvider"));
            }
            List<String> knownIdentityProviders = Arrays.asList("local", "karaf", "inubit", "jdbc", "keycloak", "oidc");
            if (!knownIdentityProviders.contains(identityProvider)) {
                throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "CORE_ERROR_IDENTITY_PROVIDER_VALIDATION_UNKNOWN_IDENTITY_PROVIDER", MapUtil.mapOf("field", "identityProvider", "identityProvider", identityProvider, "supportedIdentityProviders", knownIdentityProviders));
            }
        }
        if (setting.getName().equalsIgnoreCase("identityProvider_sessionExpirationMinutes")) {
            if (setting.getValue() == null) {
                throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "CORE_ERROR_IDENTITY_PROVIDER_SETTING_MISSING", MapUtil.mapOf("field", "identityProvider_sessionExpirationMinutes"));
            }
            if (setting.getSettingValue().asInt(-1) <= 0) {
                throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "CORE_ERROR_IDENTITY_PROVIDER_VALIDATION_MIN_NUMERIC_VALUE", MapUtil.mapOf("field", "identityProvider_sessionExpirationMinutes", "minValue", 0));
            }
        }
        if (setting.getName().equalsIgnoreCase("identityProvider_mappings") && (idpMappingsObject = setting.getValue()) instanceof Map) {
            this.validateIdentityProviderMappings((Map)idpMappingsObject);
        }
        return null;
    }

    private void validateIdentityProviderMappings(Map<String, Object> mappings) throws ValidationException {
        LOG.info("validateIdentityProviderMappings mappings=" + mappings);
        Set<String> validTopLevelKeys = SetUtil.setOf("organisations", "roles", "rights", "users");
        for (String topLevelKey : mappings.keySet()) {
            if (validTopLevelKeys.contains(topLevelKey.toLowerCase())) continue;
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "CORE_ERROR_IDENTITY_PROVIDER_VALIDATION_INVALID_TOP_LEVEL_KEY_IN_MAPPINGS", MapUtil.mapOf("topLevelKey", topLevelKey, "field", "identityProvider_mappings"));
        }
        ArrayList<String> assignedOrganisations = new ArrayList<String>();
        ArrayList<String> assignedRoles = new ArrayList<String>();
        ArrayList<String> assignedRights = new ArrayList<String>();
        this.caseSensitiveValuesCheck(mappings, assignedOrganisations, "assignedOrganisations");
        this.caseSensitiveValuesCheck(mappings, assignedRoles, "assignedRoles");
        this.caseSensitiveValuesCheck(mappings, assignedRights, "assignedRights");
    }

    private void caseSensitiveValuesCheck(Object mappings, List<String> alreadyAssignedValues, String assignedValuesKey) throws ValidationException {
        if (mappings instanceof Map) {
            Map m = (Map)mappings;
            for (Object mk : m.keySet()) {
                if (mk instanceof String && assignedValuesKey.equals(mk)) {
                    List assignedValues = (List)m.get(assignedValuesKey);
                    for (String assignedValue : assignedValues) {
                        this.checkIfValueExistsAlreadyInOtherCaseSensitivity(alreadyAssignedValues, assignedValue, assignedValuesKey);
                        alreadyAssignedValues.add(assignedValue);
                    }
                    continue;
                }
                this.caseSensitiveValuesCheck(m.get(mk), alreadyAssignedValues, assignedValuesKey);
            }
        }
    }

    private void checkIfValueExistsAlreadyInOtherCaseSensitivity(List<String> containerValues, String value, String assignedType) throws ValidationException {
        for (String containerValue : containerValues) {
            if (!containerValue.equalsIgnoreCase(value) || containerValue.equals(value)) continue;
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "CORE_ERROR_IDENTITY_PROVIDER_VALIDATION_INVALID_MAPPINGS_VALUE", MapUtil.mapOf("field", "identityProvider_mappings", "assignedType", assignedType, "value", value, "otherValue", containerValue));
        }
    }

    @Override
    public List<FrontendWarningException> validate(String moduleId, String moduleInstanceId, String instanceType, Map<String, Setting> settings) throws ValidationException {
        LOG.info("validate moduleId=" + moduleId + ", moduleInstanceId=" + moduleInstanceId + ", instanceType=" + instanceType + ", settings:...");
        String identityProvider = (String)settings.get("identityProvider").getValue();
        if (!identityProvider.equals("local") && !identityProvider.equals("karaf")) {
            if (identityProvider.equals("inubit")) {
                this.validateJaasInubit(settings);
            } else if (identityProvider.equals("jdbc")) {
                this.validateJdbc(settings);
            } else if (identityProvider.equals("oidc")) {
                this.validateOidc(settings);
            } else if (identityProvider.equals("keycloak")) {
                this.validateKeycloak(settings);
            }
        }
        return null;
    }

    private void validateJaasInubit(Map<String, Setting> settings) throws ValidationException {
        LOG.info("validateJaasInubit settings=...");
        String idpUrl = (String)settings.get("identityProvider.url").getValue();
        this.validateUrl(idpUrl, "identityProvider.url");
    }

    private void validateJdbc(Map<String, Setting> settings) throws ValidationException {
        LOG.info("validateJdbc settings=...");
        Map jdbcSettings = (Map)settings.get("identityProvider_configuration").getValue();
        if (jdbcSettings == null || jdbcSettings.isEmpty()) {
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "CORE_ERROR_IDENTITY_PROVIDER_SETTING_MISSING", MapUtil.mapOf("field", "identityProvider_configuration"));
        }
        String datasourceName = (String)jdbcSettings.get("datasource");
        if (StringUtil.isNullOrEmpty(datasourceName)) {
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "CORE_ERROR_IDENTITY_PROVIDER_VALIDATION_JDBC_DATASOURCE_MISSING", MapUtil.mapOf("field", "identityProvider_configuration"));
        }
        try {
            DatabaseManager databaseManager = this.databaseManagerTracker.getService();
            databaseManager.getDataSource(datasourceName);
        }
        catch (ServiceNotFoundException e) {
            throw new ValidationException((ErrorCode)BpcErrorCode.SERVICE_NOT_FOUND, "CORE_ERROR_IDENTITY_PROVIDER_VALIDATION_JDBC_DATABASE_MANAGER_MISSING", MapUtil.mapOf("field", "identityProvider_configuration", "dataSource", datasourceName));
        }
        catch (DataSourceNotFoundException e) {
            throw new ValidationException((ErrorCode)BpcErrorCode.DATABASE_DATASOURCE_NOT_FOUND, "CORE_ERROR_IDENTITY_PROVIDER_VALIDATION_JDBC_DATASOURCE_DOES_NOT_EXIST", MapUtil.mapOf("field", "identityProvider_configuration", "dataSource", datasourceName));
        }
    }

    private void validateOidc(Map<String, Setting> settings) throws ValidationException {
        LOG.info("validateOidc settings=...");
        String idpUrl = (String)settings.get("identityProvider.url").getValue();
        Map idpConfig = (Map)settings.get("identityProvider_configuration").getValue();
        this.validateUrl(idpUrl, "identityProvider.url");
        if (idpConfig == null || idpConfig.isEmpty()) {
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "CORE_ERROR_IDENTITY_PROVIDER_SETTING_MISSING", MapUtil.mapOf("field", "identityProvider_configuration"));
        }
        try {
            OidcIdentityProvider.checkOidcConfiguration(idpConfig);
        }
        catch (Exception e) {
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "CORE_ERROR_IDENTITY_PROVIDER_VALIDATION_OIDC", MapUtil.mapOf("field", "identityProvider_configuration", "error", e.getMessage()), (Throwable)e);
        }
    }

    private void validateKeycloak(Map<String, Setting> settings) throws ValidationException {
        LOG.info("validateKeycloak settings=...");
        String idpUrl = (String)settings.get("identityProvider.url").getValue();
        Map idpConfig = (Map)settings.get("identityProvider_configuration").getValue();
        this.validateUrl(idpUrl, "identityProvider.url");
        if (idpConfig == null || idpConfig.isEmpty()) {
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "CORE_ERROR_IDENTITY_PROVIDER_SETTING_MISSING", MapUtil.mapOf("field", "identityProvider_configuration"));
        }
        try {
            KeycloakIdentityProvider.checkKeycloakConfiguration(idpConfig);
            Map keycloakConfiguration = (Map)idpConfig.get("keycloak");
            String adminClientServerUrl = MapUtil.getValueAsString(keycloakConfiguration, "adminclient_server_url", null);
            String adminClientRealm = MapUtil.getValueAsString(keycloakConfiguration, "adminclient_realm", null);
            String adminClientClientId = MapUtil.getValueAsString(keycloakConfiguration, "adminclient_client_id", null);
            String adminClientUsername = MapUtil.getValueAsString(keycloakConfiguration, "adminclient_username", null);
            String adminClientPassword = MapUtil.getValueAsString(keycloakConfiguration, "adminclient_password", null);
            KeycloakAdminClient keycloakAdminClient = KeycloakAdminClientBuilder.builder().serverUrl(adminClientServerUrl).realm(adminClientRealm).clientId(adminClientClientId).username(adminClientUsername).password(adminClientPassword).build();
            keycloakAdminClient.validate();
        }
        catch (Exception e) {
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "CORE_ERROR_IDENTITY_PROVIDER_VALIDATION_KEYCLOAK", MapUtil.mapOf("field", "identityProvider_configuration", "error", e.getLocalizedMessage()), (Throwable)e);
        }
    }

    private void validateUrl(String url, String fieldName) throws ValidationException {
        if (StringUtil.isNullOrEmpty(url)) {
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "CORE_ERROR_IDENTITY_PROVIDER_VALIDATION_URL_MISSING", MapUtil.mapOf("field", fieldName));
        }
        try {
            URL u = new URL(url);
            URI i = u.toURI();
            URLConnection conn = u.openConnection();
            BpcTrustStore.getInstance().setTo(conn);
            conn.connect();
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException ex) {
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "CORE_ERROR_IDENTITY_PROVIDER_VALIDATION_URL_SYNTAX_RELATED", MapUtil.mapOf("field", fieldName, "url", url, "error", ex.getMessage()));
        }
        catch (SSLException ex) {
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "CORE_ERROR_IDENTITY_PROVIDER_VALIDATION_URL_SSL_RELATED", MapUtil.mapOf("field", fieldName, "url", url, "error", ex.getMessage()));
        }
        catch (Exception ex) {
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "CORE_ERROR_IDENTITY_PROVIDER_VALIDATION_URL", MapUtil.mapOf("field", fieldName, "url", url, "error", ex.getMessage()));
        }
    }
}

