/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth;

import de.virtimo.bpc.api.auth.Role;
import de.virtimo.bpc.core.auth.BpcAdminRoleImpl;
import de.virtimo.bpc.core.auth.BpcUserRoleImpl;
import de.virtimo.bpc.core.auth.FrontendBlockerRoleImpl;
import de.virtimo.bpc.core.auth.RoleImpl;
import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class RolesFactory {
    private static final Role BPC_ADMIN_ROLE = new BpcAdminRoleImpl();
    private static final Role BPC_USER_ROLE = new BpcUserRoleImpl();
    private static final Role FRONTEND_BLOCKER_ROLE = new FrontendBlockerRoleImpl();

    public static Role getRole(String roleName) {
        if (roleName.equalsIgnoreCase("bpcadmin")) {
            return RolesFactory.getBpcAdminRole();
        }
        if (roleName.equalsIgnoreCase("bpcuser")) {
            return RolesFactory.getBpcUserRole();
        }
        if (roleName.equalsIgnoreCase("bpcNoFrontend")) {
            return RolesFactory.getFrontendBlockerRole();
        }
        return new RoleImpl(roleName);
    }

    public static Role getRole(Principal principal) {
        return RolesFactory.getRole(principal.getName());
    }

    public static Role getBpcAdminRole() {
        return BPC_ADMIN_ROLE;
    }

    public static Role getBpcUserRole() {
        return BPC_USER_ROLE;
    }

    public static Role getFrontendBlockerRole() {
        return FRONTEND_BLOCKER_ROLE;
    }

    public static Set<Role> getRoles(Collection<String> roleNames) {
        HashSet<Role> result = new HashSet<Role>();
        if (roleNames != null) {
            for (String roleName : roleNames) {
                result.add(RolesFactory.getRole(roleName));
            }
        }
        return result;
    }
}

