/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth.jaas;

import de.virtimo.bpc.api.auth.Organisation;
import de.virtimo.bpc.api.auth.Role;
import de.virtimo.bpc.api.auth.User;
import de.virtimo.bpc.api.identityManagement.IdentityManagerException;
import de.virtimo.bpc.core.auth.OrganisationFactory;
import de.virtimo.bpc.core.auth.RolesFactory;
import de.virtimo.bpc.core.auth.UserFactory;
import de.virtimo.bpc.core.auth.UserNotFoundException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.karaf.jaas.boot.principal.GroupPrincipal;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.jaas.modules.BackingEngine;

public class BackingEngineDataConverter {
    public static User getUser(BackingEngine backingEngine, String userId) {
        UserPrincipal userPrincipal;
        User result = null;
        if (backingEngine != null && userId != null && (userPrincipal = backingEngine.lookupUser(userId)) != null) {
            result = UserFactory.getUser(userPrincipal);
        }
        return result;
    }

    public static List<User> getUsers(BackingEngine backingEngine) {
        ArrayList<User> result = new ArrayList<User>();
        if (backingEngine != null) {
            List userPrincipals = backingEngine.listUsers();
            for (UserPrincipal userPrincipal : userPrincipals) {
                result.add(UserFactory.getUser(userPrincipal));
            }
        }
        return result;
    }

    public static Set<Role> getRoles(BackingEngine backingEngine) {
        HashSet<Role> result = new HashSet<Role>();
        if (backingEngine != null) {
            result.addAll(BackingEngineDataConverter.getRolesOfAllUsers(backingEngine));
            result.addAll(BackingEngineDataConverter.getRolesOfAllOrganisations(backingEngine));
        }
        return result;
    }

    private static Set<Role> getRolesOfAllUsers(BackingEngine backingEngine) {
        HashSet<Role> result = new HashSet<Role>();
        if (backingEngine != null) {
            List userPrincipals = backingEngine.listUsers();
            for (UserPrincipal userPrincipal : userPrincipals) {
                result.addAll(BackingEngineDataConverter.getRolesOfUser(backingEngine, userPrincipal));
            }
        }
        return result;
    }

    private static Set<Role> getRolesOfAllOrganisations(BackingEngine backingEngine) {
        HashSet<Role> result = new HashSet<Role>();
        if (backingEngine != null) {
            Map groupPrincipalStringMap = backingEngine.listGroups();
            for (GroupPrincipal groupPrincipal : groupPrincipalStringMap.keySet()) {
                result.addAll(BackingEngineDataConverter.getRolesOfOrganisation(backingEngine, groupPrincipal));
            }
        }
        return result;
    }

    public static Set<Role> getUserRoles(BackingEngine backingEngine, String userId, boolean checkIfUserExists) throws IdentityManagerException {
        List userPrincipals;
        UserPrincipal userPrincipal = new UserPrincipal(userId);
        if (checkIfUserExists && !(userPrincipals = backingEngine.listUsers()).contains(userPrincipal)) {
            throw new UserNotFoundException(userId);
        }
        return BackingEngineDataConverter.getRolesOfUser(backingEngine, userPrincipal);
    }

    private static Set<Role> getRolesOfUser(BackingEngine backingEngine, UserPrincipal userPrincipal) {
        return BackingEngineDataConverter.getRolesOfPrincipal(backingEngine, (Principal)userPrincipal);
    }

    private static Set<Role> getRolesOfOrganisation(BackingEngine backingEngine, GroupPrincipal groupPrincipal) {
        return BackingEngineDataConverter.getRolesOfPrincipal(backingEngine, (Principal)groupPrincipal);
    }

    private static Set<Role> getRolesOfPrincipal(BackingEngine backingEngine, Principal principal) {
        HashSet<Role> result = new HashSet<Role>();
        if (backingEngine != null && principal != null) {
            List rolePrincipals = backingEngine.listRoles(principal);
            result.addAll(BackingEngineDataConverter.asRoles(rolePrincipals));
        }
        return result;
    }

    public static Set<Role> asRoles(List<RolePrincipal> rolePrincipals) {
        HashSet<Role> result = new HashSet<Role>();
        if (rolePrincipals != null) {
            for (RolePrincipal rolePrincipal : rolePrincipals) {
                result.add(RolesFactory.getRole((Principal)rolePrincipal));
            }
        }
        return result;
    }

    public static Set<Organisation> getOrganisations(BackingEngine backingEngine) {
        HashSet<Organisation> result = new HashSet<Organisation>();
        if (backingEngine != null) {
            Map groupPrincipalStringMap = backingEngine.listGroups();
            for (GroupPrincipal groupPrincipal : groupPrincipalStringMap.keySet()) {
                result.add(OrganisationFactory.getOrganisation((Principal)groupPrincipal));
            }
        }
        return result;
    }

    public static Set<Organisation> getUserOrganisations(BackingEngine backingEngine, String userId, boolean checkIfUserExists) throws IdentityManagerException {
        List userPrincipals;
        UserPrincipal userPrincipal = new UserPrincipal(userId);
        if (checkIfUserExists && !(userPrincipals = backingEngine.listUsers()).contains(userPrincipal)) {
            throw new UserNotFoundException(userId);
        }
        return BackingEngineDataConverter.getOrganisationsOfUser(backingEngine, userPrincipal);
    }

    private static Set<Organisation> getOrganisationsOfUser(BackingEngine backingEngine, UserPrincipal userPrincipal) {
        HashSet<Organisation> result = new HashSet<Organisation>();
        if (backingEngine != null && userPrincipal != null) {
            List groupPrincipals = backingEngine.listGroups(userPrincipal);
            for (GroupPrincipal groupPrincipal : groupPrincipals) {
                result.add(OrganisationFactory.getOrganisation((Principal)groupPrincipal));
            }
        }
        return result;
    }
}

