/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth.jaas.inubit;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import de.virtimo.bpc.api.ConnectionTestException;
import de.virtimo.bpc.api.auth.Organisation;
import de.virtimo.bpc.api.auth.Right;
import de.virtimo.bpc.api.auth.Role;
import de.virtimo.bpc.api.auth.User;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.ModuleInstanceNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.identityManagement.IdentityManager;
import de.virtimo.bpc.api.identityManagement.IdentityManagerException;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.auth.IdentityProviderConfiguration;
import de.virtimo.bpc.core.auth.RightFactory;
import de.virtimo.bpc.core.auth.UserFactory;
import de.virtimo.bpc.core.auth.jaas.BackingEngineDataConverter;
import de.virtimo.bpc.core.auth.jaas.ExtBackingEngine;
import de.virtimo.bpc.core.auth.jaas.RightPrincipal;
import de.virtimo.bpc.core.auth.jaas.inubit.InubitUserSession;
import de.virtimo.bpc.core.auth.jaas.inubit.response.InubitFeed;
import de.virtimo.bpc.core.auth.jaas.inubit.response.LoginResponse;
import de.virtimo.bpc.core.utils.RestWebServiceClientFactory;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.karaf.jaas.boot.principal.GroupPrincipal;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class InubitBackingEngine
implements ExtBackingEngine,
IdentityManager {
    private static final Logger LOG = Logger.getLogger(InubitBackingEngine.class.getName());

    public InubitBackingEngine(Map<String, ?> options) {
        LOG.info("InubitBackingEngine options=" + options);
    }

    private URI getIdentityProviderEndpoint() throws ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException, URISyntaxException {
        LOG.fine("getIdentityProviderEndpoint");
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        IdentityProviderConfiguration idpConfiguration = CoreModule.getCurrentIdentityProviderConfiguration(bundleContext);
        return this.getIdentityProviderEndpoint(idpConfiguration);
    }

    private URI getIdentityProviderEndpoint(IdentityProviderConfiguration idpConfiguration) throws URISyntaxException {
        LOG.fine("getIdentityProviderEndpoint idpConfiguration=...");
        String idpUrl = idpConfiguration.getIdentityProviderUrl();
        String idpType = idpConfiguration.getIdentityProviderName();
        return new URI(idpUrl + "?provider=" + idpType);
    }

    @Override
    public void destroy() {
        LOG.log(Level.FINEST, "destroy");
    }

    @Override
    public User getUser(String userId) throws IdentityManagerException {
        LOG.log(Level.FINEST, "getUser userId=" + userId);
        return this.convertToUser(this.fetchInubitFeedUser(userId));
    }

    @Override
    public List<User> getUsers() throws IdentityManagerException {
        LOG.log(Level.FINEST, "getUsers");
        return this.fetchInubitFeedUsers().stream().map(inubitFeedUser -> this.convertToUser((InubitFeed.User)inubitFeedUser)).collect(Collectors.toList());
    }

    @Override
    public Set<Organisation> getOrganisations() throws IdentityManagerException {
        LOG.log(Level.FINEST, "getOrganisations");
        return BackingEngineDataConverter.getOrganisations(this);
    }

    @Override
    public Set<Role> getRoles() throws IdentityManagerException {
        LOG.log(Level.FINEST, "getRoles");
        return BackingEngineDataConverter.asRoles(this.listRoles());
    }

    @Override
    public Set<Right> getRights() throws IdentityManagerException {
        LOG.log(Level.FINEST, "getRights");
        return this.listRights().stream().map(rightPrincipal -> RightFactory.getRight(rightPrincipal)).collect(Collectors.toSet());
    }

    @Override
    public Set<Organisation> getUserOrganisations(String userId) throws IdentityManagerException {
        LOG.log(Level.FINEST, "getUserOrganisations");
        return BackingEngineDataConverter.getUserOrganisations(this, userId, false);
    }

    @Override
    public Set<Role> getUserRoles(String userId) throws IdentityManagerException {
        LOG.log(Level.FINEST, "getUserRoles");
        return BackingEngineDataConverter.getUserRoles(this, userId, false);
    }

    @Override
    public Set<Right> getUserRights(String userId) throws IdentityManagerException {
        LOG.log(Level.FINEST, "getUserRights");
        return this.listRights((Principal)new UserPrincipal(userId)).stream().map(rightPrincipal -> RightFactory.getRight(rightPrincipal)).collect(Collectors.toSet());
    }

    @Override
    public void addUser(String username, String password) {
        LOG.info("addUser username=" + username + ", password=" + password);
        throw new UnsupportedOperationException("Adding user is not supported by this identity provider.");
    }

    @Override
    public void addUser(User user, String userPassword) throws IdentityManagerException {
        LOG.log(Level.FINEST, "addUser");
        throw new UnsupportedOperationException("Adding user is not supported by this identity provider.");
    }

    @Override
    public void addOrganisation(String userId, String orgName) throws IdentityManagerException {
        throw new UnsupportedOperationException("Adding user organisation is not supported by this identity provider.");
    }

    @Override
    public void addRight(String userId, String rightName) throws IdentityManagerException {
        throw new UnsupportedOperationException("Adding user right is not supported by this identity provider.");
    }

    @Override
    public void deleteUser(String username) {
        LOG.info("deleteUser username=" + username);
        throw new UnsupportedOperationException("Deleting user is not supported by this identity provider.");
    }

    @Override
    public void deleteOrganisation(String userId, String orgName) throws IdentityManagerException {
        throw new UnsupportedOperationException("Deleting user organisation is not supported by this identity provider.");
    }

    public List<UserPrincipal> listUsers() {
        LOG.info("listUsers");
        return this.fetchInubitFeedUsers().stream().map(inubitFeedUser -> new UserPrincipal(inubitFeedUser.name)).collect(Collectors.toList());
    }

    private User convertToUser(InubitFeed.User inubitFeedUser) {
        if (inubitFeedUser == null) {
            return null;
        }
        return UserFactory.getUser(inubitFeedUser.name, inubitFeedUser.name, inubitFeedUser.name, StringUtil.isNullOrEmpty(inubitFeedUser.firstName) ? "" : inubitFeedUser.firstName, StringUtil.isNullOrEmpty(inubitFeedUser.lastName) ? "" : inubitFeedUser.lastName, StringUtil.isNullOrEmpty(inubitFeedUser.email) ? "" : inubitFeedUser.email);
    }

    private InubitFeed.User fetchInubitFeedUser(String username) {
        LOG.info("fetchInubitFeedUser username=" + username);
        InubitFeed.User result = null;
        try (Client client = null;){
            client = RestWebServiceClientFactory.newClient(false);
            UriBuilder targetUriBuilder = UriBuilder.fromUri((URI)this.getIdentityProviderEndpoint()).queryParam("action", new Object[]{"getuser"}).queryParam("user", new Object[]{username});
            InubitFeed feed = (InubitFeed)client.target(targetUriBuilder).request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get(InubitFeed.class);
            if (feed != null && feed.entries != null && feed.entries.size() == 1) {
                result = feed.entries.get((int)0).user;
            }
        }
        return result;
    }

    private List<InubitFeed.User> fetchInubitFeedUsers() {
        LOG.info("fetchInubitFeedUsers");
        ArrayList<InubitFeed.User> result = new ArrayList<InubitFeed.User>();
        try (Client client = null;){
            client = RestWebServiceClientFactory.newClient(false);
            UriBuilder targetUriBuilder = UriBuilder.fromUri((URI)this.getIdentityProviderEndpoint()).queryParam("action", new Object[]{"getusers"});
            InubitFeed feed = (InubitFeed)client.target(targetUriBuilder).request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get(InubitFeed.class);
            if (feed != null && feed.entries != null) {
                for (InubitFeed.Entry entry : feed.entries) {
                    result.add(entry.user);
                }
            }
        }
        return result;
    }

    public UserPrincipal lookupUser(String username) {
        LOG.info("lookupUser username=" + username);
        InubitFeed.User inubitFeedUser = this.fetchInubitFeedUser(username);
        return inubitFeedUser == null ? null : new UserPrincipal(inubitFeedUser.name);
    }

    public void createGroup(String group) {
        LOG.info("createGroup group=" + group);
        throw new UnsupportedOperationException("Creating groups is not supported by this identity provider.");
    }

    public void addGroup(String username, String group) {
        LOG.info("addGroup username=" + username + ", group=" + group);
        throw new UnsupportedOperationException("Adding users to groups is not supported by this identity provider.");
    }

    public void deleteGroup(String username, String group) {
        LOG.info("deleteGroup username=" + username + ", group=" + group);
        throw new UnsupportedOperationException("Deleting users from groups is not supported by this identity provider.");
    }

    public Map<GroupPrincipal, String> listGroups() {
        LOG.info("listGroups");
        HashMap<GroupPrincipal, String> result = new HashMap<GroupPrincipal, String>();
        try (Client client = null;){
            client = RestWebServiceClientFactory.newClient(false);
            UriBuilder targetUriBuilder = UriBuilder.fromUri((URI)this.getIdentityProviderEndpoint()).queryParam("action", new Object[]{"getgroups"});
            InubitFeed feed = (InubitFeed)client.target(targetUriBuilder).request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get(InubitFeed.class);
            if (feed != null && feed.entries != null) {
                for (InubitFeed.Entry entry : feed.entries) {
                    InubitFeed.Group group = entry.group;
                    result.put(new GroupPrincipal(group.name), "");
                }
            }
        }
        return result;
    }

    public List<GroupPrincipal> listGroups(UserPrincipal user) {
        LOG.info("listGroups user=" + user);
        ArrayList<GroupPrincipal> groups = new ArrayList<GroupPrincipal>();
        try (Client client = null;){
            client = RestWebServiceClientFactory.newClient(false);
            UriBuilder targetUriBuilder = UriBuilder.fromUri((URI)this.getIdentityProviderEndpoint()).queryParam("action", new Object[]{"getusergroups"}).queryParam("user", new Object[]{user.getName()});
            InubitFeed feed = (InubitFeed)client.target(targetUriBuilder).request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get(InubitFeed.class);
            if (feed != null && feed.entries != null) {
                for (InubitFeed.Entry entry : feed.entries) {
                    InubitFeed.Group group = entry.group;
                    groups.add(new GroupPrincipal(group.name));
                }
            }
        }
        return groups;
    }

    @Override
    public void addRole(String username, String role) {
        LOG.info("addRole username=" + username + ", role=" + role);
        throw new UnsupportedOperationException("Adding roles to users is not supported by this identity provider.");
    }

    @Override
    public void addOrganisationRole(String orgName, String roleName) throws IdentityManagerException {
        throw new UnsupportedOperationException("Adding organisation role is not supported by this identity provider.");
    }

    @Override
    public void deleteRole(String username, String role) {
        LOG.info("deleteRole username=" + username + ", role=" + role);
        throw new UnsupportedOperationException("Deleting roles from users is not supported by this identity provider.");
    }

    @Override
    public void deleteOrganisationRole(String orgName, String roleName) throws IdentityManagerException {
        LOG.log(Level.FINEST, "deleteOrganisationRole");
        throw new UnsupportedOperationException("Deleting role from organisations is not supported by this identity provider.");
    }

    @Override
    public void deleteRight(String userId, String rightName) throws IdentityManagerException {
        LOG.log(Level.FINEST, "deleteRight");
        throw new UnsupportedOperationException("Deleting right from users is not supported by this identity provider.");
    }

    @Override
    public void updateUser(User user) throws IdentityManagerException {
        LOG.log(Level.FINEST, "updateUser");
        throw new UnsupportedOperationException("Updating users is not supported by this identity provider.");
    }

    @Override
    public void updateUserPassword(String userId, String userPassword) throws IdentityManagerException {
        LOG.log(Level.FINEST, "updateUserPassword");
        throw new UnsupportedOperationException("Updating user passwords is not supported by this identity provider.");
    }

    @Override
    public boolean checkUserPassword(String userId, String userPassword) throws IdentityManagerException {
        LOG.log(Level.FINEST, "checkUserPassword");
        throw new UnsupportedOperationException("Checking user passwords is not supported by this identity provider.");
    }

    public List<RolePrincipal> listRoles(Principal principal) {
        LOG.info("listRoles principal=" + principal);
        ArrayList<RolePrincipal> roles = new ArrayList<RolePrincipal>();
        try (Client client = null;){
            UriBuilder targetUriBuilder;
            client = RestWebServiceClientFactory.newClient(false);
            if (principal instanceof UserPrincipal) {
                targetUriBuilder = UriBuilder.fromUri((URI)this.getIdentityProviderEndpoint()).queryParam("action", new Object[]{"getuserroles"}).queryParam("user", new Object[]{principal.getName()});
            } else {
                if (principal instanceof GroupPrincipal) {
                    ArrayList<RolePrincipal> arrayList = roles;
                    return arrayList;
                }
                targetUriBuilder = UriBuilder.fromUri((URI)this.getIdentityProviderEndpoint()).queryParam("action", new Object[]{"getroles"});
            }
            InubitFeed feed = (InubitFeed)client.target(targetUriBuilder).request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get(InubitFeed.class);
            if (feed != null && feed.entries != null) {
                for (InubitFeed.Entry entry : feed.entries) {
                    InubitFeed.Role role = entry.role;
                    roles.add(new RolePrincipal(role.name));
                }
            }
        }
        return roles;
    }

    public void addGroupRole(String group, String role) {
        LOG.info("addGroupRole group=" + group + ", role=" + role);
        throw new UnsupportedOperationException("Adding roles to groups is not supported by this identity provider.");
    }

    public void deleteGroupRole(String group, String role) {
        LOG.info("deleteGroupRole group=" + group + ", role=" + role);
        throw new UnsupportedOperationException("Deleting roles from groups is not supported by this identity provider.");
    }

    private List<RightPrincipal> listRights(Principal principal) {
        LOG.finest("listRights principal=" + principal);
        ArrayList<RightPrincipal> rights = new ArrayList<RightPrincipal>();
        try (Client client = null;){
            UriBuilder targetUriBuilder;
            client = RestWebServiceClientFactory.newClient(false);
            if (principal instanceof UserPrincipal) {
                targetUriBuilder = UriBuilder.fromUri((URI)this.getIdentityProviderEndpoint()).queryParam("action", new Object[]{"getuserrights"}).queryParam("user", new Object[]{principal.getName()});
            } else {
                if (principal instanceof GroupPrincipal) {
                    ArrayList<RightPrincipal> arrayList = rights;
                    return arrayList;
                }
                targetUriBuilder = UriBuilder.fromUri((URI)this.getIdentityProviderEndpoint()).queryParam("action", new Object[]{"getrights"});
            }
            InubitFeed feed = (InubitFeed)client.target(targetUriBuilder).request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get(InubitFeed.class);
            if (feed != null && feed.entries != null) {
                for (InubitFeed.Entry entry : feed.entries) {
                    InubitFeed.Right right = entry.right;
                    rights.add(new RightPrincipal(right.name));
                }
            }
        }
        return rights;
    }

    private List<RightPrincipal> listRights() {
        LOG.finest("listRights");
        ArrayList<RightPrincipal> rights = new ArrayList<RightPrincipal>();
        try (Client client = null;){
            client = RestWebServiceClientFactory.newClient(false);
            UriBuilder targetUriBuilder = UriBuilder.fromUri((URI)this.getIdentityProviderEndpoint()).queryParam("action", new Object[]{"getrights"});
            InubitFeed feed = (InubitFeed)client.target(targetUriBuilder).request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get(InubitFeed.class);
            if (feed != null && feed.entries != null) {
                for (InubitFeed.Entry entry : feed.entries) {
                    InubitFeed.Right right = entry.right;
                    rights.add(new RightPrincipal(right.name));
                }
            }
        }
        return rights;
    }

    private List<RolePrincipal> listRoles() {
        LOG.finest("listRoles");
        ArrayList<RolePrincipal> roles = new ArrayList<RolePrincipal>();
        try (Client client = null;){
            client = RestWebServiceClientFactory.newClient(false);
            UriBuilder targetUriBuilder = UriBuilder.fromUri((URI)this.getIdentityProviderEndpoint()).queryParam("action", new Object[]{"getroles"});
            InubitFeed feed = (InubitFeed)client.target(targetUriBuilder).request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get(InubitFeed.class);
            if (feed != null && feed.entries != null) {
                for (InubitFeed.Entry entry : feed.entries) {
                    InubitFeed.Role role = entry.role;
                    roles.add(new RolePrincipal(role.name));
                }
            }
        }
        return roles;
    }

    @Override
    public boolean checkSession(Object sessionId) {
        LOG.finest("checkSession");
        return this.getSession(sessionId) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserSession getSession(Object sessionId) {
        LOG.finest("getSession");
        InubitUserSession userSession = null;
        try (Client client = null;){
            LoginResponse loginResponse;
            client = RestWebServiceClientFactory.newClient(false);
            UriBuilder targetUriBuilder = UriBuilder.fromUri((URI)this.getIdentityProviderEndpoint()).queryParam("action", new Object[]{"getSession"}).queryParam("sessionId", new Object[]{sessionId.toString()}).queryParam("interfaceVersion", new Object[]{"2.0.0"});
            Response response = ((Client)client.register(JacksonJsonProvider.class)).target(targetUriBuilder).request(new String[]{"application/json"}).get();
            LOG.finest("status: " + response.getStatus() + " - " + response.getStatusInfo().getReasonPhrase());
            if (response.getStatus() == Response.Status.OK.getStatusCode() && (loginResponse = (LoginResponse)response.readEntity(LoginResponse.class)).getSessionId().equals(sessionId)) {
                LOG.finest("Session OK");
                userSession = new InubitUserSession(loginResponse);
            }
        }
        return userSession;
    }

    public void performConnectionTest(IdentityProviderConfiguration idpConfiguration) throws ConnectionTestException {
        LOG.log(Level.FINEST, "performConnectionTest idpConfiguration=...");
        try (Client client = null;){
            client = RestWebServiceClientFactory.newClient(false);
            URI idpEndpoint = this.getIdentityProviderEndpoint(idpConfiguration);
            UriBuilder targetUriBuilder = UriBuilder.fromUri((URI)idpEndpoint).queryParam("action", new Object[]{"getusers"});
            Response response = client.target(targetUriBuilder).request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get();
            Response.StatusType statusType = response.getStatusInfo();
            if (statusType.getFamily() != Response.Status.Family.SUCCESSFUL) {
                throw new ConnectionTestException("Connection test failed with HTTP status code '${statusCode}': ${statusReason}", MapUtil.mapOf("statusCode", statusType.getStatusCode(), "statusReason", statusType.getReasonPhrase()));
            }
        }
    }
}

