/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth.jaas.inubit;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import de.virtimo.bpc.api.auth.jaas.SessionToken;
import de.virtimo.bpc.api.exception.ModuleInstanceNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.auth.IdentityProviderConfiguration;
import de.virtimo.bpc.core.auth.jaas.RightPrincipal;
import de.virtimo.bpc.core.auth.jaas.TenantCallback;
import de.virtimo.bpc.core.auth.jaas.inubit.response.LoginResponse;
import de.virtimo.bpc.core.utils.RestWebServiceClientFactory;
import de.virtimo.bpc.util.JsonUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.karaf.jaas.boot.principal.GroupPrincipal;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.jaas.modules.AbstractKarafLoginModule;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class InubitLoginModule
extends AbstractKarafLoginModule {
    private static final Logger LOG = Logger.getLogger(InubitLoginModule.class.getName());
    private UriBuilder uriBuilder;
    private String sessionId = "";

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, options);
        LOG.finest("initialize");
        try {
            BundleContext bundleContext = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
            IdentityProviderConfiguration idpConfiguration = CoreModule.getCurrentIdentityProviderConfiguration(bundleContext);
            String url = idpConfiguration.getIdentityProviderUrl();
            this.uriBuilder = UriBuilder.fromPath((String)url).queryParam("interfaceVersion", new Object[]{"2.0.0"});
        }
        catch (ModuleInstanceNotFoundException | ModuleNotFoundException | ServiceNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean login() throws LoginException {
        LOG.finest("login");
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false), new TenantCallback()};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            throw new LoginException(e.getMessage());
        }
        this.user = ((NameCallback)callbacks[0]).getName();
        char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
        if (tmpPassword == null) {
            tmpPassword = new char[]{};
        }
        String password = new String(tmpPassword);
        String tenant = ((TenantCallback)callbacks[2]).getTenant();
        Response response = null;
        try (Client client = null;){
            client = RestWebServiceClientFactory.newClient(false);
            HashMap<String, String> postData = new HashMap<String, String>();
            postData.put("username", this.user);
            postData.put("password", password);
            postData.put("tenant", tenant);
            this.uriBuilder.replaceQueryParam("action", new Object[]{"login"});
            LOG.info("Logging in to inubit at: " + this.uriBuilder.toTemplate());
            response = ((Client)client.register(JacksonJsonProvider.class)).target(this.uriBuilder).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)JsonUtil.getInstance().convertPojoToJsonString(postData), (MediaType)MediaType.APPLICATION_JSON_TYPE));
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                String msg = "Login status is not the expected OK:" + response.getStatus();
                LOG.info(msg);
                throw new LoginException(msg);
            }
        }
        LoginResponse loginResponse = (LoginResponse)response.readEntity(LoginResponse.class);
        this.principals = new HashSet();
        this.principals.add(new UserPrincipal(loginResponse.getUserName()));
        for (String role : loginResponse.getData().getRoles()) {
            this.principals.add(new RolePrincipal(role));
        }
        for (String organisation : loginResponse.getData().getOrganisations()) {
            this.principals.add(new GroupPrincipal(organisation));
        }
        for (String right : loginResponse.getData().getRights()) {
            this.principals.add(new RightPrincipal(right));
        }
        this.sessionId = loginResponse.getSessionId();
        this.subject.getPrivateCredentials().add(new SessionToken(){

            @Override
            public String get() {
                return InubitLoginModule.this.sessionId;
            }
        });
        this.succeeded = true;
        return true;
    }

    public boolean abort() {
        LOG.finest("abort");
        this.clear();
        return true;
    }

    public boolean logout() throws LoginException {
        LOG.finest("logout");
        this.uriBuilder.replaceQueryParam("action", new Object[]{"logout"});
        this.uriBuilder.queryParam("sessionId", new Object[]{this.sessionId});
        try (Client client = null;){
            client = RestWebServiceClientFactory.newClient(false);
            LOG.info("Logout to inubit at: " + this.uriBuilder.toTemplate());
            ((Client)client.register(JacksonJsonProvider.class)).target(this.uriBuilder).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
        }
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        return true;
    }
}

