/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth.jaas.jdbc;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.backendconnections.BackendConnections;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.auth.IdentityProviderConfiguration;
import de.virtimo.bpc.core.auth.jaas.jdbc.JDBCBackingEngine;
import de.virtimo.bpc.core.auth.jaas.jdbc.JDBCJaasOptions;
import de.virtimo.bpc.core.auth.jaas.jdbc.JDBCLoginModule;
import de.virtimo.bpc.core.auth.jaas.jdbc.JDBCQueriesConfiguration;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.karaf.jaas.modules.BackingEngine;
import org.apache.karaf.jaas.modules.BackingEngineFactory;
import org.apache.karaf.jaas.modules.encryption.EncryptionSupport;
import org.osgi.framework.BundleContext;

public class JDBCBackingEngineFactory
implements BackingEngineFactory {
    private static final Logger LOG = Logger.getLogger(JDBCBackingEngineFactory.class.getName());

    public BackingEngine build(Map<String, ?> options) {
        JDBCBackingEngine instance = null;
        BundleContext bundleContext = (BundleContext)options.get(BundleContext.class.getName());
        try (BpcServicesTracker<DatabaseManager> databaseManagerTracker = new BpcServicesTracker<DatabaseManager>(bundleContext, DatabaseManager.class);){
            String typeOfCurrentlyUsedIdentityProvider;
            IdentityProviderConfiguration jdbcIdpConfiguration = CoreModule.getCurrentIdentityProviderConfiguration(bundleContext);
            if (jdbcIdpConfiguration != null && !"jdbc".equalsIgnoreCase(typeOfCurrentlyUsedIdentityProvider = jdbcIdpConfiguration.getIdentityProviderName())) {
                LOG.warning("The currently set identity provider is of type '" + typeOfCurrentlyUsedIdentityProvider + "'. This cannot be used! Looking for one of type 'jdbc' ...");
                jdbcIdpConfiguration = null;
            }
            if (jdbcIdpConfiguration == null) {
                List<IdentityProviderConfiguration> jdbcBasedIdpConfigurations = BackendConnections.getIdentityProviderConfigurationsOfType(bundleContext, "jdbc");
                if (jdbcBasedIdpConfigurations.isEmpty()) {
                    throw new Exception("There is no identity provider backend connection of type 'jdbc'.");
                }
                if (jdbcBasedIdpConfigurations.size() > 1) {
                    throw new Exception("There are " + jdbcBasedIdpConfigurations.size() + " 'jdbc' based identity provider backend connections. There should only be one! Remove the not used ones or set the correct one as your active identity provider.");
                }
                jdbcIdpConfiguration = jdbcBasedIdpConfigurations.get(0);
            }
            Map<String, Object> jdbcIdentityProviderSettings = jdbcIdpConfiguration.getSpecificConfigurationAsMap();
            String datasourceName = (String)jdbcIdentityProviderSettings.get("datasource");
            JDBCQueriesConfiguration queries = new JDBCQueriesConfiguration(bundleContext);
            DataSource dataSource = databaseManagerTracker.getService().getDataSource(datasourceName);
            EncryptionSupport encryptionSupport = new EncryptionSupport(JDBCJaasOptions.updatedOptions(options));
            instance = new JDBCBackingEngine(dataSource, encryptionSupport, queries);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Error creating JDBCBackingEngine.", e);
        }
        return instance;
    }

    public String getModuleClass() {
        return JDBCLoginModule.class.getName();
    }
}

