/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth.jaas.jdbc;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.auth.IdentityProviderConfiguration;
import de.virtimo.bpc.core.auth.jaas.jdbc.JDBCJaasOptions;
import de.virtimo.bpc.core.auth.jaas.jdbc.JDBCQueriesConfiguration;
import de.virtimo.bpc.core.auth.jaas.jdbc.JDBCUtils;
import java.io.IOException;
import java.sql.Connection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.sql.DataSource;
import org.apache.karaf.jaas.boot.principal.GroupPrincipal;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.jaas.modules.AbstractKarafLoginModule;

public class JDBCLoginModule
extends AbstractKarafLoginModule {
    private static final Logger LOG = Logger.getLogger(JDBCLoginModule.class.getName());
    public static final String INSERT_USER_STATEMENT = "insert.user";
    public static final String INSERT_ROLE_STATEMENT = "insert.role";
    public static final String INSERT_GROUP_STATEMENT = "insert.group";
    public static final String UPDATE_USER_STATEMENT = "update.user";
    public static final String UPDATE_PASSWORD_STATEMENT = "update.pwd";
    public static final String PASSWORD_QUERY = "query.pwd";
    public static final String USERS_QUERY = "query.users";
    public static final String USER_QUERY = "query.user";
    public static final String ROLES_OF_USER_OR_GROUP_QUERY = "query.roles_of_user_or_group";
    public static final String ROLES_QUERY = "query.roles";
    public static final String GROUPS_OF_USER_QUERY = "query.groups_of_user";
    public static final String GROUPS_QUERY = "query.groups";
    public static final String DELETE_USER_STATEMENT = "delete.user";
    public static final String DELETE_ROLE_STATEMENT = "delete.role";
    public static final String DELETE_ROLES_STATEMENT = "delete.roles";
    public static final String DELETE_GROUP_STATEMENT = "delete.group";
    public static final String DELETE_GROUPS_STATEMENT = "delete.groups";

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, JDBCJaasOptions.updatedOptions(options));
    }

    public boolean login() throws LoginException {
        LOG.info("login");
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(uce.getMessage() + " not available to obtain information from user");
        }
        this.user = ((NameCallback)callbacks[0]).getName();
        char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
        if (tmpPassword == null) {
            tmpPassword = new char[]{};
        }
        String password = new String(tmpPassword);
        this.principals = new HashSet();
        try (BpcServicesTracker<DatabaseManager> databaseManagerTracker = new BpcServicesTracker<DatabaseManager>(this.bundleContext, DatabaseManager.class);){
            IdentityProviderConfiguration idpConfiguration = CoreModule.getCurrentIdentityProviderConfiguration(this.bundleContext);
            Map<String, Object> jdbcIdentityProviderSettings = idpConfiguration.getSpecificConfigurationAsMap();
            String datasourceName = (String)jdbcIdentityProviderSettings.get("datasource");
            if (datasourceName == null || datasourceName.trim().length() == 0) {
                throw new LoginException("No datasource specified in the JDBC identity provider settings");
            }
            JDBCQueriesConfiguration queries = new JDBCQueriesConfiguration(this.bundleContext);
            DataSource datasource = databaseManagerTracker.getService().getDataSource(datasourceName);
            try (Connection connection = datasource.getConnection();){
                String passwordQuery = queries.getSystemPropertyValueAsString(PASSWORD_QUERY, null);
                if (passwordQuery != null && !"".equals(passwordQuery.trim())) {
                    List<String> passwords = JDBCUtils.rawSelect(connection, passwordQuery, this.user);
                    if (passwords.isEmpty()) {
                        if (!this.detailedLoginExcepion) {
                            throw new LoginException("login failed");
                        }
                        throw new LoginException("User " + this.user + " does not exist");
                    }
                    if (!this.checkPassword(password, passwords.get(0))) {
                        if (!this.detailedLoginExcepion) {
                            throw new LoginException("login failed");
                        }
                        throw new LoginException("Password for " + this.user + " does not match");
                    }
                } else {
                    throw new LoginException("No 'query.pwd' query specified in the JDBC identity provider settings");
                }
                this.principals.add(new UserPrincipal(this.user));
                String rolesOfUserOrGroupQuery = queries.getSystemPropertyValueAsString(ROLES_OF_USER_OR_GROUP_QUERY, null);
                if (rolesOfUserOrGroupQuery != null && !"".equals(rolesOfUserOrGroupQuery.trim())) {
                    List<String> roles = JDBCUtils.rawSelect(connection, rolesOfUserOrGroupQuery, this.user);
                    for (String role : roles) {
                        this.principals.add(new RolePrincipal(role));
                    }
                } else {
                    LOG.info("No 'query.roles_of_user_or_group' specified so no roles have been retrieved for the authenticated user");
                }
                String groupsOfUserQuery = queries.getSystemPropertyValueAsString(GROUPS_OF_USER_QUERY, null);
                if (groupsOfUserQuery != null && !"".equals(groupsOfUserQuery.trim())) {
                    List<String> groups = JDBCUtils.rawSelect(connection, groupsOfUserQuery, this.user);
                    for (String group : groups) {
                        this.principals.add(new GroupPrincipal(group));
                        for (String role : JDBCUtils.rawSelect(connection, rolesOfUserOrGroupQuery, "_g_:" + group)) {
                            this.principals.add(new RolePrincipal(role));
                        }
                    }
                } else {
                    LOG.info("No 'query.groups_of_user' specified so no groups have been retrieved for the authenticated user");
                }
            }
        }
        catch (LoginException ex) {
            throw ex;
        }
        catch (ModuleNotFoundException | ServiceNotFoundException ex) {
            throw new LoginException("Failed to get the JDBC identity provider settings: " + ex.getMessage());
        }
        catch (Exception ex) {
            throw new LoginException("Error has occurred while retrieving credentials from database:" + ex.getMessage());
        }
        this.succeeded = true;
        return true;
    }

    public boolean abort() {
        return true;
    }

    public boolean logout() {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        if (this.debug) {
            LOG.fine("logout");
        }
        return true;
    }
}

