/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth.jaas.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.sql.DataSource;

public final class JDBCUtils {
    private static final Logger LOG = Logger.getLogger(JDBCUtils.class.getName());

    private JDBCUtils() {
    }

    protected static int rawUpdate(DataSource dataSource, String query, String ... params) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            int n;
            block14: {
                PreparedStatement statement = connection.prepareStatement(query);
                try {
                    for (int i = 0; i < params.length; ++i) {
                        statement.setString(i + 1, params[i]);
                    }
                    int res = statement.executeUpdate();
                    if (!connection.getAutoCommit()) {
                        connection.commit();
                    }
                    n = res;
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return n;
        }
    }

    protected static int rawUpdate(Connection connection, String query, String ... params) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement(query);){
            for (int i = 0; i < params.length; ++i) {
                statement.setString(i + 1, params[i]);
            }
            int n = statement.executeUpdate();
            return n;
        }
    }

    protected static List<String> rawSelect(DataSource dataSource, String query, String ... params) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            List<String> list = JDBCUtils.rawSelect(connection, query, params);
            return list;
        }
    }

    protected static List<String> rawSelect(Connection connection, String query, String ... params) throws SQLException {
        ArrayList<String> results = new ArrayList<String>();
        try (PreparedStatement statement = connection.prepareStatement(query);){
            for (int i = 0; i < params.length; ++i) {
                statement.setString(i + 1, params[i]);
            }
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    results.add(resultSet.getString(1));
                }
            }
        }
        return results;
    }

    protected static List<Map<String, String>> rawRecordSelect(Connection connection, String query, String ... params) throws SQLException {
        ArrayList<Map<String, String>> results = new ArrayList<Map<String, String>>();
        try (PreparedStatement statement = connection.prepareStatement(query);){
            for (int i = 0; i < params.length; ++i) {
                statement.setString(i + 1, params[i]);
            }
            try (ResultSet resultSet = statement.executeQuery();){
                HashSet<String> columnLabels = new HashSet<String>();
                for (int i = 1; i <= resultSet.getMetaData().getColumnCount(); ++i) {
                    columnLabels.add(resultSet.getMetaData().getColumnLabel(i));
                }
                while (resultSet.next()) {
                    HashMap<String, String> recordMap = new HashMap<String, String>();
                    for (String columnLabel : columnLabels) {
                        recordMap.put(columnLabel.toUpperCase(), resultSet.getString(columnLabel));
                    }
                    results.add(recordMap);
                }
            }
        }
        return results;
    }
}

