/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth.oidc;

import de.virtimo.bpc.core.auth.oidc.KeycloakAdminClient;

public class KeycloakAdminClientBuilder {
    private String serverUrl;
    private String realm;
    private String clientId;
    private String username;
    private String password;
    private boolean allowUntrustedConnections = false;
    private long connectionTimeoutInSeconds = 60L;

    private KeycloakAdminClientBuilder() {
    }

    public static KeycloakAdminClientBuilder builder() {
        return new KeycloakAdminClientBuilder();
    }

    public KeycloakAdminClientBuilder serverUrl(String serverUrl) {
        this.serverUrl = serverUrl;
        return this;
    }

    public KeycloakAdminClientBuilder realm(String realm) {
        this.realm = realm;
        return this;
    }

    public KeycloakAdminClientBuilder clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public KeycloakAdminClientBuilder username(String username) {
        this.username = username;
        return this;
    }

    public KeycloakAdminClientBuilder password(String password) {
        this.password = password;
        return this;
    }

    public KeycloakAdminClientBuilder allowUntrustedConnections(boolean allowUntrustedConnections) {
        this.allowUntrustedConnections = allowUntrustedConnections;
        return this;
    }

    public KeycloakAdminClientBuilder connectionTimeoutInSeconds(long connectionTimeoutInSeconds) {
        this.connectionTimeoutInSeconds = connectionTimeoutInSeconds;
        return this;
    }

    public KeycloakAdminClient build() {
        if (this.serverUrl == null) {
            throw new IllegalStateException("serverUrl required");
        }
        if (this.realm == null) {
            throw new IllegalStateException("realm required");
        }
        if (this.clientId == null) {
            throw new IllegalStateException("clientId required");
        }
        if (this.username == null) {
            throw new IllegalStateException("username required");
        }
        if (this.password == null) {
            throw new IllegalStateException("password required");
        }
        return new KeycloakAdminClient(this.serverUrl, this.realm, this.clientId, this.username, this.password, this.allowUntrustedConnections, this.connectionTimeoutInSeconds);
    }
}

