/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.backup;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.virtimo.bpc.api.AbstractRestoreBackupDoneEventHandler;
import de.virtimo.bpc.api.AbstractRestoreBackupStartEventHandler;
import de.virtimo.bpc.api.AbstractSettingUpdatedEventHandler;
import de.virtimo.bpc.api.BackupJobInfo;
import de.virtimo.bpc.api.BackupManager;
import de.virtimo.bpc.api.BackupSetting;
import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.Settings;
import de.virtimo.bpc.api.auditlog.SystemAuditLog;
import de.virtimo.bpc.api.backup.BackupActivatedInfo;
import de.virtimo.bpc.api.backup.BackupJob;
import de.virtimo.bpc.api.backup.BackupRestoredInfo;
import de.virtimo.bpc.api.backup.BackupSnapshotInfo;
import de.virtimo.bpc.api.backup.SnapshotName;
import de.virtimo.bpc.api.backup.exception.BackupConflictException;
import de.virtimo.bpc.api.backup.exception.BackupException;
import de.virtimo.bpc.api.backup.exception.BackupJobNotFoundException;
import de.virtimo.bpc.api.backup.exception.BackupNotFoundException;
import de.virtimo.bpc.api.backup.exception.BackupRepositoryNotFoundException;
import de.virtimo.bpc.api.exception.IndexMigrationException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.BpcIndexInfo;
import de.virtimo.bpc.api.opensearch.SearchScrollIterator;
import de.virtimo.bpc.api.response.GlobalConfig;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.backup.BackupActivatedInfoImpl;
import de.virtimo.bpc.core.backup.BackupJobsManager;
import de.virtimo.bpc.core.backup.BackupRestoredInfoImpl;
import de.virtimo.bpc.core.backup.Snapshotter;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.opensearch.ModuleConfigurationPersistenceHandler;
import de.virtimo.bpc.core.opensearch.migration.BpcIndicesMigrator;
import de.virtimo.bpc.core.resource.response.SettingsBasedConfigImpl;
import de.virtimo.bpc.core.service.EventManagerImpl;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BroadcastWebsocketMessage;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.ObjectMapperPool;
import de.virtimo.bpc.util.SetUtil;
import de.virtimo.bpc.util.StringUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.jetbrains.annotations.NotNull;
import org.opensearch.OpenSearchException;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.osgi.framework.BundleContext;

public class BackupManagerImpl
implements BackupManager,
BpcService {
    private static final Logger LOG = Logger.getLogger(BackupManagerImpl.class.getName());
    public static final String BACKUP_EVENT_TOPIC_CREATED = "de/virtimo/bpc/core/backup/backupCreated";
    public static final String BACKUP_EVENT_TOPIC_DELETED = "de/virtimo/bpc/core/backup/backupDeleted";
    public static final String BACKUP_EVENT_TOPIC_ACTIVATED = "de/virtimo/bpc/core/backup/backupActivated";
    public static final String BACKUP_EVENT_TOPIC_RESTORED = "de/virtimo/bpc/core/backup/backupRestored";
    public static final String SNAPSHOTS_REPOSITORY_NAME = "bpc_backup";
    private final BackupJobsManager backupJobsManager;
    private final BundleContext bundleContext;
    private final BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private final BpcServicesTracker<ClientSessionManager> clientSessionManagerTracker;
    private final BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private final BpcServicesTracker<EventManager> eventManagerTracker;
    private final EventRegistration eventRegistration;

    public BackupManagerImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.backupJobsManager = new BackupJobsManager(bundleContext);
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(bundleContext, ModuleManager.class);
        this.clientSessionManagerTracker = new BpcServicesTracker<ClientSessionManager>(bundleContext, ClientSessionManager.class);
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
        this.eventManagerTracker = new BpcServicesTracker<EventManager>(bundleContext, EventManager.class);
        this.eventRegistration = new EventRegistration(bundleContext);
        this.eventRegistration.forModuleUpdatedEvents("_core", "backupRepository", new BackupRepositoryUpdatedEventHandler());
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOG.info("shutdownService");
        this.backupJobsManager.destroy();
        this.eventRegistration.unregisterAllEventHandler();
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public List<BackupJobInfo> getBackupJobs() {
        return this.backupJobsManager.getBackupJobs();
    }

    @Override
    public int getNumberOfScheduledBackupJobs() {
        return this.backupJobsManager.getNumberOfScheduledBackupJobs();
    }

    @Override
    public Set<String> getIdentifiersOfScheduledBackupJobs() {
        return this.backupJobsManager.getIdentifiersOfScheduledBackupJobs();
    }

    @Override
    public Set<String> getIdentifiersOfBackupJobs() {
        return this.backupJobsManager.getIdentifiersOfBackupJobs();
    }

    @Override
    public void scheduleBackupJobWithSettings(String backupJobIdentifier, BackupSetting backupSetting) {
        LOG.info("scheduleBackupJobWithSettings backupJobIdentifier=" + backupJobIdentifier + ", backupJobSetting=" + backupSetting);
        this.backupJobsManager.scheduleBackupJobWithSettings(backupJobIdentifier, backupSetting);
    }

    @Override
    public void stopBackupJob(String backupJobIdentifier) {
        LOG.info("stopBackupJob backupJobIdentifier=" + backupJobIdentifier);
        this.backupJobsManager.stopBackupJob(backupJobIdentifier);
    }

    @Override
    public void stopBackupJobsWithPrefix(String backupJobIdentifierPrefix) {
        LOG.info("stopBackupJobsWithPrefix backupJobIdentifierPrefix=" + backupJobIdentifierPrefix);
        this.backupJobsManager.stopBackupJobsWithPrefix(backupJobIdentifierPrefix);
    }

    @Override
    public void deleteBackupJob(String backupJobIdentifier) {
        LOG.info("deleteBackupJob backupJobIdentifier=" + backupJobIdentifier);
        this.backupJobsManager.deleteBackupJob(backupJobIdentifier);
    }

    @Override
    public List<BackupSnapshotInfo> getAllBackups() throws ServiceNotFoundException, BackupRepositoryNotFoundException, OpenSearchRelatedException {
        LOG.info("getAllBackups");
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        Snapshotter snapshotter = new Snapshotter(oss);
        return snapshotter.getAllSnapshots(SNAPSHOTS_REPOSITORY_NAME);
    }

    @Override
    public BackupSnapshotInfo getBackupInfo(String snapshotNameAsString) throws BackupRepositoryNotFoundException, BackupNotFoundException, ServiceNotFoundException, OpenSearchRelatedException {
        LOG.info("getBackupInfo snapshotNameAsString=" + snapshotNameAsString);
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        SnapshotName snapshotName = SnapshotName.parse(snapshotNameAsString);
        Snapshotter snapshotter = new Snapshotter(oss);
        BackupSnapshotInfo snapshotInfo = snapshotter.getSnapshot(SNAPSHOTS_REPOSITORY_NAME, snapshotName);
        if (snapshotInfo == null) {
            throw new BackupNotFoundException(SNAPSHOTS_REPOSITORY_NAME, snapshotName.asString());
        }
        return snapshotInfo;
    }

    @Override
    public BackupSnapshotInfo createBackupUsingBackupJob(String backupJobIdentifier) throws BackupException, ServiceNotFoundException, ModuleNotFoundException, OpenSearchRelatedException {
        LOG.info("createBackupUsingBackupJob backupJobIdentifier=" + backupJobIdentifier);
        BackupJob backupJob = this.backupJobsManager.getBackupJob(backupJobIdentifier);
        if (backupJob == null) {
            throw new BackupJobNotFoundException(backupJobIdentifier);
        }
        BackupSnapshotInfo backupInfo = this.createBackup(backupJob.createNewSnapshotName(), backupJob.getBackupSetting().getIndicesToBackup());
        backupJob.setTimestampOfLatestBackup(backupInfo.getStartTimeInMillis());
        return backupInfo;
    }

    @Override
    public BackupSnapshotInfo createBackup(SnapshotName snapshotName, Set<String> indicesToBackup) throws BackupException, ServiceNotFoundException, ModuleNotFoundException, OpenSearchRelatedException {
        LOG.info("createBackup snapshotName=" + snapshotName + ", indicesToBackup=" + indicesToBackup);
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
        Snapshotter snapshotter = new Snapshotter(oss);
        this.checkIfBackupRepositoryExistsAndCreateIfNot(snapshotter);
        BackupSnapshotInfo snapshotInfo = snapshotter.createSnapshot(SNAPSHOTS_REPOSITORY_NAME, snapshotName, indicesToBackup);
        if (snapshotInfo == null) {
            throw new BackupException((ErrorCode)CoreErrorCode.BACKUP_CREATION_FAILED, "CORE_ERROR_BACKUP_SNAPSHOT_CREATION_FAILED", MapUtil.mapOf("snapshotName", snapshotName));
        }
        clientSessionManager.sendToUserRolesByWebsocketAsync(SetUtil.setOf("bpcadmin"), BACKUP_EVENT_TOPIC_CREATED, JsonUtil.getInstance().convertPojoToMap(snapshotInfo));
        return snapshotInfo;
    }

    @Override
    public BackupSnapshotInfo createBackupForBackupJob(BackupJob backupJob) throws BackupException, ServiceNotFoundException, ModuleNotFoundException, OpenSearchRelatedException {
        List<BackupSnapshotInfo> deletedSnapshots;
        LOG.info("createBackupForBackupJob backupJob=" + backupJob);
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
        String backupJobIdentifier = backupJob.getBackupJobIdentifier();
        Snapshotter snapshotter = new Snapshotter(oss);
        this.checkIfBackupRepositoryExistsAndCreateIfNot(snapshotter);
        List<BackupSnapshotInfo> snapshots = snapshotter.getAllSnapshotsWithPrefix(SNAPSHOTS_REPOSITORY_NAME, backupJob.getSnapshotNamePrefix());
        if (snapshots == null || snapshots.isEmpty()) {
            LOG.info(backupJobIdentifier + ": No snapshots exist");
            backupJob.setTimestampOfLatestBackup(0L);
        } else {
            long timestampOfLatestBackup = snapshotter.getTimestampOfLatestSnapshot(snapshots);
            LOG.info(backupJobIdentifier + ": Snapshots exist; date of latest:" + new Date(timestampOfLatestBackup));
            backupJob.setTimestampOfLatestBackup(timestampOfLatestBackup);
        }
        if (!backupJob.getBackupSetting().isEnabled()) {
            LOG.info(backupJobIdentifier + ": Skipping backup job execution ... job is disabled.");
            return null;
        }
        BackupSnapshotInfo snapshotInfo = null;
        if (backupJob.isItTimeToCreateABackup()) {
            LOG.info(backupJobIdentifier + ": Snapshot must be created");
            snapshotInfo = snapshotter.createSnapshot(SNAPSHOTS_REPOSITORY_NAME, backupJob.createNewSnapshotName(), backupJob.getBackupSetting().getIndicesToBackup());
            if (snapshotInfo != null) {
                backupJob.setTimestampOfLatestBackup(snapshotInfo.getStartTimeInMillis());
                SystemAuditLog.info("BackupCreated", "Backup with the snapshot name '" + snapshotInfo.getSnapshotName() + "' created");
                clientSessionManager.sendToUserRolesByWebsocketAsync(SetUtil.setOf("bpcadmin"), BACKUP_EVENT_TOPIC_CREATED, JsonUtil.getInstance().convertPojoToMap(snapshotInfo));
            }
        } else {
            LOG.info(backupJobIdentifier + ": Creating a snapshot is not necessary at the moment");
        }
        if (!(deletedSnapshots = snapshotter.deleteOldSnapshots(SNAPSHOTS_REPOSITORY_NAME, snapshots, backupJob.getBackupSetting().getKeepBackupsDurationInSeconds())).isEmpty()) {
            ArrayList<Map<String, Object>> websocketMessageContent = new ArrayList<Map<String, Object>>();
            for (BackupSnapshotInfo deletedSnapshot : deletedSnapshots) {
                SystemAuditLog.info("BackupDeleted", "Backup with the snapshot name '" + deletedSnapshot.getSnapshotName() + "' deleted");
                websocketMessageContent.add(JsonUtil.getInstance().convertPojoToMap(deletedSnapshot));
            }
            clientSessionManager.sendToUserRolesByWebsocketAsync(SetUtil.setOf("bpcadmin"), BACKUP_EVENT_TOPIC_DELETED, websocketMessageContent);
        }
        return snapshotInfo;
    }

    private void checkIfBackupRepositoryExistsAndCreateIfNot(Snapshotter snapshotter) throws BackupException, ServiceNotFoundException, ModuleNotFoundException {
        LOG.info("checkIfBackupRepositoryExistsAndCreateIfNot snapshotter=...");
        try {
            if (!snapshotter.existsBackupRepository(SNAPSHOTS_REPOSITORY_NAME)) {
                CoreModule coreModule = this.moduleManagerTracker.getService().getModuleByClass(CoreModule.class);
                Setting backupRepositorySetting = coreModule.getConfiguration().getSetting("backupRepository");
                Map backupRepositoryDefinition = backupRepositorySetting.getSettingValue().asMap();
                snapshotter.createBackupRepository(SNAPSHOTS_REPOSITORY_NAME, backupRepositoryDefinition);
            }
        }
        catch (ModuleNotFoundException | ServiceNotFoundException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BackupException((ErrorCode)CoreErrorCode.BACKUP_REPOSITORY_FAILURE, "CORE_ERROR_BACKUP_REPOSITORY_CREATION_FAILED", MapUtil.mapOf("repositoryName", SNAPSHOTS_REPOSITORY_NAME), (Throwable)ex);
        }
    }

    @Override
    public BackupSnapshotInfo deleteBackup(String snapshotNameAsString) throws BackupRepositoryNotFoundException, BackupNotFoundException, ServiceNotFoundException, OpenSearchRelatedException {
        LOG.info("deleteBackup snapshotNameAsString=" + snapshotNameAsString);
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
        SnapshotName snapshotName = SnapshotName.parse(snapshotNameAsString);
        Snapshotter snapshotter = new Snapshotter(oss);
        BackupSnapshotInfo snapshotInfo = snapshotter.getSnapshot(SNAPSHOTS_REPOSITORY_NAME, snapshotName);
        if (snapshotInfo == null) {
            throw new BackupNotFoundException(SNAPSHOTS_REPOSITORY_NAME, snapshotName.asString());
        }
        snapshotter.deleteSnapshot(SNAPSHOTS_REPOSITORY_NAME, snapshotName);
        clientSessionManager.sendToUserRolesByWebsocketAsync(SetUtil.setOf("bpcadmin"), BACKUP_EVENT_TOPIC_DELETED, JsonUtil.getInstance().convertPojoToMap(snapshotInfo));
        return snapshotInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BackupActivatedInfo activateBackup(String snapshotNameAsString) throws BackupNotFoundException, BackupConflictException, BackupException, ServiceNotFoundException, OpenSearchRelatedException {
        boolean bl;
        LOG.info("activateBackup snapshotNameAsString=" + snapshotNameAsString);
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
        SnapshotName snapshotName = SnapshotName.parse(snapshotNameAsString);
        Snapshotter snapshotter = new Snapshotter(oss);
        BackupSnapshotInfo snapshotInfo = snapshotter.getSnapshot(SNAPSHOTS_REPOSITORY_NAME, snapshotName);
        if (snapshotInfo == null) {
            throw new BackupNotFoundException(SNAPSHOTS_REPOSITORY_NAME, snapshotName.asString());
        }
        List<String> backupIndexNames = snapshotInfo.getIndices();
        for (String string : backupIndexNames) {
            Set<String> existingIndexNames;
            String aliasOfIndex = oss.aliasFromBpcIndexName(string);
            if (aliasOfIndex == null || (existingIndexNames = oss.getIndexNamesWithAlias(aliasOfIndex)).size() <= 1) continue;
            throw new BackupConflictException((ErrorCode)CoreErrorCode.BACKUP_ACTIVATION_FAILED, "Backup activation failed due to inconsistency. There are ${numberOfIndicesWithAlias} indices with the alias '${alias}': ${indexNames}", MapUtil.mapOf("numberOfIndicesWithAlias", existingIndexNames.size(), "alias", aliasOfIndex, "indexNames", "" + Arrays.asList(existingIndexNames.toArray(new String[0])), "snapshot", snapshotName));
        }
        ArrayList<String> aliasesOfBackupIndices = new ArrayList<String>();
        for (String backupIndexName : backupIndexNames) {
            String aliasOfBackupIndexName = oss.aliasFromBpcIndexName(backupIndexName);
            if (aliasOfBackupIndexName != null) {
                aliasesOfBackupIndices.add(aliasOfBackupIndexName);
                continue;
            }
            aliasesOfBackupIndices.add(backupIndexName);
        }
        boolean bl2 = false;
        ArrayList<Map<String, Object>> summary = new ArrayList<Map<String, Object>>();
        boolean startEventSent = this.sendBackupRestoreStartEvent(snapshotName, aliasesOfBackupIndices, backupIndexNames);
        try {
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (String backupIndexName : backupIndexNames) {
                HashMap<String, String> summaryEntry = new HashMap<String, String>();
                summaryEntry.put("backupIndexName", backupIndexName);
                String aliasOfIndex = oss.aliasFromBpcIndexName(backupIndexName);
                if (aliasOfIndex != null) {
                    summaryEntry.put("alias", aliasOfIndex);
                    Set<String> existingIndexNames = oss.getIndexNamesWithAlias(aliasOfIndex);
                    if (existingIndexNames.size() > 1) {
                        throw new BackupConflictException((ErrorCode)CoreErrorCode.BACKUP_ACTIVATION_FAILED, "Backup activation failed due to inconsistency. There are ${numberOfIndicesWithAlias} indices with the alias '${alias}': ${indexNames}", MapUtil.mapOf("numberOfIndicesWithAlias", existingIndexNames.size(), "alias", "bpc-configuration", "indexNames", "" + Arrays.asList(existingIndexNames.toArray(new String[0])), "snapshot", snapshotName));
                    }
                    String newIndexName = oss.existsIndex(backupIndexName) ? oss.newIndexNameForAlias(aliasOfIndex) : backupIndexName;
                    LOG.info("Activating backup index '" + backupIndexName + "' to new index '" + newIndexName + "'");
                    snapshotter.restoreSingleSnapshotIndex(SNAPSHOTS_REPOSITORY_NAME, snapshotName, backupIndexName, newIndexName, false);
                    summaryEntry.put("restoredToIndexName", newIndexName);
                    if (existingIndexNames.size() == 1) {
                        String currentIndexName = existingIndexNames.iterator().next();
                        oss.moveAlias(currentIndexName, newIndexName);
                        oss.closeIndex(currentIndexName);
                    } else if (existingIndexNames.size() == 0) {
                        oss.addAliasToIndex(aliasOfIndex, newIndexName);
                    }
                    if ("bpc-configuration".equalsIgnoreCase(aliasOfIndex)) {
                        bl = true;
                        try {
                            indicesMigrator = new BpcIndicesMigrator(oss);
                            indicesMigrator.migrateBpcConfigurationIndex();
                        }
                        catch (IndexMigrationException ex) {
                            LOG.log(Level.SEVERE, "Could not migrate the '" + aliasOfIndex + "' index", ex);
                        }
                        try {
                            this.moduleManagerTracker.getService().reloadAllModules();
                        }
                        catch (SettingException ex) {
                            LOG.log(Level.SEVERE, "Could not reload all modules due to a setting problem.", ex);
                        }
                    } else if ("bpc-notification".equalsIgnoreCase(aliasOfIndex)) {
                        try {
                            indicesMigrator = new BpcIndicesMigrator(oss);
                            indicesMigrator.migrateBpcNotificationIndex();
                        }
                        catch (IndexMigrationException ex) {
                            LOG.log(Level.SEVERE, "Could not migrate the '" + aliasOfIndex + "' index", ex);
                        }
                    } else if ("bpc-auditlog".equalsIgnoreCase(aliasOfIndex)) {
                        try {
                            indicesMigrator = new BpcIndicesMigrator(oss);
                            indicesMigrator.migrateBpcAuditlogIndex();
                        }
                        catch (IndexMigrationException ex) {
                            LOG.log(Level.SEVERE, "Could not migrate the '" + aliasOfIndex + "' index", ex);
                        }
                    }
                } else {
                    if (oss.existsIndex(backupIndexName)) {
                        oss.deleteIndex(backupIndexName);
                    }
                    LOG.info("Activating backup index '" + backupIndexName);
                    snapshotter.restoreSingleSnapshotIndex(SNAPSHOTS_REPOSITORY_NAME, snapshotName, backupIndexName, backupIndexName, false);
                    summaryEntry.put("restoredToIndexName", backupIndexName);
                }
                summary.add(summaryEntry);
            }
        }
        finally {
            if (startEventSent) {
                this.sendBackupRestoreDoneEvent(snapshotName, aliasesOfBackupIndices, summary);
            }
        }
        BackupActivatedInfoImpl backupActivatedInfo = new BackupActivatedInfoImpl(snapshotName.asString(), bl ? Boolean.TRUE : Boolean.FALSE);
        clientSessionManager.sendToUserRolesByWebsocketAsync(SetUtil.setOf("bpcadmin"), BACKUP_EVENT_TOPIC_ACTIVATED, MapUtil.mapOf("BackupName", backupActivatedInfo.getBackupName(), "BpcConfigurationIndex", backupActivatedInfo.isBpcConfigurationIndex()));
        if (bl) {
            EventManager eventManager = this.eventManagerTracker.getService();
            BroadcastWebsocketMessage broadcastWebsocketMessage = new BroadcastWebsocketMessage(((EventManagerImpl)eventManager).getServerUUID(), LocalDateTime.now(), "BpcConfigurationIndexRestored", null);
            eventManager.fireEvent("de/virtimo/os-bpc-plugin-send-broadcast-message-to-all", "msg", broadcastWebsocketMessage);
        }
        return backupActivatedInfo;
    }

    private boolean sendBackupRestoreStartEvent(SnapshotName snapshotName, List<String> aliasesOfBackupIndices, List<String> backupIndexNames) {
        try {
            AbstractRestoreBackupStartEventHandler.RestoreBackupStartEvent restoreBackupStartEvent = new AbstractRestoreBackupStartEventHandler.RestoreBackupStartEvent(snapshotName.asString(), aliasesOfBackupIndices, backupIndexNames);
            this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/backup/restore/start", restoreBackupStartEvent.asDictionary());
            return true;
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Failed to send the backup restore start event.", ex);
            return false;
        }
    }

    private boolean sendBackupRestoreDoneEvent(SnapshotName snapshotName, List<String> aliasesOfBackupIndices, List<Map<String, Object>> summary) {
        try {
            AbstractRestoreBackupDoneEventHandler.RestoreBackupDoneEvent restoreBackupDoneEvent = new AbstractRestoreBackupDoneEventHandler.RestoreBackupDoneEvent(snapshotName.asString(), aliasesOfBackupIndices, summary);
            this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/backup/restore/done", restoreBackupDoneEvent.asDictionary());
            return true;
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Failed to send the backup restore done event.", ex);
            return false;
        }
    }

    @Override
    public BackupRestoredInfo restoreBackup(String snapshotNameAsString, String givenIndexName) throws BackupNotFoundException, BackupConflictException, BackupException, ServiceNotFoundException, OpenSearchRelatedException {
        LOG.info("restoreBackup snapshotNameAsString=" + snapshotNameAsString + ", givenIndexName=" + givenIndexName);
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
        SnapshotName snapshotName = SnapshotName.parse(snapshotNameAsString);
        Snapshotter snapshotter = new Snapshotter(oss);
        BackupSnapshotInfo snapshotInfo = snapshotter.getSnapshot(SNAPSHOTS_REPOSITORY_NAME, snapshotName);
        if (snapshotInfo == null) {
            throw new BackupNotFoundException(SNAPSHOTS_REPOSITORY_NAME, snapshotName.asString());
        }
        List<String> indices = snapshotInfo.getIndices();
        if (indices.size() == 1) {
            String restoreToIndexName;
            String backupIndexName = indices.get(0);
            String string = restoreToIndexName = StringUtil.isNullOrEmpty(givenIndexName) ? backupIndexName : givenIndexName;
            if (oss.existsIndex(restoreToIndexName)) {
                throw new BackupConflictException((ErrorCode)CoreErrorCode.BACKUP_RESTORE_FAILED, "Restore not possible. There is already an index with the name '${index}'.", MapUtil.mapOf("index", restoreToIndexName));
            }
            LOG.info("Restoring backup index: " + backupIndexName + " to new index " + restoreToIndexName);
            snapshotter.restoreSingleSnapshotIndex(SNAPSHOTS_REPOSITORY_NAME, snapshotName, backupIndexName, restoreToIndexName, false);
            BackupRestoredInfoImpl backupRestoredInfo = new BackupRestoredInfoImpl(snapshotName.asString(), backupIndexName, restoreToIndexName);
            clientSessionManager.sendToUserRolesByWebsocketAsync(SetUtil.setOf("bpcadmin"), BACKUP_EVENT_TOPIC_RESTORED, MapUtil.mapOf("BackupName", backupRestoredInfo.getBackupName(), "RestoredFromIndex", backupRestoredInfo.getRestoredFromIndex(), "RestoredToIndex", backupRestoredInfo.getRestoredToIndex()));
            return backupRestoredInfo;
        }
        for (String index : indices) {
            if (!oss.existsIndex(index)) continue;
            throw new BackupConflictException((ErrorCode)CoreErrorCode.BACKUP_RESTORE_FAILED, "Restore not possible. There is already an index with the name '${index}'.", MapUtil.mapOf("index", index));
        }
        try {
            snapshotter.restoreAllSnapshotIndices(SNAPSHOTS_REPOSITORY_NAME, snapshotName, false);
            BackupRestoredInfoImpl backupRestoredInfo = new BackupRestoredInfoImpl(snapshotName.asString());
            clientSessionManager.sendToUserRolesByWebsocketAsync(SetUtil.setOf("bpcadmin"), BACKUP_EVENT_TOPIC_RESTORED, MapUtil.mapOf("BackupName", backupRestoredInfo.getBackupName()));
            return backupRestoredInfo;
        }
        catch (OpenSearchRelatedException ex) {
            throw new BackupException((ErrorCode)CoreErrorCode.BACKUP_RESTORE_FAILED, "Could not restore the indices of the snapshot '${snapshotName}'.", MapUtil.mapOf("snapshotName", snapshotName), (Throwable)ex);
        }
    }

    @Override
    public StreamingOutput downloadSnapshotContent(String snapshotNameAsString) throws BackupNotFoundException, BackupConflictException, BackupException, ServiceNotFoundException, OpenSearchRelatedException {
        LOG.info("downloadSnapshotContent snapshotNameAsString=" + snapshotNameAsString);
        final OpenSearchService oss = this.openSearchServiceTracker.getService();
        SnapshotName snapshotName = SnapshotName.parse(snapshotNameAsString);
        Snapshotter snapshotter = new Snapshotter(oss);
        BackupSnapshotInfo snapshotInfo = snapshotter.getSnapshot(SNAPSHOTS_REPOSITORY_NAME, snapshotName);
        if (snapshotInfo == null) {
            throw new BackupNotFoundException(SNAPSHOTS_REPOSITORY_NAME, snapshotName.asString());
        }
        List<String> indices = snapshotInfo.getIndices();
        final TemporaryIndices temporaryIndices = new TemporaryIndices(oss, indices);
        if (temporaryIndices.existsAtLeastOneOfThem()) {
            throw new BackupConflictException((ErrorCode)CoreErrorCode.BACKUP_DOWNLOAD_FAILED, "Download not possible. There is already an index with the temporary name '${index}'.", MapUtil.mapOf("index", temporaryIndices.getNameOfExistingTmpIndex()));
        }
        LOG.info("Temporary restoring backup indices ...");
        try {
            snapshotter.restoreSnapshotIndices(SNAPSHOTS_REPOSITORY_NAME, snapshotName, "(.+)", temporaryIndices.getPrefix() + "$1", false);
        }
        catch (Exception ex) {
            temporaryIndices.deleteAll();
            throw new BackupException((ErrorCode)CoreErrorCode.BACKUP_DOWNLOAD_FAILED, "Download not possible. Could not restore the content to temporary indices.", ex);
        }
        return new StreamingOutput(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(OutputStream outputStream) throws IOException, WebApplicationException {
                ObjectMapper mapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
                int i = 0;
                try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(outputStream));){
                    bw.write("[");
                    bw.newLine();
                    for (String tmpIndexName : temporaryIndices) {
                        String indexName = temporaryIndices.getIndexName(tmpIndexName);
                        SearchRequest searchReq = new SearchRequest().indices(tmpIndexName).source(new SearchSourceBuilder().size(500).query(QueryBuilders.matchAllQuery()));
                        bw.write("  {");
                        bw.newLine();
                        bw.write("    \"index\": \"" + indexName + "\"");
                        bw.write(",");
                        bw.newLine();
                        bw.write("    \"data\": ");
                        bw.write("[");
                        bw.newLine();
                        int rowIdx = 0;
                        try (SearchScrollIterator searchScrollIterator = new SearchScrollIterator(oss, searchReq);){
                            while (searchScrollIterator.hasNext()) {
                                SearchHits searchHits = searchScrollIterator.next();
                                for (SearchHit hit : searchHits) {
                                    Map<String, Object> sourceValues = hit.getSourceAsMap();
                                    bw.write("      ");
                                    bw.write(mapper.writeValueAsString(sourceValues));
                                    if ((long)(++rowIdx) < searchScrollIterator.getTotalHitsCount()) {
                                        bw.write(",");
                                        bw.newLine();
                                    }
                                    if (rowIdx % 5000 != 0) continue;
                                    bw.flush();
                                }
                            }
                        }
                        bw.newLine();
                        bw.write("    ]");
                        bw.newLine();
                        bw.write("  }");
                        if (++i >= temporaryIndices.size()) continue;
                        bw.write(",");
                        bw.newLine();
                    }
                    bw.newLine();
                    bw.write("]");
                }
                catch (IOException | OpenSearchException ex) {
                    LOG.log(Level.SEVERE, "Failed to read the index content.", ex);
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, "Could not write the index content to the download stream.", ex);
                }
                finally {
                    if (mapper != null) {
                        ObjectMapperPool.getInstance().restore((Object)mapper);
                    }
                    temporaryIndices.deleteAll();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GlobalConfig exportBpcConfiguration(String snapshotNameAsString) throws BackupException, BackupConflictException, ServiceNotFoundException, OpenSearchRelatedException {
        LOG.info("exportBpcConfiguration snapshotNameAsString=" + snapshotNameAsString);
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        SnapshotName snapshotName = SnapshotName.parse(snapshotNameAsString);
        Snapshotter snapshotter = new Snapshotter(oss);
        BackupSnapshotInfo snapshotInfo = snapshotter.getSnapshot(SNAPSHOTS_REPOSITORY_NAME, snapshotName);
        if (snapshotInfo == null) {
            throw new BackupNotFoundException(SNAPSHOTS_REPOSITORY_NAME, snapshotName.asString());
        }
        List<String> indices = snapshotInfo.getIndices();
        if (indices.size() != 1 || !indices.get(0).startsWith("bpc-configuration")) {
            throw new BackupConflictException((ErrorCode)CoreErrorCode.BACKUP_DOWNLOAD_FAILED, "Export not possible. Only snapshots of the bpc-configuration index can be exported.");
        }
        String bpcConfigurationIndexName = indices.get(0);
        TemporaryIndices temporaryIndices = new TemporaryIndices(oss, indices);
        if (temporaryIndices.existsAtLeastOneOfThem()) {
            throw new BackupConflictException((ErrorCode)CoreErrorCode.BACKUP_DOWNLOAD_FAILED, "Export not possible. There is already an index with the temporary name '${index}'.", MapUtil.mapOf("index", temporaryIndices.getNameOfExistingTmpIndex()));
        }
        String restoredBpcConfigurationIndexName = temporaryIndices.getTmpIndexName(bpcConfigurationIndexName);
        try {
            LOG.info("Temporary restoring backup indices ...");
            try {
                snapshotter.restoreSnapshotIndices(SNAPSHOTS_REPOSITORY_NAME, snapshotName, "(.+)", temporaryIndices.getPrefix() + "$1", false);
            }
            catch (OpenSearchRelatedException ex) {
                throw new BackupException((ErrorCode)CoreErrorCode.BACKUP_DOWNLOAD_FAILED, "Download not possible. Could not restore the content to temporary indices.", ex);
            }
            int modelVersion = oss.getModelVersion(restoredBpcConfigurationIndexName);
            BpcIndexInfo restoredBpcIndexInfo = oss.getBpcIndexInfoUsingIndexName(restoredBpcConfigurationIndexName);
            Settings allSettings = ModuleConfigurationPersistenceHandler.readAllSettingsFromBpcConfigurationIndex(oss, restoredBpcConfigurationIndexName);
            SettingsBasedConfigImpl settingsBasedConfigImpl = new SettingsBasedConfigImpl(this.moduleManagerTracker.getService(), restoredBpcIndexInfo, modelVersion, allSettings);
            return settingsBasedConfigImpl;
        }
        catch (BackupException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to read the settings from the temporarily restored bpc-configuration index: " + restoredBpcConfigurationIndexName, ex);
        }
        finally {
            temporaryIndices.deleteAll();
        }
        return null;
    }

    private class BackupRepositoryUpdatedEventHandler
    extends AbstractSettingUpdatedEventHandler {
        private BackupRepositoryUpdatedEventHandler() {
        }

        @Override
        public void processSetting(Setting backupRepositorySetting) {
            LOG.info(this.getClass().getSimpleName() + ".processSetting backupRepositorySetting=...");
            try {
                OpenSearchService oss = BackupManagerImpl.this.openSearchServiceTracker.getService();
                Snapshotter snapshotter = new Snapshotter(oss);
                Map backupRepositoryDefinition = backupRepositorySetting.getSettingValue().asMap();
                snapshotter.createBackupRepository(BackupManagerImpl.SNAPSHOTS_REPOSITORY_NAME, backupRepositoryDefinition);
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, this.getClass().getSimpleName() + ": Failed to register the backup repository in OpenSearch.", ex);
            }
        }
    }

    private static class TemporaryIndices
    implements Iterable<String> {
        private final OpenSearchService oss;
        private final Map<String, String> tmpIndexNames;
        private final String prefix;
        private static long prefixCounter = 0L;
        private String existingIndexName;

        TemporaryIndices(OpenSearchService oss, List<String> indices) {
            this.oss = oss;
            this.prefix = "tmp_backup_restore_index_" + TemporaryIndices.getNextPrefixCounter() + "_";
            this.tmpIndexNames = this.createTmpIndexNames(indices);
        }

        private static synchronized long getNextPrefixCounter() {
            if (prefixCounter == Long.MAX_VALUE) {
                prefixCounter = 0L;
            }
            return ++prefixCounter;
        }

        String getPrefix() {
            return this.prefix;
        }

        private String createTmpIndexName(String indexName) {
            return this.prefix + indexName;
        }

        private Map<String, String> createTmpIndexNames(List<String> indices) {
            HashMap<String, String> result = new HashMap<String, String>();
            if (indices != null) {
                for (String index : indices) {
                    result.put(index, this.createTmpIndexName(index));
                }
            }
            return result;
        }

        @Override
        @NotNull
        public Iterator<String> iterator() {
            return this.tmpIndexNames.values().iterator();
        }

        int size() {
            return this.tmpIndexNames.size();
        }

        String getTmpIndexName(String indexName) {
            return this.tmpIndexNames.get(indexName);
        }

        String getIndexName(String temporaryIndexName) {
            for (Map.Entry<String, String> indexAndTmpIndexNames : this.tmpIndexNames.entrySet()) {
                String indexName = indexAndTmpIndexNames.getKey();
                String tmpIndexName = indexAndTmpIndexNames.getValue();
                if (!tmpIndexName.equals(temporaryIndexName)) continue;
                return indexName;
            }
            return null;
        }

        boolean existsAtLeastOneOfThem() throws OpenSearchRelatedException {
            LOG.info("existsAtLeastOneOfThem");
            for (String tmpIndexName : this.tmpIndexNames.values()) {
                if (!this.oss.existsIndex(tmpIndexName)) continue;
                this.existingIndexName = tmpIndexName;
                return true;
            }
            return false;
        }

        String getNameOfExistingTmpIndex() {
            return this.existingIndexName;
        }

        void deleteAll() {
            LOG.info("deleteAll");
            for (String tmpIndexName : this.tmpIndexNames.values()) {
                try {
                    this.oss.deleteIndex(tmpIndexName);
                }
                catch (Throwable ex) {
                    LOG.log(Level.SEVERE, "Failed to delete the temporary index: " + tmpIndexName, ex);
                }
            }
        }
    }
}

