/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.backup;

import de.virtimo.bpc.api.backup.BackupSnapshotInfo;
import de.virtimo.bpc.api.backup.SnapshotName;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import org.opensearch.snapshots.SnapshotInfo;
import org.opensearch.snapshots.SnapshotState;

public class BackupSnapshotInfoImpl
implements BackupSnapshotInfo {
    private final SnapshotName snapshotName;
    private final Instant startTime;
    private final SnapshotState state;
    private final List<String> indices;
    private final boolean bpcConfigurationIndex;

    public BackupSnapshotInfoImpl(SnapshotInfo snapshotInfo) {
        this.snapshotName = SnapshotName.parse(snapshotInfo.snapshotId().getName());
        this.startTime = this.snapshotName.getCreatedDate();
        this.state = snapshotInfo.state();
        this.indices = snapshotInfo.indices();
        this.bpcConfigurationIndex = snapshotInfo.indices() != null && snapshotInfo.indices().size() == 1 && snapshotInfo.indices().get(0).startsWith("bpc-configuration");
    }

    public BackupSnapshotInfoImpl(SnapshotName snapshotName, Instant startTime, SnapshotState state, List<String> indices, boolean bpcConfigurationIndex) {
        this.snapshotName = snapshotName;
        this.startTime = startTime;
        this.state = state;
        this.indices = indices;
        this.bpcConfigurationIndex = bpcConfigurationIndex;
    }

    @Override
    public SnapshotName getSnapshotName() {
        return this.snapshotName;
    }

    @Override
    public Instant getStartTime() {
        return this.startTime;
    }

    @Override
    public long getStartTimeInMillis() {
        return this.startTime.toEpochMilli();
    }

    @Override
    public SnapshotState getState() {
        return this.state;
    }

    @Override
    public List<String> getIndices() {
        return this.indices;
    }

    @Override
    public boolean isBpcConfigurationIndex() {
        return this.bpcConfigurationIndex;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackupSnapshotInfoImpl that = (BackupSnapshotInfoImpl)o;
        return this.bpcConfigurationIndex == that.bpcConfigurationIndex && Objects.equals(this.snapshotName, that.snapshotName) && Objects.equals(this.startTime, that.startTime) && this.state == that.state && Objects.equals(this.indices, that.indices);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.snapshotName, this.startTime, this.state, this.indices, this.bpcConfigurationIndex});
    }

    public String toString() {
        return "BackupSnapshotInfoImpl{snapshotName='" + this.snapshotName + "', startTime=" + this.startTime + ", state=" + this.state + ", indices=" + this.indices + ", bpcConfigurationIndex=" + this.bpcConfigurationIndex + "}";
    }
}

