/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.db;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.db.DatabaseConnectionPoolEntry;
import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.util.MapUtil;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.GaugeMetricFamily;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;

public class DatabaseConnectionPoolCollector
extends Collector {
    private static final Logger LOG = Logger.getLogger(DatabaseConnectionPoolCollector.class.getName());
    private final BpcServicesTracker<DatabaseManager> databaseManagerTracker;

    public DatabaseConnectionPoolCollector(BundleContext bundleContext) {
        this.databaseManagerTracker = new BpcServicesTracker<DatabaseManager>(bundleContext, DatabaseManager.class);
    }

    public void unregister() {
        LOG.info("unregister");
        CollectorRegistry.defaultRegistry.unregister((Collector)this);
        BpcServicesTracker.stopAll((Object)this);
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        try {
            List<DatabaseConnectionPoolEntry> connectionPoolEntries = this.databaseManagerTracker.getService().getDatabaseConnectionPoolEntries();
            List<String> labelList = Arrays.asList("pool", "db");
            GaugeMetricFamily activeGauge = new GaugeMetricFamily("karaf_dbcp2_pool_connections_active", "Number of active pool connections", labelList);
            GaugeMetricFamily waitersGauge = new GaugeMetricFamily("karaf_dbcp2_pool_connections_waiters", "Number of waiting for pool connection", labelList);
            GaugeMetricFamily idleGauge = new GaugeMetricFamily("karaf_dbcp2_pool_connections_idle", "Number of idle pool connections", labelList);
            GaugeMetricFamily maxTotalGauge = new GaugeMetricFamily("karaf_dbcp2_pool_connections_max_total", "Max total number of pool connections", labelList);
            GaugeMetricFamily borrowedGauge = new GaugeMetricFamily("karaf_dbcp2_pool_connections_borrowed", "Number of borrowed pool connections", labelList);
            GaugeMetricFamily returnedGauge = new GaugeMetricFamily("karaf_dbcp2_pool_connections_returned", "Number of returned pool connections", labelList);
            GaugeMetricFamily meanBorrowWaitTimeMillisGauge = new GaugeMetricFamily("karaf_dbcp2_pool_connections_mean_borrow_wait_time", "Mean borrow wait time in millis", labelList);
            GaugeMetricFamily maxBorrowWaitTimeMillisGauge = new GaugeMetricFamily("karaf_dbcp2_pool_connections_max_borrow_wait_time", "Max borrow wait time in millis", labelList);
            for (DatabaseConnectionPoolEntry connectionPoolEntry : connectionPoolEntries) {
                List<String> labelValueList = Arrays.asList(connectionPoolEntry.getName(), connectionPoolEntry.getDatabaseName());
                Map<String, Object> poolAttrs = connectionPoolEntry.getAttributes();
                activeGauge.addMetric(labelValueList, this.asDouble(MapUtil.getValueAsInt(poolAttrs, "NumActive", 0)));
                waitersGauge.addMetric(labelValueList, this.asDouble(MapUtil.getValueAsInt(poolAttrs, "NumWaiters", 0)));
                idleGauge.addMetric(labelValueList, this.asDouble(MapUtil.getValueAsInt(poolAttrs, "NumIdle", 0)));
                maxTotalGauge.addMetric(labelValueList, this.asDouble(MapUtil.getValueAsInt(poolAttrs, "MaxTotal", 0)));
                borrowedGauge.addMetric(labelValueList, this.asDouble(MapUtil.getValueAsLong(poolAttrs, "BorrowedCount", 0L)));
                returnedGauge.addMetric(labelValueList, this.asDouble(MapUtil.getValueAsLong(poolAttrs, "ReturnedCount", 0L)));
                meanBorrowWaitTimeMillisGauge.addMetric(labelValueList, this.asDouble(MapUtil.getValueAsLong(poolAttrs, "MeanBorrowWaitTimeMillis", 0L)));
                maxBorrowWaitTimeMillisGauge.addMetric(labelValueList, this.asDouble(MapUtil.getValueAsLong(poolAttrs, "MaxBorrowWaitTimeMillis", 0L)));
            }
            mfs.add((Collector.MetricFamilySamples)activeGauge);
            mfs.add((Collector.MetricFamilySamples)waitersGauge);
            mfs.add((Collector.MetricFamilySamples)idleGauge);
            mfs.add((Collector.MetricFamilySamples)maxTotalGauge);
            mfs.add((Collector.MetricFamilySamples)borrowedGauge);
            mfs.add((Collector.MetricFamilySamples)returnedGauge);
            mfs.add((Collector.MetricFamilySamples)meanBorrowWaitTimeMillisGauge);
            mfs.add((Collector.MetricFamilySamples)maxBorrowWaitTimeMillisGauge);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return mfs;
    }

    private double asDouble(Object o) {
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        return 0.0;
    }
}

