/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.db;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ConnectionTestException;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.db.DataSourceEntry;
import de.virtimo.bpc.api.db.DatabaseConnectionPoolEntry;
import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.api.db.PaxJdbcConfigurationUpdatedInfo;
import de.virtimo.bpc.api.db.exception.DataSourceException;
import de.virtimo.bpc.api.db.exception.DataSourceNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.core.db.DataSourceEntryImpl;
import de.virtimo.bpc.core.db.DatabaseConnectionPoolEntryImpl;
import de.virtimo.bpc.core.db.PaxJdbcConfigurationUpdatedInfoImpl;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.util.DictionaryUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.SetUtil;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.jdbc.DataSourceFactory;
import org.osgi.util.tracker.ServiceTracker;

public class DatabaseManagerImpl
implements DatabaseManager,
BpcService {
    private static final Logger LOG = Logger.getLogger(DatabaseManager.class.getName());
    private BundleContext bundleContext;
    private BpcServicesTracker<ConfigurationAdmin> configurationAdminTracker;

    private DatabaseManagerImpl() {
    }

    public DatabaseManagerImpl(BundleContext bundleContext) {
        LOG.info("DatabaseManagerImpl bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
        this.configurationAdminTracker = new BpcServicesTracker<ConfigurationAdmin>(bundleContext, ConfigurationAdmin.class);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOG.info("shutdownService");
        BpcServicesTracker.stopAll(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized DataSource getDataSource(String dataSourceName) throws DataSourceNotFoundException {
        LOG.info("getDataSource dataSourceName=" + dataSourceName);
        ServiceReference<CommonDataSource> dataSourceServiceReference = this.getDataSourceServiceReference(this.bundleContext, dataSourceName);
        if (dataSourceServiceReference == null) {
            throw new DataSourceNotFoundException(dataSourceName);
        }
        try {
            DataSource dataSource = (DataSource)this.bundleContext.getService(dataSourceServiceReference);
            return dataSource;
        }
        finally {
            this.bundleContext.ungetService(dataSourceServiceReference);
        }
    }

    @Override
    public Configuration getDataSourceConfiguration(String dataSourceName) throws DataSourceException {
        LOG.info("getDataSourceConfiguration dataSourceName=" + dataSourceName);
        try {
            ConfigurationAdmin confAdmin = this.configurationAdminTracker.getService();
            String filter = String.format("(%s=%s)", "dataSourceName", dataSourceName);
            Configuration[] configs = confAdmin.listConfigurations(filter);
            if (configs == null || configs.length == 0) {
                LOG.info("No data source configuration registered under the data source name '" + dataSourceName + "'");
                return null;
            }
            if (configs.length > 1) {
                throw new DataSourceException((ErrorCode)CoreErrorCode.DATABASE_DATASOURCE_CONFIG_FAILURE, "Multiple data source configurations registered under the data source name '${dataSourceName}'.", MapUtil.mapOf("dataSourceName", dataSourceName));
            }
            return configs[0];
        }
        catch (ServiceNotFoundException | IOException | InvalidSyntaxException ex) {
            throw new DataSourceException((ErrorCode)CoreErrorCode.DATABASE_DATASOURCE_CONFIG_FAILURE, "ConfigurationAdmin is unable to list the configurations of the data source '${dataSourceName}': ${error}", MapUtil.mapOf("dataSourceName", dataSourceName, "error", ex.getLocalizedMessage()), ex);
        }
    }

    @Override
    public Configuration registerDataSourceConfiguration(Map<String, Object> dataSourceConfiguration) throws DataSourceException {
        LOG.info("registerDataSourceConfiguration dataSourceConfiguration=...");
        try {
            ConfigurationAdmin confAdmin = this.configurationAdminTracker.getService();
            Configuration configuration = confAdmin.createFactoryConfiguration("org.ops4j.datasource", null);
            configuration.update(new Hashtable<String, Object>(dataSourceConfiguration));
            return configuration;
        }
        catch (ServiceNotFoundException | IOException ex) {
            throw new DataSourceException((ErrorCode)CoreErrorCode.DATABASE_DATASOURCE_CONFIG_FAILURE, "Could not register the data source configuration: ${error}", MapUtil.mapOf("error", ex.getLocalizedMessage()), (Throwable)ex);
        }
    }

    @Override
    public void deleteAllDataSourceConfigurations() throws DataSourceException {
        LOG.info("deleteAllDataSourceConfigurations");
        try {
            ConfigurationAdmin confAdmin = this.configurationAdminTracker.getService();
            Configuration[] configs = confAdmin.listConfigurations(null);
            if (configs != null) {
                for (Configuration config : configs) {
                    if (!"org.ops4j.datasource".equalsIgnoreCase(config.getFactoryPid())) continue;
                    LOG.info("Deleting data source configuration: " + config);
                    config.delete();
                }
            }
        }
        catch (ServiceNotFoundException | IOException | InvalidSyntaxException ex) {
            throw new DataSourceException((ErrorCode)CoreErrorCode.DATABASE_DATASOURCE_CONFIG_FAILURE, "Failed to delete all data source configurations: ${error}", MapUtil.mapOf("error", ex.getLocalizedMessage()), ex);
        }
    }

    @Override
    public List<Map> getAllDataSourceConfigurationProperties() throws DataSourceException {
        LOG.info("getAllDataSourceConfigurationProperties");
        try {
            ConfigurationAdmin confAdmin = this.configurationAdminTracker.getService();
            Configuration[] configs = confAdmin.listConfigurations(null);
            ArrayList<Map> result = new ArrayList<Map>();
            if (configs != null) {
                for (Configuration config : configs) {
                    Dictionary props;
                    if (!"org.ops4j.datasource".equalsIgnoreCase(config.getFactoryPid()) || (props = config.getProcessedProperties(null)) == null) continue;
                    result.add(DictionaryUtil.convertToMap(props));
                }
            }
            return result;
        }
        catch (ServiceNotFoundException | IOException | InvalidSyntaxException ex) {
            throw new DataSourceException((ErrorCode)CoreErrorCode.DATABASE_DATASOURCE_CONFIG_FAILURE, "Failed to get all data source configurations: ${error}", MapUtil.mapOf("error", ex.getLocalizedMessage()), ex);
        }
    }

    @Override
    public List<Map> getDataSourceConfigurationProperties(List<DataSourceEntry> dataSourceEntries) throws DataSourceException {
        LOG.info("getDataSourceConfigurationProperties dataSourceEntries=" + dataSourceEntries);
        ArrayList<Map> result = new ArrayList<Map>();
        if (dataSourceEntries != null && !dataSourceEntries.isEmpty()) {
            List<Map> allDataSourceConfigs = this.getAllDataSourceConfigurationProperties();
            for (DataSourceEntry dataSourceEntry : dataSourceEntries) {
                if (dataSourceEntry.getServicePid() == null) continue;
                for (Map dataSourceConfig : allDataSourceConfigs) {
                    if (!dataSourceEntry.getServicePid().equals(dataSourceConfig.get("service.pid"))) continue;
                    result.add(dataSourceConfig);
                }
            }
        }
        return result;
    }

    @Override
    public void deleteDataSourceConfiguration(String dataSourceName) throws DataSourceException {
        LOG.info("deleteDataSourceConfiguration dataSourceName=" + dataSourceName);
        try {
            ConfigurationAdmin confAdmin = this.configurationAdminTracker.getService();
            String filter = String.format("(%s=%s)", "dataSourceName", dataSourceName);
            Configuration[] configs = confAdmin.listConfigurations(filter);
            if (configs != null) {
                for (Configuration config : configs) {
                    LOG.info("Deleting data source configuration: " + config);
                    config.delete();
                }
            } else {
                LOG.warning("Failed to delete the data source with the name '" + dataSourceName + "'. Because it does not exist.");
            }
        }
        catch (ServiceNotFoundException | IOException | InvalidSyntaxException ex) {
            throw new DataSourceException((ErrorCode)CoreErrorCode.DATABASE_DATASOURCE_CONFIG_FAILURE, "Failed to delete the data source configuration of the data source '${dataSourceName}': ${error}", MapUtil.mapOf("dataSourceName", dataSourceName, "error", ex.getLocalizedMessage()), ex);
        }
    }

    @Override
    public List<DataSourceEntry> getDataSourceEntries() throws DataSourceException {
        LOG.info("getDataSourceEntries");
        try {
            ArrayList<DataSourceEntry> result = new ArrayList<DataSourceEntry>();
            Collection dataSourceReferences = this.bundleContext.getServiceReferences(DataSource.class, null);
            if (dataSourceReferences != null) {
                for (ServiceReference dataSourceReference : dataSourceReferences) {
                    String dataSourceName = (String)dataSourceReference.getProperty("dataSourceName");
                    String servicePid = (String)dataSourceReference.getProperty("service.pid");
                    if (dataSourceName == null) continue;
                    result.add(new DataSourceEntryImpl(dataSourceName, servicePid));
                }
            }
            return result;
        }
        catch (InvalidSyntaxException ex) {
            throw new DataSourceException((ErrorCode)CoreErrorCode.DATABASE_DATASOURCE_CONFIG_FAILURE, "Failed to get all data sources: ${error}", MapUtil.mapOf("error", ex.getLocalizedMessage()), (Throwable)ex);
        }
    }

    @Override
    public List<String> getAllDataSourceNames() throws DataSourceException {
        LOG.info("getAllDataSourceNames");
        return this.getDataSourceEntries().stream().map(DataSourceEntry::getDataSourceName).collect(Collectors.toList());
    }

    @Override
    public List<String> getAllDataSourceFactoryNames() throws DataSourceException {
        LOG.info("getAllDataSourceFactoryNames");
        try {
            ArrayList<String> result = new ArrayList<String>();
            Collection dataSourceFactoryReferences = this.bundleContext.getServiceReferences(DataSourceFactory.class, null);
            if (dataSourceFactoryReferences != null) {
                for (ServiceReference dataSourceFactoryReference : dataSourceFactoryReferences) {
                    String driverName;
                    if (!this.isUsableDataSourceFactory((ServiceReference<DataSourceFactory>)dataSourceFactoryReference) || (driverName = (String)dataSourceFactoryReference.getProperty("osgi.jdbc.driver.name")) == null) continue;
                    result.add(driverName);
                }
            }
            return result;
        }
        catch (InvalidSyntaxException ex) {
            throw new DataSourceException((ErrorCode)CoreErrorCode.DATABASE_DATASOURCE_CONFIG_FAILURE, "Failed to get all data source factory names: ${error}", MapUtil.mapOf("error", ex.getLocalizedMessage()), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUsableDataSourceFactory(ServiceReference<DataSourceFactory> dataSourceFactoryReference) {
        if (dataSourceFactoryReference != null) {
            try {
                Object dataSourceFactory = this.bundleContext.getService(dataSourceFactoryReference);
                String dataSourceFactoryClassName = dataSourceFactory.getClass().getSimpleName();
                boolean bl = !"DriverDataSourceFactory".equals(dataSourceFactoryClassName);
                return bl;
            }
            finally {
                this.bundleContext.ungetService(dataSourceFactoryReference);
            }
        }
        return false;
    }

    private ServiceReference<CommonDataSource> getDataSourceServiceReference(BundleContext bundleContext, String dataSourceName) throws DataSourceNotFoundException {
        LOG.info("getDataSourceServiceReference bundleContext=" + bundleContext + ", dataSourceName=" + dataSourceName);
        String filter = "(&(|(objectClass=" + DataSource.class.getName() + ")(objectClass=" + XADataSource.class.getName() + "))(|(osgi.jndi.service.name=" + dataSourceName + ")(datasource=" + dataSourceName + ")(name=" + dataSourceName + ")(service.id=" + dataSourceName + ")))";
        LOG.fine("Data source service filter: " + filter);
        try {
            return this.waitForServiceReference(bundleContext, bundleContext.createFilter(filter), 15L, TimeUnit.SECONDS);
        }
        catch (InvalidSyntaxException e) {
            throw new DataSourceNotFoundException(dataSourceName, (Exception)((Object)e));
        }
    }

    private ServiceReference waitForServiceReference(BundleContext context, Filter filter, long timeout, TimeUnit unit) {
        LOG.fine("waitForServiceReference context:" + context + " filter:" + filter + " timeout:" + timeout + " unit:" + unit);
        final AtomicReference atomicref = new AtomicReference();
        ServiceReferenceHandler handler = new ServiceReferenceHandler(){

            @Override
            public void addingService(ServiceReference sref, Object service) {
                atomicref.set(sref);
            }
        };
        this.trackService(context, filter, handler, timeout, unit);
        return (ServiceReference)atomicref.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trackService(BundleContext context, Filter filter, final ServiceReferenceHandler handler, long timeout, TimeUnit unit) {
        LOG.fine("trackService context:" + context + " filter:" + filter + " handler:" + handler + " timeout:" + timeout + " unit:" + unit);
        long startTime = System.currentTimeMillis();
        final CountDownLatch latch = new CountDownLatch(1);
        tracker.open();
        try (ServiceTracker tracker = new ServiceTracker(context, filter, null){

            public Object addingService(ServiceReference sref) {
                Object service = super.addingService(sref);
                handler.addingService(sref, service);
                latch.countDown();
                return service;
            }
        };){
            latch.await(timeout, unit);
            LOG.fine("Tracked service found after " + (System.currentTimeMillis() - startTime) + " ms");
        }
    }

    private boolean areIdentical(Map map, Dictionary dict) {
        LOG.fine("areIdentical");
        if (map == null && dict == null) {
            return true;
        }
        if (map == null || dict == null || map.size() != dict.size()) {
            return false;
        }
        for (Object mapKey : map.keySet()) {
            Object dictValue = dict.get(mapKey);
            if (dictValue != null && dictValue.equals(map.get(mapKey))) continue;
            return false;
        }
        return true;
    }

    private Dictionary cleanupDataSourceConfiguration(Dictionary existingConfig) {
        LOG.info("cleanupDataSourceConfiguration");
        Hashtable result = new Hashtable();
        if (existingConfig != null) {
            Enumeration e = existingConfig.keys();
            while (e.hasMoreElements()) {
                Object k = e.nextElement();
                if (!(k instanceof String)) continue;
                String key = (String)k;
                Object value = existingConfig.get(key);
                if (key.startsWith("service.")) continue;
                result.put(key, value);
            }
        }
        return result;
    }

    @Override
    public PaxJdbcConfigurationUpdatedInfo createOrUpdateDataSourcesByUsingPaxJdbcConfigurations(List<Map<String, Object>> paxJdbcDataSourceConfigurations) throws DataSourceException {
        String dataSourceName;
        LOG.info("createOrUpdateDataSourcesByUsingPaxJdbcConfigurations paxJdbcDataSourceConfigurations=" + paxJdbcDataSourceConfigurations);
        PaxJdbcConfigurationUpdatedInfoImpl info = new PaxJdbcConfigurationUpdatedInfoImpl();
        List<String> existingDataSourceNames = this.getAllDataSourceNames();
        LOG.info("existingDataSourceNames: " + existingDataSourceNames);
        HashSet<String> stillUsedDataSourceNames = new HashSet<String>();
        if (paxJdbcDataSourceConfigurations != null) {
            for (Map map : paxJdbcDataSourceConfigurations) {
                HashMap<String, Object> cleanedPaxJdbcDataSourceConfiguration = new HashMap<String, Object>();
                cleanedPaxJdbcDataSourceConfiguration.putAll(map);
                cleanedPaxJdbcDataSourceConfiguration.remove("doNotDeleteId");
                dataSourceName = (String)cleanedPaxJdbcDataSourceConfiguration.get("dataSourceName");
                Configuration dataSourceConfig = this.getDataSourceConfiguration(dataSourceName);
                if (dataSourceConfig == null) {
                    LOG.info("Registering new data source configuration for data source name '" + dataSourceName + "'.");
                    this.registerDataSourceConfiguration(cleanedPaxJdbcDataSourceConfiguration);
                    info.addNewDataSource(dataSourceName);
                } else {
                    Dictionary existingConfig = this.cleanupDataSourceConfiguration(dataSourceConfig.getProcessedProperties(null));
                    if (!this.areIdentical(cleanedPaxJdbcDataSourceConfiguration, existingConfig)) {
                        LOG.info("Updating data source configuration for data source name '" + dataSourceName + "'.");
                        try {
                            dataSourceConfig.update(new Hashtable<String, Object>(cleanedPaxJdbcDataSourceConfiguration));
                            info.addUpdatedDataSource(dataSourceName);
                        }
                        catch (IOException ex) {
                            throw new DataSourceException((ErrorCode)CoreErrorCode.DATABASE_DATASOURCE_CONFIG_FAILURE, "Failed to update the configuration of the data source '${dataSourceName}': ${error}", MapUtil.mapOf("dataSourceName", dataSourceName, "error", ex.getLocalizedMessage()), (Throwable)ex);
                        }
                    }
                }
                stillUsedDataSourceNames.add(dataSourceName);
            }
        }
        for (String string : existingDataSourceNames) {
            if (stillUsedDataSourceNames.contains(string)) continue;
            LOG.info("Deleting the no longer used data source: " + string);
            this.deleteDataSourceConfiguration(string);
            info.addDeletedDataSource(string);
        }
        List<Map> allDataSourceConfigurationProperties = this.getAllDataSourceConfigurationProperties();
        for (Map dataSourceConfigurationProperty : allDataSourceConfigurationProperties) {
            dataSourceName = (String)dataSourceConfigurationProperty.get("dataSourceName");
            if (dataSourceName == null || stillUsedDataSourceNames.contains(dataSourceName)) continue;
            this.deleteDataSourceConfiguration(dataSourceName);
        }
        return info;
    }

    @Override
    public List<DatabaseConnectionPoolEntry> getDatabaseConnectionPoolEntries() throws MalformedObjectNameException, MBeanException, IntrospectionException, ReflectionException, InstanceNotFoundException {
        LOG.info("getDatabaseConnectionPoolEntries");
        ArrayList<DatabaseConnectionPoolEntry> entries = new ArrayList<DatabaseConnectionPoolEntry>();
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        if (mBeanServer != null) {
            Set<ObjectName> beanObjectNames = mBeanServer.queryNames(new ObjectName("org.ops4j.pax.jdbc.pool.dbcp2:*"), null);
            for (ObjectName beanObjectName : beanObjectNames) {
                Hashtable<String, String> keyPropertyList = beanObjectName.getKeyPropertyList();
                String poolName = keyPropertyList.get("name");
                AnnoyingPooledObjectToStringValuesExtractor databaseInfo = this.getDatabaseInfo(mBeanServer, beanObjectName);
                Map<String, Object> poolAttrs = this.getPoolAttributes(mBeanServer, beanObjectName);
                entries.add(new DatabaseConnectionPoolEntryImpl(poolName, databaseInfo.databaseUrl, databaseInfo.databaseName, poolAttrs));
            }
        }
        return entries;
    }

    private AnnoyingPooledObjectToStringValuesExtractor getDatabaseInfo(MBeanServer mBeanServer, ObjectName objectName) throws IntrospectionException, InstanceNotFoundException, ReflectionException, MBeanException {
        MBeanOperationInfo[] operations;
        LOG.info("getDatabaseInfo mBeanServer=..., objectName=" + objectName);
        for (MBeanOperationInfo operation : operations = mBeanServer.getMBeanInfo(objectName).getOperations()) {
            CompositeData[] cds;
            if (!"listAllObjects".equals(operation.getName())) continue;
            Object result = mBeanServer.invoke(objectName, "listAllObjects", new Object[0], new String[0]);
            for (CompositeData cd : cds = (CompositeData[])result) {
                for (String key : cd.getCompositeType().keySet()) {
                    String pooledObjectToString;
                    if (!"pooledObjectToString".equals(key) || StringUtil.isNullOrEmpty(pooledObjectToString = (String)cd.get(key))) continue;
                    return new AnnoyingPooledObjectToStringValuesExtractor(pooledObjectToString);
                }
            }
        }
        return new AnnoyingPooledObjectToStringValuesExtractor(null);
    }

    private Map<String, Object> getPoolAttributes(MBeanServer mBeanServer, ObjectName objectName) throws IntrospectionException, InstanceNotFoundException, ReflectionException {
        LOG.info("getPoolAttributes mBeanServer=..., objectName=" + objectName);
        HashMap<String, Object> result = new HashMap<String, Object>();
        Set<String> attributesToIgnore = SetUtil.setOf("FactoryType", "CreationStackTrace");
        HashSet<String> attributeNames = new HashSet<String>();
        MBeanInfo mBeanInfo = mBeanServer.getMBeanInfo(objectName);
        for (MBeanAttributeInfo attribute : mBeanInfo.getAttributes()) {
            attributeNames.add(attribute.getName());
        }
        AttributeList attrs = mBeanServer.getAttributes(objectName, (String[])attributeNames.toArray(String[]::new));
        for (Attribute attr : attrs.asList()) {
            if (attributesToIgnore.contains(attr.getName())) continue;
            result.put(attr.getName(), attr.getValue());
        }
        return result;
    }

    @Override
    public void performConnectionTest(String dataSourceName) throws ConnectionTestException {
        LOG.info("performConnectionTest dataSourceName=" + dataSourceName);
        try {
            DataSource dataSource = this.getDataSource(dataSourceName);
            try (Connection databaseConnection = dataSource.getConnection();){
                if (databaseConnection == null) {
                    throw new ConnectionTestException("The database connection '${dataSourceName}' does not exist.", MapUtil.mapOf("dataSourceName", dataSourceName));
                }
                if (!databaseConnection.isValid(15)) {
                    throw new ConnectionTestException("The database connection '${dataSourceName}' is invalid.", MapUtil.mapOf("dataSourceName", dataSourceName));
                }
            }
        }
        catch (ConnectionTestException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConnectionTestException(ex);
        }
    }

    private static interface ServiceReferenceHandler {
        public void addingService(ServiceReference var1, Object var2);
    }

    private static class AnnoyingPooledObjectToStringValuesExtractor {
        String databaseUrl;
        String databaseName;

        public AnnoyingPooledObjectToStringValuesExtractor(String pooledObjectToStringValue) {
            if (StringUtil.isNullOrEmpty(pooledObjectToStringValue)) {
                this.databaseUrl = "";
                this.databaseName = "";
            } else if (pooledObjectToStringValue.contains("URL=") && pooledObjectToStringValue.contains("UserName=")) {
                int urlIdx = pooledObjectToStringValue.indexOf("URL=");
                int userNameIdx = pooledObjectToStringValue.indexOf("UserName=", urlIdx);
                int userNameAndDatabaseSeparatorIdx = pooledObjectToStringValue.indexOf(", ", userNameIdx);
                this.databaseUrl = pooledObjectToStringValue.substring(urlIdx + "URL=".length(), userNameIdx - ", ".length());
                this.databaseName = pooledObjectToStringValue.substring(userNameAndDatabaseSeparatorIdx + ", ".length());
            } else if (pooledObjectToStringValue.contains("URL=")) {
                int urlIdx = pooledObjectToStringValue.indexOf("URL=");
                int databaseSeparatorIdx = pooledObjectToStringValue.indexOf(", ", urlIdx);
                this.databaseUrl = pooledObjectToStringValue.substring(urlIdx + "URL=".length(), databaseSeparatorIdx);
                this.databaseName = pooledObjectToStringValue.substring(databaseSeparatorIdx + ", ".length());
            } else {
                this.databaseUrl = pooledObjectToStringValue;
                this.databaseName = "";
            }
        }
    }
}

