/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.deployment;

import com.fasterxml.jackson.core.JsonProcessingException;
import de.virtimo.bpc.api.BackupManager;
import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.InstantiableModule;
import de.virtimo.bpc.api.LicenseException;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.Settings;
import de.virtimo.bpc.api.ValidationException;
import de.virtimo.bpc.api.auditlog.UserAuditLog;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.backup.BackupActivatedInfo;
import de.virtimo.bpc.api.backup.BackupSnapshotInfo;
import de.virtimo.bpc.api.backup.SnapshotName;
import de.virtimo.bpc.api.backup.exception.BackupConflictException;
import de.virtimo.bpc.api.backup.exception.BackupException;
import de.virtimo.bpc.api.backup.exception.BackupNotFoundException;
import de.virtimo.bpc.api.deployment.DeploymentInitiator;
import de.virtimo.bpc.api.deployment.DeploymentManager;
import de.virtimo.bpc.api.deployment.DeploymentSide;
import de.virtimo.bpc.api.deployment.MimeMultipartData;
import de.virtimo.bpc.api.deployment.UploadedBundleFile;
import de.virtimo.bpc.api.deployment.UploadedFile;
import de.virtimo.bpc.api.deployment.exception.DeploymentException;
import de.virtimo.bpc.api.deployment.exception.DeploymentSystemException;
import de.virtimo.bpc.api.deployment.resource.DeleteSettingOperation;
import de.virtimo.bpc.api.deployment.resource.DeploymentData;
import de.virtimo.bpc.api.deployment.resource.DeploymentSystemInfo;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.IndexMigrationException;
import de.virtimo.bpc.api.exception.ModuleInstanceCreateException;
import de.virtimo.bpc.api.exception.ModuleInstanceNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotInstantiableException;
import de.virtimo.bpc.api.exception.OpenSearchIndexNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.IndexInfo;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.api.service.StorageService;
import de.virtimo.bpc.api.storage.StoreItem;
import de.virtimo.bpc.api.storage.exception.StoreIndexPreparationException;
import de.virtimo.bpc.api.storage.exception.StoreItemJsonException;
import de.virtimo.bpc.api.storage.exception.StoreItemNotFoundException;
import de.virtimo.bpc.api.storage.exception.StoreItemRightsException;
import de.virtimo.bpc.api.storage.exception.StoreItemValidationException;
import de.virtimo.bpc.api.storage.exception.StoreNotFoundException;
import de.virtimo.bpc.backendconnections.BackendConnectionsModule;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.SettingsImpl;
import de.virtimo.bpc.core.deployment.DeploymentConstraintsEnricher;
import de.virtimo.bpc.core.deployment.DeploymentInitiatorImpl;
import de.virtimo.bpc.core.deployment.DeploymentSystem;
import de.virtimo.bpc.core.deployment.MimeMultipartDataImpl;
import de.virtimo.bpc.core.deployment.resource.DeploymentEndpoint;
import de.virtimo.bpc.core.deployment.resource.DeploymentIndexData;
import de.virtimo.bpc.core.deployment.resource.DeploymentIndexInfo;
import de.virtimo.bpc.core.deployment.resource.DeploymentSystemInfoImpl;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.license.XmlFileLicense;
import de.virtimo.bpc.core.opensearch.BroadcastCollector;
import de.virtimo.bpc.core.opensearch.ModuleConfigurationImpl;
import de.virtimo.bpc.core.opensearch.ModuleManagerImpl;
import de.virtimo.bpc.core.opensearch.migration.GlobalConfigMigrator;
import de.virtimo.bpc.core.resource.ConfigurationEndpoint;
import de.virtimo.bpc.core.resource.response.MaskPasswords;
import de.virtimo.bpc.core.storage.StoreItemFactory;
import de.virtimo.bpc.core.storage.StoreItemSettingName;
import de.virtimo.bpc.core.utils.BpcBundleUtil;
import de.virtimo.bpc.core.utils.FelixFileinstallUtil;
import de.virtimo.bpc.module.simple.SimpleSettingImpl;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;

public class DeploymentManagerImpl
implements DeploymentManager,
BpcService {
    private static final Logger LOG = Logger.getLogger(DeploymentManagerImpl.class.getName());
    private final BundleContext bundleContext;
    private final BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private final BpcServicesTracker<BackupManager> backupManagerTracker;
    private final BpcServicesTracker<EventManager> eventManagerTracker;
    private final BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;
    private final BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private final BpcServicesTracker<StorageService> storageServiceTracker;

    public DeploymentManagerImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(bundleContext, ModuleManager.class);
        this.backupManagerTracker = new BpcServicesTracker<BackupManager>(bundleContext, BackupManager.class);
        this.eventManagerTracker = new BpcServicesTracker<EventManager>(bundleContext, EventManager.class);
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(bundleContext, CoreBundleConfiguration.class);
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
        this.storageServiceTracker = new BpcServicesTracker<StorageService>(bundleContext, StorageService.class);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOG.info("shutdownService");
        BpcServicesTracker.stopAll(this);
    }

    private String appendDeploymentInitiatorInfoToLogMessage(DeploymentInitiator deploymentInitiator, String message) {
        if (message != null && !((String)message).endsWith(".")) {
            message = (String)message + ".";
        }
        return (String)message + " Initiated by '" + deploymentInitiator.getUserName() + "' from server '" + deploymentInitiator.getServerName() + "' (" + deploymentInitiator.getServerUUID() + ")";
    }

    @Override
    public List<DeploymentSystemInfo> getDeploymentSystemsInfo() throws ServiceNotFoundException, ModuleNotFoundException {
        LOG.info("getDeploymentSystemsInfo");
        ArrayList<DeploymentSystemInfo> result = new ArrayList<DeploymentSystemInfo>();
        BackendConnectionsModule backendConnectionsModule = (BackendConnectionsModule)this.moduleManagerTracker.getService().getModuleById("backendconnection");
        for (ModuleInstance moduleInstance : backendConnectionsModule.getModuleInstancesByInstanceType("deployment_system")) {
            result.add(new DeploymentSystemInfoImpl(moduleInstance.getModuleId(), ConfigurationEndpoint.getModuleInstanceName(moduleInstance), moduleInstance.getConfiguration().getSettingValue("sortPriority").asInt(1000)));
        }
        result.add(new DeploymentSystemInfoImpl(DeploymentEndpoint.JSON_TARGET_ID, "[JSON]", Integer.MAX_VALUE));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, IndexInfo> getOpenSearchIndexInfos(UserSession userSession, String deploymentSystemId, DeploymentSide deploymentSide) throws ModuleNotFoundException, ModuleInstanceNotFoundException, ServiceNotFoundException, DeploymentSystemException, JsonProcessingException {
        LOG.info("getOpenSearchIndexInfos userSession=..., deploymentSystemId=" + deploymentSystemId + ", deploymentSide=" + deploymentSide);
        ModuleConfiguration connectionConfig = this.getBackendConnectionConfiguration(deploymentSystemId);
        Map<String, Object> additionalHttpHeaders = DeploymentInitiatorImpl.httpHeaders(userSession, this.coreBundleConfigurationTracker.getService());
        DeploymentSystem deploymentSystem = null;
        try {
            deploymentSystem = new DeploymentSystem(deploymentSide, connectionConfig);
            deploymentSystem.setAdditionalHttpHeaders(additionalHttpHeaders);
            Map<String, IndexInfo> map = deploymentSystem.getIndexInfos();
            return map;
        }
        finally {
            if (deploymentSystem != null) {
                deploymentSystem.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyIndex(UserSession userSession, String indexName, String sourceDeploymentSystemId, String targetDeploymentSystemId, int blockSize, boolean deleteIndexOnTarget) throws ModuleNotFoundException, ModuleInstanceNotFoundException, ServiceNotFoundException, DeploymentSystemException, JsonProcessingException, DeploymentException {
        LOG.info("copyIndex userSession=..., indexName=" + indexName + ", sourceDeploymentSystemId=" + sourceDeploymentSystemId + ", targetDeploymentSystemId=" + targetDeploymentSystemId + ", blockSize=" + blockSize + ", deleteIndexOnTarget=" + deleteIndexOnTarget);
        ModuleConfiguration sourceConnectionConfig = this.getBackendConnectionConfiguration(sourceDeploymentSystemId);
        ModuleConfiguration targetConnectionConfig = this.getBackendConnectionConfiguration(targetDeploymentSystemId);
        String sourceSystemUrl = sourceConnectionConfig.getSettingValue("url").asString();
        String targetSystemUrl = targetConnectionConfig.getSettingValue("url").asString();
        if (sourceDeploymentSystemId.equalsIgnoreCase(targetDeploymentSystemId) || sourceSystemUrl.equalsIgnoreCase(targetSystemUrl)) {
            throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_INDEX_COPY_TO_SAME_SYSTEM_ERROR, "CORE_ERROR_DEPLOYMENT_COPY_INDEX_TO_SAME_SYSTEM", MapUtil.mapOf("index", indexName, "sourceId", sourceDeploymentSystemId, "sourceUrl", sourceSystemUrl, "targetId", targetDeploymentSystemId, "targetUrl", targetSystemUrl));
        }
        Map<String, Object> additionalHttpHeaders = DeploymentInitiatorImpl.httpHeaders(userSession, this.coreBundleConfigurationTracker.getService());
        DeploymentSystem source = null;
        DeploymentSystem target = null;
        try {
            source = new DeploymentSystem(DeploymentSide.Source, sourceConnectionConfig);
            source.setAdditionalHttpHeaders(additionalHttpHeaders);
            target = new DeploymentSystem(DeploymentSide.Target, targetConnectionConfig);
            target.setAdditionalHttpHeaders(additionalHttpHeaders);
            this.copyIndex(indexName, source, target, blockSize, deleteIndexOnTarget);
        }
        finally {
            if (source != null) {
                source.destroy();
            }
            if (target != null) {
                target.destroy();
            }
        }
    }

    private void copyIndex(String indexName, DeploymentSystem source, DeploymentSystem target, int blockSize, boolean deleteIndexOnTarget) throws DeploymentException, DeploymentSystemException, JsonProcessingException {
        LOG.info("copyIndex indexName=" + indexName + ", source=" + source + ", target=" + target + ", blockSize=" + blockSize + ", deleteIndexOnTarget=" + deleteIndexOnTarget);
        DeploymentIndexInfo indexInfo = source.getDeploymentIndexInfo(indexName);
        if (!indexInfo.hasExactlyOneAliasSet()) {
            throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_INDEX_ALIAS_ERROR, "CORE_ERROR_DEPLOYMENT_COPY_INDEX_WITH_ONE_ALIAS_ONLY", MapUtil.mapOf("index", indexName));
        }
        String alias = indexInfo.getTheOneAndOnlyAlias();
        target.prepareIndex(alias, indexInfo, deleteIndexOnTarget);
        DeploymentIndexData blockOfIndexData = source.downloadFirstIndexBlock(indexName, blockSize);
        if (blockOfIndexData.hasData()) {
            String scrollId = blockOfIndexData.getScrollId();
            do {
                target.uploadIndexData(alias, blockOfIndexData);
            } while ((blockOfIndexData = source.downloadSubsequentIndexBlock(indexName, scrollId)) != null && blockOfIndexData.hasData());
            source.releaseScrollId(indexName, scrollId);
        }
    }

    private ModuleConfiguration getBackendConnectionConfiguration(String deploymentSystemId) throws ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        LOG.info("getBackendConnectionConfiguration deploymentSystemId=" + deploymentSystemId);
        BackendConnectionsModule backendConnectionsModule = (BackendConnectionsModule)this.moduleManagerTracker.getService().getModuleById("backendconnection");
        ModuleConfiguration deploymentConnectionConfig = backendConnectionsModule.getInstanceConfiguration(deploymentSystemId);
        if (deploymentConnectionConfig == null) {
            throw new ModuleInstanceNotFoundException("backendconnection", deploymentSystemId);
        }
        return deploymentConnectionConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getModuleConfigurationsOfDeploymentSystem(UserSession userSession, String deploymentSystemId, DeploymentSide deploymentSide) throws ModuleNotFoundException, ModuleInstanceNotFoundException, DeploymentSystemException, IOException, ServiceNotFoundException {
        LOG.info("getModuleConfigurationsOfDeploymentSystem userSession=..., deploymentSystemId=" + deploymentSystemId + ", deploymentSide=" + deploymentSide);
        ModuleConfiguration connectionConfig = this.getBackendConnectionConfiguration(deploymentSystemId);
        Map<String, Object> additionalHttpHeaders = DeploymentInitiatorImpl.httpHeaders(userSession, this.coreBundleConfigurationTracker.getService());
        DeploymentSystem deploymentSystem = null;
        try {
            deploymentSystem = new DeploymentSystem(deploymentSide, connectionConfig);
            deploymentSystem.setAdditionalHttpHeaders(additionalHttpHeaders);
            Map<String, Object> map = deploymentSystem.getModuleConfigurations();
            return map;
        }
        finally {
            if (deploymentSystem != null) {
                deploymentSystem.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getModuleConfigurationsOfDeploymentSystemFromBackup(UserSession userSession, String deploymentSystemId, DeploymentSide deploymentSide, String snapshotName) throws ModuleNotFoundException, ModuleInstanceNotFoundException, DeploymentSystemException, IOException, ServiceNotFoundException {
        LOG.info("getModuleConfigurationsOfDeploymentSystemFromBackup userSession=..., deploymentSystemId=" + deploymentSystemId + ", deploymentSide=" + deploymentSide + ", snapshotName=" + snapshotName);
        ModuleConfiguration connectionConfig = this.getBackendConnectionConfiguration(deploymentSystemId);
        Map<String, Object> additionalHttpHeaders = DeploymentInitiatorImpl.httpHeaders(userSession, this.coreBundleConfigurationTracker.getService());
        DeploymentSystem deploymentSystem = null;
        try {
            deploymentSystem = new DeploymentSystem(deploymentSide, connectionConfig);
            deploymentSystem.setAdditionalHttpHeaders(additionalHttpHeaders);
            Map<String, Object> map = deploymentSystem.getModuleConfigurationsFromBackup(snapshotName);
            return map;
        }
        finally {
            if (deploymentSystem != null) {
                deploymentSystem.destroy();
            }
        }
    }

    @Override
    public void enrichModuleConfigurationsWithDeploymentConstraints(Map<String, Object> modulesConfig) throws ServiceNotFoundException, ModuleNotFoundException, IOException {
        LOG.info("enrichModuleConfigurationsWithDeploymentConstraints modulesConfig=...");
        ModuleManager moduleManager = this.moduleManagerTracker.getService();
        ArrayList<Map> deploymentSettingsOfLoadedModules = new ArrayList<Map>();
        CoreModule coreModule = moduleManager.getModuleByClass(CoreModule.class);
        Map coreModuleDeploymentSettingsMap = coreModule.getConfiguration().getSettingValue("deployment").asMap(null);
        if (coreModuleDeploymentSettingsMap != null) {
            deploymentSettingsOfLoadedModules.add(coreModuleDeploymentSettingsMap);
        }
        for (Module module : moduleManager.getLoadedModules().values()) {
            Map moduleSpecificDeploymentSettingsMap;
            if (module.getModuleId().equals("_core") || (moduleSpecificDeploymentSettingsMap = module.getConfiguration().getSettingValue("deployment").asMap(null)) == null) continue;
            deploymentSettingsOfLoadedModules.add(moduleSpecificDeploymentSettingsMap);
        }
        new DeploymentConstraintsEnricher(deploymentSettingsOfLoadedModules).enrich(modulesConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getStatusOfDeploymentSystem(UserSession userSession, String deploymentSystemId, DeploymentSide deploymentSide) throws ModuleNotFoundException, ModuleInstanceNotFoundException, DeploymentSystemException, IOException, ServiceNotFoundException {
        LOG.info("getStatusOfDeploymentSystem userSession=..., deploymentSystemId=" + deploymentSystemId + ", deploymentSide=" + deploymentSide);
        ModuleConfiguration connectionConfig = this.getBackendConnectionConfiguration(deploymentSystemId);
        Map<String, Object> additionalHttpHeaders = DeploymentInitiatorImpl.httpHeaders(userSession, this.coreBundleConfigurationTracker.getService());
        DeploymentSystem deploymentSystem = null;
        try {
            deploymentSystem = new DeploymentSystem(deploymentSide, connectionConfig);
            deploymentSystem.setAdditionalHttpHeaders(additionalHttpHeaders);
            Map<String, Object> map = deploymentSystem.getStatus();
            return map;
        }
        finally {
            if (deploymentSystem != null) {
                deploymentSystem.destroy();
            }
        }
    }

    @Override
    public Map<String, Object> deploy(UserSession userSession, String sourceDeploymentSystemId, String targetDeploymentSystemId, DeploymentData deploymentData, boolean enableMaintenanceMode, boolean validate) throws ModuleNotFoundException, ModuleInstanceNotFoundException, DeploymentException, DeploymentSystemException, IOException, ServiceNotFoundException {
        LOG.info("deploy userSession=..., sourceDeploymentSystemId=" + sourceDeploymentSystemId + ", targetDeploymentSystemId=" + targetDeploymentSystemId + ", deploymentData=" + deploymentData + ", enableMaintenanceMode=" + enableMaintenanceMode + ", validate=" + validate);
        if (deploymentData == null) {
            throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_DATA_MISSING, "CORE_ERROR_DEPLOYMENT_NO_DATA_GIVEN");
        }
        ModuleConfiguration sourceConnectionConfig = sourceDeploymentSystemId.equals(DeploymentEndpoint.JSON_TARGET_ID) ? null : this.getBackendConnectionConfiguration(sourceDeploymentSystemId);
        ModuleConfiguration targetConnectionConfig = targetDeploymentSystemId.equals(DeploymentEndpoint.JSON_TARGET_ID) ? null : this.getBackendConnectionConfiguration(targetDeploymentSystemId);
        DeploymentSystem source = null;
        DeploymentSystem target = null;
        Map<String, Object> additionalHttpHeaders = DeploymentInitiatorImpl.httpHeaders(userSession, this.coreBundleConfigurationTracker.getService());
        try {
            UserAuditLog.info(userSession, "Deployment", "Deployment to target '" + ConfigurationEndpoint.getModuleInstanceName(targetConnectionConfig) + "' (" + targetDeploymentSystemId + ") started");
            if (sourceConnectionConfig != null) {
                source = new DeploymentSystem(DeploymentSide.Source, sourceConnectionConfig);
                source.setAdditionalHttpHeaders(additionalHttpHeaders);
            }
            if (targetConnectionConfig != null) {
                target = new DeploymentSystem(DeploymentSide.Target, targetConnectionConfig);
                target.setAdditionalHttpHeaders(additionalHttpHeaders);
            }
            HashMap<String, Map<String, Object>> resp = new HashMap<String, Map<String, Object>>();
            if (deploymentData.hasSettingsToDeploy()) {
                String modulesDeploymentResp = target.uploadDeploymentData(deploymentData, enableMaintenanceMode, validate);
                resp.put("modulesDeployment", JsonUtil.getInstance().jsonStringAsMap(modulesDeploymentResp));
            }
            if (source != null && target != null) {
                if (deploymentData.hasBundlesToDeploy()) {
                    MimeMultipartData sourceBundlesAsMultipartData = source.downloadBundles(deploymentData.getBundleIDs());
                    String bundlesDeploymentResp = target.uploadBundles(sourceBundlesAsMultipartData);
                    resp.put("bundlesDeployment", JsonUtil.getInstance().jsonStringAsMap(bundlesDeploymentResp));
                }
                if (deploymentData.hasIndicesToDeploy()) {
                    for (String indexName : deploymentData.getIndices()) {
                        this.copyIndex(indexName, source, target, deploymentData.getCopyIndexBlockSize(), true);
                    }
                }
            }
            UserAuditLog.info(userSession, "Deployment", "Deployment to target '" + ConfigurationEndpoint.getModuleInstanceName(targetConnectionConfig) + "' (" + targetDeploymentSystemId + ") done");
            HashMap<String, Map<String, Object>> hashMap = resp;
            return hashMap;
        }
        catch (Exception ex) {
            UserAuditLog.error(userSession, "Deployment", "Deployment to target '" + ConfigurationEndpoint.getModuleInstanceName(targetConnectionConfig) + "' (" + targetDeploymentSystemId + ") failed: " + ex.getLocalizedMessage());
            throw ex;
        }
        finally {
            if (source != null) {
                source.destroy();
            }
            if (target != null) {
                target.destroy();
            }
        }
    }

    private void restorePreDeploymentSnapshot(UserSession userSession, DeploymentInitiator deploymentInitiator, BackupSnapshotInfo snapshotInfo) throws BackupNotFoundException, BackupConflictException, BackupException, ServiceNotFoundException, OpenSearchRelatedException {
        LOG.info("restorePreDeploymentSnapshot userSession=..., deploymentInitiator=" + deploymentInitiator + ", snapshotInfo=" + snapshotInfo);
        BackupActivatedInfo backupActivatedInfo = this.backupManagerTracker.getService().activateBackup(snapshotInfo.getSnapshotName().asString());
        UserAuditLog.info(userSession, "BackupRestored", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Backup with the snapshot name '" + snapshotInfo.getSnapshotName() + "' restored"));
    }

    @Override
    public void importDeployment(UserSession userSession, DeploymentInitiator deploymentInitiator, DeploymentData deploymentData, boolean enableMaintenanceMode, boolean validate) throws ModuleNotFoundException, DeploymentException, SettingException, ModuleInstanceCreateException, LicenseException, ModuleNotInstantiableException, ServiceNotFoundException, ValidationException, StoreIndexPreparationException, StoreNotFoundException, StoreItemRightsException, StoreItemJsonException, OpenSearchRelatedException, StoreItemValidationException, JsonProcessingException, BackupException {
        LOG.info("importDeployment userSession=..., deploymentInitiator=" + deploymentInitiator + ", deploymentData=" + deploymentData + ", enableMaintenanceMode=" + enableMaintenanceMode + ", validate=" + validate);
        if (deploymentData == null) {
            throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_DATA_MISSING, "CORE_ERROR_DEPLOYMENT_NO_DATA_GIVEN");
        }
        if (!deploymentData.hasSettingsToDeploy()) {
            throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_DATA_MISSING, "CORE_ERROR_DEPLOYMENT_NO_DATA_GIVEN");
        }
        ModuleManager moduleManager = this.moduleManagerTracker.getService();
        BackupManager backupManager = this.backupManagerTracker.getService();
        EventManager eventManager = this.eventManagerTracker.getService();
        StorageService storageService = this.storageServiceTracker.getService();
        OpenSearchService openSearchService = this.openSearchServiceTracker.getService();
        CoreModule coreModule = (CoreModule)moduleManager.getModuleById("_core");
        boolean maintenanceModeWasEnabled = coreModule.isMaintenanceModeEnabled();
        BackupSnapshotInfo bpcConfigurationIndexSnapshotInfo = null;
        BackupSnapshotInfo storageServiceRelatedIndicesSnapshotInfo = null;
        Set<String> notExistingStorageServiceIndices = null;
        Set<String> existingStorageServiceIndices = null;
        try {
            UserAuditLog.info(userSession, "Deployment", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Deployment import start"));
            if (enableMaintenanceMode && !maintenanceModeWasEnabled) {
                if (!coreModule.isMaintenanceModeEnabled()) {
                    UserAuditLog.info(userSession, "MaintenanceModeEnabled", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Requested while performing a deployment"));
                }
                coreModule.enableMaintenanceMode(true);
            }
            Set<String> relatedStoreIDs = this.extractStoreIDs(deploymentData);
            Set<String> allStorageServiceRelatedIndexNames = storageService.getIndexNames(relatedStoreIDs);
            notExistingStorageServiceIndices = this.getNotExistingIndices(openSearchService, allStorageServiceRelatedIndexNames);
            existingStorageServiceIndices = this.getExistingIndices(openSearchService, allStorageServiceRelatedIndexNames);
            if (!existingStorageServiceIndices.isEmpty()) {
                storageServiceRelatedIndicesSnapshotInfo = backupManager.createBackup(SnapshotName.createForName("Temporary-StorageServiceRelatedIndices-Deployment".toLowerCase()), existingStorageServiceIndices);
            }
            bpcConfigurationIndexSnapshotInfo = backupManager.createBackupUsingBackupJob("core:bpc-configuration");
            UserAuditLog.info(userSession, "BackupCreated", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Backup with the snapshot name '" + bpcConfigurationIndexSnapshotInfo.getSnapshotName() + "' created"));
            BroadcastCollector broadcastCollector = new BroadcastCollector(eventManager);
            if (deploymentData.getSettingsToDeploy().hasDeleteSettingOperations()) {
                this.processDeleteOperations(moduleManager, userSession, deploymentInitiator, deploymentData.getSettingsToDeploy().getDeleteSettingOperations(), broadcastCollector);
            }
            if (deploymentData.getSettingsToDeploy().hasSettingsToUpdateOrCreate()) {
                this.processUpdateOrCreateSettings(moduleManager, storageService, userSession, deploymentInitiator, deploymentData.getSettingsToDeploy().getSettingsToUpdateOrCreate(), broadcastCollector, validate);
            }
            try {
                ExecutorService executorService = Executors.newSingleThreadExecutor(new ThreadFactoryWithNamePrefix("bpc-core-deployment"));
                for (Runnable broadcastEntry : broadcastCollector.getEntries()) {
                    executorService.execute(broadcastEntry);
                }
                executorService.shutdown();
            }
            catch (Throwable ex) {
                LOG.log(Level.SEVERE, "Could not inform the other Karaf installations about the deployment import.", ex);
            }
            UserAuditLog.info(userSession, "Deployment", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Deployment import done"));
            eventManager.fireEvent("de/virtimo/bpc/core/Configuration/modulesImported", new Hashtable());
        }
        catch (Exception ex) {
            UserAuditLog.error(userSession, "Deployment", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Deployment import failed: " + ex.getLocalizedMessage()));
            if (notExistingStorageServiceIndices != null) {
                for (String nameOfNotExistingIndex : notExistingStorageServiceIndices) {
                    try {
                        if (!openSearchService.existsIndex(nameOfNotExistingIndex)) continue;
                        String physicalNameOfNotExistingIndex = openSearchService.getBpcIndexNameForAlias(nameOfNotExistingIndex);
                        openSearchService.deleteIndexWithException(physicalNameOfNotExistingIndex);
                    }
                    catch (OpenSearchIndexNotFoundException physicalNameOfNotExistingIndex) {
                    }
                    catch (Exception e) {
                        LOG.log(Level.SEVERE, "Not good. Exception while deleting the storage service indices (" + nameOfNotExistingIndex + ") created during deployment.", e);
                    }
                }
            }
            if (storageServiceRelatedIndicesSnapshotInfo != null) {
                try {
                    this.restorePreDeploymentSnapshot(userSession, deploymentInitiator, storageServiceRelatedIndicesSnapshotInfo);
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Not good. Exception while restoring the just done snapshot of the storage service indices (" + storageServiceRelatedIndicesSnapshotInfo + ").", e);
                }
            }
            if (bpcConfigurationIndexSnapshotInfo != null) {
                try {
                    this.restorePreDeploymentSnapshot(userSession, deploymentInitiator, bpcConfigurationIndexSnapshotInfo);
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Not good. Exception while restoring the just done bpc-configuration snapshot (" + bpcConfigurationIndexSnapshotInfo + ").", e);
                }
            }
            if (enableMaintenanceMode && !maintenanceModeWasEnabled) {
                coreModule.disableMaintenanceMode(true);
            }
            throw ex;
        }
        finally {
            if (storageServiceRelatedIndicesSnapshotInfo != null) {
                try {
                    backupManager.deleteBackup(storageServiceRelatedIndicesSnapshotInfo.getSnapshotName().asString());
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Exception while deleting the temporary snapshot of the storage service indices (" + storageServiceRelatedIndicesSnapshotInfo + ").", e);
                }
            }
        }
    }

    private void processDeleteOperations(ModuleManager moduleManager, UserSession userSession, DeploymentInitiator deploymentInitiator, List<DeleteSettingOperation> deleteOperations, BroadcastCollector broadcastCollector) throws DeploymentException {
        LOG.info("processDeleteOperations moduleManager=..., userSession=..., deploymentInitiator=" + deploymentInitiator + ", deleteOperations=..., broadcastCollector=...");
        if (deleteOperations == null || deleteOperations.isEmpty()) {
            LOG.info("Bye, bye ... no delete operations given");
            return;
        }
        for (DeleteSettingOperation deleteOperation : deleteOperations) {
            this.processDeleteOperation(moduleManager, userSession, deploymentInitiator, deleteOperation, broadcastCollector);
        }
    }

    private void processDeleteOperation(ModuleManager moduleManager, UserSession userSession, DeploymentInitiator deploymentInitiator, DeleteSettingOperation deleteOperation, BroadcastCollector broadcastCollector) throws DeploymentException {
        LOG.info("processDeleteOperation moduleManager=..., userSession=..., deploymentInitiator=" + deploymentInitiator + ", deleteOperation=" + deleteOperation + ", broadcastCollector=...");
        if (StringUtil.isNullOrEmpty(deleteOperation.getModuleId())) {
            throw new DeploymentException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "CORE_ERROR_DEPLOYMENT_DELETE_OPERATION_MISSING_FIELD", MapUtil.mapOf("field", "moduleId"));
        }
        Module module = moduleManager.getModule(deleteOperation.getModuleId());
        if (module == null) {
            throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_MODULE_NOT_FOUND, "CORE_ERROR_DEPLOYMENT_DELETE_OPERATION_MODULE_NOT_FOUND", MapUtil.mapOf("moduleId", deleteOperation.getModuleId()));
        }
        ModuleInstance moduleInstance = null;
        if (!ModuleConfiguration.isNoModuleInstanceId(deleteOperation.getInstanceId())) {
            if (module instanceof InstantiableModule) {
                moduleInstance = ((InstantiableModule)module).getModuleInstance(deleteOperation.getInstanceId());
                if (moduleInstance == null) {
                    throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_MODULE_INSTANCE_NOT_FOUND, "CORE_ERROR_DEPLOYMENT_DELETE_OPERATION_MODULE_INSTANCE_NOT_FOUND", MapUtil.mapOf("moduleId", deleteOperation.getModuleId(), "instanceId", deleteOperation.getInstanceId()));
                }
            } else {
                throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_MODULE_NOT_INSTANTIABLE, "CORE_ERROR_DEPLOYMENT_DELETE_OPERATION_ON_NON_INSTANTIABLE_MODULE", MapUtil.mapOf("moduleId", deleteOperation.getModuleId()));
            }
        }
        if (!StringUtil.isNullOrEmpty(deleteOperation.getSettingName())) {
            if (StoreItemSettingName.isOneOfThese(deleteOperation.getSettingName())) {
                if (moduleInstance != null) {
                    this.deleteModuleInstanceRelatedStoreItem(userSession, deploymentInitiator, deleteOperation, module, moduleInstance, broadcastCollector);
                } else {
                    this.deleteModuleRelatedStoreItem(userSession, deploymentInitiator, deleteOperation, module, broadcastCollector);
                }
            } else if (moduleInstance != null) {
                this.deleteSingleModuleInstanceSetting(userSession, deploymentInitiator, deleteOperation, module, moduleInstance, broadcastCollector);
            } else {
                this.deleteSingleModuleSetting(userSession, deploymentInitiator, deleteOperation, module, broadcastCollector);
            }
        } else {
            this.deleteModuleInstance(userSession, deploymentInitiator, deleteOperation, module, moduleInstance, broadcastCollector);
        }
    }

    private void deleteModuleRelatedStoreItem(UserSession userSession, DeploymentInitiator deploymentInitiator, DeleteSettingOperation deleteOperation, Module module, BroadcastCollector broadcastCollector) throws DeploymentException {
        LOG.info("deleteModuleRelatedStoreItem userSession=..., deploymentInitiator=" + deploymentInitiator + ", deleteOperation=" + deleteOperation + ", module=..., broadcastCollector=...");
        String storeId = StoreItemSettingName.getStoreId(deleteOperation.getSettingName());
        String storeItemId = StoreItemSettingName.getStoreItemId(deleteOperation.getSettingName());
        try {
            StoreItem deletedStoreItem = this.storageServiceTracker.getService().deleteItem(storeId, storeItemId, userSession);
            UserAuditLog.info(userSession, "StoreItemDeleted", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Store item '" + storeItemId + "' ('" + storeId + "') of module '" + module.getModuleName() + "' (" + deleteOperation.getModuleId() + ") deleted."), (Object)deletedStoreItem.asJsonString(), null);
            broadcastCollector.moduleRelatedStoreItemDeleted(deleteOperation.getModuleId(), storeId, storeItemId);
        }
        catch (StoreItemNotFoundException | StoreNotFoundException deletedStoreItem) {
        }
        catch (OpenSearchRelatedException | ServiceNotFoundException | StoreItemJsonException | StoreItemRightsException ex) {
            throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_DELETE_STORE_ITEM_FAILED, "CORE_ERROR_DEPLOYMENT_DELETE_MODULE_RELATED_STORE_ITEM", MapUtil.mapOf("moduleId", deleteOperation.getModuleId(), "storeId", storeId, "storeItemId", storeItemId, "error", ex.getMessage()), (Throwable)ex);
        }
    }

    private void deleteModuleInstanceRelatedStoreItem(UserSession userSession, DeploymentInitiator deploymentInitiator, DeleteSettingOperation deleteOperation, Module module, ModuleInstance moduleInstance, BroadcastCollector broadcastCollector) throws DeploymentException {
        LOG.info("deleteModuleInstanceRelatedStoreItem userSession=..., deploymentInitiator=" + deploymentInitiator + ", deleteOperation=" + deleteOperation + ", module=..., moduleInstance=..., broadcastCollector=...");
        String storeId = StoreItemSettingName.getStoreId(deleteOperation.getSettingName());
        String storeItemId = StoreItemSettingName.getStoreItemId(deleteOperation.getSettingName());
        try {
            StoreItem deletedStoreItem = this.storageServiceTracker.getService().deleteItem(storeId, storeItemId, userSession);
            UserAuditLog.info(userSession, "StoreItemDeleted", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Store item '" + storeItemId + "' ('" + storeId + "') of module instance '" + deleteOperation.getInstanceId() + "' of module '" + module.getModuleName() + "' (" + deleteOperation.getModuleId() + ") deleted."), (Object)deletedStoreItem.asJsonString(), null);
            broadcastCollector.moduleInstanceRelatedStoreItemDeleted(deleteOperation.getModuleId(), deleteOperation.getInstanceId(), deleteOperation.getInstanceType(), storeId, storeItemId);
        }
        catch (StoreItemNotFoundException | StoreNotFoundException deletedStoreItem) {
        }
        catch (OpenSearchRelatedException | ServiceNotFoundException | StoreItemJsonException | StoreItemRightsException ex) {
            throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_DELETE_STORE_ITEM_FAILED, "CORE_ERROR_DEPLOYMENT_DELETE_MODULE_INSTANCE_RELATED_STORE_ITEM", MapUtil.mapOf("moduleId", deleteOperation.getModuleId(), "moduleInstanceId", deleteOperation.getInstanceId(), "moduleInstanceType", deleteOperation.getInstanceType(), "storeId", storeId, "storeItemId", storeItemId, "error", ex.getMessage()), (Throwable)ex);
        }
    }

    private void deleteModuleInstance(UserSession userSession, DeploymentInitiator deploymentInitiator, DeleteSettingOperation deleteOperation, Module module, ModuleInstance moduleInstance, BroadcastCollector broadcastCollector) throws DeploymentException {
        LOG.info("deleteModuleInstance userSession=..., deploymentInitiator=" + deploymentInitiator + ", deleteOperation=" + deleteOperation + ", module=..., moduleInstance=..., broadcastCollector=...");
        if (moduleInstance == null) {
            throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_DELETE_MODULE_SETTING_FAILED, "CORE_ERROR_DEPLOYMENT_DELETE_OPERATION_MODULE_SETTINGS", MapUtil.mapOf("moduleId", deleteOperation.getModuleId()));
        }
        moduleInstance.deleteInstance();
        UserAuditLog.info(userSession, "ModuleInstanceDeleted", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Module instance '" + ConfigurationEndpoint.getModuleInstanceName(moduleInstance) + "' (" + deleteOperation.getInstanceId() + ") of module '" + module.getModuleName() + "' (" + deleteOperation.getModuleId() + ") deleted"));
        moduleInstance.getParentModule().moduleInstanceDeleted(moduleInstance);
        broadcastCollector.moduleInstanceDeleted(deleteOperation.getModuleId(), deleteOperation.getInstanceId());
    }

    private void deleteSingleModuleSetting(UserSession userSession, DeploymentInitiator deploymentInitiator, DeleteSettingOperation deleteOperation, Module module, BroadcastCollector broadcastCollector) throws DeploymentException {
        LOG.info("deleteSingleModuleSetting userSession=..., deploymentInitiator=" + deploymentInitiator + ", deleteOperation=" + deleteOperation + ", module=..., broadcastCollector=...");
        try {
            Setting targetSetting = module.getConfiguration().getSetting(deleteOperation.getSettingName());
            if (targetSetting != null) {
                if (userSession == null || !userSession.hasWriteAccessToSetting(module, targetSetting)) {
                    throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTING_NO_ACCESS_RIGHT, "CORE_ERROR_DEPLOYMENT_DELETE_MODULE_SETTING_NOT_ALLOWED", MapUtil.mapOf("moduleId", deleteOperation.getModuleId(), "settingName", deleteOperation.getSettingName()));
                }
                module.getConfiguration().removeSetting(targetSetting);
                UserAuditLog.info(userSession, "ModuleSettingDeleted", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Setting of module '" + module.getModuleName() + "' (" + deleteOperation.getModuleId() + ") deleted: " + deleteOperation.getSettingName()), (Object)JsonUtil.getInstance().convertPojoToJsonString(new MaskPasswords().maskPasswords(Collections.singletonList(targetSetting)), null), null);
                broadcastCollector.moduleSettingDeleted(deleteOperation.getModuleId(), deleteOperation.getSettingName());
            } else {
                UserAuditLog.info(userSession, "ModuleSettingDeleted", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Setting of module '" + module.getModuleName() + "' (" + deleteOperation.getModuleId() + ") to delete does not exist: " + deleteOperation.getSettingName()), null, null);
            }
        }
        catch (SettingException ex) {
            throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_DELETE_MODULE_SETTING_FAILED, "CORE_ERROR_DEPLOYMENT_DELETE_MODULE_SETTING", MapUtil.mapOf("moduleId", deleteOperation.getModuleId(), "settingName", deleteOperation.getSettingName(), "error", ex.getMessage()), (Throwable)ex);
        }
    }

    private void deleteSingleModuleInstanceSetting(UserSession userSession, DeploymentInitiator deploymentInitiator, DeleteSettingOperation deleteOperation, Module module, ModuleInstance moduleInstance, BroadcastCollector broadcastCollector) throws DeploymentException {
        LOG.info("deleteSingleModuleInstanceSetting userSession=..., deploymentInitiator=" + deploymentInitiator + ", deleteOperation=" + deleteOperation + ", module=..., moduleInstance=..., broadcastCollector=...");
        try {
            Setting targetSetting = moduleInstance.getConfiguration().getSetting(deleteOperation.getSettingName());
            if (targetSetting != null) {
                if (userSession == null || !userSession.hasWriteAccessToSetting(module, targetSetting)) {
                    throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTING_NO_ACCESS_RIGHT, "CORE_ERROR_DEPLOYMENT_DELETE_MODULE_INSTANCE_SETTING_NOT_ALLOWED", MapUtil.mapOf("moduleId", deleteOperation.getModuleId(), "moduleInstanceId", deleteOperation.getInstanceId(), "settingName", deleteOperation.getSettingName()));
                }
                moduleInstance.getConfiguration().removeSetting(targetSetting);
                UserAuditLog.info(userSession, "ModuleInstanceSettingDeleted", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Setting of module instance '" + ConfigurationEndpoint.getModuleInstanceName(moduleInstance) + "' (" + deleteOperation.getInstanceId() + ") and module '" + module.getModuleName() + "' (" + deleteOperation.getModuleId() + ") deleted: " + deleteOperation.getSettingName()), (Object)JsonUtil.getInstance().convertPojoToJsonString(new MaskPasswords().maskPasswords(Collections.singletonList(targetSetting)), null), null);
                moduleInstance.getParentModule().moduleInstanceUpdated(moduleInstance);
                broadcastCollector.moduleInstanceSettingDeleted(deleteOperation.getModuleId(), deleteOperation.getInstanceId(), deleteOperation.getInstanceType(), deleteOperation.getSettingName());
            } else {
                UserAuditLog.info(userSession, "ModuleInstanceSettingDeleted", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Setting of module instance '" + ConfigurationEndpoint.getModuleInstanceName(moduleInstance) + "' (" + deleteOperation.getInstanceId() + ") and module '" + module.getModuleName() + "' (" + deleteOperation.getModuleId() + ") to delete does not exist: " + deleteOperation.getSettingName()), null, null);
            }
        }
        catch (SettingException ex) {
            throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_DELETE_MODULE_INSTANCE_SETTING_FAILED, "CORE_ERROR_DEPLOYMENT_DELETE_MODULE_INSTANCE_SETTING", MapUtil.mapOf("moduleId", deleteOperation.getModuleId(), "instanceId", deleteOperation.getInstanceId(), "settingName", deleteOperation.getSettingName()), (Throwable)ex);
        }
    }

    private Set<String> extractStoreIDs(DeploymentData deploymentData) {
        String storeId;
        String settingName;
        LOG.info("extractStoreIDs deploymentData=...");
        HashSet<String> result = new HashSet<String>();
        if (deploymentData.getSettingsToDeploy().hasDeleteSettingOperations()) {
            List<DeleteSettingOperation> deleteOperations = deploymentData.getSettingsToDeploy().getDeleteSettingOperations();
            for (DeleteSettingOperation deleteOperation : deleteOperations) {
                settingName = deleteOperation.getSettingName();
                if (StringUtil.isNullOrEmpty(settingName) || !StoreItemSettingName.isOneOfThese(settingName)) continue;
                storeId = StoreItemSettingName.getStoreId(settingName);
                result.add(storeId);
            }
        }
        if (deploymentData.getSettingsToDeploy().hasSettingsToUpdateOrCreate()) {
            Settings settingsToUpdateOrCreate = deploymentData.getSettingsToDeploy().getSettingsToUpdateOrCreate();
            for (Setting settingToUpdateOrCreate : settingsToUpdateOrCreate) {
                settingName = settingToUpdateOrCreate.getName();
                if (StringUtil.isNullOrEmpty(settingName) || !StoreItemSettingName.isOneOfThese(settingName)) continue;
                storeId = StoreItemSettingName.getStoreId(settingName);
                result.add(storeId);
            }
        }
        return result;
    }

    private Set<String> getNotExistingIndices(OpenSearchService openSearchService, Set<String> indexNamesToCheck) throws OpenSearchRelatedException {
        LOG.info("getNotExistingIndices openSearchService=..., indexNamesToCheck=" + indexNamesToCheck);
        HashSet<String> result = new HashSet<String>();
        if (indexNamesToCheck != null) {
            for (String indexNameToCheck : indexNamesToCheck) {
                if (openSearchService.existsIndex(indexNameToCheck)) continue;
                result.add(indexNameToCheck);
            }
        }
        return result;
    }

    private Set<String> getExistingIndices(OpenSearchService openSearchService, Set<String> indexNamesToCheck) throws OpenSearchRelatedException {
        LOG.info("getExistingIndices openSearchService=..., indexNamesToCheck=" + indexNamesToCheck);
        HashSet<String> result = new HashSet<String>();
        if (indexNamesToCheck != null) {
            for (String indexNameToCheck : indexNamesToCheck) {
                if (!openSearchService.existsIndex(indexNameToCheck)) continue;
                result.add(indexNameToCheck);
            }
        }
        return result;
    }

    private void processUpdateOrCreateSettings(ModuleManager moduleManager, StorageService storageService, UserSession userSession, DeploymentInitiator deploymentInitiator, Settings settings, BroadcastCollector broadcastCollector, boolean validate) throws DeploymentException, SettingException, ModuleInstanceCreateException, LicenseException, ModuleNotInstantiableException, ValidationException, StoreIndexPreparationException, StoreNotFoundException, StoreItemRightsException, ServiceNotFoundException, StoreItemJsonException, OpenSearchRelatedException, StoreItemValidationException, JsonProcessingException {
        LOG.info("processUpdateOrCreateSettings moduleManager=..., storageService=..., userSession=..., deploymentInitiator=" + deploymentInitiator + ", settings=..., broadcastCollector=..., validate=" + validate);
        for (String moduleId : settings.getModuleIDs()) {
            Module module = moduleManager.getModule(moduleId);
            if (module == null) {
                throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_MODULE_NOT_FOUND, "CORE_ERROR_DEPLOYMENT_UPDATE_OR_CREATE_OPERATION_MODULE_NOT_FOUND", MapUtil.mapOf("moduleId", moduleId));
            }
            Settings settingsOfModule = settings.getSettingsOfModuleId(moduleId);
            SettingsImpl realModuleSettingsOfModule = new SettingsImpl();
            SettingsImpl storageServiceItemSettingsOfModule = new SettingsImpl();
            for (Setting settingOfModule : settingsOfModule) {
                if (StoreItemSettingName.isOneOfThese(settingOfModule.getName())) {
                    storageServiceItemSettingsOfModule.add(settingOfModule);
                    continue;
                }
                realModuleSettingsOfModule.add(settingOfModule);
            }
            this.updateModule(moduleManager, userSession, deploymentInitiator, module, realModuleSettingsOfModule, broadcastCollector, validate);
            this.updateOrCreateStorageServiceItemsOfModule(storageService, userSession, deploymentInitiator, module, storageServiceItemSettingsOfModule.asList(), broadcastCollector);
        }
    }

    private void tryToMergeJsonSettingValues(Setting newSetting, Setting oldSetting) {
        if (newSetting == null || oldSetting == null) {
            return;
        }
        if (!newSetting.getCustomFields().existsField("deployment_import_action")) {
            return;
        }
        if ("json_merge".equals(newSetting.getCustomFields().getStringValue("deployment_import_action")) && "json".equals(newSetting.getType()) && "json".equals(oldSetting.getType())) {
            Map newSettingValueAsMap = newSetting.getSettingValue().asMap();
            Map oldSettingValueAsMap = oldSetting.getSettingValue().asMap();
            if (newSettingValueAsMap != null && oldSettingValueAsMap != null && newSetting instanceof SimpleSettingImpl) {
                SimpleSettingImpl newSettingImpl = (SimpleSettingImpl)newSetting;
                Map mergedMap = MapUtil.merge(newSettingValueAsMap, oldSettingValueAsMap);
                newSettingImpl.setValue(mergedMap);
            }
        }
        newSetting.getCustomFields().removeField("deployment_import_action");
    }

    private void updateModule(ModuleManager moduleManager, UserSession userSession, DeploymentInitiator deploymentInitiator, Module module, Settings settingsOfModule, BroadcastCollector broadcastCollector, boolean validate) throws SettingException, ModuleInstanceCreateException, LicenseException, ModuleNotInstantiableException, ValidationException {
        LOG.info("updateModule moduleManager=..., userSession=..., deploymentInitiator=" + deploymentInitiator + ", module=" + module + ", settingsOfModule=..., broadcastCollector=..., validate=" + validate);
        String moduleId = module.getModuleId();
        Set<String> instanceIDs = settingsOfModule.getInstanceIDs();
        if (instanceIDs.contains("noinstance")) {
            LOG.info(moduleId + ": Processing the global module settings");
            ModuleConfiguration currentModuleConfiguration = module.getConfiguration();
            Settings noInstanceSettings = settingsOfModule.getSettingsOfInstanceId("noinstance");
            if (userSession == null || !userSession.hasWriteAccessToSettings(module, noInstanceSettings)) {
                throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTING_NO_ACCESS_RIGHT, "CORE_ERROR_DEPLOYMENT_UPDATE_MODULE_SETTINGS_NOT_ALLOWED", MapUtil.mapOf("moduleId", moduleId));
            }
            SettingsImpl existingSettings = new SettingsImpl(currentModuleConfiguration.getSettings().values());
            noInstanceSettings.unmaskPasswords(existingSettings);
            noInstanceSettings.clearMaskedPasswords();
            if (validate) {
                moduleManager.validateModuleSettings(moduleId, existingSettings, noInstanceSettings);
            }
            Settings oldSettings = currentModuleConfiguration.getSettingsByName(noInstanceSettings.getNames());
            SettingsImpl newSettings = new SettingsImpl(noInstanceSettings);
            for (Setting noInstanceSetting : noInstanceSettings) {
                Setting existingSetting = currentModuleConfiguration.getSetting(noInstanceSetting.getName());
                if (existingSetting == null) {
                    LOG.info(moduleId + ": Adding the module setting: " + noInstanceSetting.getName());
                    currentModuleConfiguration.addSetting(noInstanceSetting);
                    continue;
                }
                LOG.info(moduleId + ": Updating the module setting: " + noInstanceSetting.getName());
                this.tryToMergeJsonSettingValues(noInstanceSetting, existingSetting);
                currentModuleConfiguration.updateSetting(noInstanceSetting);
            }
            UserAuditLog.info(userSession, "ModuleUpdated", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Settings of module '" + module.getModuleName() + "' (" + module.getModuleId() + ") updated: " + StringUtil.implode(", ", noInstanceSettings.getNames())), (Object)JsonUtil.getInstance().convertPojoToJsonString(oldSettings.maskPasswords(), null), (Object)JsonUtil.getInstance().convertPojoToJsonString(newSettings.maskPasswords(), null));
            broadcastCollector.moduleUpdated(moduleId);
        }
        instanceIDs.remove("noinstance");
        if (!instanceIDs.isEmpty() && !(module instanceof InstantiableModule)) {
            throw new ModuleNotInstantiableException(moduleId);
        }
        if (module instanceof InstantiableModule) {
            InstantiableModule instantiableModule = (InstantiableModule)module;
            LOG.info(moduleId + ": Processing the module instances");
            for (String instanceId : instanceIDs) {
                SettingsImpl existingSettingsOfModuleInstance;
                LOG.info(moduleId + "/" + instanceId + ": Processing the instance settings");
                Settings settingsOfModuleInstance = settingsOfModule.getSettingsOfInstanceId(instanceId);
                Set<String> instanceTypes = settingsOfModuleInstance.getInstanceTypes();
                if (instanceTypes.size() != 1) {
                    throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTINGS_MESS, "CORE_ERROR_DEPLOYMENT_MODULE_INSTANCE_SETTINGS_WITH_WRONG_INSTANCE_TYPE", MapUtil.mapOf("moduleId", moduleId, "moduleInstanceId", instanceId, "instanceTypes", instanceTypes));
                }
                String instanceType = instanceTypes.iterator().next();
                if (userSession == null || !userSession.hasWriteAccessToSettings(module, settingsOfModuleInstance)) {
                    throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTING_NO_ACCESS_RIGHT, "CORE_ERROR_DEPLOYMENT_UPDATE_MODULE_INSTANCE_SETTINGS_NOT_ALLOWED", MapUtil.mapOf("moduleId", moduleId, "moduleInstanceId", instanceId));
                }
                ModuleInstance moduleInstance = instantiableModule.getModuleInstance(instanceId);
                if (moduleInstance == null) {
                    LOG.info(moduleId + "/" + instanceId + ": Creating new module instance");
                    ModuleConfigurationImpl moduleInstanceConfiguration = new ModuleConfigurationImpl(instantiableModule, instanceId, instanceType, settingsOfModuleInstance.asMap(), (ModuleManagerImpl)moduleManager);
                    existingSettingsOfModuleInstance = new SettingsImpl(moduleInstanceConfiguration.getSettings().values());
                    settingsOfModuleInstance.clearMaskedPasswords();
                    if (validate) {
                        moduleManager.validateModuleInstanceSettings(moduleId, instanceId, instanceType, existingSettingsOfModuleInstance, settingsOfModuleInstance);
                    }
                    moduleInstance = instantiableModule.createModuleInstance(instanceId, instanceType, moduleInstanceConfiguration);
                    UserAuditLog.info(userSession, "ModuleInstanceCreated", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Module instance '" + ConfigurationEndpoint.getModuleInstanceName(moduleInstance) + "' (" + instanceId + ") of module '" + module.getModuleName() + "' (" + moduleId + ") created"));
                    instantiableModule.moduleInstanceCreated(moduleInstance);
                    broadcastCollector.moduleInstanceCreated(moduleId, instanceId, instanceType);
                    continue;
                }
                LOG.info(moduleId + "/" + instanceId + ": Updating existing module instance");
                ModuleConfiguration currentInstanceConfiguration = moduleInstance.getConfiguration();
                existingSettingsOfModuleInstance = new SettingsImpl(currentInstanceConfiguration.getSettings().values());
                settingsOfModuleInstance.unmaskPasswords(existingSettingsOfModuleInstance);
                settingsOfModuleInstance.clearMaskedPasswords();
                if (validate) {
                    moduleManager.validateModuleInstanceSettings(moduleId, instanceId, instanceType, existingSettingsOfModuleInstance, settingsOfModuleInstance);
                }
                Settings oldSettings = currentInstanceConfiguration.getSettingsByName(settingsOfModuleInstance.getNames());
                SettingsImpl newSettings = new SettingsImpl(settingsOfModuleInstance);
                for (Setting instanceSetting : settingsOfModuleInstance) {
                    if (currentInstanceConfiguration.getSetting(instanceSetting.getName()) == null) {
                        LOG.info(moduleId + "/" + instanceId + ": Adding module instance setting: " + instanceSetting.getName());
                        currentInstanceConfiguration.addSetting(instanceSetting);
                        continue;
                    }
                    LOG.info(moduleId + "/" + instanceId + ": Updating module instance setting: " + instanceSetting.getName());
                    currentInstanceConfiguration.updateSetting(instanceSetting);
                }
                UserAuditLog.info(userSession, "ModuleInstanceUpdated", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Settings of module instance '" + ConfigurationEndpoint.getModuleInstanceName(moduleInstance) + "' (" + instanceId + ") of module '" + module.getModuleName() + "' (" + moduleId + ") updated: " + StringUtil.implode(", ", settingsOfModuleInstance.getNames())), (Object)JsonUtil.getInstance().convertPojoToJsonString(oldSettings.maskPasswords(), null), (Object)JsonUtil.getInstance().convertPojoToJsonString(newSettings.maskPasswords(), null));
                instantiableModule.moduleInstanceUpdated(moduleInstance);
                broadcastCollector.moduleInstanceUpdated(moduleId, instanceId, instanceType);
            }
        }
    }

    private void updateOrCreateStorageServiceItemsOfModule(StorageService storageService, UserSession userSession, DeploymentInitiator deploymentInitiator, Module module, List<Setting> storageServiceItemSettingsOfModule, BroadcastCollector broadcastCollector) throws StoreIndexPreparationException, StoreNotFoundException, StoreItemRightsException, ServiceNotFoundException, StoreItemJsonException, OpenSearchRelatedException, StoreItemValidationException, JsonProcessingException {
        LOG.info("updateOrCreateStorageServiceItemsOfModule storageService=..., userSession=..., deploymentInitiator=" + deploymentInitiator + ", module=" + module + ", storageServiceItemSettingsOfModule=..., broadcastCollector=...");
        if (storageServiceItemSettingsOfModule == null || storageServiceItemSettingsOfModule.isEmpty()) {
            return;
        }
        for (Setting storageServiceItemSetting : storageServiceItemSettingsOfModule) {
            if (!StoreItemSettingName.isOneOfThese(storageServiceItemSetting.getName())) continue;
            String moduleId = storageServiceItemSetting.getModuleId();
            String instanceId = storageServiceItemSetting.getInstanceId();
            String instanceType = storageServiceItemSetting.getInstanceType();
            String storeId = StoreItemSettingName.getStoreId(storageServiceItemSetting.getName());
            String storeItemId = StoreItemSettingName.getStoreItemId(storageServiceItemSetting.getName());
            Object storeItemValueObject = storageServiceItemSetting.getValue();
            if (storeItemValueObject instanceof Map) {
                Map storeItemAsMap = (Map)storeItemValueObject;
                StoreItem storeItem = StoreItemFactory.create(storeItemId, storeItemAsMap);
                StoreItem updatedOldStoreItem = storageService.updateOrCreateItem(storeId, storeItem, userSession);
                if (updatedOldStoreItem != null && Objects.equals(updatedOldStoreItem, storeItem)) continue;
                if (ModuleConfiguration.isNoModuleInstanceId(instanceId)) {
                    if (updatedOldStoreItem == null) {
                        UserAuditLog.info(userSession, "StoreItemCreated", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Store item '" + storeItemId + "' ('" + storeId + "') of module '" + module.getModuleName() + "' (" + moduleId + ") created."), null, (Object)JsonUtil.getInstance().convertPojoToJsonString(storeItemAsMap));
                        broadcastCollector.moduleRelatedStoreItemCreated(moduleId, storeId, storeItemId);
                        continue;
                    }
                    UserAuditLog.info(userSession, "StoreItemUpdated", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Store item '" + storeItemId + "' ('" + storeId + "') of module '" + module.getModuleName() + "' (" + moduleId + ") updated."), (Object)updatedOldStoreItem.asJsonString(), (Object)JsonUtil.getInstance().convertPojoToJsonString(storeItemAsMap));
                    broadcastCollector.moduleRelatedStoreItemUpdated(moduleId, storeId, storeItemId);
                    continue;
                }
                if (updatedOldStoreItem == null) {
                    UserAuditLog.info(userSession, "StoreItemCreated", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Store item '" + storeItemId + "' ('" + storeId + "') of module instance '" + instanceId + "' of module '" + module.getModuleName() + "' (" + moduleId + ") created."), null, (Object)JsonUtil.getInstance().convertPojoToJsonString(storeItemAsMap));
                    broadcastCollector.moduleInstanceRelatedStoreItemCreated(moduleId, instanceId, instanceType, storeId, storeItemId);
                    continue;
                }
                UserAuditLog.info(userSession, "StoreItemUpdated", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Store item '" + storeItemId + "' ('" + storeId + "') of module instance '" + instanceId + "' of module '" + module.getModuleName() + "' (" + moduleId + ") updated."), (Object)updatedOldStoreItem.asJsonString(), (Object)JsonUtil.getInstance().convertPojoToJsonString(storeItemAsMap));
                broadcastCollector.moduleInstanceRelatedStoreItemUpdated(moduleId, instanceId, instanceType, storeId, storeItemId);
                continue;
            }
            LOG.warning("Hey BPC devs. The value of a deployed storage service related setting is not from the expected Java Map (StoreItem):" + storageServiceItemSetting);
        }
    }

    @Override
    public void importXmlFileLicense(UserSession userSession, DeploymentInitiator deploymentInitiator, UploadedFile uploadedFile) throws DeploymentSystemException {
        File deployFolder;
        LOG.info("importXmlFileLicense userSession=..., deploymentInitiator=" + deploymentInitiator + ", uploadedFile=...");
        if (uploadedFile == null) {
            throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_UNEXPECTED_ERROR, DeploymentSide.Target, "CORE_ERROR_DEPLOYMENT_IMPORT_LICENSE_FILE_MISSING");
        }
        if (!XmlFileLicense.isWellKnownLicenseFilename(uploadedFile.getFileName())) {
            throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_UNEXPECTED_ERROR, DeploymentSide.Target, "CORE_ERROR_DEPLOYMENT_IMPORT_LICENSE_FILE_MISSING");
        }
        if (!this.isXmlFile(uploadedFile)) {
            throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_UNEXPECTED_ERROR, DeploymentSide.Target, "CORE_ERROR_DEPLOYMENT_IMPORT_LICENSE_FILE_MISSING");
        }
        try {
            deployFolder = FelixFileinstallUtil.getDeployFolder(this.bundleContext);
        }
        catch (Exception ex) {
            throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_UNEXPECTED_ERROR, DeploymentSide.Target, "CORE_ERROR_DEPLOYMENT_UNABLE_TO_GET_KARAF_DEPLOY_FOLDER", (Throwable)ex);
        }
        LOG.info("Going to copy the uploaded file '" + uploadedFile.getFileName() + "' to the deploy folder: " + deployFolder);
        File deployArchiveFolder = this.getDeployArchiveFolder(deployFolder);
        LOG.info("Making backup of the to be overwritten '" + uploadedFile.getFileName() + "' to the folder: " + deployArchiveFolder);
        try {
            this.writeUploadedXmlLicenseFileToFolder(userSession, deploymentInitiator, uploadedFile, deployFolder, uploadedFile.getFileName(), deployArchiveFolder);
        }
        catch (Exception ex) {
            throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_UNEXPECTED_ERROR, DeploymentSide.Target, "CORE_ERROR_DEPLOYMENT_IMPORT_LICENSE_FILE_WRITE_FAILED", (Throwable)ex);
        }
        try {
            Thread.sleep(TimeUnit.SECONDS.toMillis(2L));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean isXmlFile(UploadedFile uploadedFile) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            documentBuilderFactory.setXIncludeAware(false);
            DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
            builder.parse(uploadedFile.getInputStream());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void importBundles(UserSession userSession, DeploymentInitiator deploymentInitiator, List<UploadedBundleFile> uploadedBundleFiles) throws DeploymentSystemException {
        File deployFolder;
        LOG.info("importBundles userSession=..., deploymentInitiator=" + deploymentInitiator + ", uploadedBundleFiles=...");
        if (uploadedBundleFiles == null) throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_UNEXPECTED_ERROR, DeploymentSide.Target, "CORE_ERROR_DEPLOYMENT_IMPORT_BUNDLES_MISSING");
        if (uploadedBundleFiles.isEmpty()) {
            throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_UNEXPECTED_ERROR, DeploymentSide.Target, "CORE_ERROR_DEPLOYMENT_IMPORT_BUNDLES_MISSING");
        }
        try {
            deployFolder = FelixFileinstallUtil.getDeployFolder(this.bundleContext);
        }
        catch (Exception ex) {
            throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_UNEXPECTED_ERROR, DeploymentSide.Target, "CORE_ERROR_DEPLOYMENT_UNABLE_TO_GET_KARAF_DEPLOY_FOLDER", (Throwable)ex);
        }
        LOG.info("Going to copy the uploaded bundles to the deploy folder: " + deployFolder);
        File deployArchiveFolder = this.getDeployArchiveFolder(deployFolder);
        LOG.info("Making backups of the to be overwritten bundles to the folder: " + deployArchiveFolder);
        BundleListener bundleListener = null;
        try {
            final HashMap<String, Integer> processedBundleFileNames = new HashMap<String, Integer>();
            final long t1 = System.currentTimeMillis();
            bundleListener = new BundleListener(){

                public void bundleChanged(BundleEvent bundleEvent) {
                    LOG.info("Received " + bundleEvent + " with type/status '" + bundleEvent.getType() + "' after " + (System.currentTimeMillis() - t1) + " milliseconds");
                    String bundleFileName = BpcBundleUtil.getBundleFilename(bundleEvent.getBundle());
                    processedBundleFileNames.put(bundleFileName, bundleEvent.getType());
                }
            };
            this.bundleContext.addBundleListener(bundleListener);
            HashMap<String, Integer> copiedBundleFileNames = new HashMap<String, Integer>();
            for (UploadedBundleFile uploadedBundle : uploadedBundleFiles) {
                try {
                    boolean isBundleThatCannotBeUpdated;
                    String bundleFileName = uploadedBundle.getFileName();
                    Bundle existingBundle = BpcBundleUtil.getBundleByFilename(this.bundleContext, uploadedBundle.getFileName());
                    if (existingBundle == null && (existingBundle = BpcBundleUtil.getBundleBySymbolicName(this.bundleContext, uploadedBundle.getSymbolicName())) != null) {
                        bundleFileName = BpcBundleUtil.getBundleFilename(existingBundle);
                    }
                    boolean bl = isBundleThatCannotBeUpdated = existingBundle != null && bundleFileName == null;
                    if (isBundleThatCannotBeUpdated) {
                        throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_UNEXPECTED_ERROR, DeploymentSide.Target, "CORE_ERROR_DEPLOYMENT_BUNDLE_CANNOT_BE_UPDATED");
                    }
                    copiedBundleFileNames.put(bundleFileName, existingBundle == null ? -1 : existingBundle.getState());
                    this.writeUploadedBundleToFolder(userSession, deploymentInitiator, uploadedBundle, deployFolder, bundleFileName, deployArchiveFolder);
                }
                finally {
                    if (uploadedBundle == null) continue;
                    uploadedBundle.cleanUp();
                }
            }
            for (String bundleFileName : copiedBundleFileNames.keySet()) {
                LOG.info("Bundle status before import: " + bundleFileName + " = " + copiedBundleFileNames.get(bundleFileName));
            }
            try {
                this.waitUntilAllBundlesProcessed(26L, copiedBundleFileNames, processedBundleFileNames);
            }
            catch (InterruptedException ex) {
                LOG.log(Level.WARNING, "Ignoring the interruption of our wait until all of the uploaded bundles are processed. Maybe some stopped the Karaf?", ex);
            }
            if (bundleListener == null) return;
        }
        catch (BundleException ex) {
            try {
                throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_UNEXPECTED_ERROR, DeploymentSide.Target, "CORE_ERROR_DEPLOYMENT_UPLOAD_IS_NO_BUNDLE", (Throwable)ex);
                catch (DeploymentSystemException ex2) {
                    throw ex2;
                }
                catch (Exception ex3) {
                    LOG.log(Level.SEVERE, "Failed to copy the deployed bundles to the Karaf deploy folder and wait for them to be installed.", ex3);
                    throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_UNEXPECTED_ERROR, DeploymentSide.Target, "CORE_ERROR_DEPLOYMENT_IMPORT_BUNDLES_FAILED", (Throwable)ex3);
                }
            }
            catch (Throwable throwable) {
                if (bundleListener == null) throw throwable;
                this.bundleContext.removeBundleListener(bundleListener);
                throw throwable;
            }
        }
        this.bundleContext.removeBundleListener(bundleListener);
    }

    private void waitUntilAllBundlesProcessed(long maxWaitTimeInSeconds, Map<String, Integer> copiedBundleFileNames, Map<String, Integer> processedBundleFileNames) throws InterruptedException {
        long waitStartTime = System.currentTimeMillis();
        while (true) {
            if (this.allBundlesProcessed(copiedBundleFileNames, processedBundleFileNames)) {
                LOG.info("It seems that all deployed bundles are now processed by Karaf ... going on ...");
                break;
            }
            if (System.currentTimeMillis() - waitStartTime > maxWaitTimeInSeconds * 1000L) {
                LOG.info("Max wait time of " + maxWaitTimeInSeconds + " seconds reached ... giving up!");
                break;
            }
            LOG.info("Waiting for bundles to be installed ... sleeping and trying again ...");
            Thread.sleep(250L);
        }
    }

    private boolean allBundlesProcessed(Map<String, Integer> copiedBundleFileNames, Map<String, Integer> processedBundleFileNames) {
        HashMap<Integer, Integer> expected = new HashMap<Integer, Integer>();
        expected.put(-1, 2);
        expected.put(32, 2);
        expected.put(2, 8);
        HashSet<String> confirmedFileNames = new HashSet<String>();
        for (String fileName : copiedBundleFileNames.keySet()) {
            int state = copiedBundleFileNames.get(fileName);
            if (!processedBundleFileNames.containsKey(fileName)) continue;
            int type = processedBundleFileNames.get(fileName);
            if (!expected.containsKey(state) || (Integer)expected.get(state) != type) continue;
            confirmedFileNames.add(fileName);
        }
        return copiedBundleFileNames.size() == confirmedFileNames.size();
    }

    private File getDeployArchiveFolder(File deployFolder) {
        LOG.info("getDeployArchiveFolder deployFolder=" + deployFolder);
        try {
            String parentDeployFolder = deployFolder.getParent();
            LOG.info("parentDeployFolder = " + parentDeployFolder);
            File baseDeployArchiveFolderFile = new File(parentDeployFolder, "deploy_archive");
            LOG.info("baseDeployArchiveFolderFile = " + baseDeployArchiveFolderFile);
            boolean baseDeployArchiveFolderCreated = baseDeployArchiveFolderFile.mkdir();
            LOG.info("baseDeployArchiveFolderCreated = " + baseDeployArchiveFolderCreated);
            String deployArchiveFolderName = DateTimeFormatter.ISO_INSTANT.format(Instant.now());
            deployArchiveFolderName = deployArchiveFolderName.replaceAll("[:|.]", "-");
            LOG.info("deployArchiveFolderName = " + deployArchiveFolderName);
            File deployArchiveFolder = new File(baseDeployArchiveFolderFile, deployArchiveFolderName);
            LOG.info("deployArchiveFolder = " + deployArchiveFolder);
            boolean deployArchiveFolderCreated = deployArchiveFolder.mkdir();
            LOG.info("deployArchiveFolderCreated = " + deployArchiveFolderCreated);
            return deployArchiveFolderCreated ? deployArchiveFolder : null;
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to get/create the deploy archive folder.", ex);
            return null;
        }
    }

    private void writeUploadedXmlLicenseFileToFolder(UserSession userSession, DeploymentInitiator deploymentInitiator, UploadedFile uploadedFile, File targetFolder, String targetFilename, File targetArchiveFolder) throws IOException {
        LOG.info("writeUploadedXmlLicenseFileToFolder userSession=" + userSession + ", deploymentInitiator=" + deploymentInitiator + ", uploadedFile=" + uploadedFile + ", targetFolder=" + targetFolder + ", targetFilename=" + targetFilename + ", targetArchiveFolder=" + targetArchiveFolder);
        try {
            this.writeUploadedFileToFolder(uploadedFile, targetFolder, targetFilename, targetArchiveFolder);
            UserAuditLog.info(userSession, "LicenseDeployed", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Deployed the license file '" + targetFilename + "' to folder '" + targetFolder + "'"));
        }
        catch (Exception ex) {
            UserAuditLog.error(userSession, "LicenseNotDeployed", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Failed to deploy the license file '" + targetFilename + "' to folder '" + targetFolder + "'. Error: " + ex.getLocalizedMessage()));
            throw ex;
        }
    }

    private void writeUploadedBundleToFolder(UserSession userSession, DeploymentInitiator deploymentInitiator, UploadedBundleFile uploadedBundle, File targetFolder, String targetFilename, File targetArchiveFolder) throws IOException {
        LOG.info("writeUploadedBundleFileToFolder userSession=" + userSession + ", deploymentInitiator=" + deploymentInitiator + ", uploadedBundle=" + uploadedBundle + ", targetFolder=" + targetFolder + ", targetFilename=" + targetFilename + ", targetArchiveFolder=" + targetArchiveFolder);
        try {
            this.writeUploadedFileToFolder(uploadedBundle, targetFolder, targetFilename, targetArchiveFolder);
            UserAuditLog.info(userSession, "BundleFileDeployed", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Deployed the bundle file '" + targetFilename + "' to folder '" + targetFolder + "'"));
        }
        catch (Exception ex) {
            UserAuditLog.error(userSession, "BundleFileNotDeployed", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Failed to deploy the bundle file '" + targetFilename + "' to folder '" + targetFolder + "'. Error: " + ex.getLocalizedMessage()));
            throw ex;
        }
    }

    private void writeUploadedFileToFolder(UploadedFile uploadedFile, File targetFolder, String targetFilename, File targetArchiveFolder) throws IOException {
        LOG.info("writeUploadedFileToFolder uploadedFile=" + uploadedFile + ", targetFolder=" + targetFolder + ", targetFilename=" + targetFilename + ", targetArchiveFolder=" + targetArchiveFolder);
        if (targetArchiveFolder != null) {
            LOG.info("Archiving the to be overwritten file: " + targetFilename);
            this.archiveTheToBeOverwrittenFile(targetFolder, targetFilename, targetArchiveFolder);
        }
        LOG.info("Writing the uploaded file '" + targetFilename + "' to the target folder '" + targetFolder + "'.");
        this.writeContentOfUploadedFileToTargetFolder(uploadedFile, targetFolder, targetFilename);
    }

    private void archiveTheToBeOverwrittenFile(File sourceFolder, String fileName, File targetFolder) {
        LOG.info("archiveTheToBeOverwrittenFile sourceFolder=" + sourceFolder + ", fileName=" + fileName + ", targetFolder=" + targetFolder);
        try {
            Path sourceFilePath = new File(sourceFolder, fileName).toPath();
            Path targetFilePath = new File(targetFolder, fileName).toPath();
            Files.copy(sourceFilePath, targetFilePath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception ex) {
            LOG.warning("Failed to create a backup of the file: " + fileName);
        }
    }

    private void writeContentOfUploadedFileToTargetFolder(UploadedFile uploadedFile, File targetFolder, String targetFilename) throws IOException {
        LOG.info("writeContentOfUploadedFileToTargetFolder uploadedFile=" + uploadedFile + ", targetFolder=" + targetFolder + ", targetFilename=" + targetFilename);
        try (InputStream bais = uploadedFile.getInputStream();){
            File targetFile = new File(targetFolder, targetFilename);
            Files.copy(bais, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    @Override
    public MimeMultipartData getBundlesAsMultipartData(List<Long> bundleIDs) throws IOException, URISyntaxException {
        LOG.info("getBundlesDeploymentMultipartPostData bundleIDs=" + bundleIDs);
        MimeMultipartDataImpl.Builder mimeMultipartDataBuilder = MimeMultipartDataImpl.newBuilder();
        for (Bundle bundle : this.bundleContext.getBundles()) {
            long bundleId = bundle.getBundleId();
            if (!bundleIDs.contains(bundleId)) continue;
            LOG.info("Great, found the bundle with the ID '" + bundleId + "' for deployment.");
            String bundleFileLocation = bundle.getLocation();
            if (bundleFileLocation.startsWith("file:")) {
                URI bundleFileURI = new URI(bundleFileLocation);
                String bundleFileName = Paths.get(bundleFileURI).getFileName().toString();
                File bundleFile = new File(bundleFileURI);
                String bundleFileContentType = Files.probeContentType(bundleFile.toPath());
                if (bundleFileContentType == null) {
                    bundleFileContentType = "application/java-archive";
                }
                mimeMultipartDataBuilder.addFile(bundleFileName, bundleFile.toPath(), bundleFileContentType);
                continue;
            }
            LOG.warning("The bundle with the ID '" + bundleId + "' cannot be deployed, it uses an unknown location prefix (expecting 'file:'): " + bundleFileLocation);
        }
        return mimeMultipartDataBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getMigrateModulesConfigFromDeploymentSystem(UserSession userSession, String deploymentSystemId, DeploymentSide deploymentSide, Map<String, Object> modulesConfigToMigrate) throws ModuleNotFoundException, ModuleInstanceNotFoundException, ServiceNotFoundException, DeploymentSystemException, IOException, OpenSearchRelatedException {
        LOG.info("getMigrateModulesConfigFromDeploymentSystem userSession=..., deploymentSystemId=" + deploymentSystemId + ", deploymentSide=" + deploymentSide + ", modulesConfigToMigrate=...");
        ModuleConfiguration connectionConfig = this.getBackendConnectionConfiguration(deploymentSystemId);
        Map<String, Object> additionalHttpHeaders = DeploymentInitiatorImpl.httpHeaders(userSession, this.coreBundleConfigurationTracker.getService());
        DeploymentSystem deploymentSystem = null;
        try {
            deploymentSystem = new DeploymentSystem(deploymentSide, connectionConfig);
            deploymentSystem.setAdditionalHttpHeaders(additionalHttpHeaders);
            String moduleConfigMigratedResp = deploymentSystem.migrateModulesConfig(modulesConfigToMigrate);
            Map<String, Object> map = JsonUtil.getInstance().jsonStringAsMap(moduleConfigMigratedResp);
            return map;
        }
        finally {
            if (deploymentSystem != null) {
                deploymentSystem.destroy();
            }
        }
    }

    @Override
    public Map<String, Object> migrateModulesConfig(UserSession userSession, DeploymentInitiator deploymentInitiator, Map<String, Object> modulesConfig) throws ServiceNotFoundException, IOException, OpenSearchRelatedException, IndexMigrationException {
        LOG.info("migrateModulesConfig userSession=..., deploymentInitiator=" + deploymentInitiator + ", modulesConfig=...");
        GlobalConfigMigrator configMigrator = new GlobalConfigMigrator(this.moduleManagerTracker.getService(), this.openSearchServiceTracker.getService());
        return configMigrator.migrate(modulesConfig);
    }
}

