/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.event.resource;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.core.event.resource.EventData;
import de.virtimo.bpc.jaxrs.ApiResponse;
import de.virtimo.bpc.jaxrs.ApiResponses;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.osgi.framework.BundleContext;

@Path(value="event")
public class EventEndpoint {
    private static final Logger LOG = Logger.getLogger(EventEndpoint.class.getName());
    private final BundleContext bundleContext;
    private BpcServicesTracker<EventManager> eventManagerTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;

    public EventEndpoint(BundleContext bundleContext) {
        LOG.info("EventEndpoint bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOG.info("onStartup");
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
        this.eventManagerTracker = new BpcServicesTracker<EventManager>(this.bundleContext, EventManager.class);
    }

    public void onShutdown() {
        LOG.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    @Consumes(value={"application/json"})
    @POST
    @Path(value="/")
    @BpcUserSessionRequired
    @BpcRoleOrRightRequired(role="EVENT_API_ADMIN", right="EVENT_API_SEND", message="Not allowed to send event")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Authentication could not be performed"), @ApiResponse(responseCode="403", description="No access rights"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response processEvent(EventData eventData, @Context HttpHeaders hh) {
        LOG.info("processEvent");
        try {
            String topic = eventData.getTopic();
            Hashtable<String, Map<String, Object>> eventDataDictionary = new Hashtable<String, Map<String, Object>>();
            Map<String, Object> data = eventData.getData();
            if (data == null || data.isEmpty()) {
                throw new IllegalArgumentException("data empty");
            }
            ((Dictionary)eventDataDictionary).put("data", data);
            if (eventData.getRecipients() != null) {
                ((Dictionary)eventDataDictionary).put("_websocketRecipients", eventData.getRecipients());
            }
            EventManager eventManager = this.eventManagerTracker.getService();
            eventManager.fireEvent(topic, eventDataDictionary);
            return Response.status((Response.Status)Response.Status.CREATED).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to fire the event", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

