/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.internationalization;

import de.virtimo.bpc.api.Setting;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class TranslationsOfSetting {
    private static final Logger LOG = Logger.getLogger(TranslationsOfSetting.class.getName());
    private final Set<String> isoLanguages = new HashSet<String>(Arrays.asList(Locale.getISOLanguages()));
    private Map customTranslationsMap = null;

    void updateWithSetting(Setting customTranslationsSetting) {
        LOG.info("updateWithSetting customTranslationsSetting=" + customTranslationsSetting);
        this.customTranslationsMap = customTranslationsSetting == null ? null : customTranslationsSetting.getSettingValue().asMap(null);
    }

    Set<String> getLanguages() {
        LOG.info("getLanguages");
        HashSet<String> result = new HashSet<String>();
        if (this.customTranslationsMap != null) {
            for (Object languageObject : this.customTranslationsMap.keySet()) {
                String language;
                if (!(languageObject instanceof String) || !this.isoLanguages.contains(language = ((String)languageObject).toLowerCase())) continue;
                result.add(language);
            }
        }
        return result;
    }

    Map<String, Object> getTranslationsForLanguage(String lowerCaseLangKey) {
        Object langEntries;
        LOG.info("getTranslationsForLanguage lowerCaseLangKey=" + lowerCaseLangKey);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.customTranslationsMap != null && this.customTranslationsMap.containsKey(lowerCaseLangKey) && (langEntries = this.customTranslationsMap.get(lowerCaseLangKey)) instanceof Map) {
            result.putAll((Map)langEntries);
        }
        return result;
    }
}

