/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.license;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.core.license.LicenseService;
import de.virtimo.bpc.core.license.XmlFileLicense;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.felix.fileinstall.ArtifactInstaller;
import org.apache.felix.fileinstall.ArtifactListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Component;

@Component(service={ArtifactInstaller.class, ArtifactListener.class})
public class LicenseDeployer
implements ArtifactInstaller {
    private static final Logger LOG = Logger.getLogger(LicenseDeployer.class.getName());

    public void install(File file) throws Exception {
        LOG.info("install file=" + file);
        this.loadLicense(file);
    }

    public void update(File file) throws Exception {
        LOG.info("update file=" + file);
        this.loadLicense(file);
    }

    public void uninstall(File file) throws Exception {
        LOG.info("uninstall file=" + file + " (ignored at the moment, the already loaded license is still in use)");
    }

    public boolean canHandle(File file) {
        LOG.finest("canHandle file=" + file);
        return XmlFileLicense.isWellKnownLicenseFilename(file.getName());
    }

    private void loadLicense(File file) {
        LOG.info("loadLicense file=" + file);
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        try (BpcServicesTracker<LicenseService> licenseServiceTracker = new BpcServicesTracker<LicenseService>(bundleContext, LicenseService.class);){
            licenseServiceTracker.getService().loadAndSetLicense(file);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to read/set the BPC license '" + file + "'.", ex);
        }
    }
}

