/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.license;

import de.virtimo.bpc.api.AbstractLicense;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XmlFileLicense
extends AbstractLicense {
    private static final Logger LOG = Logger.getLogger(XmlFileLicense.class.getName());
    public static final String LICENSE_FILE_NAME = "license.xml.bpc";
    public static final String ALTERNATIVE_LICENSE_FILE_NAME = "license.xml.virtimo";

    public XmlFileLicense(File licenseFile) throws FileNotFoundException, IOException {
        super(licenseFile.getName());
        try (FileInputStream xmlInputStream = new FileInputStream(licenseFile);){
            Map<String, Object> licenseKeyObjectMap = this.getMapFromLicenseXml(xmlInputStream);
            this.setLicenseMap(licenseKeyObjectMap);
        }
    }

    public static boolean isWellKnownLicenseFilename(String filename) {
        return Set.of(LICENSE_FILE_NAME, ALTERNATIVE_LICENSE_FILE_NAME).contains(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getMapFromLicenseXml(InputStream xmlInputStream) {
        HashMap<String, Object> licenseMap = new HashMap<String, Object>();
        XMLStreamReader reader = null;
        try {
            int event;
            reader = XMLInputFactory.newFactory().createXMLStreamReader(xmlInputStream);
            String elementName = null;
            Stack<String> elementStack = new Stack<String>();
            boolean bpcLicenseMode = false;
            boolean licenseKeyMode = false;
            boolean licenseMapMode = false;
            boolean licenseListMode = false;
            while ((event = reader.next()) != 8) {
                if (event == 1) {
                    elementName = reader.getLocalName();
                    if ("bpc".equalsIgnoreCase(elementName)) {
                        bpcLicenseMode = true;
                    } else if (bpcLicenseMode) {
                        if (elementStack.size() == 2) {
                            if ("licenseKeys".equalsIgnoreCase(elementName)) {
                                licenseKeyMode = true;
                            } else if ("licenseMaps".equalsIgnoreCase(elementName)) {
                                licenseMapMode = true;
                            } else if ("licenseLists".equalsIgnoreCase(elementName)) {
                                licenseListMode = true;
                            }
                        }
                        if (elementStack.size() == 3) {
                            if (licenseMapMode) {
                                licenseMap.put(elementName, new HashMap());
                            } else if (licenseListMode) {
                                licenseMap.put(elementName, new ArrayList());
                            }
                        }
                    }
                    elementStack.push(elementName);
                    continue;
                }
                if (event == 2) {
                    elementName = reader.getLocalName();
                    elementStack.pop();
                    if ("bpc".equalsIgnoreCase(elementName)) {
                        bpcLicenseMode = false;
                        continue;
                    }
                    if (!bpcLicenseMode) continue;
                    if (elementStack.size() == 2) {
                        if ("licenseKeys".equalsIgnoreCase(elementName)) {
                            licenseKeyMode = false;
                        } else if ("licenseMaps".equalsIgnoreCase(elementName)) {
                            licenseMapMode = false;
                        } else if ("licenseLists".equalsIgnoreCase(elementName)) {
                            licenseListMode = false;
                        }
                    }
                    if (elementStack.size() != 4 || !licenseListMode) continue;
                    String listName = (String)elementStack.elementAt(elementStack.size() - 1);
                    List targetList = (List)licenseMap.get(listName);
                    targetList.add(elementName);
                    LOG.info("ADD LIST: " + listName + " = " + elementName);
                    continue;
                }
                if (event != 4 || reader.isWhiteSpace()) continue;
                String value = reader.getText().trim();
                if (licenseKeyMode) {
                    licenseMap.put(elementName, value);
                    LOG.info("ADD: " + elementName + " = " + value);
                    continue;
                }
                if (!licenseMapMode) continue;
                String mapName = (String)elementStack.elementAt(elementStack.size() - 2);
                Map targetMap = (Map)licenseMap.get(mapName);
                targetMap.put(elementName, value);
                LOG.info("ADD MAP: " + mapName + "." + elementName + " = " + value);
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Error retrieving xml configuration", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
        return licenseMap;
    }
}

