/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.notification;

import de.virtimo.bpc.core.notification.ExpirationNotificationSettings;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Logger;

public class ExpirationNotificationEvaluator {
    private static final Logger LOG = Logger.getLogger(ExpirationNotificationEvaluator.class.getName());
    private final LocalDate expirationDate;
    private final ExpirationNotificationSettings expirationNotificationSettings;
    private LocalDate currentDate;
    private String currentTime;
    private boolean timeToNotify;
    private long expiresInDays;
    private Period expiresInPeriod;

    public ExpirationNotificationEvaluator(LocalDate expirationDate, ExpirationNotificationSettings expirationNotificationSettings) {
        this.expirationDate = expirationDate;
        this.expirationNotificationSettings = expirationNotificationSettings;
        this.updateForNow();
    }

    public LocalDate getExpirationDate() {
        return this.expirationDate;
    }

    public String getSendNotificationsAtTime() {
        return this.expirationNotificationSettings.getSendAtTime();
    }

    public List<Integer> getSendNotificationsDaysBeforeExpiration() {
        return this.expirationNotificationSettings.getSendDaysBeforeExpiration();
    }

    public LocalDate getCurrentDate() {
        return this.currentDate;
    }

    public String getCurrentTime() {
        return this.currentTime;
    }

    public boolean isTimeToNotify() {
        return this.timeToNotify;
    }

    public long getExpiresInDays() {
        return this.expiresInDays;
    }

    public Period getExpiresInPeriod() {
        return this.expiresInPeriod;
    }

    public void updateForNow() {
        this.currentDate = LocalDate.now();
        this.currentTime = new SimpleDateFormat("HH:mm").format(Calendar.getInstance().getTime());
        List<Integer> sendNotificationsDaysBeforeExpiration = this.expirationNotificationSettings.getSendDaysBeforeExpiration();
        String sendNotificationsAtTime = this.expirationNotificationSettings.getSendAtTime();
        this.expiresInDays = ChronoUnit.DAYS.between(this.currentDate, this.expirationDate);
        this.expiresInPeriod = Period.between(this.currentDate, this.expirationDate);
        LOG.info("[" + this.currentDate + " " + this.currentTime + "]: Expires on " + this.expirationDate + " (" + this.expiresInPeriod.getYears() + " years, " + this.expiresInPeriod.getMonths() + " months and " + this.expiresInPeriod.getDays() + " days)");
        this.timeToNotify = sendNotificationsDaysBeforeExpiration.contains(Long.valueOf(this.expiresInDays).intValue()) && sendNotificationsAtTime.equals(this.currentTime);
    }
}

