/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.notification;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.core.notification.NotificationData;
import de.virtimo.bpc.util.SetUtil;
import de.virtimo.bpc.util.StringUtil;
import de.virtimo.bpc.util.ZonedDateTimeSerializer;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

public class Notification {
    public static final String TYPE_INFO = "info";
    public static final String TYPE_LINK = "link";
    public static final String RECIPIENTS_TYPE_USER = "user";
    public static final String RECIPIENTS_TYPE_ROLE = "role";
    public static final String RECIPIENTS_TYPE_ORGANISATION = "organisation";
    public static final Set<String> ValidRecipientsTypes = SetUtil.setOf("user", "role", "organisation");
    private final String id;
    private final long version;
    private final int priority;
    private final ZonedDateTime date;
    private final String subject;
    private final String message;
    private final Set<String> recipients;
    private final String recipientsType;
    private final String originator;
    private final String icon;
    private final String type;
    private final Map<String, Object> typeSpecificData;

    private Notification(Builder notificationBuilder) {
        this.id = notificationBuilder.id;
        this.version = notificationBuilder.version;
        this.priority = notificationBuilder.priority;
        this.date = notificationBuilder.date;
        this.subject = notificationBuilder.subject;
        this.message = notificationBuilder.message;
        this.recipients = notificationBuilder.recipients;
        this.recipientsType = notificationBuilder.recipientsType;
        this.originator = notificationBuilder.originator;
        this.icon = notificationBuilder.icon;
        this.type = notificationBuilder.type;
        this.typeSpecificData = notificationBuilder.typeSpecificData;
    }

    public String getId() {
        return this.id;
    }

    public long getVersion() {
        return this.version;
    }

    public int getPriority() {
        return this.priority;
    }

    @JsonSerialize(using=ZonedDateTimeSerializer.class)
    public ZonedDateTime getDate() {
        return this.date;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getMessage() {
        return this.message;
    }

    public Set<String> getRecipients() {
        return this.recipients;
    }

    public String getRecipientsType() {
        return this.recipientsType;
    }

    public String getOriginator() {
        return this.originator;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, Object> getTypeSpecificData() {
        return this.typeSpecificData;
    }

    @JsonIgnore
    public boolean hasAccessRight(UserSession userSession) {
        if (userSession != null) {
            if (RECIPIENTS_TYPE_USER.equals(this.recipientsType)) {
                for (String recipient : this.recipients) {
                    if (!recipient.equalsIgnoreCase(userSession.getLoginName())) continue;
                    return true;
                }
                return false;
            }
            if (RECIPIENTS_TYPE_ROLE.equals(this.recipientsType)) {
                return userSession.hasAnyRole(this.recipients);
            }
            if (RECIPIENTS_TYPE_ORGANISATION.equals(this.recipientsType)) {
                return userSession.hasAnyOrganisation(this.recipients);
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Notification that = (Notification)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "Notification{id='" + this.id + "', version=" + this.version + ", priority=" + this.priority + ", date=" + this.date + ", subject='" + this.subject + "', message='" + this.message + "', recipients='" + this.recipients + "', recipientsType='" + this.recipientsType + "', originator='" + this.originator + "', icon='" + this.icon + "', type='" + this.type + "', typeSpecificData=" + this.typeSpecificData + "}";
    }

    public static class Builder {
        private String id;
        private long version;
        private Integer priority;
        private ZonedDateTime date;
        private String subject;
        private String message;
        private Set<String> recipients;
        private String recipientsType;
        private String originator;
        private String icon;
        private String type;
        private Map<String, Object> typeSpecificData;

        public Builder(Notification notification) {
            this.id = this.getNewIdIfNotSet(notification.id);
            this.version = this.getInitialVersionIfNotSet(notification.version);
            this.priority = notification.priority;
            this.date = this.getCurrentDateTimeIfNotSet(notification.date);
            this.subject = notification.subject;
            this.message = notification.message;
            this.recipients = notification.recipients;
            this.recipientsType = notification.recipientsType;
            this.originator = notification.originator;
            this.icon = notification.icon;
            this.type = this.getDefaultTypeIfNotSet(notification.type);
            this.typeSpecificData = notification.typeSpecificData == null ? null : new HashMap<String, Object>(notification.typeSpecificData);
        }

        public Builder(NotificationData notificationData) {
            this.id = this.getNewIdIfNotSet(notificationData.id);
            this.version = this.getInitialVersionIfNotSet(notificationData.version);
            this.priority = notificationData.priority;
            this.date = this.getCurrentDateTimeIfNotSet(notificationData.date);
            this.subject = notificationData.subject;
            this.message = notificationData.message;
            this.recipients = notificationData.recipients;
            this.recipientsType = notificationData.recipientsType;
            this.originator = notificationData.originator;
            this.icon = notificationData.icon;
            this.type = this.getDefaultTypeIfNotSet(notificationData.type);
            this.typeSpecificData = notificationData.typeSpecificData == null ? null : new HashMap<String, Object>(notificationData.typeSpecificData);
        }

        public Builder() {
            this.id = this.getNewIdIfNotSet(null);
            this.version = this.getInitialVersionIfNotSet(-1L);
            this.priority = null;
            this.date = this.getCurrentDateTimeIfNotSet(null);
            this.originator = null;
            this.type = this.getDefaultTypeIfNotSet(null);
        }

        private String getNewIdIfNotSet(String id) {
            return StringUtil.isNullOrEmpty(id) ? UUID.randomUUID().toString() : id;
        }

        private String getDefaultTypeIfNotSet(String type) {
            return StringUtil.isNullOrEmpty(type) ? Notification.TYPE_INFO : type;
        }

        private long getInitialVersionIfNotSet(long version) {
            return version < 1L ? 1L : version;
        }

        private ZonedDateTime getCurrentDateTimeIfNotSet(ZonedDateTime date) {
            return date == null ? ZonedDateTime.now() : date;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public Builder priority(Priority priority) {
            this.priority = priority.value;
            return this;
        }

        public Builder date(ZonedDateTime date) {
            this.date = date;
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder recipients(Set<String> recipients, String recipientsType) {
            this.recipients = recipients;
            this.recipientsType = recipientsType;
            return this;
        }

        public Builder originator(String originator) {
            this.originator = originator;
            return this;
        }

        public Builder icon(String icon) {
            this.icon = icon;
            return this;
        }

        public Builder type(String type, Map<String, Object> typeSpecificData) {
            this.type = type;
            this.typeSpecificData = typeSpecificData;
            return this;
        }

        public Notification build() {
            if (this.originator == null) {
                throw new IllegalStateException("Originator must not be null.");
            }
            if (this.type == null) {
                throw new IllegalStateException("Type must not be null.");
            }
            if (this.subject == null) {
                throw new IllegalStateException("Subject must not be null.");
            }
            if (this.recipients == null || this.recipientsType == null) {
                throw new IllegalStateException("Recipients and recipients type must not be null.");
            }
            if (this.priority == null) {
                this.priority = Priority.TOAST.value;
            } else if (!SetUtil.setOf(Priority.SILENT.value, Priority.TOAST.value, Priority.POPUP.value).contains(this.priority)) {
                throw new IllegalStateException("Priority must be one of the following: " + Priority.SILENT.value + " (Silent), " + Priority.TOAST.value + " (Toast), " + Priority.POPUP.value + " (Popup)");
            }
            if (!ValidRecipientsTypes.contains(this.recipientsType.toLowerCase())) {
                throw new IllegalStateException("Recipients type must be one of the following: " + ValidRecipientsTypes);
            }
            return new Notification(this);
        }
    }

    public static enum Priority {
        SILENT(0),
        TOAST(5),
        POPUP(10);

        public final int value;

        private Priority(int value) {
            this.value = value;
        }
    }
}

