/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch;

import de.virtimo.bpc.api.AbstractEventHandler;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.BpcIndexCreateCallable;
import de.virtimo.bpc.api.opensearch.BpcIndexState;
import de.virtimo.bpc.api.opensearch.BpcIndexStateException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.util.StringUtil;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.service.event.Event;

public class BpcIndexStateImpl
implements BpcIndexState {
    private static final Logger LOG = Logger.getLogger(BpcIndexStateImpl.class.getName());
    private static final String INDEX_DOES_NOT_EXIST = "@@@index_does_not_exist@@@";
    private static final Object INDEX_LOCK = new Object();
    private OpenSearchService oss;
    private String alias;
    private String indexName;
    private final EventRegistration eventRegistration;

    public BpcIndexStateImpl(OpenSearchService oss, String alias) {
        LOG.info(alias + ": BpcIndexState()");
        this.oss = oss;
        this.alias = alias;
        this.indexName = null;
        this.eventRegistration = new EventRegistration(oss.getBundleContext());
        this.eventRegistration.forOpenSearchPluginEvents(new IndexDeletedEventHandler());
    }

    @Override
    public void destroy() {
        LOG.info(this.alias + ": destroy");
        this.eventRegistration.unregisterAllEventHandler();
        this.oss = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void prepareUsing(BpcIndexCreateCallable indexCreateCallable) throws BpcIndexStateException, OpenSearchRelatedException, ServiceNotFoundException, ModuleNotFoundException {
        LOG.fine(this.alias + ": prepareUsing indexCreateCallable=... (indexName=" + this.indexName + ")");
        Object object = INDEX_LOCK;
        synchronized (object) {
            if (this.indexName == null) {
                if (this.oss.existsIndex(this.alias)) {
                    Set<String> indexNames = this.oss.getIndexNamesWithAlias(this.alias);
                    if (indexNames == null || indexNames.size() == 0) {
                        throw new BpcIndexStateException("The OpenSearch alias '" + this.alias + "' is an index and not just an alias for an index. Please fix this.");
                    }
                    if (indexNames.size() != 1) throw new BpcIndexStateException("The OpenSearch alias '" + this.alias + "' has multiple indices assigned. Please fix this.");
                    this.indexName = indexNames.iterator().next();
                } else if (indexCreateCallable != null) {
                    this.indexName = indexCreateCallable.createIndex(this.oss);
                    LOG.info(this.alias + ": The OpenSearch index '" + this.indexName + " has been created");
                } else {
                    this.indexName = INDEX_DOES_NOT_EXIST;
                }
            } else if (this.indexName.equals(INDEX_DOES_NOT_EXIST)) {
                if (indexCreateCallable != null) {
                    try {
                        this.indexName = indexCreateCallable.createIndex(this.oss);
                        LOG.info(this.alias + ": The OpenSearch index '" + this.indexName + " has been created");
                    }
                    catch (OpenSearchRelatedException ex) {
                        LOG.log(Level.SEVERE, this.alias + ": Something failed while creating the index for the alias.", ex);
                        this.indexName = null;
                        throw ex;
                    }
                } else {
                    this.indexName = INDEX_DOES_NOT_EXIST;
                }
            }
            if (this.indexName == null || this.indexName.equals(INDEX_DOES_NOT_EXIST)) {
                throw new BpcIndexStateException("The index with the alias '" + this.alias + "' is somehow not pre-parable.");
            }
            LOG.fine("The index '" + this.indexName + "' for alias '" + this.alias + "' is prepared and can be used.");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid() {
        Object object = INDEX_LOCK;
        synchronized (object) {
            return this.indexName != null && !this.indexName.equals(INDEX_DOES_NOT_EXIST);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAlias() {
        Object object = INDEX_LOCK;
        synchronized (object) {
            return this.alias;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getIndexName() {
        Object object = INDEX_LOCK;
        synchronized (object) {
            return this.indexName == null ? null : (this.indexName.equals(INDEX_DOES_NOT_EXIST) ? null : this.indexName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        LOG.fine(this.alias + ": reset");
        Object object = INDEX_LOCK;
        synchronized (object) {
            this.indexName = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleDeletedIndex(String nameOfDeletedIndex) {
        LOG.fine(this.alias + ": handleDeletedIndex nameOfDeletedIndex=" + nameOfDeletedIndex);
        Object object = INDEX_LOCK;
        synchronized (object) {
            block15: {
                if (this.indexName != null && this.indexName.equals(nameOfDeletedIndex)) {
                    LOG.info(this.alias + ": The OpenSearch index '" + nameOfDeletedIndex + "' has been deleted. Checking for other indices with this alias to use instead...");
                    try {
                        if (this.oss.existsIndex(this.alias)) {
                            Set<String> indexNames = this.oss.getIndexNamesWithAlias(this.alias);
                            if (indexNames.size() == 1) {
                                String existingIndexName = indexNames.iterator().next();
                                if (this.indexName.equals(existingIndexName)) {
                                    LOG.log(Level.WARNING, this.alias + ": Strange, the alias '" + this.alias + "' still belongs to the just deleted index '" + this.indexName + "'. Checking again for max. 1 second.");
                                    if (this.hasIndexReallyBeenDeleted(this.alias, nameOfDeletedIndex, 1000L)) {
                                        LOG.log(Level.INFO, this.alias + ": Great, the alias has no longer the just deleted index '" + this.indexName + "' assigned.");
                                        this.indexName = INDEX_DOES_NOT_EXIST;
                                    } else {
                                        LOG.log(Level.SEVERE, this.alias + ": This alias has still the just deleted index '" + this.indexName + "' assigned. Please fix this or report it to OpenSearch.");
                                        this.indexName = null;
                                    }
                                } else {
                                    this.indexName = existingIndexName;
                                    LOG.info(this.alias + ": There is already an index '" + this.indexName + "' with this alias and I'm going to use this instead of the just deleted one.");
                                }
                            } else {
                                LOG.log(Level.SEVERE, this.alias + ": This alias has multiple indices assigned. Please fix this.");
                                this.indexName = null;
                            }
                            break block15;
                        }
                        LOG.info(this.alias + ": There is no other index with this alias. It gets created on next usage.");
                        this.indexName = INDEX_DOES_NOT_EXIST;
                    }
                    catch (OpenSearchRelatedException ex) {
                        LOG.log(Level.SEVERE, this.alias + ": Failed to check for already existing indices.", ex);
                        this.indexName = null;
                    }
                } else if (this.indexName != null && !this.indexName.equals(INDEX_DOES_NOT_EXIST) && this.alias.equals(nameOfDeletedIndex)) {
                    LOG.info(this.alias + ": The OpenSearch index '" + nameOfDeletedIndex + "' (same name as the alias) has been deleted. That was obviously an incorrectly created index.");
                    this.indexName = INDEX_DOES_NOT_EXIST;
                }
            }
        }
    }

    private boolean hasIndexReallyBeenDeleted(String aliasOfDeletedIndex, String nameOfDeletedIndex, long maxMilliseconds) throws OpenSearchRelatedException {
        LOG.fine(this.alias + ": hasIndexReallyBeenDeleted aliasOfDeletedIndex=" + aliasOfDeletedIndex + ", nameOfDeletedIndex=" + nameOfDeletedIndex + ", maxMilliseconds=" + maxMilliseconds + ")");
        long startTime = System.currentTimeMillis();
        boolean deleted = false;
        while (!deleted) {
            boolean timeout;
            deleted = this.checkIfIndexHasReallyBeenDeleted(aliasOfDeletedIndex, nameOfDeletedIndex);
            if (deleted) continue;
            boolean bl = timeout = startTime + maxMilliseconds < System.currentTimeMillis();
            if (timeout) break;
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return deleted;
    }

    private boolean checkIfIndexHasReallyBeenDeleted(String aliasOfDeletedIndex, String nameOfDeletedIndex) throws OpenSearchRelatedException {
        LOG.fine(this.alias + ": checkIfIndexHasReallyBeenDeleted aliasOfDeletedIndex=" + aliasOfDeletedIndex + ", nameOfDeletedIndex=" + nameOfDeletedIndex);
        if (this.oss.existsIndex(aliasOfDeletedIndex)) {
            Set<String> existingIndexNames = this.oss.getIndexNamesWithAlias(aliasOfDeletedIndex);
            for (String existingIndexName : existingIndexNames) {
                if (!nameOfDeletedIndex.equals(existingIndexName)) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "BpcIndexState{alias='" + this.alias + "', indexName='" + this.indexName + "'}";
    }

    private class IndexDeletedEventHandler
    extends AbstractEventHandler {
        private IndexDeletedEventHandler() {
        }

        @Override
        protected boolean canProcessEvent(Event event) {
            return Arrays.asList(event.getPropertyNames()).contains("IndexDeleted");
        }

        @Override
        public void processEvent(Event event) {
            LOG.info(BpcIndexStateImpl.this.alias + ": " + this.getClass().getSimpleName() + ".processEvent event=...");
            Map msg = (Map)event.getProperty("IndexDeleted");
            String nameOfDeletedIndex = (String)msg.get("index");
            if (!StringUtil.isNullOrEmpty(nameOfDeletedIndex)) {
                BpcIndexStateImpl.this.handleDeletedIndex(nameOfDeletedIndex);
            } else {
                LOG.log(Level.SEVERE, "Please inform the BPC developers. There is something wrong with the received deleted index event: " + msg);
            }
        }
    }
}

