/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch;

import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.opensearch.Broadcast;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BroadcastWebsocketMessage;
import de.virtimo.bpc.util.MapUtil;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.logging.Logger;

public class BroadcastImpl
implements Broadcast {
    private static final Logger LOG = Logger.getLogger(BroadcastImpl.class.getName());
    private final EventManager eventManager;
    private final String serverUUID;

    public BroadcastImpl(EventManager eventManager, String serverUUID) {
        this.eventManager = eventManager;
        this.serverUUID = serverUUID;
    }

    private void broadcastConfigChangeMessage(BroadcastType bpcConfigurationType, Map<String, Object> data) {
        LOG.info("broadcastConfigChangeMessage bpcConfigurationType=" + bpcConfigurationType + ", data=...");
        BroadcastWebsocketMessage broadcastWebsocketMessage = new BroadcastWebsocketMessage(this.serverUUID, LocalDateTime.now(), bpcConfigurationType.name(), data);
        this.eventManager.fireEvent("de/virtimo/os-bpc-plugin-send-broadcast-message", "msg", broadcastWebsocketMessage);
    }

    @Override
    public void moduleInstanceCreated(String moduleId, String instanceId, String instanceType) {
        LOG.info("moduleInstanceCreated moduleId=" + moduleId + ", instanceId=" + instanceId + ", instanceType=" + instanceType);
        this.broadcastConfigChangeMessage(BroadcastType.ModuleInstanceCreated, MapUtil.mapOf("moduleId", moduleId, "moduleInstanceId", instanceId, "moduleInstanceType", instanceType));
    }

    @Override
    public void moduleUpdated(String moduleId) {
        LOG.info("moduleUpdated moduleId=" + moduleId);
        this.broadcastConfigChangeMessage(BroadcastType.ModuleUpdated, MapUtil.mapOf("moduleId", moduleId));
    }

    @Override
    public void moduleInstanceUpdated(String moduleId, String instanceId, String instanceType) {
        LOG.info("moduleInstanceUpdated moduleId=" + moduleId + ", instanceId=" + instanceId + ", instanceType=" + instanceType);
        this.broadcastConfigChangeMessage(BroadcastType.ModuleInstanceUpdated, MapUtil.mapOf("moduleId", moduleId, "moduleInstanceId", instanceId, "moduleInstanceType", instanceType));
    }

    @Override
    public void moduleInstanceDeleted(String moduleId, String instanceId) {
        LOG.info("moduleInstanceDeleted moduleId=" + moduleId + ", instanceId=" + instanceId);
        this.broadcastConfigChangeMessage(BroadcastType.ModuleInstanceDeleted, MapUtil.mapOf("moduleId", moduleId, "moduleInstanceId", instanceId));
    }

    @Override
    public void moduleSettingDeleted(String moduleId, String settingName) {
        LOG.info("moduleSettingDeleted moduleId=" + moduleId + ", settingName=" + settingName);
        this.broadcastConfigChangeMessage(BroadcastType.ModuleUpdated, MapUtil.mapOf("moduleId", moduleId));
    }

    @Override
    public void moduleInstanceSettingDeleted(String moduleId, String instanceId, String instanceType, String settingName) {
        LOG.info("moduleInstanceSettingDeleted moduleId=" + moduleId + ", instanceId=" + instanceId + ", instanceType=" + instanceType + ", settingName=" + settingName);
        this.broadcastConfigChangeMessage(BroadcastType.ModuleInstanceUpdated, MapUtil.mapOf("moduleId", moduleId, "moduleInstanceId", instanceId, "moduleInstanceType", instanceType));
    }

    @Override
    public void clientEvent(Map<String, Object> clientEvent) {
        LOG.info("clientEvent clientEvent=" + clientEvent);
        this.broadcastConfigChangeMessage(BroadcastType.ClientEvent, clientEvent);
    }

    @Override
    public void moduleRelatedStoreItemDeleted(String moduleId, String storeId, String storeItemId) {
        LOG.info("moduleRelatedStoreItemDeleted moduleId=" + moduleId + ", storeId=" + storeId + ", storeItemId=" + storeItemId);
        this.broadcastConfigChangeMessage(BroadcastType.ModuleRelatedStoreItemDeleted, MapUtil.mapOf("moduleId", moduleId, "storeId", storeId, "storeItemId", storeItemId));
    }

    @Override
    public void moduleRelatedStoreItemCreated(String moduleId, String storeId, String storeItemId) {
        LOG.info("moduleRelatedStoreItemCreated moduleId=" + moduleId + ", storeId=" + storeId + ", storeItemId=" + storeItemId);
        this.broadcastConfigChangeMessage(BroadcastType.ModuleRelatedStoreItemCreated, MapUtil.mapOf("moduleId", moduleId, "storeId", storeId, "storeItemId", storeItemId));
    }

    @Override
    public void moduleRelatedStoreItemUpdated(String moduleId, String storeId, String storeItemId) {
        LOG.info("moduleRelatedStoreItemUpdated moduleId=" + moduleId + ", storeId=" + storeId + ", storeItemId=" + storeItemId);
        this.broadcastConfigChangeMessage(BroadcastType.ModuleRelatedStoreItemUpdated, MapUtil.mapOf("moduleId", moduleId, "storeId", storeId, "storeItemId", storeItemId));
    }

    @Override
    public void moduleInstanceRelatedStoreItemDeleted(String moduleId, String instanceId, String instanceType, String storeId, String storeItemId) {
        LOG.info("moduleInstanceRelatedStoreItemDeleted moduleId=" + moduleId + ", instanceId=" + instanceId + ", instanceType=" + instanceType + ", storeId=" + storeId + ", storeItemId=" + storeItemId);
        this.broadcastConfigChangeMessage(BroadcastType.ModuleInstanceRelatedStoreItemDeleted, MapUtil.mapOf("moduleId", moduleId, "moduleInstanceId", instanceId, "moduleInstanceType", instanceType, "storeId", storeId, "storeItemId", storeItemId));
    }

    @Override
    public void moduleInstanceRelatedStoreItemCreated(String moduleId, String instanceId, String instanceType, String storeId, String storeItemId) {
        LOG.info("moduleInstanceRelatedStoreItemCreated moduleId=" + moduleId + ", instanceId=" + instanceId + ", instanceType=" + instanceType + ", storeId=" + storeId + ", storeItemId=" + storeItemId);
        this.broadcastConfigChangeMessage(BroadcastType.ModuleInstanceRelatedStoreItemCreated, MapUtil.mapOf("moduleId", moduleId, "moduleInstanceId", instanceId, "moduleInstanceType", instanceType, "storeId", storeId, "storeItemId", storeItemId));
    }

    @Override
    public void moduleInstanceRelatedStoreItemUpdated(String moduleId, String instanceId, String instanceType, String storeId, String storeItemId) {
        LOG.info("moduleInstanceRelatedStoreItemUpdated moduleId=" + moduleId + ", instanceId=" + instanceId + ", instanceType=" + instanceType + ", storeId=" + storeId + ", storeItemId=" + storeItemId);
        this.broadcastConfigChangeMessage(BroadcastType.ModuleInstanceRelatedStoreItemUpdated, MapUtil.mapOf("moduleId", moduleId, "moduleInstanceId", instanceId, "moduleInstanceType", instanceType, "storeId", storeId, "storeItemId", storeItemId));
    }

    public static enum BroadcastType {
        ModuleInstanceDeleted,
        ModuleInstanceUpdated,
        ModuleInstanceCreated,
        ModuleUpdated,
        ClientEvent,
        ModuleRelatedStoreItemDeleted,
        ModuleRelatedStoreItemCreated,
        ModuleRelatedStoreItemUpdated,
        ModuleInstanceRelatedStoreItemDeleted,
        ModuleInstanceRelatedStoreItemCreated,
        ModuleInstanceRelatedStoreItemUpdated;

    }
}

