/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch.migration;

import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.opensearch.migration.AllSearchHitsMigration;
import de.virtimo.bpc.core.opensearch.migration.IndexToMigrate;
import de.virtimo.bpc.util.SetUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.search.SearchHit;

public class BpcConfigurationIndexMigrationFromModelVersion19To20
extends AllSearchHitsMigration {
    private static final Logger LOG = Logger.getLogger(BpcConfigurationIndexMigrationFromModelVersion19To20.class.getName());
    private static final Set<String> ReservedFieldNamesOfASetting = SetUtil.setOf("id", "moduleId", "instanceId", "instanceType", "name", "type", "value");
    private static final String CustomFieldsFieldName = "customFields";

    public BpcConfigurationIndexMigrationFromModelVersion19To20(OpenSearchService oss) {
        super(oss, 20);
    }

    @Override
    public List<IndexRequest> migrateSearchHit(RestHighLevelClient osClient, IndexToMigrate oldIndex, IndexToMigrate newIndex, SearchHit hit) {
        Map<String, Object> sourceValues = hit.getSourceAsMap();
        HashMap<String, Object> updatedSourceValues = new HashMap<String, Object>();
        HashMap<String, Object> customFields = new HashMap<String, Object>();
        for (String fieldName : sourceValues.keySet()) {
            Object fieldValue = sourceValues.get(fieldName);
            if (ReservedFieldNamesOfASetting.contains(fieldName)) {
                updatedSourceValues.put(fieldName, fieldValue);
                continue;
            }
            customFields.put(fieldName, fieldValue);
        }
        updatedSourceValues.put(CustomFieldsFieldName, customFields);
        return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(updatedSourceValues, (MediaType)XContentType.JSON));
    }
}

