/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch.migration;

import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.opensearch.migration.AllSearchHitsMigration;
import de.virtimo.bpc.core.opensearch.migration.IndexToMigrate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.search.SearchHit;

class BpcConfigurationIndexMigrationFromModelVersion6To7
extends AllSearchHitsMigration {
    private static final Logger LOG = Logger.getLogger(BpcConfigurationIndexMigrationFromModelVersion6To7.class.getName());

    public BpcConfigurationIndexMigrationFromModelVersion6To7(OpenSearchService oss) {
        super(oss, 7);
    }

    @Override
    public List<IndexRequest> migrateSearchHit(RestHighLevelClient osClient, IndexToMigrate oldIndex, IndexToMigrate newIndex, SearchHit hit) {
        Map<String, Object> sourceValues = hit.getSourceAsMap();
        if (!hit.getId().equals(sourceValues.get("id"))) {
            LOG.warning("Skipping document with ID mismatch: " + hit.getId() + " != " + sourceValues.get("id"));
            return null;
        }
        if ("_core_noinstance_replicatorThreadCount".equals(hit.getId())) {
            String newId = this.createSettingId("replication", "noinstance", "replicatorThreadCount");
            sourceValues.put("id", newId);
            sourceValues.put("moduleId", "replication");
            sourceValues.put("instanceId", "noinstance");
            return Collections.singletonList(new IndexRequest(newIndex.getName()).id(newId).source(sourceValues, (MediaType)XContentType.JSON));
        }
        if ("_core_noinstance_replicationRdmsEs".equals(hit.getId())) {
            ArrayList<IndexRequest> replicationInstanceRequests = new ArrayList<IndexRequest>();
            Object replicationRdmsEsObject = sourceValues.get("value");
            if (replicationRdmsEsObject instanceof Map) {
                Map replicationRdmsEsMap = (Map)replicationRdmsEsObject;
                List replicationJobs = (List)replicationRdmsEsMap.get("replicationJobs");
                for (Map replicationJob : replicationJobs) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException ex) {
                        LOG.log(Level.WARNING, "Sleep has been interrupted", ex);
                    }
                    String instanceId = String.valueOf(System.currentTimeMillis());
                    Object replicationIdObject = replicationJob.get("replicationId");
                    if (replicationIdObject != null) {
                        String moduleNameSettingId = this.createSettingId("replication", instanceId, "module_name");
                        Map<String, Object> moduleNameSettingMap = this.createSettingMap(moduleNameSettingId, "replication", instanceId, "none", "module_name", "text", String.valueOf(replicationIdObject));
                        replicationInstanceRequests.add(new IndexRequest(newIndex.getName()).id(moduleNameSettingId).source(moduleNameSettingMap, (MediaType)XContentType.JSON));
                    }
                    this.addReplicationSetting(newIndex, instanceId, replicationJob, "rdmsDataSourceName", "text", replicationInstanceRequests);
                    this.addReplicationSetting(newIndex, instanceId, replicationJob, "sourceTable", "text", replicationInstanceRequests);
                    this.addReplicationSetting(newIndex, instanceId, replicationJob, "sourceTimeZone", "text", replicationInstanceRequests);
                    this.addReplicationSetting(newIndex, instanceId, replicationJob, "idColumns", "text", replicationInstanceRequests);
                    this.addReplicationSetting(newIndex, instanceId, replicationJob, "lastUpdateColumn", "text", replicationInstanceRequests);
                    this.addReplicationSetting(newIndex, instanceId, replicationJob, "lastUpdateColumnTimeZone", "text", replicationInstanceRequests);
                    this.addReplicationSetting(newIndex, instanceId, replicationJob, "targetIndex", "text", replicationInstanceRequests);
                    this.addReplicationSetting(newIndex, instanceId, replicationJob, "targetIndexDynamicTemplates", "json", replicationInstanceRequests);
                    this.addReplicationSetting(newIndex, instanceId, replicationJob, "replicationEnabled", "boolean", replicationInstanceRequests);
                    this.addReplicationSetting(newIndex, instanceId, replicationJob, "replicationDelay", "int", replicationInstanceRequests);
                    this.addReplicationSetting(newIndex, instanceId, replicationJob, "replicationInterval", "int", replicationInstanceRequests);
                    this.addReplicationSetting(newIndex, instanceId, replicationJob, "replicationStartDate", "text", replicationInstanceRequests);
                    this.addReplicationSetting(newIndex, instanceId, replicationJob, "replicationBlockDayRange", "int", replicationInstanceRequests);
                    this.addReplicationSetting(newIndex, instanceId, replicationJob, "replicationBlockSize", "int", replicationInstanceRequests);
                    this.addReplicationSetting(newIndex, instanceId, replicationJob, "replicationSyncFiles", "boolean", replicationInstanceRequests);
                    this.addReplicationSetting(newIndex, instanceId, replicationJob, "replicationUnzipSyncedFiles", "boolean", replicationInstanceRequests);
                    this.addReplicationSetting(newIndex, instanceId, replicationJob, "restartReplicationWhereLeftOff", "boolean", replicationInstanceRequests);
                    this.addReplicationSetting(newIndex, instanceId, replicationJob, "adjustUpperDateLimitInSeconds", "int", replicationInstanceRequests);
                    this.addReplicationSetting(newIndex, instanceId, replicationJob, "sourceQueryTimeoutInSeconds", "int", replicationInstanceRequests);
                    this.addReplicationSetting(newIndex, instanceId, replicationJob, "vamOrganizationId", "text", replicationInstanceRequests);
                    this.addReplicationSetting(newIndex, instanceId, replicationJob, "replicationShadowCopyEnabled", "boolean", replicationInstanceRequests);
                    this.addReplicationSetting(newIndex, instanceId, replicationJob, "replicationShadowCopyCronPattern", "text", replicationInstanceRequests);
                    this.addReplicationSetting(newIndex, instanceId, replicationJob, "replicationShadowCopyKeepCopiesCount", "int", replicationInstanceRequests);
                    this.addReplicationSetting(newIndex, instanceId, replicationJob, "replicationTailSyncEnabled", "boolean", replicationInstanceRequests);
                    this.addReplicationSetting(newIndex, instanceId, replicationJob, "replicationTailSyncCronPattern", "text", replicationInstanceRequests);
                    this.addReplicationSetting(newIndex, instanceId, replicationJob, "replicationTailSyncBlockSize", "int", replicationInstanceRequests);
                    this.addReplicationSetting(newIndex, instanceId, replicationJob, "replicationTailSyncRelativeStartDate", "text", replicationInstanceRequests);
                    this.addReplicationSetting(newIndex, instanceId, replicationJob, "replicationTailSyncRelativeEndDate", "text", replicationInstanceRequests);
                    this.addReplicationSetting(newIndex, instanceId, replicationJob, "replicationTailSyncBlockDayRange", "int", replicationInstanceRequests);
                    this.addReplicationSetting(newIndex, instanceId, replicationJob, "replicationTailSyncRelativeDeleteOlderThanDate", "text", replicationInstanceRequests);
                    this.addReplicationSetting(newIndex, instanceId, replicationJob, "replicationConsistencyCheckFrequency", "int", replicationInstanceRequests);
                    this.addReplicationSetting(newIndex, instanceId, replicationJob, "join", "json", replicationInstanceRequests);
                    this.addAdjustedLastUpdateTimestampToTargetIndex(replicationJob.get("targetIndex"), replicationJob.get("replicationId"), instanceId);
                }
            }
            return replicationInstanceRequests;
        }
        return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(sourceValues, (MediaType)XContentType.JSON));
    }

    private void addAdjustedLastUpdateTimestampToTargetIndex(Object targetIndexObject, Object replicationIdObject, String instanceId) {
        if (targetIndexObject instanceof String && replicationIdObject instanceof String) {
            try {
                Object lastUpdateTimestampObject;
                OpenSearchService oss = this.getOpenSearchService();
                String targetIndex = (String)targetIndexObject;
                if (oss.existsIndex(targetIndex) && (lastUpdateTimestampObject = oss.getMetaDataValue(targetIndex, "last_update_timestamp:::" + replicationIdObject)) != null) {
                    oss.setMetaDataValue(targetIndex, "last_update_timestamp:::" + instanceId, lastUpdateTimestampObject);
                }
            }
            catch (Throwable ex) {
                LOG.log(Level.SEVERE, "Failed to adjust the 'last_update_timestamp:::' meta data value of the target index '" + targetIndexObject + "'.", ex);
            }
        }
    }

    private void addReplicationSetting(IndexToMigrate newIndex, String instanceId, Map<String, Object> replicationJobMap, String settingName, String settingType, List<IndexRequest> replicationInstanceRequests) {
        if (replicationJobMap != null && settingName != null && replicationJobMap.containsKey(settingName)) {
            String settingId = this.createSettingId("replication", instanceId, settingName);
            Object settingValue = replicationJobMap.get(settingName);
            Map<String, Object> settingMap = this.createSettingMap(settingId, "replication", instanceId, "none", settingName, settingType, settingValue);
            replicationInstanceRequests.add(new IndexRequest(newIndex.getName()).id(settingId).source(settingMap, (MediaType)XContentType.JSON));
        }
    }

    private String createSettingId(String moduleId, String instanceId, String settingName) {
        return moduleId + "_" + instanceId + "_" + settingName;
    }

    private Map<String, Object> createSettingMap(String id, String moduleId, String instanceId, String instanceType, String settingName, String valueType, Object value) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("id", id);
        result.put("moduleId", moduleId);
        result.put("instanceId", instanceId);
        result.put("instanceType", instanceType);
        result.put("name", settingName);
        result.put("type", valueType);
        result.put("value", value);
        return result;
    }
}

