/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch.migration;

import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.opensearch.migration.AllSearchHitsMigration;
import de.virtimo.bpc.core.opensearch.migration.IndexToMigrate;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.SetUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.search.SearchHit;

public class BpcNotificationIndexMigrationFromModelVersion1To2
extends AllSearchHitsMigration {
    private static final Logger LOG = Logger.getLogger(BpcNotificationIndexMigrationFromModelVersion1To2.class.getName());

    public BpcNotificationIndexMigrationFromModelVersion1To2(OpenSearchService oss) {
        super(oss, 2);
    }

    @Override
    public List<IndexRequest> migrateSearchHit(RestHighLevelClient osClient, IndexToMigrate oldIndex, IndexToMigrate newIndex, SearchHit hit) {
        Map<String, Object> sourceValues = hit.getSourceAsMap();
        if (sourceValues.containsKey("recipient")) {
            String recipient = MapUtil.getValueAsString(sourceValues, "recipient", null);
            sourceValues.remove("recipient");
            sourceValues.put("recipients", SetUtil.setOf(recipient));
        }
        if (sourceValues.containsKey("recipientType")) {
            String recipientType = MapUtil.getValueAsString(sourceValues, "recipientType", null);
            sourceValues.remove("recipientType");
            sourceValues.put("recipientsType", recipientType);
        }
        return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(sourceValues, (MediaType)XContentType.JSON));
    }
}

