/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch.plugin;

import de.virtimo.bpc.api.AbstractEventHandler;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.plugin.OpenSearchBpcPluginManager;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.opensearch.BroadcastImpl;
import de.virtimo.bpc.opensearch.plugin.dto.IndexOperationDTO;
import de.virtimo.bpc.opensearch.plugin.dto.LoadedModuleDTO;
import de.virtimo.bpc.opensearch.plugin.dto.LoadedModulesDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ServerStateInfoDTO;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessageException;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessageFactory;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BroadcastToAllExceptSenderWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BroadcastToAllWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BroadcastToWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BroadcastWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.IndexDeletedWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.IndexOperationWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ServerLoadedModulesWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ServerStateInfoWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.SetAsMasterServerWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.WebsocketMessageForFrontendSession;
import de.virtimo.bpc.util.DictionaryUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class OpenSearchBpcPluginListener
implements Runnable {
    private static final Logger LOG = Logger.getLogger(OpenSearchBpcPluginListener.class.getName());
    public static final String RETRY_INTERVAL_IN_SECONDS_PROPERTY_NAME = "de.virtimo.bpc.core.os-bpc-plugin.retryInterval";
    public static final int RETRY_INTERVAL_IN_SECONDS_DEFAULT_VALUE = 5;
    private final BundleContext bundleContext;
    private BpcServicesTracker<EventManager> eventManagerTracker;
    private BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private BpcServicesTracker<ClientSessionManager> clientSessionManagerTracker;
    private BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private OpenSearchBpcPluginManager openSearchBpcPluginManager;
    private WebSocketClient websocketClient = null;

    public OpenSearchBpcPluginListener(BundleContext bundleContext, OpenSearchBpcPluginManager openSearchBpcPluginManager) {
        this.bundleContext = bundleContext;
        this.openSearchBpcPluginManager = openSearchBpcPluginManager;
    }

    public void destroy() {
        LOG.info("destroy");
        if (this.websocketClient != null) {
            try {
                this.websocketClient.stop();
                this.websocketClient = null;
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Could not stop the websocket connection", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        OpenSearchBpcPluginSocket socket;
        ServiceRegistration msgEventHandlerRegistration;
        LOG.info("run");
        if (this.websocketClient != null && this.websocketClient.isRunning()) {
            LOG.info("Nothing to do ... there is already a running websocket connection.");
            return;
        }
        if (this.websocketClient != null) {
            LOG.warning("Should not happen ... previously used websocket client is in state: " + this.websocketClient.getState());
            try {
                this.websocketClient.stop();
                this.websocketClient = null;
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Failed to stop an old/previously used websocket client.", ex);
            }
        }
        if ((msgEventHandlerRegistration = this.bundleContext.registerService(EventHandler.class, (Object)(socket = new OpenSearchBpcPluginSocket()), DictionaryUtil.dictionaryOf("event.topics", new String[]{"de/virtimo/os-bpc-plugin-send-broadcast-message-to-all", "de/virtimo/os-bpc-plugin-send-broadcast-message", "de/virtimo/os-bpc-plugin-send-state-info-message", "de/virtimo/os-bpc-plugin-send-percolator-hit-message", "de/virtimo/bpc/core/backendModuleLoaded", "de/virtimo/bpc/core/backendModuleUnloaded", "de/virtimo/os-bpc-plugin"}))) == null) {
            LOG.log(Level.SEVERE, "No websocket connection established. Could not register the event handler!");
            return;
        }
        LOG.info("Establishing Websocket connection");
        try {
            this.eventManagerTracker = new BpcServicesTracker<EventManager>(this.bundleContext, EventManager.class);
            this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);
            this.clientSessionManagerTracker = new BpcServicesTracker<ClientSessionManager>(this.bundleContext, ClientSessionManager.class);
            this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(this.bundleContext, OpenSearchService.class);
            this.websocketClient = new WebSocketClient();
            this.websocketClient.start();
            this.websocketClient.setConnectTimeout(10000L);
            this.websocketClient.setMaxIdleTimeout(0L);
            URI openSearchBpcPluginWebsocketURI = new URI(this.openSearchBpcPluginManager.getOpenSearchBpcPluginWebsocketUrl());
            ClientUpgradeRequest request = new ClientUpgradeRequest();
            this.websocketClient.connect((Object)socket, openSearchBpcPluginWebsocketURI, request);
            LOG.info("Connecting to : " + openSearchBpcPluginWebsocketURI);
            socket.await();
            LOG.info("Websocket client stopped");
            return;
        }
        catch (InterruptedException ex) {
            LOG.info("The websocket connection has been interrupted. Maybe just the core bundle stopped.");
            this.openSearchBpcPluginManager.setWebsocketState(OpenSearchBpcPluginManager.WebsocketState.DISCONNECTED);
            return;
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, "Could not establish the websocket connection", t);
            this.openSearchBpcPluginManager.addError("Could not establish the websocket connection.", t);
            this.openSearchBpcPluginManager.setWebsocketState(OpenSearchBpcPluginManager.WebsocketState.DISCONNECTED_DUE_TO_ERROR);
            return;
        }
        finally {
            try {
                msgEventHandlerRegistration.unregister();
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Could not unregister the message event handler", e);
            }
            if (this.websocketClient != null) {
                try {
                    this.websocketClient.stop();
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Could not stop the websocket connection", e);
                }
                finally {
                    this.websocketClient = null;
                }
            }
            BpcServicesTracker.stopAll(this);
        }
    }

    @WebSocket(maxTextMessageSize=262144)
    public class OpenSearchBpcPluginSocket
    extends AbstractEventHandler {
        private final CountDownLatch closeLatch = new CountDownLatch(1);
        private Session session;
        private RemoteEndpoint remote;

        public boolean awaitClose(int duration, TimeUnit unit) throws InterruptedException {
            return this.closeLatch.await(duration, unit);
        }

        public void await() throws InterruptedException {
            this.closeLatch.await();
        }

        @OnWebSocketConnect
        public void onConnect(Session session) {
            LOG.info(this.getClass().getSimpleName() + ".onConnect: " + session);
            this.session = session;
            this.remote = this.session.getRemote();
            OpenSearchBpcPluginListener.this.openSearchBpcPluginManager.setWebsocketState(OpenSearchBpcPluginManager.WebsocketState.CONNECTED);
        }

        @OnWebSocketClose
        public void onClose(int statusCode, String reason) {
            LOG.info(this.getClass().getSimpleName() + ".onClose: " + statusCode + " - " + reason);
            this.session = null;
            this.remote = null;
            this.closeLatch.countDown();
            OpenSearchBpcPluginListener.this.openSearchBpcPluginManager.setWebsocketState(OpenSearchBpcPluginManager.WebsocketState.DISCONNECTED);
        }

        @OnWebSocketError
        public void onError(Throwable cause) {
            LOG.log(Level.SEVERE, this.getClass().getSimpleName() + ".onError", cause);
            this.session = null;
            this.remote = null;
            this.closeLatch.countDown();
            OpenSearchBpcPluginListener.this.openSearchBpcPluginManager.addError("Closing websocket session due to received transport error.", cause);
            OpenSearchBpcPluginListener.this.openSearchBpcPluginManager.setWebsocketState(OpenSearchBpcPluginManager.WebsocketState.DISCONNECTED_DUE_TO_ERROR);
        }

        @OnWebSocketMessage
        public void onMessage(String msg) {
            LOG.info(this.getClass().getSimpleName() + ".onMessage: " + msg);
            try {
                WebsocketMessage websocketMessage = WebsocketMessageFactory.create((String)msg);
                if (websocketMessage == null) {
                    return;
                }
                LOG.finest("os-bpc-plugin onMessage: " + websocketMessage);
                if (websocketMessage instanceof WebsocketMessageForFrontendSession) {
                    WebsocketMessageForFrontendSession websocketMessageForFrontendSession = (WebsocketMessageForFrontendSession)websocketMessage;
                    try {
                        String sessionId = websocketMessageForFrontendSession.getSessionId();
                        String json = websocketMessageForFrontendSession.getMessage();
                        ClientSessionManager clientSessionManager = OpenSearchBpcPluginListener.this.clientSessionManagerTracker.getService();
                        if (sessionId.equalsIgnoreCase("ALL")) {
                            clientSessionManager.broadcastMessage(json);
                        } else {
                            clientSessionManager.sendByWebsocket(sessionId, json);
                        }
                    }
                    catch (ServiceNotFoundException ex) {
                        LOG.log(Level.SEVERE, "Failed to process the WebSocket message due to missing service.", ex);
                        OpenSearchBpcPluginListener.this.openSearchBpcPluginManager.addError("Failed to get the ClientSessionManager service", ex);
                    }
                }
                if (websocketMessage instanceof BroadcastWebsocketMessage) {
                    BroadcastWebsocketMessage broadcastWebsocketMessage = (BroadcastWebsocketMessage)websocketMessage;
                    try {
                        if (broadcastWebsocketMessage.isType(BroadcastImpl.BroadcastType.ClientEvent.name())) {
                            Map eventData = broadcastWebsocketMessage.getData();
                            OpenSearchBpcPluginListener.this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/client/" + eventData.get("event"), DictionaryUtil.dictionaryOf("data", eventData.get("data")));
                        } else {
                            OpenSearchBpcPluginListener.this.eventManagerTracker.getService().fireEvent("de/virtimo/os-bpc-plugin", "BroadcastMessage", broadcastWebsocketMessage);
                        }
                    }
                    catch (ServiceNotFoundException ex) {
                        LOG.log(Level.SEVERE, "Failed to fire the WebSocket broadcast message event.", ex);
                        OpenSearchBpcPluginListener.this.openSearchBpcPluginManager.addError("Failed to get the EventManager service", ex);
                    }
                }
                if (websocketMessage instanceof IndexOperationWebsocketMessage) {
                    IndexOperationWebsocketMessage indexOperationWebsocketMessage = (IndexOperationWebsocketMessage)websocketMessage;
                    try {
                        IndexOperationDTO indexOperation = indexOperationWebsocketMessage.getIndexOperation();
                        if (indexOperation != null) {
                            OpenSearchBpcPluginListener.this.eventManagerTracker.getService().fireEvent("de/virtimo/os-bpc-plugin", "IndexOperation", indexOperation);
                        }
                    }
                    catch (ServiceNotFoundException ex) {
                        LOG.log(Level.SEVERE, "Failed to fire the Index operation event", ex);
                        OpenSearchBpcPluginListener.this.openSearchBpcPluginManager.addError("Failed to get the EventManager service", ex);
                    }
                }
                if (websocketMessage instanceof IndexDeletedWebsocketMessage) {
                    IndexDeletedWebsocketMessage indexDeletedWebsocketMessage = (IndexDeletedWebsocketMessage)websocketMessage;
                    try {
                        String index = indexDeletedWebsocketMessage.getIndexName();
                        if (index != null && !index.endsWith("_creation_lock")) {
                            String aliasOfBpcIndex = OpenSearchBpcPluginListener.this.openSearchServiceTracker.getService().aliasFromBpcIndexName(index);
                            OpenSearchBpcPluginListener.this.eventManagerTracker.getService().fireEvent("de/virtimo/os-bpc-plugin", "IndexDeleted", MapUtil.mapOf("index", index, "aliasOfBpcIndex", aliasOfBpcIndex));
                        }
                    }
                    catch (ServiceNotFoundException ex) {
                        LOG.log(Level.SEVERE, "Failed to fire the Index deleted event", ex);
                        OpenSearchBpcPluginListener.this.openSearchBpcPluginManager.addError("Failed to get the EventManager service", ex);
                    }
                }
                if (websocketMessage instanceof SetAsMasterServerWebsocketMessage) {
                    SetAsMasterServerWebsocketMessage setAsMasterServerWebsocketMessage = (SetAsMasterServerWebsocketMessage)websocketMessage;
                    try {
                        OpenSearchBpcPluginListener.this.eventManagerTracker.getService().fireEvent("de/virtimo/os-bpc-plugin", "SetAsMasterServer", setAsMasterServerWebsocketMessage);
                    }
                    catch (ServiceNotFoundException ex) {
                        LOG.log(Level.SEVERE, "Failed to fire the set as master server event", ex);
                        OpenSearchBpcPluginListener.this.openSearchBpcPluginManager.addError("Failed to get the EventManager service", ex);
                    }
                }
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Failed to process the received websocket message from the os-bpc-plugin.", t);
            }
        }

        @Override
        public void processEvent(Event event) {
            BroadcastWebsocketMessage broadcastWebsocketMessage;
            Object msgObject;
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=" + event);
            if (event.getTopic().equals("de/virtimo/os-bpc-plugin-send-broadcast-message-to-all") && (msgObject = event.getProperty("msg")) instanceof BroadcastWebsocketMessage) {
                broadcastWebsocketMessage = (BroadcastWebsocketMessage)msgObject;
                try {
                    BroadcastToAllWebsocketMessage broadcastToAllWebsocketMessage = new BroadcastToAllWebsocketMessage((WebsocketMessage)broadcastWebsocketMessage);
                    this.sendWebsocketMessageSync((WebsocketMessage)broadcastToAllWebsocketMessage);
                }
                catch (WebsocketMessageException ex) {
                    LOG.log(Level.SEVERE, this.getClass().getSimpleName() + ".processEvent : Failed to send a broadcast to all websocket message.", ex);
                }
            }
            if (event.getTopic().equals("de/virtimo/os-bpc-plugin-send-broadcast-message") && (msgObject = event.getProperty("msg")) instanceof BroadcastWebsocketMessage) {
                broadcastWebsocketMessage = (BroadcastWebsocketMessage)msgObject;
                try {
                    BroadcastToAllExceptSenderWebsocketMessage broadcastToAllExceptSenderWebsocketMessage = new BroadcastToAllExceptSenderWebsocketMessage((WebsocketMessage)broadcastWebsocketMessage);
                    this.sendWebsocketMessageSync((WebsocketMessage)broadcastToAllExceptSenderWebsocketMessage);
                }
                catch (WebsocketMessageException ex) {
                    LOG.log(Level.SEVERE, this.getClass().getSimpleName() + ".processEvent : Failed to send a broadcast websocket message.", ex);
                }
            }
            if (event.getTopic().equals("de/virtimo/os-bpc-plugin-send-state-info-message") && (msgObject = event.getProperty("msg")) instanceof ServerStateInfoDTO) {
                ServerStateInfoDTO serverStateInfoDTO = (ServerStateInfoDTO)msgObject;
                ServerStateInfoWebsocketMessage serverStateInfoWebsocketMessage = new ServerStateInfoWebsocketMessage(serverStateInfoDTO);
                this.sendWebsocketMessageSync((WebsocketMessage)serverStateInfoWebsocketMessage);
            }
            if (event.getTopic().equals("de/virtimo/bpc/core/backendModuleLoaded") || event.getTopic().equals("de/virtimo/bpc/core/backendModuleUnloaded") || event.getTopic().equals("de/virtimo/os-bpc-plugin") && event.getProperty("WebsocketState") == OpenSearchBpcPluginManager.WebsocketState.CONNECTED) {
                try {
                    ModuleManager moduleManager = OpenSearchBpcPluginListener.this.moduleManagerTracker.getService();
                    LoadedModulesDTO serverLoadedModules = new LoadedModulesDTO();
                    for (Module module : moduleManager.getLoadedModules().values()) {
                        serverLoadedModules.addLoadedModule(new LoadedModuleDTO(module.getModuleId(), module.getModuleBundle().getVersion().toString()));
                    }
                    ServerLoadedModulesWebsocketMessage serverLoadedModulesWebsocketMessage = new ServerLoadedModulesWebsocketMessage(serverLoadedModules);
                    this.sendWebsocketMessageSync((WebsocketMessage)serverLoadedModulesWebsocketMessage);
                }
                catch (ServiceNotFoundException ex) {
                    LOG.log(Level.WARNING, this.getClass().getSimpleName() + ".processEvent : Failed to inform the os-bpc-plugin about my loaded modules.", ex);
                }
            }
            if (event.getTopic().equals("de/virtimo/os-bpc-plugin-send-percolator-hit-message")) {
                try {
                    String serverUUID = (String)event.getProperty("serverUUID");
                    String sessionId = (String)event.getProperty("sessionId");
                    String jsonMsg = (String)event.getProperty("jsonMsg");
                    if (!StringUtil.isNullOrEmpty(serverUUID)) {
                        BroadcastToWebsocketMessage broadcastToWebsocketMessage = new BroadcastToWebsocketMessage(List.of(serverUUID), (WebsocketMessage)new WebsocketMessageForFrontendSession(sessionId, jsonMsg));
                        this.sendWebsocketMessageSync((WebsocketMessage)broadcastToWebsocketMessage);
                    } else {
                        BroadcastToAllWebsocketMessage broadcastToAllWebsocketMessage = new BroadcastToAllWebsocketMessage((WebsocketMessage)new WebsocketMessageForFrontendSession(sessionId, jsonMsg));
                        this.sendWebsocketMessageSync((WebsocketMessage)broadcastToAllWebsocketMessage);
                    }
                }
                catch (WebsocketMessageException ex) {
                    LOG.log(Level.SEVERE, this.getClass().getSimpleName() + ".processEvent : Failed not create the websocket message instances for the percolators hit message.", ex);
                }
            }
        }

        private void sendWebsocketMessageSync(WebsocketMessage websocketMessage) {
            block5: {
                String msg;
                LOG.info(this.getClass().getSimpleName() + ".sendWebsocketMessageSync websocketMessage=...");
                try {
                    msg = websocketMessage.getMessageToSend();
                }
                catch (WebsocketMessageException ex) {
                    LOG.log(Level.SEVERE, this.getClass().getSimpleName() + ".sendWebsocketMessageSync : Failed to get the message to send.", ex);
                    return;
                }
                Future fut = null;
                try {
                    fut = this.remote.sendStringByFuture(msg);
                    fut.get(15L, TimeUnit.SECONDS);
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.log(Level.SEVERE, this.getClass().getSimpleName() + ".sendWebsocketMessageSync : Could not send the websocket message: " + msg, e);
                }
                catch (TimeoutException e) {
                    LOG.log(Level.SEVERE, this.getClass().getSimpleName() + ".sendWebsocketMessageSync : Timeout (15 seconds) while sending the websocket message: " + msg, e);
                    if (fut == null) break block5;
                    fut.cancel(true);
                }
            }
        }

        private void sendWebsocketMessageAsync(WebsocketMessage websocketMessage) {
            String msg;
            LOG.info(this.getClass().getSimpleName() + ".sendWebsocketMessageAsync websocketMessage=...");
            try {
                msg = websocketMessage.getMessageToSend();
            }
            catch (WebsocketMessageException ex) {
                LOG.log(Level.SEVERE, this.getClass().getSimpleName() + ".sendWebsocketMessageAsync : Failed to get the message to send.", ex);
                return;
            }
            this.remote.sendStringByFuture(msg);
        }
    }
}

