/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator;

import de.virtimo.bpc.util.StringUtil;
import java.util.logging.Logger;

public class DbColumnNamesToOpenSearchFieldNamesConverter {
    private static final Logger LOG = Logger.getLogger(DbColumnNamesToOpenSearchFieldNamesConverter.class.getName());
    public static final String AS_SOURCE = "asSource";
    public static final String LOWER_CASE = "lowerCase";
    public static final String UPPER_CASE = "upperCase";
    private final String caseSensitivityOfFields;

    public DbColumnNamesToOpenSearchFieldNamesConverter(String caseSensitivityOfFields) {
        this.caseSensitivityOfFields = caseSensitivityOfFields;
    }

    public String getCaseSensitivityOfFields() {
        return this.caseSensitivityOfFields;
    }

    public String convert(String dbColumnName) {
        if (!StringUtil.isNullOrEmpty(dbColumnName) && !StringUtil.isNullOrEmpty(this.caseSensitivityOfFields)) {
            if (LOWER_CASE.equals(this.caseSensitivityOfFields)) {
                return dbColumnName.toLowerCase();
            }
            if (UPPER_CASE.equals(this.caseSensitivityOfFields)) {
                return dbColumnName.toUpperCase();
            }
        }
        return dbColumnName;
    }

    public String toString() {
        return "DbColumnNamesToOpenSearchFieldNamesConverter{caseSensitivityOfFields='" + this.caseSensitivityOfFields + "'}";
    }
}

