/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator;

import de.virtimo.bpc.core.replicator.DbQueryBuilder;
import de.virtimo.bpc.util.DateUtil;
import de.virtimo.bpc.util.MapUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.logging.Logger;

public class DbLowerLimitTimestampEvaluator {
    private static final Logger LOG = Logger.getLogger(DbLowerLimitTimestampEvaluator.class.getName());

    public static Timestamp getLowerLimitTimestamp(Connection connection, int queryTimeoutInSeconds, String tableName, String lastUpdateColumnName, Calendar lastUpdateColumnTimeZoneCalendar, Timestamp startFromTimestamp) throws SQLException {
        LOG.info("getLowerLimitTimestamp connection=..., queryTimeoutInSeconds=" + queryTimeoutInSeconds + ", tableName=" + tableName + ", lastUpdateColumnName=" + lastUpdateColumnName + ", lastUpdateColumnTimeZoneCalendar=" + lastUpdateColumnTimeZoneCalendar + ", startFromTimestamp=" + startFromTimestamp);
        Timestamp ts = null;
        long currentTimestamp = System.currentTimeMillis();
        String sqlQuery = new DbQueryBuilder(connection).withQuery("SELECT min($LASTUPDATE_COLUMN) AS MINDATE FROM $TABLE WHERE $LASTUPDATE_COLUMN >= ?").withPlaceHolders(MapUtil.mapOf("$TABLE", tableName, "$LASTUPDATE_COLUMN", lastUpdateColumnName)).build();
        try (PreparedStatement lowerLimitStatement = connection.prepareStatement(sqlQuery);){
            if (lastUpdateColumnTimeZoneCalendar != null) {
                lowerLimitStatement.setTimestamp(1, startFromTimestamp, lastUpdateColumnTimeZoneCalendar);
            } else {
                lowerLimitStatement.setTimestamp(1, startFromTimestamp);
            }
            if (queryTimeoutInSeconds >= 0) {
                lowerLimitStatement.setQueryTimeout(queryTimeoutInSeconds);
            }
            try (ResultSet lowerLimitResultSet = lowerLimitStatement.executeQuery();){
                if (lowerLimitResultSet.next()) {
                    ts = lastUpdateColumnTimeZoneCalendar != null ? lowerLimitResultSet.getTimestamp(1, lastUpdateColumnTimeZoneCalendar) : lowerLimitResultSet.getTimestamp(1);
                    if (ts != null) {
                        ts = DateUtil.addDurationToTimestamp(13, -1, ts);
                        LOG.info("lower limit resolved: " + ts);
                    } else {
                        ts = DateUtil.addDurationToTimestamp(13, -1, new Timestamp(currentTimestamp));
                        LOG.info("special case handling when the table is empty ... using the current timestamp as lower limit: " + ts);
                    }
                }
            }
        }
        return ts;
    }
}

