/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator;

import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.exception.LogServiceSettingsException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.opensearch.ManagedIndexConfig;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.replicator.ReindexActionException;
import de.virtimo.bpc.core.replicator.ReplicationJob;
import de.virtimo.bpc.core.replicator.shadowcopy.ShadowCopyTask;
import de.virtimo.bpc.logservice.LogServiceModuleInstance;
import de.virtimo.bpc.logservice.opensearch.OpenSearchLogService;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.opensearch.common.settings.Settings;
import org.osgi.framework.BundleContext;

public class ReindexAction {
    private static final Logger LOG = Logger.getLogger(ReindexAction.class.getName());
    private final BundleContext bundleContext;
    private final OpenSearchService oss;
    private final String aliasName;
    private final String sourceIndexName;
    private final String targetIndexName;
    private final boolean copyIndexMapping;
    private final boolean copyMetaData;
    private final boolean deleteSourceIndexAfterwards;
    private final Map defaultIndexCreationSettings;
    private final List defaultDynamicTemplates;
    private final Map<String, Object> sourceIndexSettings;
    private final Map<String, Object> sourceIndexMappings;
    private final ManagedIndexConfig managedIndexConfig;
    private List<ReplicationJob> relatedReplicationJobs;
    private List<LogServiceModuleInstance> relatedLogServices;

    public ReindexAction(BundleContext bundleContext, OpenSearchService oss, String indexName, boolean copyIndexMapping, boolean copyMetaData, boolean deleteSourceIndexAfterwards, Map defaultIndexCreationSettings, List defaultDynamicTemplates) throws ReindexActionException {
        LOG.info("ReindexAction bundleContext=" + bundleContext + ", oss=..., indexName=" + indexName + ", copyIndexMapping=" + copyIndexMapping + ", copyMetaData=" + copyMetaData + ", deleteSourceIndexAfterwards=" + deleteSourceIndexAfterwards + ", defaultIndexCreationSettings=..., defaultDynamicTemplate=...");
        this.bundleContext = bundleContext;
        this.oss = oss;
        this.sourceIndexName = indexName;
        this.copyIndexMapping = copyIndexMapping;
        this.copyMetaData = copyMetaData;
        this.deleteSourceIndexAfterwards = deleteSourceIndexAfterwards;
        this.defaultIndexCreationSettings = defaultIndexCreationSettings;
        this.defaultDynamicTemplates = defaultDynamicTemplates;
        try {
            if (!oss.existsIndex(this.sourceIndexName)) {
                throw new ReindexActionException((ErrorCode)CoreErrorCode.REINDEX_ACTION_INDEX_NOT_FOUND, "The index '${index}' to reindex does not exist.", MapUtil.mapOf("index", this.sourceIndexName));
            }
            String computedAliasName = oss.aliasFromBpcIndexName(indexName);
            if (computedAliasName == null) {
                throw new ReindexActionException((ErrorCode)CoreErrorCode.REINDEX_ACTION_GENERAL_ERROR, "Only indices created by the BPC can be reindexed. The index '${index}' does not follow our index naming convention.", MapUtil.mapOf("index", indexName));
            }
            Set<String> aliases = oss.getAliasesForIndexName(indexName);
            if (aliases.isEmpty()) {
                throw new ReindexActionException((ErrorCode)CoreErrorCode.REINDEX_ACTION_ALIAS_MISUSAGE, "Only indices with an alias can be reindexed. The index '${index}' does not.", MapUtil.mapOf("index", indexName));
            }
            if (aliases.size() != 1) {
                throw new ReindexActionException((ErrorCode)CoreErrorCode.REINDEX_ACTION_ALIAS_MISUSAGE, "Wrong alias usage in index '${index}'. An index must have only one alias.", MapUtil.mapOf("index", indexName));
            }
            this.aliasName = aliases.iterator().next();
            if (!this.aliasName.equals(computedAliasName)) {
                throw new ReindexActionException((ErrorCode)CoreErrorCode.REINDEX_ACTION_GENERAL_ERROR, "The alias '${aliasFromIndex}' found in the index '${index}' does not match the alias '${aliasFromIndexName}' evaluated from the index name.", MapUtil.mapOf("index", indexName, "aliasFromIndex", this.aliasName, "aliasFromIndexName", computedAliasName));
            }
            this.targetIndexName = oss.newIndexNameForAlias(this.aliasName);
        }
        catch (OpenSearchRelatedException ex) {
            throw new ReindexActionException((ErrorCode)CoreErrorCode.REINDEX_ACTION_GENERAL_ERROR, "The Reindex action initialization of index '${sourceIndex}' failed due to an OpenSearch exception: ${error}", MapUtil.mapOf("sourceIndex", this.sourceIndexName, "error", ex.getMessage()), (Throwable)ex);
        }
        this.sourceIndexSettings = oss.getSettings(this.sourceIndexName);
        this.sourceIndexMappings = oss.getMapping(this.sourceIndexName);
        this.managedIndexConfig = oss.getManagedIndicesHandler().getManagedIndexConfig(this.aliasName);
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public String getSourceIndexName() {
        return this.sourceIndexName;
    }

    public String getTargetIndexName() {
        return this.targetIndexName;
    }

    public boolean isDeleteSourceIndexAfterwards() {
        return this.deleteSourceIndexAfterwards;
    }

    public void setRelatedReplicationJobs(List<ReplicationJob> relatedReplicationJobs) {
        this.relatedReplicationJobs = relatedReplicationJobs;
    }

    private boolean existRelatedReplicationJobs() {
        return this.relatedReplicationJobs != null && !this.relatedReplicationJobs.isEmpty();
    }

    private Map<String, Object> getIndexCreationSettingsFromRelatedReplicationJobs() throws ReindexActionException {
        LOG.info("getIndexCreationSettingsFromReplicationJobs");
        Map previousIndexCreationSettings = null;
        if (this.existRelatedReplicationJobs()) {
            int replicationJobsWithoutIndexCreationSettings = 0;
            boolean indexCreationSettingsAreDifferent = false;
            for (ReplicationJob relatedReplicationJob : this.relatedReplicationJobs) {
                if (relatedReplicationJob.getTarget().hasIndexCreationSettings()) {
                    Map currentIndexCreationSettings = relatedReplicationJob.getTarget().getIndexCreationSettings();
                    if (replicationJobsWithoutIndexCreationSettings > 0 || previousIndexCreationSettings != null && !currentIndexCreationSettings.equals(previousIndexCreationSettings)) {
                        indexCreationSettingsAreDifferent = true;
                        break;
                    }
                    previousIndexCreationSettings = currentIndexCreationSettings;
                    continue;
                }
                ++replicationJobsWithoutIndexCreationSettings;
                if (previousIndexCreationSettings == null) continue;
                indexCreationSettingsAreDifferent = true;
                break;
            }
            if (indexCreationSettingsAreDifferent) {
                throw new ReindexActionException((ErrorCode)CoreErrorCode.REINDEX_ACTION_INDEX_CREATION_FAILED, "The index is used by multiple replication jobs and they have different index creation settings.");
            }
        }
        return previousIndexCreationSettings;
    }

    private Map<String, ?> getIndexMappingFromRelatedReplicationJobs() throws ReindexActionException {
        LOG.info("getIndexMappingFromRelatedReplicationJobs");
        Map previousIndexMappings = null;
        if (this.existRelatedReplicationJobs()) {
            int replicationJobsWithoutIndexMappings = 0;
            boolean indexMappingsAreDifferent = false;
            for (ReplicationJob relatedReplicationJob : this.relatedReplicationJobs) {
                if (relatedReplicationJob.getTarget().hasIndexMappings()) {
                    Map currentIndexMappings = relatedReplicationJob.getTarget().getIndexMappings();
                    if (replicationJobsWithoutIndexMappings > 0 || previousIndexMappings != null && !currentIndexMappings.equals(previousIndexMappings)) {
                        indexMappingsAreDifferent = true;
                        break;
                    }
                    previousIndexMappings = currentIndexMappings;
                    continue;
                }
                ++replicationJobsWithoutIndexMappings;
                if (previousIndexMappings == null) continue;
                indexMappingsAreDifferent = true;
                break;
            }
            if (indexMappingsAreDifferent) {
                throw new ReindexActionException((ErrorCode)CoreErrorCode.REINDEX_ACTION_INDEX_CREATION_FAILED, "The index is used by multiple replication jobs and they have different index mappings.");
            }
        }
        return previousIndexMappings;
    }

    private List getDynamicTemplatesFromRelatedReplicationJobs() throws ReindexActionException {
        LOG.info("getDynamicTemplatesFromRelatedReplicationJobs");
        List previousDynamicTemplates = null;
        if (this.existRelatedReplicationJobs()) {
            int replicationJobsWithoutDynamicTemplates = 0;
            boolean dynamicTemplatesAreDifferent = false;
            for (ReplicationJob relatedReplicationJob : this.relatedReplicationJobs) {
                if (relatedReplicationJob.getTarget().hasDynamicTemplates()) {
                    List currentDynamicTemplates = relatedReplicationJob.getTarget().getDynamicTemplates();
                    if (replicationJobsWithoutDynamicTemplates > 0 || previousDynamicTemplates != null && !currentDynamicTemplates.equals(previousDynamicTemplates)) {
                        dynamicTemplatesAreDifferent = true;
                        break;
                    }
                    previousDynamicTemplates = currentDynamicTemplates;
                    continue;
                }
                ++replicationJobsWithoutDynamicTemplates;
                if (previousDynamicTemplates == null) continue;
                dynamicTemplatesAreDifferent = true;
                break;
            }
            if (dynamicTemplatesAreDifferent) {
                throw new ReindexActionException((ErrorCode)CoreErrorCode.REINDEX_ACTION_INDEX_CREATION_FAILED, "The index is used by multiple replication jobs and they have different dynamic templates.");
            }
        }
        return previousDynamicTemplates;
    }

    public void setRelatedLogServices(List<LogServiceModuleInstance> relatedLogServices) {
        this.relatedLogServices = relatedLogServices;
    }

    private boolean existRelatedLogServices() {
        return this.relatedLogServices != null && !this.relatedLogServices.isEmpty();
    }

    private Map<String, ?> getIndexMappingFromRelatedLogServices(String forIndexAlias) throws ReindexActionException {
        LOG.info("getIndexMappingFromRelatedLogServices forIndexAlias=" + forIndexAlias);
        Map<String, Object> previousMappingProperties = null;
        if (this.relatedLogServices != null && !this.relatedLogServices.isEmpty()) {
            boolean mappingPropertiesAreDifferent = false;
            for (LogServiceModuleInstance logServiceModuleInstance : this.relatedLogServices) {
                if (!logServiceModuleInstance.isOpenSearchLoggingEnabled()) continue;
                try {
                    Map<String, Object> currentMappingProperties;
                    LogServiceModuleInstance.OpenSearchConfig openSearchConfig = logServiceModuleInstance.getOpenSearchConfig();
                    LogServiceModuleInstance.FieldsConfig fieldsConfig = logServiceModuleInstance.getFieldsConfig();
                    if (openSearchConfig == null || fieldsConfig == null) continue;
                    if (openSearchConfig.parent != null && !StringUtil.isNullOrEmpty(openSearchConfig.parent.index) && forIndexAlias.equals(openSearchConfig.parent.index)) {
                        currentMappingProperties = OpenSearchLogService.fieldsAsOpenSearchMappingProperties(fieldsConfig.parent);
                        if (previousMappingProperties != null && !currentMappingProperties.equals(previousMappingProperties)) {
                            mappingPropertiesAreDifferent = true;
                            break;
                        }
                        previousMappingProperties = currentMappingProperties;
                    }
                    if (openSearchConfig.child == null || StringUtil.isNullOrEmpty(openSearchConfig.child.index) || !forIndexAlias.equals(openSearchConfig.child.index)) continue;
                    currentMappingProperties = OpenSearchLogService.fieldsAsOpenSearchMappingProperties(fieldsConfig.child);
                    if (previousMappingProperties != null && !currentMappingProperties.equals(previousMappingProperties)) {
                        mappingPropertiesAreDifferent = true;
                        break;
                    }
                    previousMappingProperties = currentMappingProperties;
                }
                catch (LogServiceSettingsException ex) {
                    throw new ReindexActionException((ErrorCode)CoreErrorCode.REINDEX_ACTION_INDEX_CREATION_FAILED, "The index is used by a log service with invalid OpenSearch settings.");
                }
            }
            if (mappingPropertiesAreDifferent) {
                throw new ReindexActionException((ErrorCode)CoreErrorCode.REINDEX_ACTION_INDEX_CREATION_FAILED, "The index is used by multiple log services and they have different fields settings.");
            }
        }
        HashMap<String, Map<String, Object>> mapping = new HashMap<String, Map<String, Object>>();
        mapping.put("properties", previousMappingProperties);
        return mapping;
    }

    public Map<String, Object> getSourceIndexSettings() {
        return this.sourceIndexSettings;
    }

    public Map<String, Object> getSourceIndexMappings() {
        return this.sourceIndexMappings;
    }

    public Map<String, Object> getTargetIndexSettings() throws ReindexActionException {
        Map<String, Object> targetIndexSettings = null;
        if (targetIndexSettings == null && this.managedIndexConfig != null && this.managedIndexConfig.hasSettings()) {
            targetIndexSettings = this.managedIndexConfig.getSettings();
        }
        if (targetIndexSettings == null && this.existRelatedReplicationJobs()) {
            targetIndexSettings = this.getIndexCreationSettingsFromRelatedReplicationJobs();
        }
        if (targetIndexSettings == null) {
            targetIndexSettings = this.defaultIndexCreationSettings;
        }
        return new HashMap<String, Object>(targetIndexSettings);
    }

    public Map<String, Object> getTargetIndexMappings() throws ReindexActionException {
        Map<String, Object> targetIndexMappings = null;
        if (this.copyIndexMapping && this.sourceIndexMappings != null) {
            if (this.existRelatedReplicationJobs()) {
                targetIndexMappings = new HashMap<String, Object>(this.sourceIndexMappings);
                if (targetIndexMappings.containsKey("properties")) {
                    Map currentProperties = (Map)targetIndexMappings.get("properties");
                    HashMap<String, Map> cleanedUpProperties = new HashMap<String, Map>();
                    for (String fieldName : currentProperties.keySet()) {
                        Map fieldValue = (Map)currentProperties.get(fieldName);
                        String type = (String)fieldValue.get("type");
                        if ("text".equalsIgnoreCase(type)) continue;
                        cleanedUpProperties.put(fieldName, fieldValue);
                    }
                    if (cleanedUpProperties.isEmpty()) {
                        targetIndexMappings.remove("properties");
                    } else {
                        targetIndexMappings.put("properties", cleanedUpProperties);
                    }
                }
            } else {
                targetIndexMappings = this.existRelatedLogServices() ? new HashMap<String, Object>(this.sourceIndexMappings) : new HashMap<String, Object>(this.sourceIndexMappings);
            }
        }
        if (this.managedIndexConfig != null && this.managedIndexConfig.hasMappings()) {
            targetIndexMappings = this.mergeIndexMappings(targetIndexMappings, this.managedIndexConfig.getMappings());
        } else {
            List dynamicTemplates;
            Map<String, ?> logServicesMappings;
            Map<String, ?> replicationJobsMappings;
            if (this.existRelatedReplicationJobs() && (replicationJobsMappings = this.getIndexMappingFromRelatedReplicationJobs()) != null && !replicationJobsMappings.isEmpty()) {
                targetIndexMappings = this.mergeIndexMappings(targetIndexMappings, replicationJobsMappings);
            }
            if (this.existRelatedLogServices() && (logServicesMappings = this.getIndexMappingFromRelatedLogServices(this.aliasName)) != null && !logServicesMappings.isEmpty()) {
                targetIndexMappings = this.mergeIndexMappings(targetIndexMappings, logServicesMappings);
            }
            if ((dynamicTemplates = null) == null && this.existRelatedReplicationJobs()) {
                dynamicTemplates = this.getDynamicTemplatesFromRelatedReplicationJobs();
            }
            if (dynamicTemplates == null) {
                dynamicTemplates = this.defaultDynamicTemplates;
            }
            if (dynamicTemplates != null && !dynamicTemplates.isEmpty()) {
                if (targetIndexMappings == null) {
                    targetIndexMappings = new HashMap();
                }
                targetIndexMappings.put("dynamic_templates", dynamicTemplates);
            } else if (targetIndexMappings != null) {
                targetIndexMappings.remove("dynamic_templates");
            }
        }
        return targetIndexMappings;
    }

    public Map<String, Object> getIndexSettingsOfTemporarilyCreateTargetIndex() throws ReindexActionException {
        LOG.info("getIndexSettingsOfTemporarilyCreateTargetIndex");
        String tmpTargetIndexName = this.oss.newIndexNameForAlias(this.aliasName);
        try {
            Map<String, Object> tmpTargetIndexSettings = this.getTargetIndexSettings();
            Map<String, Object> tmpTargetIndexMappings = this.getTargetIndexMappings();
            this.oss.createIndex(null, tmpTargetIndexName, tmpTargetIndexSettings, tmpTargetIndexMappings);
            Map<String, Object> map = this.oss.getSettings(tmpTargetIndexName);
            return map;
        }
        catch (Exception ex) {
            throw new ReindexActionException((ErrorCode)CoreErrorCode.REINDEX_ACTION_INDEX_CREATION_FAILED, "The target index '${index}' could not be created temporarily.", MapUtil.mapOf("index", tmpTargetIndexName), (Throwable)ex);
        }
        finally {
            try {
                this.oss.deleteIndex(tmpTargetIndexName);
            }
            catch (Exception exception) {}
        }
    }

    public void perform() throws ReindexActionException {
        LOG.info("perform");
        long startTime = System.currentTimeMillis();
        try {
            Map<String, Object> sourceIndexMetaData;
            LOG.info("Reindex started:");
            LOG.info("Alias ......................: " + this.aliasName);
            LOG.info("Source index ...............: " + this.sourceIndexName);
            LOG.info("Target index ...............: " + this.targetIndexName);
            LOG.info("copyIndexMapping ...........: " + this.copyIndexMapping);
            LOG.info("copyMetaData ...............: " + this.copyMetaData);
            LOG.info("deleteSourceIndexAfterwards : " + this.deleteSourceIndexAfterwards);
            if (this.oss.existsIndex(this.targetIndexName)) {
                throw new ReindexActionException((ErrorCode)CoreErrorCode.REINDEX_ACTION_INDEX_EXISTS_ALREADY, "The target index '${index}' exists already.", MapUtil.mapOf("index", this.targetIndexName));
            }
            Map<String, Object> targetIndexSettings = this.getTargetIndexSettings();
            Map<String, Object> targetIndexMappings = this.getTargetIndexMappings();
            LOG.info("to compare...\n\n--- Index Settings ---\nOLD (" + this.sourceIndexName + "): " + this.sourceIndexSettings + "\n\nNEW (" + this.targetIndexName + "): " + targetIndexSettings + "\n\n--- Index Mappings---\nOLD (" + this.sourceIndexName + "): " + this.sourceIndexMappings + "\n\nNEW (" + this.targetIndexName + "): " + targetIndexMappings + "\n");
            try {
                this.oss.createIndex(null, this.targetIndexName, targetIndexSettings, targetIndexMappings);
            }
            catch (Exception ex) {
                throw new ReindexActionException((ErrorCode)CoreErrorCode.REINDEX_ACTION_INDEX_CREATION_FAILED, "The target index '${index}' could not be created.", MapUtil.mapOf("index", this.targetIndexName), (Throwable)ex);
            }
            Map<String, Object> settingsOfJustCreatedIndex = this.oss.getSettings(this.targetIndexName);
            int backupOfNumberOfReplicas = MapUtil.getValueAsInt(settingsOfJustCreatedIndex, "number_of_replicas", -1);
            Object backupOfRefreshInterval = MapUtil.getValueAsObject(settingsOfJustCreatedIndex, "refresh_interval", null);
            try {
                Settings.Builder optimizedIndexSettings = Settings.builder();
                optimizedIndexSettings.put("index.number_of_replicas", 0);
                optimizedIndexSettings.put("index.refresh_interval", -1);
                this.oss.updateIndexSettings(this.targetIndexName, optimizedIndexSettings);
            }
            catch (Exception ex) {
                this.oss.deleteIndex(this.targetIndexName);
                throw new ReindexActionException((ErrorCode)CoreErrorCode.REINDEX_ACTION_UPDATE_INDEX_SETTINGS_FAILED, "Updating the settings of the target index '${targetIndex}' failed.", MapUtil.mapOf("targetIndex", this.targetIndexName), (Throwable)ex);
            }
            if (this.copyMetaData && (sourceIndexMetaData = this.oss.getMetaDataValues(this.sourceIndexName)) != null) {
                try {
                    this.oss.setMetaDataValues(this.targetIndexName, sourceIndexMetaData);
                }
                catch (Exception ex) {
                    this.oss.deleteIndex(this.targetIndexName);
                    throw new ReindexActionException((ErrorCode)CoreErrorCode.REINDEX_ACTION_INDEX_CREATION_FAILED, "Could not set the meta data values of the source index '${sourceIndex}' to the target index '${targetIndex}'.", MapUtil.mapOf("sourceIndex", this.sourceIndexName, "targetIndex", this.targetIndexName), (Throwable)ex);
                }
            }
            this.oss.flushIndices(this.sourceIndexName);
            try {
                this.oss.reindex(this.sourceIndexName, this.targetIndexName, null);
            }
            catch (OpenSearchRelatedException ex) {
                this.oss.deleteIndex(this.targetIndexName);
                throw new ReindexActionException((ErrorCode)CoreErrorCode.REINDEX_ACTION_REINDEX_FAILED, "Reindexing the source index '${sourceIndex}' to the target index '${targetIndex}' failed.", MapUtil.mapOf("sourceIndex", this.sourceIndexName, "targetIndex", this.targetIndexName), (Throwable)ex);
            }
            try {
                Settings.Builder indexSettingsToRestore = Settings.builder();
                if (backupOfNumberOfReplicas == -1) {
                    indexSettingsToRestore.put("index.number_of_replicas", (String)null);
                } else {
                    indexSettingsToRestore.put("index.number_of_replicas", backupOfNumberOfReplicas);
                }
                if (backupOfRefreshInterval == null) {
                    indexSettingsToRestore.put("index.refresh_interval", (String)null);
                } else {
                    indexSettingsToRestore.put("index.refresh_interval", String.valueOf(backupOfRefreshInterval));
                }
                this.oss.updateIndexSettings(this.targetIndexName, indexSettingsToRestore);
            }
            catch (Exception ex) {
                this.oss.deleteIndex(this.targetIndexName);
                throw new ReindexActionException((ErrorCode)CoreErrorCode.REINDEX_ACTION_UPDATE_INDEX_SETTINGS_FAILED, "Updating the settings of the target index '${targetIndex}' failed.", MapUtil.mapOf("targetIndex", this.targetIndexName), (Throwable)ex);
            }
            try {
                this.oss.moveAlias(this.sourceIndexName, this.targetIndexName);
            }
            catch (Exception ex) {
                this.oss.deleteIndex(this.targetIndexName);
                throw new ReindexActionException((ErrorCode)CoreErrorCode.REINDEX_ACTION_ALIAS_SWITCHING_FAILED, "Moving the alias '${alias}' from the source index '${sourceIndex}' to the target index '${targetIndex}' failed.", MapUtil.mapOf("alias", this.aliasName, "sourceIndex", this.sourceIndexName, "targetIndex", this.targetIndexName), (Throwable)ex);
            }
            if (this.existRelatedReplicationJobs() || this.existRelatedLogServices()) {
                this.oss.prepareAttachmentsPipeline(this.aliasName);
            }
            if (this.deleteSourceIndexAfterwards) {
                this.oss.deleteIndex(this.sourceIndexName);
            } else {
                this.oss.closeIndex(this.sourceIndexName);
                List<String> allIndices = this.oss.getAllBpcIndexNamesWithAlias(this.aliasName);
                allIndices.remove(this.targetIndexName);
                List<String> indicesToDelete = ShadowCopyTask.getOpenSearchIndiceNamesToDelete(allIndices, 1);
                for (String indexToDelete : indicesToDelete) {
                    this.oss.deleteIndex(indexToDelete);
                }
            }
        }
        catch (OpenSearchRelatedException ex) {
            throw new ReindexActionException((ErrorCode)CoreErrorCode.REINDEX_ACTION_GENERAL_ERROR, "Reindex of index '${sourceIndex}' failed due to an OpenSearch exception: ${error}", MapUtil.mapOf("sourceIndex", this.sourceIndexName, "error", ex.getMessage()), (Throwable)ex);
        }
        finally {
            LOG.info("Reindex finished in " + (System.currentTimeMillis() - startTime) / 1000L + " seconds");
        }
    }

    private Map<String, Object> mergeIndexMappings(Map oldMappings, Map newPartialMappings) {
        if (oldMappings == null) {
            return newPartialMappings == null ? null : new HashMap(newPartialMappings);
        }
        if (newPartialMappings == null) {
            return oldMappings == null ? null : new HashMap(oldMappings);
        }
        HashMap<String, Object> result = new HashMap<String, Object>(oldMappings);
        if (newPartialMappings.containsKey("properties")) {
            Map newProperties = (Map)newPartialMappings.get("properties");
            if (!result.containsKey("properties")) {
                result.put("properties", new HashMap(newProperties));
            } else {
                Map oldProperties = (Map)result.get("properties");
                oldProperties.putAll(newProperties);
            }
        }
        return result;
    }
}

