/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.Percolator;
import de.virtimo.bpc.api.PercolatorsManager;
import de.virtimo.bpc.api.PercolatorsProcessor;
import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.api.db.exception.DataSourceNotFoundException;
import de.virtimo.bpc.api.exception.MaintenanceModeEnabledException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.replicator.ReplicationDisabledException;
import de.virtimo.bpc.core.replicator.ReplicationJob;
import de.virtimo.bpc.core.replicator.ReplicationJobCallback;
import de.virtimo.bpc.core.replicator.ReplicationJobException;
import de.virtimo.bpc.core.replicator.ReplicationJobNotFoundException;
import de.virtimo.bpc.core.replicator.ReplicationManager;
import de.virtimo.bpc.core.replicator.ReplicationModule;
import de.virtimo.bpc.core.replicator.consistency.ConsistencyCheck;
import de.virtimo.bpc.core.replicator.consistency.ConsistencyCheckResult;
import de.virtimo.bpc.core.replicator.consistency.ConsistencyCheckTask;
import de.virtimo.bpc.core.replicator.logger.ReplicationJobLogData;
import de.virtimo.bpc.core.replicator.logger.ReplicationJobsLogService;
import de.virtimo.bpc.core.replicator.shadowcopy.ShadowCopy;
import de.virtimo.bpc.core.replicator.shadowcopy.ShadowCopyTask;
import de.virtimo.bpc.core.replicator.tailsync.TailSyncTask;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;

public class ReplicationManagerImpl
implements ReplicationManager,
ReplicationJobCallback,
BpcService {
    private static final Logger LOG = Logger.getLogger(ReplicationManagerImpl.class.getName());
    private final BundleContext bundleContext;
    private final Map<String, ReplicationJob> jobs;
    private final Map<String, ScheduledFuture<?>> replicationJobHandles;
    private ScheduledThreadPoolExecutor executorService;
    private Scheduler shadowCopyAndTailSyncTasksScheduler;
    private final ExecutorService percolatorsExecutorService;
    private final ExecutorService consistencyCheckExecutorService;
    private final BpcServicesTracker<PercolatorsManager> percolatorsManagerTracker;
    private final BpcServicesTracker<DatabaseManager> databaseManagerTracker;
    private final BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private final BpcServicesTracker<ReplicationJobsLogService> replicationJobsLogServiceTracker;
    private final BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private static final Object REPLICATION_JOBS_LOCK = new Object();

    public ReplicationManagerImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.percolatorsManagerTracker = new BpcServicesTracker<PercolatorsManager>(bundleContext, PercolatorsManager.class);
        this.databaseManagerTracker = new BpcServicesTracker<DatabaseManager>(bundleContext, DatabaseManager.class);
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(bundleContext, ModuleManager.class);
        this.replicationJobsLogServiceTracker = new BpcServicesTracker<ReplicationJobsLogService>(bundleContext, ReplicationJobsLogService.class);
        this.percolatorsExecutorService = Executors.newFixedThreadPool(3, new ThreadFactoryWithNamePrefix("bpc-core-replication-done-percolators"));
        this.consistencyCheckExecutorService = Executors.newFixedThreadPool(1, new ThreadFactoryWithNamePrefix("bpc-core-replication-done-consistencycheck"));
        this.jobs = new HashMap<String, ReplicationJob>();
        this.replicationJobHandles = new HashMap();
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOG.info("shutdownService");
        this.stop();
        BpcServicesTracker.stopAll(this);
        if (this.percolatorsExecutorService != null) {
            this.percolatorsExecutorService.shutdownNow();
        }
        if (this.consistencyCheckExecutorService != null) {
            this.consistencyCheckExecutorService.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        LOG.info("stop");
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            HashSet<String> replicationJobIDs = new HashSet<String>(this.jobs.keySet());
            for (String replicationJobID : replicationJobIDs) {
                this._stopReplicationJob(replicationJobID);
            }
            if (!this.jobs.isEmpty() || !this.replicationJobHandles.isEmpty()) {
                LOG.severe("BPC developers, there is a bug/problem in the replication ReplicationManagerImpl.stop() method.");
                LOG.severe("- jobs.......................: " + this.jobs.size());
                LOG.severe("- replicationJobHandles......: " + this.replicationJobHandles.size());
            }
            this.jobs.clear();
            this.replicationJobHandles.clear();
            if (this.executorService != null) {
                this.executorService.shutdownNow();
                this.executorService = null;
            }
            try {
                if (this.shadowCopyAndTailSyncTasksScheduler != null && !this.shadowCopyAndTailSyncTasksScheduler.isShutdown()) {
                    this.shadowCopyAndTailSyncTasksScheduler.shutdown(false);
                    this.shadowCopyAndTailSyncTasksScheduler = null;
                }
            }
            catch (SchedulerException ex) {
                LOG.log(Level.SEVERE, "Failed to stop the shadow copy and tail sync tasks scheduler.", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopReplicationJob(String replicationJobId) {
        LOG.info("stopReplicationJob replicationJobId=" + replicationJobId);
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            this._stopReplicationJob(replicationJobId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _stopReplicationJob(String replicationJobId) {
        LOG.info("stopReplicationJob replicationJobId=" + replicationJobId);
        if (this.replicationJobHandles.containsKey(replicationJobId)) {
            try {
                ScheduledFuture<?> replicationJobHandle = this.replicationJobHandles.get(replicationJobId);
                if (replicationJobHandle.cancel(true)) {
                    LOG.info("Running ReplicationJob '" + replicationJobId + "' canceled");
                } else {
                    LOG.warning("Could not cancel the running ReplicationJob '" + replicationJobId + "'");
                }
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Failed to cancel the scheduled ReplicationJob '" + replicationJobId + "'.", ex);
            }
            finally {
                this.replicationJobHandles.remove(replicationJobId);
            }
        }
        if (this.jobs.containsKey(replicationJobId)) {
            try {
                ReplicationJob replicationJobToStop = this.jobs.get(replicationJobId);
                replicationJobToStop.destroy();
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Failed to destroy the ReplicationJob '" + replicationJobId + "'.", ex);
            }
            finally {
                this.jobs.remove(replicationJobId);
            }
        }
        try {
            JobKey tailSyncJobKey = JobKey.jobKey((String)replicationJobId, (String)"tail_sync");
            if (this.shadowCopyAndTailSyncTasksScheduler.checkExists(tailSyncJobKey)) {
                this.shadowCopyAndTailSyncTasksScheduler.interrupt(tailSyncJobKey);
                this.shadowCopyAndTailSyncTasksScheduler.deleteJob(tailSyncJobKey);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to un-schedule the tail sync task of the ReplicationJob '" + replicationJobId + "'.", ex);
        }
        try {
            JobKey shadowCopyJobKey = JobKey.jobKey((String)replicationJobId, (String)"shadow_copy");
            if (this.shadowCopyAndTailSyncTasksScheduler.checkExists(shadowCopyJobKey)) {
                this.shadowCopyAndTailSyncTasksScheduler.interrupt(shadowCopyJobKey);
                this.shadowCopyAndTailSyncTasksScheduler.deleteJob(shadowCopyJobKey);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to un-schedule the shadow copy task of the ReplicationJob '" + replicationJobId + "'.", ex);
        }
    }

    @Override
    public ScheduledExecutorService getReplicationScheduler() {
        return this.executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startReplication() throws ServiceNotFoundException, ModuleNotFoundException {
        LOG.info("startReplication");
        CoreModule coreModule = this.moduleManagerTracker.getService().getModuleByClass(CoreModule.class);
        ReplicationModule replicationModule = this.moduleManagerTracker.getService().getModuleByClass(ReplicationModule.class);
        if (!coreModule.isMasterServer()) {
            LOG.warning("Replication could not be started, because this server is not the 'master'. BPC developers, there is anywhere a state bug!");
            return;
        }
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            this.executorService = new ScheduledThreadPoolExecutor((int)replicationModule.getReplicatorThreadCount(), new ThreadFactoryWithNamePrefix("bpc-core-replication"));
            this.executorService.setRemoveOnCancelPolicy(true);
            this.executorService.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            try {
                this.shadowCopyAndTailSyncTasksScheduler = StdSchedulerFactory.getDefaultScheduler();
                this.shadowCopyAndTailSyncTasksScheduler.start();
            }
            catch (SchedulerException ex) {
                LOG.log(Level.SEVERE, "Failed to initialize the shadow copy and tail sync tasks scheduler.", ex);
            }
            List<ReplicationJob> replicationJobs = replicationModule.getReplicationJobs();
            for (ReplicationJob replicationJob : replicationJobs) {
                this._startReplicationJob(replicationJob);
            }
        }
    }

    @Override
    public void setReplicatorThreadCount(Integer threadCount) {
        LOG.info("setReplicatorThreadCount replicatorThreadCount=" + threadCount);
        if (threadCount != null && this.executorService != null) {
            this.executorService.setCorePoolSize(threadCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startReplicationJob(String replicationJobId) {
        LOG.info("startReplicationJob replicationJobId=" + replicationJobId);
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            ReplicationJob replicationJobToStart = this.jobs.get(replicationJobId);
            this._startReplicationJob(replicationJobToStart);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startReplicationJob(ReplicationJob job) {
        LOG.info("startReplicationJob job=" + job);
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            this._startReplicationJob(job);
        }
    }

    private void _startReplicationJob(ReplicationJob job) {
        LOG.finest("_startReplicationJob job=" + job);
        if (job != null) {
            JobDataMap jobDataMap;
            String replicationJobId = job.getId();
            job.setCallback(this);
            this.jobs.put(replicationJobId, job);
            ScheduledFuture<?> replicationJobHandle = this.executorService.scheduleWithFixedDelay(job, job.getSettings().getReplicationDelay(), job.getSettings().getReplicationInterval(), TimeUnit.SECONDS);
            this.replicationJobHandles.put(replicationJobId, replicationJobHandle);
            if (job.isEnabled()) {
                if (job.getShadowCopy().isEnabled()) {
                    LOG.info("Scheduling shadow copy task for replication job: " + job);
                    try {
                        jobDataMap = new JobDataMap();
                        jobDataMap.setAllowsTransientData(true);
                        jobDataMap.put("replicationJob", (Object)job);
                        JobDetail shadowCopyTaskJob = JobBuilder.newJob(ShadowCopyTask.class).withIdentity(JobKey.jobKey((String)replicationJobId, (String)"shadow_copy")).usingJobData(jobDataMap).build();
                        CronTrigger shadowCopyTaskJobTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(TriggerKey.triggerKey((String)replicationJobId, (String)"shadow_copy_trigger")).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)job.getShadowCopy().getCronPattern())).forJob(shadowCopyTaskJob).build();
                        this.shadowCopyAndTailSyncTasksScheduler.scheduleJob(shadowCopyTaskJob, (Trigger)shadowCopyTaskJobTrigger);
                    }
                    catch (SchedulerException ex) {
                        LOG.log(Level.SEVERE, "Failed to schedule the shadow copy task job.", ex);
                    }
                } else {
                    LOG.info("Skipping shadow copy task scheduling, it is disabled for replication job: " + job);
                }
            } else {
                LOG.info("Skipping shadow copy task scheduling, the related replication job is disabled: " + job);
            }
            if (job.isEnabled()) {
                if (job.getTailSync().isEnabled()) {
                    LOG.info("Scheduling tail sync task for replication job: " + job);
                    try {
                        jobDataMap = new JobDataMap();
                        jobDataMap.setAllowsTransientData(true);
                        jobDataMap.put("replicationJob", (Object)job);
                        jobDataMap.put("callback", (Object)this);
                        JobDetail tailSyncTaskJob = JobBuilder.newJob(TailSyncTask.class).withIdentity(JobKey.jobKey((String)replicationJobId, (String)"tail_sync")).usingJobData(jobDataMap).build();
                        CronTrigger tailSyncTaskJobTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(replicationJobId, "tail_sync_trigger").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)job.getTailSync().getCronPattern())).forJob(tailSyncTaskJob).build();
                        this.shadowCopyAndTailSyncTasksScheduler.scheduleJob(tailSyncTaskJob, (Trigger)tailSyncTaskJobTrigger);
                    }
                    catch (SchedulerException ex) {
                        LOG.log(Level.SEVERE, "Failed to schedule the tail sync task job.", ex);
                    }
                } else {
                    LOG.info("Skipping tail sync scheduling, it is disabled for replication job: " + job);
                }
            } else {
                LOG.info("Skipping tail sync task scheduling, the related replication job is disabled: " + job);
            }
        }
    }

    @Override
    public void onFinished(String replicationType, final ReplicationJob replicationJob, final PercolatorsProcessor percolatorsProcessor) {
        ConsistencyCheck consistencyCheck;
        LOG.info("onFinished replicationType=" + replicationType + ", replicationJob=" + replicationJob + ", percolatorsProcessor=" + percolatorsProcessor);
        if (percolatorsProcessor.existSomePercolators() && percolatorsProcessor.hasData()) {
            Runnable percolatorsRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        PercolatorsManager percolatorsManager = ReplicationManagerImpl.this.percolatorsManagerTracker.getService(15L);
                        OpenSearchService oss = ReplicationManagerImpl.this.openSearchServiceTracker.getService(15L);
                        percolatorsManager.informClientsAboutReplicatedData(oss, replicationJob.getTarget().getIndex(), percolatorsProcessor);
                    }
                    catch (ServiceNotFoundException ex) {
                        LOG.log(Level.WARNING, "Failed to process the collected percolators data due to missing service.", ex);
                    }
                    catch (OpenSearchRelatedException ex) {
                        LOG.log(Level.WARNING, "Failed to process the collected percolators data due to a OpenSearch failure.", ex);
                    }
                    catch (Exception ex) {
                        LOG.log(Level.WARNING, "Failed to process the collected percolators data due to an unexpected error.", ex);
                    }
                }
            };
            this.percolatorsExecutorService.submit(percolatorsRunnable);
        }
        if ("replication".equals(replicationType) && (consistencyCheck = replicationJob.getConsistencyCheck()).isEnabled() && !consistencyCheck.isRunning() && replicationJob.getStats().getJobCount() % consistencyCheck.getConsistencyCheckFrequency() == 0) {
            Runnable consistencyCheckRunnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        DatabaseManager databaseManager = ReplicationManagerImpl.this.databaseManagerTracker.getService(15L);
                        OpenSearchService oss = ReplicationManagerImpl.this.openSearchServiceTracker.getService(15L);
                        try {
                            oss.flushIndices(replicationJob.getTarget().getIndex());
                        }
                        catch (OpenSearchRelatedException openSearchRelatedException) {
                            // empty catch block
                        }
                        try {
                            consistencyCheck.started();
                            DataSource dataSource = databaseManager.getDataSource(replicationJob.getSource().getDataSourceName());
                            ConsistencyCheckTask consistencyCheckTask = new ConsistencyCheckTask(replicationJob, dataSource, oss);
                            ConsistencyCheckResult consistencyCheckResult = consistencyCheckTask.process();
                            consistencyCheck.setLastRunResult(consistencyCheckResult);
                            consistencyCheck.increaseRunCount();
                            LOG.info(replicationJob.getId() + ": Replication job result is consistent: " + consistencyCheckResult.areSourceAndTargetConsistent());
                        }
                        catch (Exception ex) {
                            LOG.log(Level.SEVERE, "Failed to perform the replication job consistency check.", ex);
                            consistencyCheck.increaseErrorCount();
                        }
                        finally {
                            consistencyCheck.stopped();
                        }
                    }
                    catch (ServiceNotFoundException ex) {
                        LOG.log(Level.WARNING, "Failed to perform the replication job consistency check due to missing service.", ex);
                    }
                }
            };
            this.consistencyCheckExecutorService.submit(consistencyCheckRunnable);
        }
    }

    @Override
    public OpenSearchService getOpenSearchService() throws ServiceNotFoundException {
        LOG.fine("getOpenSearchService");
        return this.openSearchServiceTracker.getService();
    }

    @Override
    public Connection getDatabaseConnection(ReplicationJob replicationJob) throws ServiceNotFoundException, DataSourceNotFoundException, SQLException {
        LOG.fine("getDatabaseConnection replicationJob=...");
        String dataSourceName = replicationJob.getSource().getDataSourceName();
        DataSource dataSource = this.databaseManagerTracker.getService().getDataSource(dataSourceName);
        return dataSource.getConnection();
    }

    @Override
    public Set<Percolator> getAllValidPercolatorsFromIndex(OpenSearchService oss, String index) throws ServiceNotFoundException {
        LOG.fine("getAllValidPercolatorsFromIndex oss=..., index=" + index);
        return this.percolatorsManagerTracker.getService().getAllValidPercolatorsFromIndex(oss, index);
    }

    @Override
    public void persistReplicationJobLogData(ReplicationJobLogData replicationJobLogData) {
        LOG.fine("persistReplicationJobLogData replicationJobsLogData=...");
        try {
            ReplicationJobsLogService replicationJobsLogService = this.replicationJobsLogServiceTracker.getService();
            replicationJobsLogService.log(replicationJobLogData);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Failed to persist the replication job log data.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<ReplicationJob> getJobs() {
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            return new ArrayList<ReplicationJob>(this.jobs.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<ReplicationJob> getJobsUsingTargetIndexAliases(Set<String> aliases) {
        LOG.info("getJobsUsingTargetIndexAliases aliases=" + aliases);
        ArrayList<ReplicationJob> result = new ArrayList<ReplicationJob>();
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            if (aliases != null && this.jobs != null) {
                for (ReplicationJob job : this.jobs.values()) {
                    String replicationJobTargetIndex = job.getTarget().getIndex();
                    if (!aliases.contains(replicationJobTargetIndex)) continue;
                    result.add(job);
                }
            }
        }
        return result;
    }

    @Override
    @NotNull
    public ReplicationJob getReplicationJobById(String replicationJobId) throws ReplicationJobNotFoundException {
        if (this.jobs.containsKey(replicationJobId)) {
            return this.jobs.get(replicationJobId);
        }
        throw new ReplicationJobNotFoundException(replicationJobId);
    }

    @Override
    public void forcedStartOfReplicationJobsUsingIndices(Set<String> indexNames) throws ServiceNotFoundException, MaintenanceModeEnabledException, ReplicationDisabledException, ReplicationJobException, ModuleNotFoundException {
        LOG.info("forcedStartOfReplicationJobsUsingIndices indexNames=" + indexNames);
        if (indexNames == null || indexNames.isEmpty()) {
            return;
        }
        CoreModule coreModule = this.moduleManagerTracker.getService().getModuleByClass(CoreModule.class);
        if (coreModule.isMaintenanceModeEnabled()) {
            throw new MaintenanceModeEnabledException();
        }
        if (!coreModule.isMasterServer()) {
            throw new ReplicationDisabledException();
        }
        List<ReplicationJob> jobsUsingIndexNames = this.getJobsUsingTargetIndexAliases(indexNames);
        if (jobsUsingIndexNames.isEmpty()) {
            throw new ReplicationJobException((ErrorCode)CoreErrorCode.REPLICATION_JOB_NOT_FOUND, "No related replication jobs found.");
        }
        for (ReplicationJob replicationJob : jobsUsingIndexNames) {
            try {
                this.forcedStartOfReplicationJob(replicationJob);
            }
            catch (ReplicationJobException ex) {
                LOG.warning("Failed to start a replication job: " + ex.getMessage());
            }
        }
    }

    @Override
    public void forcedStartOfReplicationJob(String replicationJobId) throws ReplicationJobException, MaintenanceModeEnabledException, ServiceNotFoundException, ReplicationDisabledException, ModuleNotFoundException {
        LOG.info("forcedStartOfReplicationJob replicationJobId=" + replicationJobId);
        this.forcedStartOfReplicationJob(this.getReplicationJobById(replicationJobId));
    }

    @Override
    public void forcedStartOfReplicationJob(ReplicationJob replicationJob) throws ReplicationJobException, ServiceNotFoundException, MaintenanceModeEnabledException, ReplicationDisabledException, ModuleNotFoundException {
        LOG.info("forcedStartOfReplicationJob replicationJob=" + replicationJob);
        CoreModule coreModule = this.moduleManagerTracker.getService().getModuleByClass(CoreModule.class);
        if (coreModule.isMaintenanceModeEnabled()) {
            throw new MaintenanceModeEnabledException();
        }
        if (!coreModule.isMasterServer()) {
            throw new ReplicationDisabledException();
        }
        if (!replicationJob.isEnabled()) {
            throw new ReplicationJobException((ErrorCode)CoreErrorCode.REPLICATION_JOB_DISABLED, "Replication job is disabled.");
        }
        if (replicationJob.getStats().isRunning()) {
            throw new ReplicationJobException((ErrorCode)CoreErrorCode.REPLICATION_JOB_ALREADY_RUNNING, "Replication job is running at the moment.");
        }
        ShadowCopy shadowCopy = replicationJob.getShadowCopy();
        if (shadowCopy != null && shadowCopy.isEnabled() && shadowCopy.isRunning()) {
            throw new ReplicationJobException((ErrorCode)CoreErrorCode.REPLICATION_JOB_SHADOW_COPY_RUNNING, "Replication job cannot be started due to running shadow copy task.");
        }
        replicationJob.run();
    }
}

