/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator;

import de.virtimo.bpc.api.AbstractBackendModuleLoadedEventHandler;
import de.virtimo.bpc.api.AbstractEventHandler;
import de.virtimo.bpc.api.AbstractMaintenanceModeAcknowledgeEventHandler;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.auditlog.SystemAuditLog;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.replicator.ReplicationJob;
import de.virtimo.bpc.core.replicator.ReplicationManager;
import de.virtimo.bpc.core.replicator.ReplicationModuleInstance;
import de.virtimo.bpc.module.AbstractInstantiableModule;
import de.virtimo.bpc.module.ModuleConfigurationBuilder;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;

public class ReplicationModule
extends AbstractInstantiableModule {
    private static final Logger LOG = Logger.getLogger(ReplicationModule.class.getName());
    public static final String SETTING_REPLICATOR_THREAD_COUNT = "replicatorThreadCount";
    public static final String MODULE_ID = "replication";
    private BpcServicesTracker<ReplicationManager> replicationManagerTracker;
    private final EventRegistration eventRegistration = new EventRegistration(null);

    public ReplicationModule(ModuleManager moduleManager) {
        super(moduleManager);
    }

    @Override
    public void setModuleBundle(Bundle moduleBundle) {
        super.setModuleBundle(moduleBundle);
        BundleContext bundleContext = moduleBundle.getBundleContext();
        BpcServicesTracker.stopAll(this);
        this.replicationManagerTracker = new BpcServicesTracker<ReplicationManager>(bundleContext, ReplicationManager.class);
        this.eventRegistration.setBundleContext(bundleContext);
        this.eventRegistration.forMaintenanceModeAcknowledgeEvents(new MaintenanceModeChangedEventHandler(bundleContext));
        this.eventRegistration.forBackendModuleLoadedEvents(MODULE_ID, new ReplicationModuleLoadedEventHandler());
        this.eventRegistration.forServerModeChangedEvents(new MasterOrSlaveModeChangedEventHandler());
    }

    @Override
    public void destroy() {
        LOG.info("destroy");
        super.destroy();
        this.eventRegistration.unregisterAllEventHandler();
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public String getModuleId() {
        return MODULE_ID;
    }

    @Override
    public String getModuleName() {
        return "Replication";
    }

    @Override
    public Class<? extends ModuleInstance> getModuleInstanceClass() {
        return ReplicationModuleInstance.class;
    }

    @Override
    public ModuleConfiguration getDefaultConfiguration() {
        return ModuleConfigurationBuilder.newInstance().withModuleId(this.getModuleId()).addSortableGroupedSettingsFromFile(this.getModuleBundle(), "defaults/replication/default_module_settings.json").build();
    }

    @Override
    public ModuleConfiguration getDefaultInstanceConfiguration() {
        return ModuleConfigurationBuilder.newInstance().withModuleId(this.getModuleId()).withInstanceId(null).addSortableGroupedSettingsFromFile(this.getModuleBundle(), "defaults/replication/default_instance_settings.json").build();
    }

    @Override
    public void moduleInstanceCreated(ModuleInstance moduleInstance) {
        LOG.info("moduleInstanceCreated moduleInstance=" + moduleInstance);
        if (moduleInstance instanceof ReplicationModuleInstance) {
            ReplicationModuleInstance replicationModuleInstance = (ReplicationModuleInstance)moduleInstance;
            String replicationJobId = replicationModuleInstance.getModuleId();
            try {
                ReplicationManager replicationManager = this.replicationManagerTracker.getService();
                CoreModule coreModule = (CoreModule)this.getModuleManager().getModuleById("_core");
                if (coreModule.isMaintenanceModeEnabled()) {
                    LOG.info("Created replication job '" + replicationJobId + "' not started due to enabled maintenance mode.");
                    SystemAuditLog.info("ReplicationJobNotStarted", "Replication job of new replication module instance '" + moduleInstance.getModuleId() + "' not started due to enabled maintenance mode.");
                } else if (!coreModule.isMasterServer()) {
                    LOG.info("Created replication job '" + replicationJobId + "' not started, because this BPC server is not the master.");
                    SystemAuditLog.info("ReplicationJobNotStarted", "Replication job of new replication module instance '" + moduleInstance.getModuleId() + "' not started, because this is not the 'master' server.");
                } else {
                    LOG.info("Created replication job '" + replicationJobId + "' gets started.");
                    replicationManager.startReplicationJob(replicationModuleInstance.getReplicationJob());
                    SystemAuditLog.info("ReplicationJobStarted", "Replication job of new replication module instance '" + moduleInstance.getModuleId() + "' started.");
                }
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Replication module instance created, but starting the replication job '" + replicationJobId + "' failed.", ex);
            }
        }
    }

    @Override
    public void moduleInstanceUpdated(ModuleInstance moduleInstance) {
        LOG.info("moduleInstanceUpdated moduleInstance=" + moduleInstance);
        if (moduleInstance instanceof ReplicationModuleInstance) {
            ReplicationModuleInstance replicationModuleInstance = (ReplicationModuleInstance)moduleInstance;
            String replicationJobId = replicationModuleInstance.getModuleId();
            try {
                ReplicationManager replicationManager = this.replicationManagerTracker.getService();
                CoreModule coreModule = (CoreModule)this.getModuleManager().getModuleById("_core");
                if (coreModule.isMaintenanceModeEnabled()) {
                    LOG.info("Updated replication job '" + replicationJobId + "' not restarted due to enabled maintenance mode.");
                    SystemAuditLog.info("ReplicationJobNotRestarted", "Replication job of updated replication module instance '" + moduleInstance.getModuleId() + "' must not be restarted due to enabled maintenance mode.");
                } else if (!coreModule.isMasterServer()) {
                    LOG.info("Updated replication job '" + replicationJobId + "' not restarted, because this BPC server is not the master.");
                    SystemAuditLog.info("ReplicationJobNotRestarted", "Replication job of updated replication module instance '" + moduleInstance.getModuleId() + "' must not be restarted, because this is not the 'master' server.");
                } else {
                    LOG.info("Updated replication job '" + replicationJobId + "' gets restarted.");
                    replicationManager.stopReplicationJob(replicationJobId);
                    replicationManager.startReplicationJob(replicationModuleInstance.getReplicationJob());
                    SystemAuditLog.info("ReplicationJobRestarted", "Replication job of updated replication module instance '" + moduleInstance.getModuleId() + "' restarted.");
                }
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Replication module instance updated, but re-starting the replication job '" + replicationJobId + "' failed.", ex);
            }
        }
    }

    @Override
    public void moduleInstanceDeleted(ModuleInstance moduleInstance) {
        LOG.info("moduleInstanceDeleted moduleInstance=" + moduleInstance);
        if (moduleInstance instanceof ReplicationModuleInstance) {
            String replicationJobId = moduleInstance.getModuleId();
            try {
                ReplicationManager replicationManager = this.replicationManagerTracker.getService();
                CoreModule coreModule = (CoreModule)this.getModuleManager().getModuleById("_core");
                if (coreModule.isMaintenanceModeEnabled()) {
                    LOG.info("Replication job of deleted replication module instance '" + replicationJobId + "' must not be stopped due to enabled maintenance mode.");
                    SystemAuditLog.info("ReplicationJobNotStopped", "Replication job of deleted replication module instance '" + replicationJobId + "' must not be stopped due to enabled maintenance mode.");
                } else if (!coreModule.isMasterServer()) {
                    LOG.info("Replication job of deleted replication module instance '" + replicationJobId + "' must not be stopped, because this BPC server is not the master.");
                    SystemAuditLog.info("ReplicationJobNotStopped", "Replication job of deleted replication module instance '" + replicationJobId + "' must not be stopped, because this is not the 'master' server.");
                } else {
                    LOG.info("Replication job of deleted replication module instance '" + replicationJobId + "' gets stopped.");
                    replicationManager.stopReplicationJob(replicationJobId);
                    SystemAuditLog.info("ReplicationJobStopped", "Replication job of deleted replication module instance '" + moduleInstance.getModuleId() + "' stopped.");
                }
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Replication module instance deleted, but stopping/cancelling the related replication job '" + replicationJobId + "' failed.", ex);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getSource() instanceof ModuleConfiguration && SETTING_REPLICATOR_THREAD_COUNT.equals(evt.getPropertyName())) {
            try {
                ReplicationManager replicationManager = this.replicationManagerTracker.getService();
                replicationManager.setReplicatorThreadCount(this.getReplicatorThreadCount());
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Replicator thread count setting update recognized, but failed to set it in the replication manager.", ex);
            }
        }
    }

    public ReplicationManager getReplicationManager() throws ServiceNotFoundException {
        return this.replicationManagerTracker.getService();
    }

    public Integer getReplicatorThreadCount() {
        return this.getConfiguration().getSettingValue(SETTING_REPLICATOR_THREAD_COUNT).asInt(1);
    }

    public List<ReplicationJob> getReplicationJobs() {
        ArrayList<ReplicationJob> replicationJobs = new ArrayList<ReplicationJob>();
        for (ModuleInstance moduleInstance : this.getModuleInstances().values()) {
            ReplicationModuleInstance replicationModuleInstance = (ReplicationModuleInstance)moduleInstance;
            replicationJobs.add(replicationModuleInstance.getReplicationJob());
        }
        return replicationJobs;
    }

    public RestartReplicationJobsState restartReplicationJobs() {
        LOG.info("restartReplicationJobs");
        try {
            CoreModule coreModule = this.getModuleManager().getModuleByClass(CoreModule.class);
            ReplicationManager replicationManager = this.replicationManagerTracker.getService();
            replicationManager.stop();
            if (coreModule.isMaintenanceModeEnabled()) {
                LOG.info("Replication jobs cannot be started due to enabled maintenance mode.");
                return RestartReplicationJobsState.MAINTENANCE_MODE_ENABLED;
            }
            if (!coreModule.isMasterServer()) {
                LOG.info("Replication jobs cannot be started, because this BPC server is not the master.");
                return RestartReplicationJobsState.NOT_THE_MASTER;
            }
            LOG.info("Replication jobs get started ...");
            replicationManager.startReplication();
            return RestartReplicationJobsState.DONE;
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Restarting replication jobs failed.", ex);
            return RestartReplicationJobsState.EXCEPTION;
        }
    }

    private class MaintenanceModeChangedEventHandler
    extends AbstractMaintenanceModeAcknowledgeEventHandler {
        public MaintenanceModeChangedEventHandler(BundleContext bundleContext) {
            super(bundleContext, ReplicationModule.MODULE_ID);
        }

        @Override
        public void processNewMaintenanceMode(boolean enabled) {
            LOG.info(this.getClass().getSimpleName() + ".processNewMaintenanceMode enabled=" + enabled);
            try {
                RestartReplicationJobsState restartState = ReplicationModule.this.restartReplicationJobs();
                if (restartState == RestartReplicationJobsState.DONE) {
                    SystemAuditLog.info("ReplicationJobsStarted", "Replication jobs started due to disabled maintenance mode.");
                } else if (restartState == RestartReplicationJobsState.MAINTENANCE_MODE_ENABLED) {
                    SystemAuditLog.info("ReplicationJobsNotStarted", "Replication jobs stopped due to enabled maintenance mode.");
                } else if (restartState == RestartReplicationJobsState.NOT_THE_MASTER) {
                    SystemAuditLog.info("ReplicationJobsNotStarted", "Replication jobs not started on maintenance mode disabling. Cause the server is not the master.");
                } else if (restartState == RestartReplicationJobsState.EXCEPTION) {
                    SystemAuditLog.info("ReplicationJobsNoStarted", "Replication jobs not started on maintenance mode disabling. There was an error.");
                }
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Failed to process the maintenance mode changed event.", ex);
            }
        }
    }

    private class ReplicationModuleLoadedEventHandler
    extends AbstractBackendModuleLoadedEventHandler {
        private ReplicationModuleLoadedEventHandler() {
        }

        @Override
        public void processLoadedModule(Module module) {
            LOG.info(this.getClass().getSimpleName() + ".processLoadedModule module=...");
            RestartReplicationJobsState restartState = ReplicationModule.this.restartReplicationJobs();
            if (restartState == RestartReplicationJobsState.DONE) {
                SystemAuditLog.info("ReplicationJobsStarted", "Replication jobs started on load of the 'replication' module.");
            } else if (restartState == RestartReplicationJobsState.MAINTENANCE_MODE_ENABLED) {
                SystemAuditLog.info("ReplicationJobsNotStarted", "Replication jobs not started on load of the 'replication' module. Maintenance mode is enabled.");
            } else if (restartState == RestartReplicationJobsState.NOT_THE_MASTER) {
                SystemAuditLog.info("ReplicationJobsNotStarted", "Replication jobs not started on load of the 'replication' module. The server is not the master.");
            } else if (restartState == RestartReplicationJobsState.EXCEPTION) {
                SystemAuditLog.info("ReplicationJobsNotStarted", "Replication jobs not started on load of the 'replication' module. There was an error.");
            }
        }
    }

    private class MasterOrSlaveModeChangedEventHandler
    extends AbstractEventHandler {
        private MasterOrSlaveModeChangedEventHandler() {
        }

        @Override
        protected void processEvent(Event event) {
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
            Object serverModeObject = event.getProperty("serverMode");
            Object thisServerUUidObject = event.getProperty("thisServerUUID");
            Object masterServerUuidObject = event.getProperty("masterServerUUID");
            if ("master".equals(serverModeObject)) {
                this.processThisIsNowTheMasterServer((String)thisServerUUidObject, (String)masterServerUuidObject);
            } else if ("slave".equals(serverModeObject)) {
                this.processThisIsNowASlaveServer((String)thisServerUUidObject, (String)masterServerUuidObject);
            } else {
                LOG.log(Level.SEVERE, "Please inform the BPC developers that an unknown 'serverMode' property value is used: " + serverModeObject);
            }
        }

        private void processThisIsNowTheMasterServer(String thisServerUUID, String masterServerUUID) {
            LOG.info(this.getClass().getSimpleName() + ".processThisIsNowTheMasterServer thisServerUUID=" + thisServerUUID + ", masterServerUUID=" + masterServerUUID);
            RestartReplicationJobsState restartState = ReplicationModule.this.restartReplicationJobs();
            if (restartState == RestartReplicationJobsState.DONE) {
                SystemAuditLog.info("ReplicationJobsStarted", "Replication jobs started. Because this server has become the 'master'.");
            } else if (restartState == RestartReplicationJobsState.MAINTENANCE_MODE_ENABLED) {
                SystemAuditLog.info("ReplicationJobsNotStarted", "Replication jobs not started on set as master due to enabled maintenance mode.");
            } else if (restartState == RestartReplicationJobsState.NOT_THE_MASTER) {
                SystemAuditLog.info("ReplicationJobsNotStarted", "Replication jobs not started on set as master, because this server is not the master (should be impossible that the user sees this).");
            } else if (restartState == RestartReplicationJobsState.EXCEPTION) {
                SystemAuditLog.info("ReplicationJobsNoStarted", "Replication jobs not started on set as master. There was an error.");
            }
        }

        private void processThisIsNowASlaveServer(String thisServerUUID, String masterServerUUID) {
            LOG.info(this.getClass().getSimpleName() + ".processThisIsNowASlaveServer thisServerUUID=" + thisServerUUID + ", masterServerUUID=" + masterServerUUID);
            try {
                ReplicationManager replicationManager = ReplicationModule.this.replicationManagerTracker.getService();
                replicationManager.stop();
                SystemAuditLog.info("ReplicationJobsStopped", "Replication jobs stopped. Because this server is no longer the 'master'.");
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Failed to process the set as slave event to stop the replication jobs.", ex);
                SystemAuditLog.error("ReplicationJobsStopped", "Replication jobs not stopped on set as slave due to an error.", null, ex.getMessage());
            }
        }
    }

    public static enum RestartReplicationJobsState {
        MAINTENANCE_MODE_ENABLED,
        NOT_THE_MASTER,
        EXCEPTION,
        DONE;

    }
}

