/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator;

import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.util.DateUtil;
import de.virtimo.bpc.util.StringUtil;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;

public class ReplicationSource {
    private static final Logger LOG = Logger.getLogger(ReplicationSource.class.getName());
    public static final String RDMS_DATASOURCE_NAME_FIELD = "rdmsDataSourceName";
    public static final String SOURCE_TABLE_FIELD = "sourceTable";
    public static final String SOURCE_TIMEZONE_FIELD = "sourceTimeZone";
    public static final String LAST_UPDATE_COLUMN_FIELD = "lastUpdateColumn";
    public static final String LAST_UPDATE_COLUMN_TIMEZONE_FIELD = "lastUpdateColumnTimeZone";
    public static final String ID_COLUMNS_FIELD = "idColumns";
    public static final String DB_QUERY_TIMEOUT_IN_SECONDS_FIELD = "sourceQueryTimeoutInSeconds";
    public static final String DEFAULT_LAST_UPDATE_COLUMN = "LASTUPDATE";
    public static final String DEFAULT_ID_COLUMNS = "PROCESSID";
    public static final int DEFAULT_DB_QUERY_TIMEOUT_IN_SECONDS = 300;
    private final String dataSourceName;
    private final String table;
    private final String dateFieldColumnsTimeZoneId;
    private final Calendar dateFieldColumnsTimeZoneCalendar;
    private final String lastUpdateColumn;
    private final String lastUpdateColumnTimeZoneId;
    private final Calendar lastUpdateColumnTimeZoneCalendar;
    private final List<String> idColumns;
    private final int queryTimeoutInSeconds;

    public ReplicationSource(ModuleConfiguration jobConfig) {
        this(jobConfig.getSettingValue(RDMS_DATASOURCE_NAME_FIELD).asString(null), jobConfig.getSettingValue(SOURCE_TABLE_FIELD).asString(null), jobConfig.getSettingValue(LAST_UPDATE_COLUMN_FIELD).asString(DEFAULT_LAST_UPDATE_COLUMN), jobConfig.getSettingValue(LAST_UPDATE_COLUMN_TIMEZONE_FIELD).asString(null), jobConfig.getSettingValue(ID_COLUMNS_FIELD).asString(DEFAULT_ID_COLUMNS), jobConfig.getSettingValue(SOURCE_TIMEZONE_FIELD).asString(null), jobConfig.getSettingValue(DB_QUERY_TIMEOUT_IN_SECONDS_FIELD).asInt(300));
    }

    private ReplicationSource(Builder builder) {
        this(builder.dataSourceName, builder.table, builder.lastUpdateColumn, builder.lastUpdateColumnTimeZoneId, builder.idColumns, builder.dateFieldColumnsTimeZoneId, builder.queryTimeoutInSeconds);
    }

    private ReplicationSource(String dataSourceName, String table, String lastUpdateColumn, String lastUpdateColumnTimeZoneId, String idColumns, String dateFieldColumnsTimeZoneId, int queryTimeoutInSeconds) {
        this.dataSourceName = dataSourceName;
        this.table = table;
        this.dateFieldColumnsTimeZoneId = dateFieldColumnsTimeZoneId;
        this.dateFieldColumnsTimeZoneCalendar = DateUtil.getCalendar(dateFieldColumnsTimeZoneId);
        this.lastUpdateColumn = lastUpdateColumn == null ? DEFAULT_LAST_UPDATE_COLUMN : lastUpdateColumn;
        this.lastUpdateColumnTimeZoneId = lastUpdateColumnTimeZoneId;
        this.lastUpdateColumnTimeZoneCalendar = DateUtil.getCalendar(lastUpdateColumnTimeZoneId);
        this.idColumns = idColumns == null ? StringUtil.explode(DEFAULT_ID_COLUMNS, ",") : StringUtil.explode(idColumns, ",");
        this.queryTimeoutInSeconds = queryTimeoutInSeconds;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getTable() {
        return this.table;
    }

    public String getDateFieldColumnsTimeZoneId() {
        return this.dateFieldColumnsTimeZoneId;
    }

    public Calendar getDateFieldColumnsTimeZoneCalendar() {
        return this.dateFieldColumnsTimeZoneCalendar;
    }

    public String getLastUpdateColumn() {
        return this.lastUpdateColumn;
    }

    public String getLastUpdateColumnTimeZoneId() {
        return this.lastUpdateColumnTimeZoneId;
    }

    public Calendar getLastUpdateColumnTimeZoneCalendar() {
        return this.lastUpdateColumnTimeZoneCalendar;
    }

    public String[] getIdColumns() {
        return this.idColumns.toArray(new String[0]);
    }

    public int getQueryTimeoutInSeconds() {
        return this.queryTimeoutInSeconds;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationSource that = (ReplicationSource)o;
        return this.queryTimeoutInSeconds == that.queryTimeoutInSeconds && Objects.equals(this.dataSourceName, that.dataSourceName) && Objects.equals(this.table, that.table) && Objects.equals(this.dateFieldColumnsTimeZoneId, that.dateFieldColumnsTimeZoneId) && Objects.equals(this.dateFieldColumnsTimeZoneCalendar, that.dateFieldColumnsTimeZoneCalendar) && Objects.equals(this.lastUpdateColumn, that.lastUpdateColumn) && Objects.equals(this.lastUpdateColumnTimeZoneId, that.lastUpdateColumnTimeZoneId) && Objects.equals(this.lastUpdateColumnTimeZoneCalendar, that.lastUpdateColumnTimeZoneCalendar) && Objects.equals(this.idColumns, that.idColumns);
    }

    public int hashCode() {
        return Objects.hash(this.dataSourceName, this.table, this.dateFieldColumnsTimeZoneId, this.dateFieldColumnsTimeZoneCalendar, this.lastUpdateColumn, this.lastUpdateColumnTimeZoneId, this.lastUpdateColumnTimeZoneCalendar, this.idColumns, this.queryTimeoutInSeconds);
    }

    public String toString() {
        return "ReplicationSource{dataSourceName='" + this.dataSourceName + "', table='" + this.table + "', dateFieldColumnsTimeZoneId=" + this.dateFieldColumnsTimeZoneId + ", dateFieldColumnsTimeZoneCalendar=" + this.dateFieldColumnsTimeZoneCalendar + ", lastUpdateColumn='" + this.lastUpdateColumn + "', lastUpdateColumnTimeZoneId='" + this.lastUpdateColumnTimeZoneId + "', lastUpdateColumnTimeZoneCalendar=" + this.lastUpdateColumnTimeZoneCalendar + ", idColumns=" + this.idColumns + ", queryTimeoutInSeconds=" + this.queryTimeoutInSeconds + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String dataSourceName;
        private String table;
        private String dateFieldColumnsTimeZoneId;
        private String lastUpdateColumn = "LASTUPDATE";
        private String lastUpdateColumnTimeZoneId;
        private String idColumns = "PROCESSID";
        private int queryTimeoutInSeconds = 300;

        private Builder() {
        }

        public Builder dataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        public Builder table(String table) {
            this.table = table;
            return this;
        }

        public Builder dateFieldColumnsTimeZoneId(String dateFieldColumnsTimeZoneId) {
            this.dateFieldColumnsTimeZoneId = dateFieldColumnsTimeZoneId;
            return this;
        }

        public Builder lastUpdateColumn(String lastUpdateColumn) {
            this.lastUpdateColumn = lastUpdateColumn;
            return this;
        }

        public Builder lastUpdateColumnTimeZoneId(String lastUpdateColumnTimeZoneId) {
            this.lastUpdateColumnTimeZoneId = lastUpdateColumnTimeZoneId;
            return this;
        }

        public Builder idColumns(String idColumns) {
            this.idColumns = idColumns;
            return this;
        }

        public Builder queryTimeoutInSeconds(int queryTimeoutInSeconds) {
            this.queryTimeoutInSeconds = queryTimeoutInSeconds;
            return this;
        }

        public ReplicationSource build() {
            return new ReplicationSource(this);
        }
    }
}

