/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator;

import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.core.replicator.DbColumnNamesToOpenSearchFieldNamesConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

public class ReplicationTarget {
    private static final Logger LOG = Logger.getLogger(ReplicationTarget.class.getName());
    public static final String TARGET_INDEX = "targetIndex";
    public static final String TARGET_INDEX_CREATION_SETTINGS = "targetIndexCreationSettings";
    public static final String TARGET_INDEX_MAPPINGS = "targetIndexMappings";
    public static final String TARGET_INDEX_DYNAMIC_TEMPLATES = "targetIndexDynamicTemplates";
    public static final String TARGET_INDEX_CASE_SENSITIVITY_OF_FIELDS = "targetIndexCaseSensitivityOfFields";
    public static final String DEFAULT_TARGET_INDEX_CASE_SENSITIVITY_OF_FIELDS = "asSource";
    private final String index;
    private final Map indexCreationSettings;
    private final Map indexMappings;
    private final List dynamicTemplates;
    private final DbColumnNamesToOpenSearchFieldNamesConverter dbColumnNamesToOpenSearchFieldNamesConverter;

    public ReplicationTarget(ModuleConfiguration jobConfig) {
        this(jobConfig.getSettingValue(TARGET_INDEX).asString(null), jobConfig.getSettingValue(TARGET_INDEX_CREATION_SETTINGS).asMap(null), jobConfig.getSettingValue(TARGET_INDEX_MAPPINGS).asMap(null), jobConfig.getSettingValue(TARGET_INDEX_DYNAMIC_TEMPLATES).asList(null), jobConfig.getSettingValue(TARGET_INDEX_CASE_SENSITIVITY_OF_FIELDS).asString(DEFAULT_TARGET_INDEX_CASE_SENSITIVITY_OF_FIELDS));
    }

    private ReplicationTarget(Builder builder) {
        this(builder.index, builder.indexCreationSettings, builder.indexMappings, builder.dynamicTemplates, builder.caseSensitivityOfFields);
    }

    private ReplicationTarget(String index, Map indexCreationSettings, Map indexMappings, List dynamicTemplatesMapping, String caseSensitivityOfFields) {
        this.index = index != null ? index.toLowerCase() : index;
        this.indexCreationSettings = indexCreationSettings;
        this.indexMappings = indexMappings;
        this.dynamicTemplates = dynamicTemplatesMapping;
        this.dbColumnNamesToOpenSearchFieldNamesConverter = new DbColumnNamesToOpenSearchFieldNamesConverter(caseSensitivityOfFields);
    }

    public String getIndex() {
        return this.index;
    }

    public boolean hasIndexCreationSettings() {
        return this.indexCreationSettings != null && !this.indexCreationSettings.isEmpty();
    }

    public Map getIndexCreationSettings() {
        return this.hasIndexCreationSettings() ? new HashMap(this.indexCreationSettings) : null;
    }

    public boolean hasIndexMappings() {
        return this.indexMappings != null && !this.indexMappings.isEmpty();
    }

    public Map getIndexMappings() {
        return this.hasIndexMappings() ? new HashMap(this.indexMappings) : null;
    }

    public boolean hasDynamicTemplates() {
        return this.dynamicTemplates != null && !this.dynamicTemplates.isEmpty();
    }

    public List getDynamicTemplates() {
        return this.hasDynamicTemplates() ? new ArrayList(this.dynamicTemplates) : null;
    }

    public DbColumnNamesToOpenSearchFieldNamesConverter getDbColumnNamesToOpenSearchFieldNamesConverter() {
        return this.dbColumnNamesToOpenSearchFieldNamesConverter;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ReplicationTarget)) {
            return false;
        }
        ReplicationTarget that = (ReplicationTarget)o;
        return Objects.equals(this.index, that.index) && Objects.equals(this.indexCreationSettings, that.indexCreationSettings) && Objects.equals(this.indexMappings, that.indexMappings) && Objects.equals(this.dynamicTemplates, that.dynamicTemplates) && Objects.equals(this.dbColumnNamesToOpenSearchFieldNamesConverter, that.dbColumnNamesToOpenSearchFieldNamesConverter);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.indexCreationSettings, this.indexMappings, this.dynamicTemplates, this.dbColumnNamesToOpenSearchFieldNamesConverter);
    }

    public String toString() {
        return "ReplicationTarget{index='" + this.index + "', indexCreationSettings=" + this.indexCreationSettings + ", indexMappings=" + this.indexMappings + ", dynamicTemplates=" + this.dynamicTemplates + ", dbColumnNamesToOpenSearchFieldNamesConverter=" + this.dbColumnNamesToOpenSearchFieldNamesConverter + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String index;
        private Map indexCreationSettings;
        private Map indexMappings;
        private List dynamicTemplates;
        private String caseSensitivityOfFields = "asSource";

        private Builder() {
        }

        public Builder index(String index) {
            this.index = index;
            return this;
        }

        public Builder indexCreationSettings(Map indexCreationSettings) {
            this.indexCreationSettings = indexCreationSettings;
            return this;
        }

        public Builder indexMappings(Map indexMappings) {
            this.indexMappings = indexMappings;
            return this;
        }

        public Builder dynamicTemplates(List dynamicTemplates) {
            this.dynamicTemplates = dynamicTemplates;
            return this;
        }

        public Builder caseSensitivityOfFields(String caseSensitivityOfFields) {
            this.caseSensitivityOfFields = caseSensitivityOfFields;
            return this;
        }

        public ReplicationTarget build() {
            return new ReplicationTarget(this);
        }
    }
}

