/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator.consistency;

import de.virtimo.bpc.core.replicator.DbQueryBuilder;
import de.virtimo.bpc.util.MapUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.logging.Logger;
import javax.sql.DataSource;

class ConsistencyCheckDatabaseHandler {
    private static final Logger LOG = Logger.getLogger(ConsistencyCheckDatabaseHandler.class.getName());
    private final DataSource dataSource;
    private final String tableName;
    private final String lastUpdateColumn;
    private final Calendar lastUpdateColumnTimezoneCalendar;
    private final String loggingPrefix;

    ConsistencyCheckDatabaseHandler(DataSource dataSource, String tableName, String lastUpdateColumn, Calendar lastUpdateColumnTimezoneCalendar, String loggingPrefix) {
        this.dataSource = dataSource;
        this.tableName = tableName;
        this.lastUpdateColumn = lastUpdateColumn;
        this.lastUpdateColumnTimezoneCalendar = lastUpdateColumnTimezoneCalendar;
        this.loggingPrefix = loggingPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long countRecords(Timestamp lowerDateLimit, Timestamp upperDateLimit) throws SQLException {
        LOG.info(this.loggingPrefix + ": countRecords lowerDateLimit:" + lowerDateLimit + ", upperDateLimit:" + upperDateLimit);
        long start = System.currentTimeMillis();
        try {
            long result = -1L;
            try (Connection connection = this.dataSource.getConnection();){
                String sqlTemplate = new DbQueryBuilder(connection).withQuery("SELECT count(*) AS COUNT FROM $TABLE WHERE $LASTUPDATE_COLUMN >= ? AND $LASTUPDATE_COLUMN <= ?").withPlaceHolders(MapUtil.mapOf("$TABLE", this.tableName, "$LASTUPDATE_COLUMN", this.lastUpdateColumn)).build();
                try (PreparedStatement countPreparedStatement = connection.prepareStatement(sqlTemplate, 1003, 1007);){
                    if (this.lastUpdateColumnTimezoneCalendar != null) {
                        countPreparedStatement.setTimestamp(1, lowerDateLimit, this.lastUpdateColumnTimezoneCalendar);
                        countPreparedStatement.setTimestamp(2, upperDateLimit, this.lastUpdateColumnTimezoneCalendar);
                    } else {
                        countPreparedStatement.setTimestamp(1, lowerDateLimit);
                        countPreparedStatement.setTimestamp(2, upperDateLimit);
                    }
                    LOG.fine(this.loggingPrefix + ": " + sqlTemplate + " (from: " + lowerDateLimit + ", to: " + upperDateLimit + ")");
                    try (ResultSet rs = countPreparedStatement.executeQuery();){
                        result = rs.next() ? rs.getLong("COUNT") : 0L;
                    }
                }
            }
            long l = result;
            return l;
        }
        finally {
            LOG.fine(this.loggingPrefix + ": countRecords time: " + (System.currentTimeMillis() - start) + "ms");
        }
    }
}

