/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator.tailsync;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.Percolator;
import de.virtimo.bpc.api.PercolatorsManager;
import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.percolators.PercolatorsProcessorImpl;
import de.virtimo.bpc.core.replicator.DbResultSetToJsonConverter;
import de.virtimo.bpc.core.replicator.ReplicationJob;
import de.virtimo.bpc.core.replicator.ReplicationJobCallback;
import de.virtimo.bpc.core.replicator.tailsync.GetDataResult;
import de.virtimo.bpc.core.replicator.tailsync.RecordData;
import de.virtimo.bpc.core.replicator.tailsync.TailSync;
import de.virtimo.bpc.core.replicator.tailsync.TailSyncDatabaseHandler;
import de.virtimo.bpc.core.replicator.tailsync.TailSyncOpenSearchHandler;
import de.virtimo.bpc.util.DateUtil;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.bulk.BulkProcessor;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.unit.ByteSizeUnit;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.xcontent.XContentBuilder;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.quartz.InterruptableJob;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;

public class TailSyncTask
implements InterruptableJob {
    private static final Logger LOG = Logger.getLogger(TailSyncTask.class.getName());
    private ReplicationJob replicationJob;
    private ReplicationJobCallback callback;
    private String replicationJobId;
    private String dbTable;
    private String dbDateFieldColumnsTimeZoneId;
    private Calendar dbDateFieldColumnsTimeZoneCalendar;
    private String[] dbIdColumnNames;
    private String dbLastUpdateColumnName;
    private String dbLastUpdateColumnTimeZoneId;
    private Calendar dbLastUpdateColumnTimeZoneCalendar;
    private String index;
    private boolean syncFiles;
    private boolean unzipSyncedFiles;
    private int blockSize;
    private int blockDayRange;
    private String relativeStartDate;
    private String relativeEndDate;
    private String relativeDeleteOlderThanDate;
    private boolean cancelled = false;

    private void setReplicationJob(ReplicationJob replicationJob) {
        this.replicationJob = replicationJob;
        this.replicationJobId = replicationJob.getId();
        this.syncFiles = replicationJob.getSettings().isSyncFiles();
        this.unzipSyncedFiles = replicationJob.getSettings().isUnzipSyncedFiles();
        this.dbTable = replicationJob.getSource().getTable();
        this.dbDateFieldColumnsTimeZoneId = replicationJob.getSource().getDateFieldColumnsTimeZoneId();
        this.dbDateFieldColumnsTimeZoneCalendar = replicationJob.getSource().getDateFieldColumnsTimeZoneCalendar();
        this.dbIdColumnNames = replicationJob.getSource().getIdColumns();
        this.dbLastUpdateColumnName = replicationJob.getSource().getLastUpdateColumn();
        this.dbLastUpdateColumnTimeZoneId = replicationJob.getSource().getLastUpdateColumnTimeZoneId();
        this.dbLastUpdateColumnTimeZoneCalendar = replicationJob.getSource().getLastUpdateColumnTimeZoneCalendar();
        this.index = replicationJob.getTarget().getIndex();
        this.blockSize = replicationJob.getTailSync().getBlockSize();
        this.blockDayRange = replicationJob.getTailSync().getBlockDayRange();
        this.relativeStartDate = replicationJob.getTailSync().getRelativeStartDate();
        this.relativeEndDate = replicationJob.getTailSync().getRelativeEndDate();
        this.relativeDeleteOlderThanDate = replicationJob.getTailSync().getRelativeDeleteOlderThanDate();
    }

    private void setCallback(ReplicationJobCallback callback) {
        this.callback = callback;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void interrupt() throws UnableToInterruptJobException {
        LOG.info(this.replicationJobId + ": interrupt");
        this.cancelled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        this.setReplicationJob((ReplicationJob)jobDataMap.get((Object)"replicationJob"));
        this.setCallback((ReplicationJobCallback)jobDataMap.get((Object)"callback"));
        LOG.info(this.replicationJobId + ": execute context=" + context);
        BundleContext bundleContext = FrameworkUtil.getBundle(TailSyncTask.class).getBundleContext();
        TailSync tailSync = this.replicationJob.getTailSync();
        if (tailSync.isRunning()) {
            LOG.warning(this.replicationJobId + ": Skipping the tail sync task execution. There is already a running task.");
            return;
        }
        if (!this.replicationJob.isEnabled()) {
            LOG.warning(this.replicationJobId + ": Skipping the tail sync task execution. The related replication job is disabled.");
            return;
        }
        if (!tailSync.isEnabled()) {
            LOG.warning(this.replicationJobId + ": Skipping the tail sync task execution. It is disabled.");
            return;
        }
        if (!this.replicationJob.isReplicatingLatestRecords()) {
            LOG.warning(this.replicationJobId + ": Skipping the tail sync task execution. The related replication job is still in the middle of its work and does not already replicate just the latest records.");
            return;
        }
        tailSync.setRunning(true);
        tailSync.setLastRunStart(new Date());
        tailSync.setLastRunEnd(null);
        tailSync.increaseRunCount();
        long tailSyncStartTimestamp = System.currentTimeMillis();
        long amountMissingDatabaseRecords = 0L;
        long amountUpdatedDatabaseRecords = 0L;
        long amountDeletedDatabaseRecords = 0L;
        TailSyncOpenSearchHandler osHandler = null;
        TailSyncDatabaseHandler dbHandler = null;
        BpcServicesTracker<DatabaseManager> databaseManagerTracker = new BpcServicesTracker<DatabaseManager>(bundleContext, DatabaseManager.class);
        BpcServicesTracker<PercolatorsManager> percolatorsManagerTracker = new BpcServicesTracker<PercolatorsManager>(bundleContext, PercolatorsManager.class);
        BpcServicesTracker<OpenSearchService> openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
        try (BpcServicesTracker<DatabaseManager> bpcServicesTracker = databaseManagerTracker;
             BpcServicesTracker<PercolatorsManager> bpcServicesTracker2 = percolatorsManagerTracker;
             BpcServicesTracker<OpenSearchService> bpcServicesTracker3 = openSearchServiceTracker;){
            Timestamp lowerDateLimit;
            Timestamp deleteOlderThanTimestamp;
            DatabaseManager databaseManager = databaseManagerTracker.getService();
            PercolatorsManager percolatorsManager = percolatorsManagerTracker.getService();
            OpenSearchService oss = openSearchServiceTracker.getService();
            if (!oss.existsIndex(this.index)) {
                LOG.info(this.replicationJobId + ": Nothing to do, the target index " + this.index + " does not exist. Regular replication must run first.");
                return;
            }
            osHandler = new TailSyncOpenSearchHandler(oss, this.index, this.replicationJobId);
            DbResultSetToJsonConverter dbResultSetToJsonConverter = this.replicationJob.createDbResultSetToJsonConverter(oss);
            dbHandler = new TailSyncDatabaseHandler(databaseManager, this.replicationJob.getSource().getDataSourceName(), this.replicationJobId);
            dbHandler.initVamWorkaround(this.replicationJob.getSettings().getVamOrganizationId());
            dbHandler.initSelectByIdPreparedStatement(this.dbTable, this.dbIdColumnNames);
            dbHandler.initSelectByRangePreparedStatements(this.dbTable, this.blockSize, this.dbIdColumnNames, this.dbLastUpdateColumnName);
            Set<Percolator> percolatorsFromIndex = percolatorsManager.getAllValidPercolatorsFromIndex(oss, this.index);
            final PercolatorsProcessorImpl percolatorsProcessor = new PercolatorsProcessorImpl(oss, this.index, percolatorsFromIndex);
            Timestamp startTimestamp = dbHandler.evaluateStartTimestamp(this.dbTable, this.dbLastUpdateColumnName, this.dbLastUpdateColumnTimeZoneCalendar, this.replicationJob);
            Timestamp relativeStartTimestamp = StringUtil.isNullOrEmpty(this.relativeStartDate) ? null : new Timestamp(DateUtil.getDateForRelativeValue(this.relativeStartDate).getTime());
            Timestamp endTimestamp = new Timestamp(DateUtil.getDateForRelativeValue(this.relativeEndDate).getTime());
            if (relativeStartTimestamp != null && relativeStartTimestamp.after(endTimestamp)) {
                LOG.warning(this.replicationJobId + ": The relative start date (" + this.relativeStartDate + " = " + relativeStartTimestamp + ") gets ignored, because it is after the relative end date (" + this.relativeEndDate + " = " + endTimestamp + ") and that makes no sense.");
                relativeStartTimestamp = null;
            }
            if (relativeStartTimestamp != null && relativeStartTimestamp.before(startTimestamp)) {
                LOG.warning(this.replicationJobId + ": The relative start date (" + this.relativeStartDate + " = " + relativeStartTimestamp + ") gets ignored, because it is before the evaluated start time (" + startTimestamp + ")");
                relativeStartTimestamp = null;
            }
            if (endTimestamp != null) {
                endTimestamp = DateUtil.cloneTimestampAndMaximizeNanos(endTimestamp);
            }
            if (StringUtil.isNullOrEmpty(this.relativeDeleteOlderThanDate)) {
                LOG.info(this.replicationJobId + ": The relative delete older than date is not given, using the 'startTimestamp' to delete older documents.");
                deleteOlderThanTimestamp = new Timestamp(startTimestamp.getTime());
            } else {
                deleteOlderThanTimestamp = new Timestamp(DateUtil.getDateForRelativeValue(this.relativeDeleteOlderThanDate).getTime());
                LOG.info(this.replicationJobId + ": Using the given relative delete older than date (" + this.relativeDeleteOlderThanDate + " = " + deleteOlderThanTimestamp + ") to delete older documents.");
            }
            if (relativeStartTimestamp != null) {
                if (relativeStartTimestamp.before(deleteOlderThanTimestamp)) {
                    LOG.warning(this.replicationJobId + ": The relative sync start date (" + this.relativeStartDate + " = " + relativeStartTimestamp + ") is before the delete documents older than date (" + deleteOlderThanTimestamp + "). This leads to less than optimal processing.");
                }
            } else if (startTimestamp.before(deleteOlderThanTimestamp)) {
                LOG.warning(this.replicationJobId + ": The sync start date (" + startTimestamp + ") is before the delete documents older than date (" + deleteOlderThanTimestamp + "). This leads to less than optimal processing.");
            }
            LOG.info(this.replicationJobId + ": startTimestamp=" + startTimestamp + ", relativeStartTimestamp=" + relativeStartTimestamp + " (" + this.relativeStartDate + "), endTimestamp=" + endTimestamp + ", deleteOlderThanTimestamp=" + deleteOlderThanTimestamp);
            osHandler.deleteDocumentsOlderThan(this.dbLastUpdateColumnName, deleteOlderThanTimestamp);
            BulkProcessor.Listener listener = new BulkProcessor.Listener(){

                @Override
                public void beforeBulk(long executionId, BulkRequest request) {
                }

                @Override
                public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
                    try {
                        percolatorsProcessor.keepDatabaseIDsFromBulkResponse(response);
                    }
                    catch (Throwable ex) {
                        LOG.log(Level.SEVERE, TailSyncTask.this.replicationJobId + ": Failed to keep the database IDs", ex);
                    }
                }

                @Override
                public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
                    LOG.log(Level.SEVERE, TailSyncTask.this.replicationJobId + ": After bulk failed.", failure);
                }
            };
            BulkProcessor bulkProcessor = BulkProcessor.builder((request, bulkListener) -> oss.getClient().bulkAsync((BulkRequest)request, RequestOptions.DEFAULT, (ActionListener<BulkResponse>)bulkListener), listener).setBulkActions(10000).setBulkSize(new ByteSizeValue(10L, ByteSizeUnit.MB)).setFlushInterval(TimeValue.timeValueSeconds(5L)).setConcurrentRequests(1).build();
            Timestamp timestamp = lowerDateLimit = relativeStartTimestamp != null ? new Timestamp(relativeStartTimestamp.getTime()) : new Timestamp(startTimestamp.getTime());
            while (true) {
                if (this.isCancelled()) {
                    LOG.info(this.replicationJobId + ": Tail sync stopped by context");
                    break;
                }
                long tailSyncBlockStartTimestamp = System.currentTimeMillis();
                Timestamp upperDateLimit = DateUtil.addDaysToTimestamp(this.blockDayRange, lowerDateLimit);
                if ((upperDateLimit = DateUtil.cloneTimestampAndMaximizeNanos(upperDateLimit)).after(endTimestamp)) {
                    upperDateLimit = DateUtil.cloneTimestampWithNanos(endTimestamp);
                }
                LOG.info(this.replicationJobId + ": Processing date range: " + lowerDateLimit + " <-> " + upperDateLimit);
                GetDataResult dbResult = dbHandler.getRecordData(this.dbIdColumnNames, this.dbLastUpdateColumnName, this.dbLastUpdateColumnTimeZoneCalendar, lowerDateLimit, upperDateLimit);
                if (dbResult.getThrowable() != null) {
                    throw dbResult.getThrowable();
                }
                GetDataResult openSearchResult = osHandler.getRecordData(this.dbIdColumnNames, this.dbLastUpdateColumnName, lowerDateLimit, upperDateLimit);
                if (openSearchResult.getThrowable() != null) {
                    throw openSearchResult.getThrowable();
                }
                HashMap<String, RecordData> dbRecordDatas = dbResult.getData();
                HashMap<String, RecordData> openSearchRecordDatas = openSearchResult.getData();
                List<RecordData> missingDatabaseRecords = this.evaluateMissingDatabaseRecords(dbRecordDatas, openSearchRecordDatas);
                List<RecordData> updatedDatabaseRecords = this.evaluateUpdatedDatabaseRecords(dbRecordDatas, openSearchRecordDatas);
                List<RecordData> deletedDatabaseRecords = this.evaluateDeletedDatabaseRecords(dbRecordDatas, openSearchRecordDatas);
                amountMissingDatabaseRecords += (long)missingDatabaseRecords.size();
                amountUpdatedDatabaseRecords += (long)updatedDatabaseRecords.size();
                amountDeletedDatabaseRecords += (long)deletedDatabaseRecords.size();
                if (!missingDatabaseRecords.isEmpty()) {
                    this.addDatabaseRecordsToOpenSearch(missingDatabaseRecords, dbHandler, dbResultSetToJsonConverter, this.dbIdColumnNames, oss, bulkProcessor);
                }
                if (!updatedDatabaseRecords.isEmpty()) {
                    this.addDatabaseRecordsToOpenSearch(updatedDatabaseRecords, dbHandler, dbResultSetToJsonConverter, this.dbIdColumnNames, oss, bulkProcessor);
                }
                if (!deletedDatabaseRecords.isEmpty()) {
                    this.deleteNoLongerExistingOpenSearchRecords(deletedDatabaseRecords, bulkProcessor);
                }
                LOG.info(this.replicationJobId + ": Tail sync date range (" + lowerDateLimit + " <-> " + upperDateLimit + ") block done [new:" + missingDatabaseRecords.size() + ",updated:" + updatedDatabaseRecords.size() + ",deleted:" + deletedDatabaseRecords.size() + "] in " + (float)(System.currentTimeMillis() - tailSyncBlockStartTimestamp) / 1000.0f + " seconds");
                if (upperDateLimit.equals(endTimestamp)) {
                    LOG.info(this.replicationJobId + ": We reached the end");
                    break;
                }
                lowerDateLimit = new Timestamp(upperDateLimit.getTime());
            }
            bulkProcessor.awaitClose(5L, TimeUnit.MINUTES);
            percolatorsProcessor.process();
            LOG.info(this.replicationJobId + ": Tail sync done [new:" + amountMissingDatabaseRecords + ",updated:" + amountUpdatedDatabaseRecords + ",deleted:" + amountDeletedDatabaseRecords + "] in " + (float)(System.currentTimeMillis() - tailSyncStartTimestamp) / 1000.0f + " seconds");
            if (this.callback != null) {
                this.callback.onFinished("tailsync", this.replicationJob, percolatorsProcessor);
            }
        }
        catch (OpenSearchRelatedException | IOException | OpenSearchException ex) {
            tailSync.increaseErrorCount();
            LOG.log(Level.SEVERE, this.replicationJobId + ": OpenSearch related error: " + ex.getLocalizedMessage(), ex);
        }
        catch (Exception ex) {
            tailSync.increaseErrorCount();
            LOG.log(Level.SEVERE, this.replicationJobId + ": " + ex.getLocalizedMessage(), ex);
        }
        catch (Throwable ex) {
            tailSync.increaseErrorCount();
            LOG.log(Level.SEVERE, this.replicationJobId + ": Unexpected Throwable!", ex);
        }
        finally {
            if (osHandler != null) {
                osHandler.destroy();
            }
            if (dbHandler != null) {
                dbHandler.destroy();
            }
            tailSync.setRunning(false);
            tailSync.setLastRunEnd(new Date());
            tailSync.addTailSyncLastRunRecords(amountMissingDatabaseRecords, amountUpdatedDatabaseRecords, amountDeletedDatabaseRecords);
        }
    }

    private List<RecordData> evaluateMissingDatabaseRecords(Map<String, RecordData> dbRecordDatas, Map<String, RecordData> openSearchRecordDatas) {
        ArrayList<RecordData> result = new ArrayList<RecordData>();
        dbRecordDatas.forEach((dbRecordId, dbRecordData) -> {
            if (!openSearchRecordDatas.containsKey(dbRecordId)) {
                result.add((RecordData)dbRecordData);
            }
        });
        return result;
    }

    private List<RecordData> evaluateUpdatedDatabaseRecords(Map<String, RecordData> dbRecordDatas, Map<String, RecordData> openSearchRecordDatas) {
        ArrayList<RecordData> result = new ArrayList<RecordData>();
        dbRecordDatas.forEach((dbRecordId, dbRecordData) -> {
            RecordData openSearchRecordData = (RecordData)openSearchRecordDatas.get(dbRecordId);
            if (openSearchRecordData != null && dbRecordData.getLastUpdateDate().getTime() != openSearchRecordData.getLastUpdateDate().getTime()) {
                result.add((RecordData)dbRecordData);
            }
        });
        return result;
    }

    private List<RecordData> evaluateDeletedDatabaseRecords(Map<String, RecordData> dbRecordDatas, Map<String, RecordData> openSearchRecordDatas) {
        ArrayList<RecordData> result = new ArrayList<RecordData>();
        openSearchRecordDatas.forEach((openSearchRecordId, openSearchRecordData) -> {
            if (!dbRecordDatas.containsKey(openSearchRecordId)) {
                result.add((RecordData)openSearchRecordData);
            }
        });
        return result;
    }

    private void addDatabaseRecordsToOpenSearch(List<RecordData> databaseRecords, TailSyncDatabaseHandler dbHandler, DbResultSetToJsonConverter dbResultSetToJsonConverter, String[] idColumnNames, OpenSearchService oss, BulkProcessor bulkProcessor) throws SQLException, IOException, OpenSearchRelatedException, ServiceNotFoundException {
        LOG.info(this.replicationJobId + ": addDatabaseRecordsToOpenSearch databaseRecords=..., dbHandler=..., dbResultSetToJsonConverter=..., idColumnNames=..., oss=..., bulkProcessor=...");
        for (RecordData recordData : databaseRecords) {
            ResultSet rs = dbHandler.getDatabaseRecordByID(idColumnNames, recordData);
            try {
                if (!rs.next()) continue;
                XContentBuilder source = dbResultSetToJsonConverter.resultToJsonObject(rs, this.syncFiles, this.unzipSyncedFiles, this.dbDateFieldColumnsTimeZoneCalendar, this.dbLastUpdateColumnName, this.dbLastUpdateColumnTimeZoneCalendar);
                IndexRequest indexRequest = ((IndexRequest)new IndexRequest().index(this.index)).id(recordData.getRecordId()).source(source);
                if (this.syncFiles) {
                    indexRequest.setPipeline(oss.getAttachmentsPipelineName(this.index));
                }
                bulkProcessor.add(indexRequest);
            }
            finally {
                if (rs == null) continue;
                rs.close();
            }
        }
    }

    private void deleteNoLongerExistingOpenSearchRecords(List<RecordData> deletedDatabaseRecords, BulkProcessor bulkProcessor) {
        LOG.info(this.replicationJobId + ": deleteNoLongerExistingOpenSearchRecords deletedDatabaseRecords=..., bulkProcessor=...");
        for (RecordData deletedDatabaseRecord : deletedDatabaseRecords) {
            bulkProcessor.add(new DeleteRequest(this.index).id(deletedDatabaseRecord.getRecordId()));
        }
    }
}

