/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource;

import de.virtimo.bpc.api.auth.UserSession;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.NewCookie;

public class BpcCookieCreator {
    private static final Logger LOG = Logger.getLogger(BpcCookieCreator.class.getName());
    private static final String COOKIE_COMMENT = "Virtimo AG - Business Process Center";
    private final String bpcCookieName;
    private final String bpcClientPath;

    public BpcCookieCreator(String bpcCookieName, String bpcClientPath) {
        this.bpcCookieName = bpcCookieName;
        this.bpcClientPath = bpcClientPath;
    }

    public NewCookie createDeleteCookie() {
        LOG.log(Level.FINEST, "createDeleteCookie");
        return new NewCookie(this.bpcCookieName, "deleted", this.bpcClientPath, null, 1, COOKIE_COMMENT, 0, new Date(0L), false, true);
    }

    public NewCookie createSessionCookie(UserSession userSession, boolean secureCookie) {
        LOG.log(Level.FINEST, "createSessionCookie userSession=..., secureCookie=" + secureCookie);
        String cookieValue = userSession.getSessionId();
        long diff = userSession.getExpirationDate().getTime() - new Date().getTime();
        long seconds = TimeUnit.MILLISECONDS.toSeconds(diff);
        int maxAge = (int)seconds;
        return new NewCookie(this.bpcCookieName, cookieValue, this.bpcClientPath, null, "Virtimo AG - Business Process Center (__SAME_SITE_STRICT__)", maxAge, secureCookie, true);
    }
}

