/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.auditlog.UserAuditLog;
import de.virtimo.bpc.api.auth.Organisation;
import de.virtimo.bpc.api.auth.Right;
import de.virtimo.bpc.api.auth.Role;
import de.virtimo.bpc.api.auth.User;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.auth.idp.IdentityProvider;
import de.virtimo.bpc.api.exception.IdentityProviderException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.identityManagement.IdentityManager;
import de.virtimo.bpc.api.identityManagement.IdentityManagerException;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.auth.IdentityProviderConfiguration;
import de.virtimo.bpc.core.auth.IdentityProviderMappings;
import de.virtimo.bpc.core.auth.IdentityProviderMappingsApplyer;
import de.virtimo.bpc.core.auth.OrganisationFactory;
import de.virtimo.bpc.core.auth.PasswordValidatorImpl;
import de.virtimo.bpc.core.auth.RolesFactory;
import de.virtimo.bpc.core.auth.UnsupportedIdentityProviderOperationsFallbackHandler;
import de.virtimo.bpc.core.auth.UserFactory;
import de.virtimo.bpc.core.auth.UserNotFoundException;
import de.virtimo.bpc.core.auth.idp.IdentityProviderWithUnsupportedOperationsFallbackHandler;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.jaxrs.ApiResponse;
import de.virtimo.bpc.jaxrs.ApiResponses;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.osgi.framework.BundleContext;

@Path(value="im")
public class IdentityManagementEndpoint {
    private static final Logger LOG = Logger.getLogger(IdentityManagementEndpoint.class.getName());
    private static final String APPLICATION_JSON_UTF8 = "application/json; charset=UTF-8";
    private final BundleContext bundleContext;
    private BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;

    public IdentityManagementEndpoint(BundleContext bundleContext) {
        LOG.info("IdentityManagementEndpoint bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOG.info("onStartup");
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
    }

    public void onShutdown() {
        LOG.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    private CoreModule getCoreModule() throws ServiceNotFoundException, ModuleNotFoundException {
        return (CoreModule)this.moduleManagerTracker.getService().getModuleById("_core");
    }

    private UnsupportedIdentityProviderOperationsFallbackHandler getUnsupportedIdentityProviderOperationsFallbackHandler() throws IdentityProviderException {
        LOG.log(Level.FINEST, "getUnsupportedIdentityProviderOperationsFallbackHandler");
        IdentityProvider idp = this.getIdentityProvider();
        if (idp instanceof IdentityProviderWithUnsupportedOperationsFallbackHandler) {
            return ((IdentityProviderWithUnsupportedOperationsFallbackHandler)((Object)idp)).getUnsupportedIdentityProviderOperationsFallbackHandler();
        }
        return null;
    }

    private IdentityProvider getIdentityProvider() throws IdentityProviderException {
        LOG.log(Level.FINEST, "getIdentityProvider");
        try {
            IdentityProvider identityProvider = this.getCoreModule().getIdentityProvider();
            if (identityProvider == null) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_NOT_FOUND, "No identity provider found");
            }
            return identityProvider;
        }
        catch (ModuleNotFoundException e) {
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "No core module found. This should never happen. I AM THE CORE!");
        }
        catch (ServiceNotFoundException e) {
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "ModuleManager service not found");
        }
    }

    private IdentityManager getIdentityManager() throws IdentityManagerException {
        LOG.log(Level.FINEST, "getIdentityManager");
        try {
            IdentityManager identityManager = this.getCoreModule().getIdentityManager();
            if (identityManager == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_NOT_FOUND, "No identity manager found");
            }
            return identityManager;
        }
        catch (ModuleNotFoundException e) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "No core module found. This should never happen. I AM THE CORE!");
        }
        catch (ServiceNotFoundException e) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "ModuleManager service not found");
        }
    }

    private boolean isValidPassword(String password) {
        LOG.info("isValidPassword password=...");
        try {
            PasswordValidatorImpl passwordValidator = new PasswordValidatorImpl(this.getCoreModule().getCurrentIdentityProviderConfiguration());
            return passwordValidator.isValid(password);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to check the given password.", ex);
            return false;
        }
    }

    @GET
    @Path(value="/users")
    @Produces(value={"application/json; charset=UTF-8"})
    @BpcRoleOrRightRequired(right="IDENTITY_MANAGER_USERS_READ", role="IDENTITY_MANAGER_ADMIN")
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="No identity manager found or another failure"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    public Response getUsers(@Context HttpHeaders hh) {
        LOG.info("getUsers");
        try {
            return Response.ok(this.getIdentityManager().getUsers()).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/users")
    @Consumes(value={"application/json"})
    @BpcRoleOrRightRequired(right="IDENTITY_MANAGER_USERS_ADD", role="IDENTITY_MANAGER_ADMIN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="Mandatory user id not given"), @ApiResponse(responseCode="500", description="Mandatory password not given"), @ApiResponse(responseCode="500", description="No identity manager found or another failure"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    public Response addUser(Map<String, Object> jsonMap, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("addUser");
        try {
            String userId = (String)jsonMap.get("id");
            String password = (String)jsonMap.get("password");
            String firstName = (String)jsonMap.getOrDefault("firstName", "");
            String lastName = (String)jsonMap.getOrDefault("lastName", "");
            String email = (String)jsonMap.getOrDefault("email", "");
            if (userId == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "User id missing");
            }
            if (!this.isValidPassword(password)) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "User password does not meet the requirements");
            }
            User user = UserFactory.getUser(userId, firstName + " " + lastName, firstName + " " + lastName, firstName, lastName, email);
            this.getIdentityManager().addUser(user, password);
            UserAuditLog.info(userSession, "addUser", "New user added", null, (Object)user);
            return Response.ok().build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @PUT
    @Path(value="/users/{userId}")
    @Consumes(value={"application/json"})
    @BpcRoleOrRightRequired(right="IDENTITY_MANAGER_USERS_UPDATE", role="IDENTITY_MANAGER_ADMIN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="Mandatory user id not given"), @ApiResponse(responseCode="500", description="No identity manager found or another failure"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    public Response updateUser(@PathParam(value="userId") String userId, Map<String, Object> jsonMap, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("updateUser");
        try {
            String firstName = (String)jsonMap.getOrDefault("firstName", "");
            String lastName = (String)jsonMap.getOrDefault("lastName", "");
            String email = (String)jsonMap.getOrDefault("email", "");
            if (userId == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "User id missing");
            }
            User oldUser = null;
            try {
                oldUser = this.getIdentityManager().getUser(userId);
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "Failed to get the old user data (" + userId + ") for audit logging.", ex);
            }
            User user = UserFactory.getUser(userId, firstName + " " + lastName, firstName + " " + lastName, firstName, lastName, email);
            this.getIdentityManager().updateUser(user);
            UserAuditLog.info(userSession, "updateUser", "User '" + userId + "' updated", (Object)oldUser, (Object)user);
            return Response.ok().build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @PATCH
    @Path(value="/users/{userId}")
    @BpcRoleOrRightRequired(right="IDENTITY_MANAGER_USERS_UPDATE", role="IDENTITY_MANAGER_ADMIN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="Mandatory user id not given"), @ApiResponse(responseCode="500", description="Mandatory user password not given"), @ApiResponse(responseCode="500", description="No identity manager found or another failure"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    public Response updateUserPassword(@PathParam(value="userId") String userId, @FormParam(value="password") String newPassword, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("updateUserPassword");
        try {
            if (userId == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "User id missing");
            }
            if (!this.isValidPassword(newPassword)) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "Password does not meet the requirements");
            }
            this.getIdentityManager().updateUserPassword(userId, newPassword);
            UserAuditLog.info(userSession, "updateUserPassword", "Password of user '" + userId + "' changed.");
            return Response.ok().build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/users/{userId}")
    @BpcRoleOrRightRequired(right="IDENTITY_MANAGER_USERS_UPDATE", role="IDENTITY_MANAGER_ADMIN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="Mandatory user id not given"), @ApiResponse(responseCode="500", description="No identity manager found or another failure"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    public Response deleteUser(@PathParam(value="userId") String userId, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("deleteUser userId=" + userId);
        try {
            if (userId == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "User id missing");
            }
            this.getIdentityManager().deleteUser(userId);
            UserAuditLog.info(userSession, "deleteUser", "User '" + userId + "' deleted");
            return Response.ok().build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @Path(value="/organisations")
    @Produces(value={"application/json; charset=UTF-8"})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="No identity manager found or another failure"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    public Response getOrganisations(@Context HttpHeaders hh) {
        LOG.info("getOrganisations");
        try {
            HashSet<Organisation> organisations = new HashSet<Organisation>();
            UnsupportedIdentityProviderOperationsFallbackHandler handler = this.getUnsupportedIdentityProviderOperationsFallbackHandler();
            if (handler != null) {
                organisations.addAll(handler.getManuallySetOrganisationsFromIdpMappings());
                try {
                    organisations.addAll(this.getIdentityManager().getOrganisations());
                    return Response.ok(organisations).build();
                }
                catch (Exception ex) {
                    if (!handler.isUnsupportedOperationException(ex)) throw ex;
                    if (!organisations.isEmpty()) return Response.ok(organisations).build();
                    throw ex;
                }
            } else {
                organisations.addAll(this.getIdentityManager().getOrganisations());
            }
            return Response.ok(organisations).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @Path(value="/roles")
    @Produces(value={"application/json; charset=UTF-8"})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="No identity manager found or another failure"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    public Response getRoles(@Context HttpHeaders hh) {
        LOG.info("getRoles");
        try {
            HashSet<Role> roles = new HashSet<Role>();
            UnsupportedIdentityProviderOperationsFallbackHandler handler = this.getUnsupportedIdentityProviderOperationsFallbackHandler();
            if (handler != null) {
                roles.addAll(handler.getManuallySetRolesFromIdpMappings());
                try {
                    roles.addAll(this.getIdentityManager().getRoles());
                    return Response.ok(roles).build();
                }
                catch (Exception ex) {
                    if (!handler.isUnsupportedOperationException(ex)) throw ex;
                    if (!roles.isEmpty()) return Response.ok(roles).build();
                    throw ex;
                }
            } else {
                roles.addAll(this.getIdentityManager().getRoles());
            }
            return Response.ok(roles).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @Path(value="/rights")
    @Produces(value={"application/json; charset=UTF-8"})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="No identity manager found or another failure"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    public Response getRights(@Context HttpHeaders hh) {
        LOG.info("getRights");
        try {
            HashSet<Right> rights = new HashSet<Right>();
            UnsupportedIdentityProviderOperationsFallbackHandler handler = this.getUnsupportedIdentityProviderOperationsFallbackHandler();
            if (handler != null) {
                rights.addAll(handler.getManuallySetRightsFromIdpMappings());
                try {
                    rights.addAll(this.getIdentityManager().getRights());
                    return Response.ok(rights).build();
                }
                catch (Exception ex) {
                    if (!handler.isUnsupportedOperationException(ex)) throw ex;
                    if (!rights.isEmpty()) return Response.ok(rights).build();
                    throw ex;
                }
            } else {
                rights.addAll(this.getIdentityManager().getRights());
            }
            return Response.ok(rights).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/users/{userId}/organisations")
    @Produces(value={"application/json; charset=UTF-8"})
    @BpcRoleOrRightRequired(right="IDENTITY_MANAGER_USER_ORGANISATIONS_READ", role="IDENTITY_MANAGER_ADMIN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="User does not exist"), @ApiResponse(responseCode="500", description="No identity manager found or another failure"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    public Response getUserOrganisations(@PathParam(value="userId") String userId, @Context HttpHeaders hh) {
        LOG.info("getUserOrganisations userId:" + userId);
        try {
            return Response.ok(this.getUserResponse(userId).getOrganisations()).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/users/{userId}/organisations")
    @Consumes(value={"application/json"})
    @BpcRoleOrRightRequired(right="IDENTITY_MANAGER_USERS_UPDATE", role="IDENTITY_MANAGER_ADMIN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="Mandatory user id not given"), @ApiResponse(responseCode="500", description="Mandatory organisation not given"), @ApiResponse(responseCode="500", description="No identity manager found or another failure"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    public Response addUserOrganisation(@PathParam(value="userId") String userId, Map<String, Object> jsonMap, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("addUserOrganisation");
        try {
            String organisationName = (String)jsonMap.get("id");
            if (userId == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "User id missing");
            }
            if (organisationName == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "organisationName missing");
            }
            this.getIdentityManager().addOrganisation(userId, organisationName);
            UserAuditLog.info(userSession, "addUserOrganisation", "Organisation '" + organisationName + "' added to user '" + userId + "'.");
            return Response.ok().build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/users/{userId}/organisations/{organisationName}")
    @BpcRoleOrRightRequired(right="IDENTITY_MANAGER_USERS_UPDATE", role="IDENTITY_MANAGER_ADMIN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="Mandatory user id not given"), @ApiResponse(responseCode="500", description="Mandatory organisation not given"), @ApiResponse(responseCode="500", description="No identity manager found or another failure"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    public Response deleteUserOrganisation(@PathParam(value="userId") String userId, @PathParam(value="organisationName") String organisationName, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("deleteUserOrganisation");
        try {
            if (userId == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "User id missing");
            }
            if (organisationName == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "organisationName missing");
            }
            this.getIdentityManager().deleteOrganisation(userId, organisationName);
            UserAuditLog.info(userSession, "deleteUserOrganisation", "Organisation '" + organisationName + "' deleted from user '" + userId + "'.");
            return Response.ok().build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/users/{userId}/roles")
    @Produces(value={"application/json; charset=UTF-8"})
    @BpcRoleOrRightRequired(right="IDENTITY_MANAGER_USER_ROLES_READ", role="IDENTITY_MANAGER_ADMIN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="User does not exist"), @ApiResponse(responseCode="500", description="No identity manager found or another failure"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    public Response getUserRoles(@PathParam(value="userId") String userId, @Context HttpHeaders hh) {
        LOG.info("getUserRoles userId:" + userId);
        try {
            return Response.ok(this.getUserResponse(userId).getRoles()).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/users/{userId}/roles")
    @Consumes(value={"application/json"})
    @BpcRoleOrRightRequired(right="IDENTITY_MANAGER_USERS_UPDATE", role="IDENTITY_MANAGER_ADMIN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="Mandatory user id not given"), @ApiResponse(responseCode="500", description="Mandatory role not given"), @ApiResponse(responseCode="500", description="No identity manager found or another failure"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    public Response addUserRole(@PathParam(value="userId") String userId, Map<String, Object> jsonMap, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("addUserRole");
        try {
            String roleName = (String)jsonMap.get("id");
            if (userId == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "User id missing");
            }
            if (roleName == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "roleName missing");
            }
            this.getIdentityManager().addRole(userId, roleName);
            UserAuditLog.info(userSession, "addUserRole", "Role '" + roleName + "' added to user '" + userId + "'.");
            return Response.ok().build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/users/{userId}/roles/{roleName}")
    @Consumes(value={"application/json"})
    @BpcRoleOrRightRequired(right="IDENTITY_MANAGER_USERS_UPDATE", role="IDENTITY_MANAGER_ADMIN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="Mandatory user id not given"), @ApiResponse(responseCode="500", description="Mandatory role not given"), @ApiResponse(responseCode="500", description="No identity manager found or another failure"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    public Response deleteUserRole(@PathParam(value="userId") String userId, @PathParam(value="roleName") String roleName, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("deleteUserRole");
        try {
            if (userId == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "User id missing");
            }
            if (roleName == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "roleName missing");
            }
            this.getIdentityManager().deleteRole(userId, roleName);
            UserAuditLog.info(userSession, "deleteUserRole", "Role '" + roleName + "' deleted from user '" + userId + "'.");
            return Response.ok().build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/users/{userId}/rights")
    @Produces(value={"application/json; charset=UTF-8"})
    @BpcRoleOrRightRequired(right="IDENTITY_MANAGER_USER_RIGHTS_READ", role="IDENTITY_MANAGER_ADMIN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="User does not exist"), @ApiResponse(responseCode="500", description="No identity manager found or another failure"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    public Response getUserRights(@PathParam(value="userId") String userId, @Context HttpHeaders hh) {
        LOG.info("getUserRights userId:" + userId);
        try {
            return Response.ok(this.getUserResponse(userId).getRights()).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/users/{userId}/rights")
    @Consumes(value={"application/json"})
    @BpcRoleOrRightRequired(right="IDENTITY_MANAGER_USERS_UPDATE", role="IDENTITY_MANAGER_ADMIN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="Mandatory user id not given"), @ApiResponse(responseCode="500", description="Mandatory right not given"), @ApiResponse(responseCode="500", description="No identity manager found or another failure"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    public Response addUserRight(@PathParam(value="userId") String userId, Map<String, Object> jsonMap, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("addUserRight userId=" + userId);
        try {
            String rightName = (String)jsonMap.get("id");
            if (userId == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "User id missing");
            }
            if (rightName == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "rightName missing");
            }
            this.getIdentityManager().addRight(userId, rightName);
            UserAuditLog.info(userSession, "addUserRight", "Right '" + rightName + "' added to user '" + userId + "'.");
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to add user right.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/users/{userId}/rights/{rightName}")
    @Consumes(value={"application/json"})
    @BpcRoleOrRightRequired(right="IDENTITY_MANAGER_USERS_UPDATE", role="IDENTITY_MANAGER_ADMIN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="Mandatory user id not given"), @ApiResponse(responseCode="500", description="Mandatory right not given"), @ApiResponse(responseCode="500", description="No identity manager found or another failure"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    public Response deleteUserRight(@PathParam(value="userId") String userId, @PathParam(value="rightName") String rightName, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("deleteUserRight");
        try {
            if (userId == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "User id missing");
            }
            if (rightName == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "rightName missing");
            }
            this.getIdentityManager().deleteRight(userId, rightName);
            UserAuditLog.info(userSession, "deleteUserRight", "Right '" + rightName + "+' deleted from user '" + userId + "'.");
            return Response.ok().build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/users/{userId}")
    @Produces(value={"application/json; charset=UTF-8"})
    @BpcRoleOrRightRequired(right="IDENTITY_MANAGER_USER_READ", role="IDENTITY_MANAGER_ADMIN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="User does not exist"), @ApiResponse(responseCode="500", description="No identity manager found or another failure"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    public Response getUser(@PathParam(value="userId") String userId, @Context HttpHeaders hh) {
        LOG.info("getUser userId:" + userId);
        try {
            return Response.ok((Object)this.getUserResponse(userId)).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    private UserResponse getUserResponse(String userId) throws IdentityManagerException {
        LOG.info("getUserResponse userId:" + userId);
        IdentityManager identityManager = this.getIdentityManager();
        User user = identityManager.getUser(userId);
        if (user == null) {
            throw new UserNotFoundException(userId);
        }
        HashSet<Organisation> userOrganisations = new HashSet<Organisation>();
        try {
            Set<Organisation> userOrganisationsList = identityManager.getUserOrganisations(userId);
            if (userOrganisationsList != null) {
                userOrganisations.addAll(userOrganisationsList);
            }
        }
        catch (Throwable userOrganisationsList) {
            // empty catch block
        }
        if (userOrganisations.isEmpty()) {
            userOrganisations.add(OrganisationFactory.getDefaultOrganisation());
        }
        HashSet<Role> userRoles = new HashSet<Role>();
        try {
            Set<Role> userRolesList = identityManager.getUserRoles(userId);
            if (userRolesList != null) {
                userRoles.addAll(userRolesList);
            }
        }
        catch (Throwable userRolesList) {
            // empty catch block
        }
        userRoles.add(RolesFactory.getBpcUserRole());
        HashSet<Right> userRights = new HashSet<Right>();
        try {
            Set<Right> userRightsList = identityManager.getUserRights(userId);
            if (userRightsList != null) {
                userRights.addAll(userRightsList);
            }
        }
        catch (Throwable userRightsList) {
            // empty catch block
        }
        try {
            IdentityProviderMappings identityProviderMappings;
            IdentityProviderConfiguration idpConfiguration = this.getCoreModule().getCurrentIdentityProviderConfiguration();
            if (idpConfiguration != null && (identityProviderMappings = idpConfiguration.getIdentityProviderMappings()) != null) {
                IdentityProviderMappingsApplyer identityProviderMappingsApplyer = new IdentityProviderMappingsApplyer(userOrganisations, userRoles, userRights);
                identityProviderMappingsApplyer.applyIdentityProviderMappings(identityProviderMappings);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to apply the identity provider mappings.", ex);
        }
        return new UserResponse(user, userOrganisations, userRoles, userRights);
    }

    private static class UserResponse
    implements User {
        private final User user;
        private final Set<Organisation> organisations;
        private final Set<Role> roles;
        private final Set<Right> rights;

        public UserResponse(User user, Set<Organisation> organisations, Set<Role> roles, Set<Right> rights) {
            this.user = user;
            this.organisations = organisations;
            this.roles = roles;
            this.rights = rights;
        }

        @Override
        public String getId() {
            return this.user.getId();
        }

        @Override
        public String getUserName() {
            return this.user.getUserName();
        }

        @Override
        public String getDisplayName() {
            return this.user.getDisplayName();
        }

        @Override
        public String getFirstName() {
            return this.user.getFirstName();
        }

        @Override
        public String getLastName() {
            return this.user.getLastName();
        }

        @Override
        public String getEmail() {
            return this.user.getEmail();
        }

        public Set<Organisation> getOrganisations() {
            return this.organisations;
        }

        public Set<Role> getRoles() {
            return this.roles;
        }

        public Set<Right> getRights() {
            return this.rights;
        }
    }
}

